/*******************************************************************
*   NC_SASD_2009_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT DX_PR_GRPS FILE INTO SPSS                             
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NC_SASD_2009_DX_PR_GRPS.ASC' FIXED / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRON7                    13-  14
 CHRON8                    15-  16
 CHRON9                    17-  18
 CHRON10                   19-  20
 CHRON11                   21-  22
 CHRON12                   23-  24
 CHRON13                   25-  26
 CHRON14                   27-  28
 CHRON15                   29-  30
 CHRON16                   31-  32
 CHRON17                   33-  34
 CHRON18                   35-  36
 CHRON19                   37-  38
 CHRON20                   39-  40
 CHRON21                   41-  42
 CHRON22                   43-  44
 CHRON23                   45-  46
 CHRON24                   47-  48
 CHRON25                   49-  50
 CHRON26                   51-  52
 CHRON27                   53-  54
 CHRON28                   55-  56
 CHRON29                   57-  58
 CHRON30                   59-  60
 CHRON31                   61-  62
 CHRON32                   63-  64
 CHRON33                   65-  66
 CHRONB1                   67-  68
 CHRONB2                   69-  70
 CHRONB3                   71-  72
 CHRONB4                   73-  74
 CHRONB5                   75-  76
 CHRONB6                   77-  78
 CHRONB7                   79-  80
 CHRONB8                   81-  82
 CHRONB9                   83-  84
 CHRONB10                  85-  86
 CHRONB11                  87-  88
 CHRONB12                  89-  90
 CHRONB13                  91-  92
 CHRONB14                  93-  94
 CHRONB15                  95-  96
 CHRONB16                  97-  98
 CHRONB17                  99- 100
 CHRONB18                 101- 102
 CHRONB19                 103- 104
 CHRONB20                 105- 106
 CHRONB21                 107- 108
 CHRONB22                 109- 110
 CHRONB23                 111- 112
 CHRONB24                 113- 114
 CHRONB25                 115- 116
 CHRONB26                 117- 118
 CHRONB27                 119- 120
 CHRONB28                 121- 122
 CHRONB29                 123- 124
 CHRONB30                 125- 126
 CHRONB31                 127- 128
 CHRONB32                 129- 130
 CHRONB33                 131- 132
 DXMCCS1                  133- 143 (A)
 DXMCCS2                  144- 154 (A)
 DXMCCS3                  155- 165 (A)
 DXMCCS4                  166- 176 (A)
 DXMCCS5                  177- 187 (A)
 DXMCCS6                  188- 198 (A)
 DXMCCS7                  199- 209 (A)
 DXMCCS8                  210- 220 (A)
 DXMCCS9                  221- 231 (A)
 DXMCCS10                 232- 242 (A)
 DXMCCS11                 243- 253 (A)
 DXMCCS12                 254- 264 (A)
 DXMCCS13                 265- 275 (A)
 DXMCCS14                 276- 286 (A)
 DXMCCS15                 287- 297 (A)
 DXMCCS16                 298- 308 (A)
 DXMCCS17                 309- 319 (A)
 DXMCCS18                 320- 330 (A)
 DXMCCS19                 331- 341 (A)
 DXMCCS20                 342- 352 (A)
 DXMCCS21                 353- 363 (A)
 DXMCCS22                 364- 374 (A)
 DXMCCS23                 375- 385 (A)
 DXMCCS24                 386- 396 (A)
 DXMCCS25                 397- 407 (A)
 DXMCCS26                 408- 418 (A)
 DXMCCS27                 419- 429 (A)
 DXMCCS28                 430- 440 (A)
 DXMCCS29                 441- 451 (A)
 DXMCCS30                 452- 462 (A)
 DXMCCS31                 463- 473 (A)
 DXMCCS32                 474- 484 (A)
 DXMCCS33                 485- 495 (A)
 E_MCCS1                  496- 506 (A)
 E_MCCS2                  507- 517 (A)
 E_MCCS3                  518- 528 (A)
 E_MCCS4                  529- 539 (A)
 E_MCCS5                  540- 550 (A)
 E_MCCS6                  551- 561 (A)
 KEY                      562- 575
 PCLASS1                  576- 577
 PCLASS2                  578- 579
 PCLASS3                  580- 581
 PCLASS4                  582- 583
 PCLASS5                  584- 585
 PCLASS6                  586- 587
 PCLASS7                  588- 589
 PCLASS8                  590- 591
 PCLASS9                  592- 593
 PCLASS10                 594- 595
 PCLASS11                 596- 597
 PCLASS12                 598- 599
 PCLASS13                 600- 601
 PCLASS14                 602- 603
 PCLASS15                 604- 605
 PCLASS16                 606- 607
 PCLASS17                 608- 609
 PCLASS18                 610- 611
 PCLASS19                 612- 613
 PCLASS20                 614- 615
 PRMCCS1                  616- 623 (A)
 PRMCCS2                  624- 631 (A)
 PRMCCS3                  632- 639 (A)
 PRMCCS4                  640- 647 (A)
 PRMCCS5                  648- 655 (A)
 PRMCCS6                  656- 663 (A)
 PRMCCS7                  664- 671 (A)
 PRMCCS8                  672- 679 (A)
 PRMCCS9                  680- 687 (A)
 PRMCCS10                 688- 695 (A)
 PRMCCS11                 696- 703 (A)
 PRMCCS12                 704- 711 (A)
 PRMCCS13                 712- 719 (A)
 PRMCCS14                 720- 727 (A)
 PRMCCS15                 728- 735 (A)
 PRMCCS16                 736- 743 (A)
 PRMCCS17                 744- 751 (A)
 PRMCCS18                 752- 759 (A)
 PRMCCS19                 760- 767 (A)
 PRMCCS20                 768- 775 (A).


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRON10                 (F3.0) /
 CHRON11                 (F3.0) /
 CHRON12                 (F3.0) /
 CHRON13                 (F3.0) /
 CHRON14                 (F3.0) /
 CHRON15                 (F3.0) /
 CHRON16                 (F3.0) /
 CHRON17                 (F3.0) /
 CHRON18                 (F3.0) /
 CHRON19                 (F3.0) /
 CHRON20                 (F3.0) /
 CHRON21                 (F3.0) /
 CHRON22                 (F3.0) /
 CHRON23                 (F3.0) /
 CHRON24                 (F3.0) /
 CHRON25                 (F3.0) /
 CHRON26                 (F3.0) /
 CHRON27                 (F3.0) /
 CHRON28                 (F3.0) /
 CHRON29                 (F3.0) /
 CHRON30                 (F3.0) /
 CHRON31                 (F3.0) /
 CHRON32                 (F3.0) /
 CHRON33                 (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 CHRONB10                (F3.0) /
 CHRONB11                (F3.0) /
 CHRONB12                (F3.0) /
 CHRONB13                (F3.0) /
 CHRONB14                (F3.0) /
 CHRONB15                (F3.0) /
 CHRONB16                (F3.0) /
 CHRONB17                (F3.0) /
 CHRONB18                (F3.0) /
 CHRONB19                (F3.0) /
 CHRONB20                (F3.0) /
 CHRONB21                (F3.0) /
 CHRONB22                (F3.0) /
 CHRONB23                (F3.0) /
 CHRONB24                (F3.0) /
 CHRONB25                (F3.0) /
 CHRONB26                (F3.0) /
 CHRONB27                (F3.0) /
 CHRONB28                (F3.0) /
 CHRONB29                (F3.0) /
 CHRONB30                (F3.0) /
 CHRONB31                (F3.0) /
 CHRONB32                (F3.0) /
 CHRONB33                (F3.0) /
 KEY                     (F8.0) /
 PCLASS1                 (F3.0) /
 PCLASS2                 (F3.0) /
 PCLASS3                 (F3.0) /
 PCLASS4                 (F3.0) /
 PCLASS5                 (F3.0) /
 PCLASS6                 (F3.0) /
 PCLASS7                 (F3.0) /
 PCLASS8                 (F3.0) /
 PCLASS9                 (F3.0) /
 PCLASS10                (F3.0) /
 PCLASS11                (F3.0) /
 PCLASS12                (F3.0) /
 PCLASS13                (F3.0) /
 PCLASS14                (F3.0) /
 PCLASS15                (F3.0) /
 PCLASS16                (F3.0) /
 PCLASS17                (F3.0) /
 PCLASS18                (F3.0) /
 PCLASS19                (F3.0) /
 PCLASS20                (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1                  "Chronic condition indicator 1"
 CHRON2                  "Chronic condition indicator 2"
 CHRON3                  "Chronic condition indicator 3"
 CHRON4                  "Chronic condition indicator 4"
 CHRON5                  "Chronic condition indicator 5"
 CHRON6                  "Chronic condition indicator 6"
 CHRON7                  "Chronic condition indicator 7"
 CHRON8                  "Chronic condition indicator 8"
 CHRON9                  "Chronic condition indicator 9"
 CHRON10                 "Chronic condition indicator 10"
 CHRON11                 "Chronic condition indicator 11"
 CHRON12                 "Chronic condition indicator 12"
 CHRON13                 "Chronic condition indicator 13"
 CHRON14                 "Chronic condition indicator 14"
 CHRON15                 "Chronic condition indicator 15"
 CHRON16                 "Chronic condition indicator 16"
 CHRON17                 "Chronic condition indicator 17"
 CHRON18                 "Chronic condition indicator 18"
 CHRON19                 "Chronic condition indicator 19"
 CHRON20                 "Chronic condition indicator 20"
 CHRON21                 "Chronic condition indicator 21"
 CHRON22                 "Chronic condition indicator 22"
 CHRON23                 "Chronic condition indicator 23"
 CHRON24                 "Chronic condition indicator 24"
 CHRON25                 "Chronic condition indicator 25"
 CHRON26                 "Chronic condition indicator 26"
 CHRON27                 "Chronic condition indicator 27"
 CHRON28                 "Chronic condition indicator 28"
 CHRON29                 "Chronic condition indicator 29"
 CHRON30                 "Chronic condition indicator 30"
 CHRON31                 "Chronic condition indicator 31"
 CHRON32                 "Chronic condition indicator 32"
 CHRON33                 "Chronic condition indicator 33"
 CHRONB1                 "Chronic condition body system 1"
 CHRONB2                 "Chronic condition body system 2"
 CHRONB3                 "Chronic condition body system 3"
 CHRONB4                 "Chronic condition body system 4"
 CHRONB5                 "Chronic condition body system 5"
 CHRONB6                 "Chronic condition body system 6"
 CHRONB7                 "Chronic condition body system 7"
 CHRONB8                 "Chronic condition body system 8"
 CHRONB9                 "Chronic condition body system 9"
 CHRONB10                "Chronic condition body system 10"
 CHRONB11                "Chronic condition body system 11"
 CHRONB12                "Chronic condition body system 12"
 CHRONB13                "Chronic condition body system 13"
 CHRONB14                "Chronic condition body system 14"
 CHRONB15                "Chronic condition body system 15"
 CHRONB16                "Chronic condition body system 16"
 CHRONB17                "Chronic condition body system 17"
 CHRONB18                "Chronic condition body system 18"
 CHRONB19                "Chronic condition body system 19"
 CHRONB20                "Chronic condition body system 20"
 CHRONB21                "Chronic condition body system 21"
 CHRONB22                "Chronic condition body system 22"
 CHRONB23                "Chronic condition body system 23"
 CHRONB24                "Chronic condition body system 24"
 CHRONB25                "Chronic condition body system 25"
 CHRONB26                "Chronic condition body system 26"
 CHRONB27                "Chronic condition body system 27"
 CHRONB28                "Chronic condition body system 28"
 CHRONB29                "Chronic condition body system 29"
 CHRONB30                "Chronic condition body system 30"
 CHRONB31                "Chronic condition body system 31"
 CHRONB32                "Chronic condition body system 32"
 CHRONB33                "Chronic condition body system 33"
 DXMCCS1                 "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                 "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                 "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                 "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                 "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                 "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                 "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                 "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                 "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17                "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18                "Multi-Level CCS:  Diagnosis 18"
 DXMCCS19                "Multi-Level CCS:  Diagnosis 19"
 DXMCCS20                "Multi-Level CCS:  Diagnosis 20"
 DXMCCS21                "Multi-Level CCS:  Diagnosis 21"
 DXMCCS22                "Multi-Level CCS:  Diagnosis 22"
 DXMCCS23                "Multi-Level CCS:  Diagnosis 23"
 DXMCCS24                "Multi-Level CCS:  Diagnosis 24"
 DXMCCS25                "Multi-Level CCS:  Diagnosis 25"
 DXMCCS26                "Multi-Level CCS:  Diagnosis 26"
 DXMCCS27                "Multi-Level CCS:  Diagnosis 27"
 DXMCCS28                "Multi-Level CCS:  Diagnosis 28"
 DXMCCS29                "Multi-Level CCS:  Diagnosis 29"
 DXMCCS30                "Multi-Level CCS:  Diagnosis 30"
 DXMCCS31                "Multi-Level CCS:  Diagnosis 31"
 DXMCCS32                "Multi-Level CCS:  Diagnosis 32"
 DXMCCS33                "Multi-Level CCS:  Diagnosis 33"
 E_MCCS1                 "Multi-Level CCS:  E Code 1"
 E_MCCS2                 "Multi-Level CCS:  E Code 2"
 E_MCCS3                 "Multi-Level CCS:  E Code 3"
 E_MCCS4                 "Multi-Level CCS:  E Code 4"
 E_MCCS5                 "Multi-Level CCS:  E Code 5"
 E_MCCS6                 "Multi-Level CCS:  E Code 6"
 KEY                     "HCUP record identifier"
 PCLASS1                 "Procedure class 1"
 PCLASS2                 "Procedure class 2"
 PCLASS3                 "Procedure class 3"
 PCLASS4                 "Procedure class 4"
 PCLASS5                 "Procedure class 5"
 PCLASS6                 "Procedure class 6"
 PCLASS7                 "Procedure class 7"
 PCLASS8                 "Procedure class 8"
 PCLASS9                 "Procedure class 9"
 PCLASS10                "Procedure class 10"
 PCLASS11                "Procedure class 11"
 PCLASS12                "Procedure class 12"
 PCLASS13                "Procedure class 13"
 PCLASS14                "Procedure class 14"
 PCLASS15                "Procedure class 15"
 PCLASS16                "Procedure class 16"
 PCLASS17                "Procedure class 17"
 PCLASS18                "Procedure class 18"
 PCLASS19                "Procedure class 19"
 PCLASS20                "Procedure class 20"
 PRMCCS1                 "Multi-Level CCS:  Procedure 1"
 PRMCCS2                 "Multi-Level CCS:  Procedure 2"
 PRMCCS3                 "Multi-Level CCS:  Procedure 3"
 PRMCCS4                 "Multi-Level CCS:  Procedure 4"
 PRMCCS5                 "Multi-Level CCS:  Procedure 5"
 PRMCCS6                 "Multi-Level CCS:  Procedure 6"
 PRMCCS7                 "Multi-Level CCS:  Procedure 7"
 PRMCCS8                 "Multi-Level CCS:  Procedure 8"
 PRMCCS9                 "Multi-Level CCS:  Procedure 9"
 PRMCCS10                "Multi-Level CCS:  Procedure 10"
 PRMCCS11                "Multi-Level CCS:  Procedure 11"
 PRMCCS12                "Multi-Level CCS:  Procedure 12"
 PRMCCS13                "Multi-Level CCS:  Procedure 13"
 PRMCCS14                "Multi-Level CCS:  Procedure 14"
 PRMCCS15                "Multi-Level CCS:  Procedure 15"
 PRMCCS16                "Multi-Level CCS:  Procedure 16"
 PRMCCS17                "Multi-Level CCS:  Procedure 17"
 PRMCCS18                "Multi-Level CCS:  Procedure 18"
 PRMCCS19                "Multi-Level CCS:  Procedure 19"
 PRMCCS20                "Multi-Level CCS:  Procedure 20" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON33
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB33
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS20
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'NC_SASD_2009_DX_PR_GRPS.SAV' /COMPRESSED.
