/*******************************************************************
*   ME_SASD_2006_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'ME_SASD_2006_CORE.ASC' FIXED / 
 KEY                        1-  14
 AMONTH                    15-  16
 ASOURCE                   17-  18
 AWEEKEND                  19-  20
 CPT1                      21-  25 (A)
 CPT2                      26-  30 (A)
 CPT3                      31-  35 (A)
 CPT4                      36-  40 (A)
 CPT5                      41-  45 (A)
 CPT6                      46-  50 (A)
 CPT7                      51-  55 (A)
 CPT8                      56-  60 (A)
 CPT9                      61-  65 (A)
 CPT10                     66-  70 (A)
 CPT11                     71-  75 (A)
 CPT12                     76-  80 (A)
 CPT13                     81-  85 (A)
 CPT14                     86-  90 (A)
 CPT15                     91-  95 (A)
 CPT16                     96- 100 (A)
 CPT17                    101- 105 (A)
 CPT18                    106- 110 (A)
 CPT19                    111- 115 (A)
 CPT20                    116- 120 (A)
 CPT21                    121- 125 (A)
 CPT22                    126- 130 (A)
 CPT23                    131- 135 (A)
 CPT24                    136- 140 (A)
 CPT25                    141- 145 (A)
 CPT26                    146- 150 (A)
 CPT27                    151- 155 (A)
 CPT28                    156- 160 (A)
 CPT29                    161- 165 (A)
 CPT30                    166- 170 (A)
 CPTDAY1                  171- 173
 CPTDAY2                  174- 176
 CPTDAY3                  177- 179
 CPTDAY4                  180- 182
 CPTDAY5                  183- 185
 CPTDAY6                  186- 188
 CPTDAY7                  189- 191
 CPTDAY8                  192- 194
 CPTDAY9                  195- 197
 CPTDAY10                 198- 200
 CPTDAY11                 201- 203
 CPTDAY12                 204- 206
 CPTDAY13                 207- 209
 CPTDAY14                 210- 212
 CPTDAY15                 213- 215
 CPTDAY16                 216- 218
 CPTDAY17                 219- 221
 CPTDAY18                 222- 224
 CPTDAY19                 225- 227
 CPTDAY20                 228- 230
 CPTDAY21                 231- 233
 CPTDAY22                 234- 236
 CPTDAY23                 237- 239
 CPTDAY24                 240- 242
 CPTDAY25                 243- 245
 CPTDAY26                 246- 248
 CPTDAY27                 249- 251
 CPTDAY28                 252- 254
 CPTDAY29                 255- 257
 CPTDAY30                 258- 260
 CPTM1_1                  261- 262 (A)
 CPTM1_2                  263- 264 (A)
 CPTM1_3                  265- 266 (A)
 CPTM1_4                  267- 268 (A)
 CPTM1_5                  269- 270 (A)
 CPTM1_6                  271- 272 (A)
 CPTM1_7                  273- 274 (A)
 CPTM1_8                  275- 276 (A)
 CPTM1_9                  277- 278 (A)
 CPTM1_10                 279- 280 (A)
 CPTM1_11                 281- 282 (A)
 CPTM1_12                 283- 284 (A)
 CPTM1_13                 285- 286 (A)
 CPTM1_14                 287- 288 (A)
 CPTM1_15                 289- 290 (A)
 CPTM1_16                 291- 292 (A)
 CPTM1_17                 293- 294 (A)
 CPTM1_18                 295- 296 (A)
 CPTM1_19                 297- 298 (A)
 CPTM1_20                 299- 300 (A)
 CPTM1_21                 301- 302 (A)
 CPTM1_22                 303- 304 (A)
 CPTM1_23                 305- 306 (A)
 CPTM1_24                 307- 308 (A)
 CPTM1_25                 309- 310 (A)
 CPTM1_26                 311- 312 (A)
 CPTM1_27                 313- 314 (A)
 CPTM1_28                 315- 316 (A)
 CPTM1_29                 317- 318 (A)
 CPTM1_30                 319- 320 (A)
 CPTM2_1                  321- 322 (A)
 CPTM2_2                  323- 324 (A)
 CPTM2_3                  325- 326 (A)
 CPTM2_4                  327- 328 (A)
 CPTM2_5                  329- 330 (A)
 CPTM2_6                  331- 332 (A)
 CPTM2_7                  333- 334 (A)
 CPTM2_8                  335- 336 (A)
 CPTM2_9                  337- 338 (A)
 CPTM2_10                 339- 340 (A)
 CPTM2_11                 341- 342 (A)
 CPTM2_12                 343- 344 (A)
 CPTM2_13                 345- 346 (A)
 CPTM2_14                 347- 348 (A)
 CPTM2_15                 349- 350 (A)
 CPTM2_16                 351- 352 (A)
 CPTM2_17                 353- 354 (A)
 CPTM2_18                 355- 356 (A)
 CPTM2_19                 357- 358 (A)
 CPTM2_20                 359- 360 (A)
 CPTM2_21                 361- 362 (A)
 CPTM2_22                 363- 364 (A)
 CPTM2_23                 365- 366 (A)
 CPTM2_24                 367- 368 (A)
 CPTM2_25                 369- 370 (A)
 CPTM2_26                 371- 372 (A)
 CPTM2_27                 373- 374 (A)
 CPTM2_28                 375- 376 (A)
 CPTM2_29                 377- 378 (A)
 CPTM2_30                 379- 380 (A)
 DIED                     381- 382
 DISPUNIF                 383- 384
 DQTR                     385- 386
 DX1                      387- 391 (A)
 DX2                      392- 396 (A)
 DX3                      397- 401 (A)
 DX4                      402- 406 (A)
 DX5                      407- 411 (A)
 DX6                      412- 416 (A)
 DX7                      417- 421 (A)
 DX8                      422- 426 (A)
 DX9                      427- 431 (A)
 DXCCS1                   432- 435
 DXCCS2                   436- 439
 DXCCS3                   440- 443
 DXCCS4                   444- 447
 DXCCS5                   448- 451
 DXCCS6                   452- 455
 DXCCS7                   456- 459
 DXCCS8                   460- 463
 DXCCS9                   464- 467
 ECODE1                   468- 472 (A)
 ECODE2                   473- 477 (A)
 ECODE3                   478- 482 (A)
 ECODE4                   483- 487 (A)
 ECODE5                   488- 492 (A)
 E_CCS1                   493- 496
 E_CCS2                   497- 500
 E_CCS3                   501- 504
 E_CCS4                   505- 508
 E_CCS5                   509- 512
 FEMALE                   513- 514
 HCUP_AS                  515- 516
 HCUP_ED                  517- 518
 HCUP_OS                  519- 520
 HOSPBRTH                 521- 523
 HOSPST                   524- 525 (A)
 LOS                      526- 530
 MDSPEC1                  531- 532 (A)
 MDSPEC2                  533- 534 (A)
 MEDINCST                 535- 536
 MRN_R                    537- 545
 NCPT                     546- 548
 NDX                      549- 550
 NECODE                   551- 552
 NEOMAT                   553- 554
 PAY1                     555- 556
 PL_CBSA                  557- 559
 PL_MSA19                 560- 562
 PL_NHCS2                 563- 564
 PL_RUCA4                 565- 566
 PL_UIC20                 567- 568
 PL_UR_CA                 569- 570
 PL_UR_CA                 571- 572
 PROCTYPE                 573- 575
 PSTATE                   576- 577 (A)
 PSTCO                    578- 582
 PSTCO2                   583- 587
 STATE_AS                 588- 589
 STATE_ED                 590- 591
 STATE_OS                 592- 593
 YEAR                     594- 597
 ZIP3                     598- 600 (A)
 ZIPINC_Q                 601- 603
 ZIP_S                    604- 608 (A)
 AGEGROUP                 609- 611
 HOSPID                   612- 616
 AYEAR                    617- 620
 DMONTH                   621- 622.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 AWEEKEND                (F3.0) /
 CPTDAY1                 (F4.0) /
 CPTDAY2                 (F4.0) /
 CPTDAY3                 (F4.0) /
 CPTDAY4                 (F4.0) /
 CPTDAY5                 (F4.0) /
 CPTDAY6                 (F4.0) /
 CPTDAY7                 (F4.0) /
 CPTDAY8                 (F4.0) /
 CPTDAY9                 (F4.0) /
 CPTDAY10                (F4.0) /
 CPTDAY11                (F4.0) /
 CPTDAY12                (F4.0) /
 CPTDAY13                (F4.0) /
 CPTDAY14                (F4.0) /
 CPTDAY15                (F4.0) /
 CPTDAY16                (F4.0) /
 CPTDAY17                (F4.0) /
 CPTDAY18                (F4.0) /
 CPTDAY19                (F4.0) /
 CPTDAY20                (F4.0) /
 CPTDAY21                (F4.0) /
 CPTDAY22                (F4.0) /
 CPTDAY23                (F4.0) /
 CPTDAY24                (F4.0) /
 CPTDAY25                (F4.0) /
 CPTDAY26                (F4.0) /
 CPTDAY27                (F4.0) /
 CPTDAY28                (F4.0) /
 CPTDAY29                (F4.0) /
 CPTDAY30                (F4.0) /
 DIED                    (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 LOS                     (F4.0) /
 MEDINCST                (F3.0) /
 MRN_R                   (F5.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NHCS2                (F3.0) /
 PL_RUCA4                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AGEGROUP                (F8.0) /
 HOSPID                  (F4.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 CPT16     "CPT/HCPCS procedure code 16"
 CPT17     "CPT/HCPCS procedure code 17"
 CPT18     "CPT/HCPCS procedure code 18"
 CPT19     "CPT/HCPCS procedure code 19"
 CPT20     "CPT/HCPCS procedure code 20"
 CPT21     "CPT/HCPCS procedure code 21"
 CPT22     "CPT/HCPCS procedure code 22"
 CPT23     "CPT/HCPCS procedure code 23"
 CPT24     "CPT/HCPCS procedure code 24"
 CPT25     "CPT/HCPCS procedure code 25"
 CPT26     "CPT/HCPCS procedure code 26"
 CPT27     "CPT/HCPCS procedure code 27"
 CPT28     "CPT/HCPCS procedure code 28"
 CPT29     "CPT/HCPCS procedure code 29"
 CPT30     "CPT/HCPCS procedure code 30"
 CPTDAY1   "Number of days from admission to CPT1"
 CPTDAY2   "Number of days from admission to CPT2"
 CPTDAY3   "Number of days from admission to CPT3"
 CPTDAY4   "Number of days from admission to CPT4"
 CPTDAY5   "Number of days from admission to CPT5"
 CPTDAY6   "Number of days from admission to CPT6"
 CPTDAY7   "Number of days from admission to CPT7"
 CPTDAY8   "Number of days from admission to CPT8"
 CPTDAY9   "Number of days from admission to CPT9"
 CPTDAY10  "Number of days from admission to CPT10"
 CPTDAY11  "Number of days from admission to CPT11"
 CPTDAY12  "Number of days from admission to CPT12"
 CPTDAY13  "Number of days from admission to CPT13"
 CPTDAY14  "Number of days from admission to CPT14"
 CPTDAY15  "Number of days from admission to CPT15"
 CPTDAY16  "Number of days from admission to CPT16"
 CPTDAY17  "Number of days from admission to CPT17"
 CPTDAY18  "Number of days from admission to CPT18"
 CPTDAY19  "Number of days from admission to CPT19"
 CPTDAY20  "Number of days from admission to CPT20"
 CPTDAY21  "Number of days from admission to CPT21"
 CPTDAY22  "Number of days from admission to CPT22"
 CPTDAY23  "Number of days from admission to CPT23"
 CPTDAY24  "Number of days from admission to CPT24"
 CPTDAY25  "Number of days from admission to CPT25"
 CPTDAY26  "Number of days from admission to CPT26"
 CPTDAY27  "Number of days from admission to CPT27"
 CPTDAY28  "Number of days from admission to CPT28"
 CPTDAY29  "Number of days from admission to CPT29"
 CPTDAY30  "Number of days from admission to CPT30"
 CPTM1_1   "First CPT-4/HCPCS modifier 1"
 CPTM1_2   "First CPT-4/HCPCS modifier 2"
 CPTM1_3   "First CPT-4/HCPCS modifier 3"
 CPTM1_4   "First CPT-4/HCPCS modifier 4"
 CPTM1_5   "First CPT-4/HCPCS modifier 5"
 CPTM1_6   "First CPT-4/HCPCS modifier 6"
 CPTM1_7   "First CPT-4/HCPCS modifier 7"
 CPTM1_8   "First CPT-4/HCPCS modifier 8"
 CPTM1_9   "First CPT-4/HCPCS modifier 9"
 CPTM1_10  "First CPT-4/HCPCS modifier 10"
 CPTM1_11  "First CPT-4/HCPCS modifier 11"
 CPTM1_12  "First CPT-4/HCPCS modifier 12"
 CPTM1_13  "First CPT-4/HCPCS modifier 13"
 CPTM1_14  "First CPT-4/HCPCS modifier 14"
 CPTM1_15  "First CPT-4/HCPCS modifier 15"
 CPTM1_16  "First CPT-4/HCPCS modifier 16"
 CPTM1_17  "First CPT-4/HCPCS modifier 17"
 CPTM1_18  "First CPT-4/HCPCS modifier 18"
 CPTM1_19  "First CPT-4/HCPCS modifier 19"
 CPTM1_20  "First CPT-4/HCPCS modifier 20"
 CPTM1_21  "First CPT-4/HCPCS modifier 21"
 CPTM1_22  "First CPT-4/HCPCS modifier 22"
 CPTM1_23  "First CPT-4/HCPCS modifier 23"
 CPTM1_24  "First CPT-4/HCPCS modifier 24"
 CPTM1_25  "First CPT-4/HCPCS modifier 25"
 CPTM1_26  "First CPT-4/HCPCS modifier 26"
 CPTM1_27  "First CPT-4/HCPCS modifier 27"
 CPTM1_28  "First CPT-4/HCPCS modifier 28"
 CPTM1_29  "First CPT-4/HCPCS modifier 29"
 CPTM1_30  "First CPT-4/HCPCS modifier 30"
 CPTM2_1   "Second CPT-4/HCPCS modifier 1"
 CPTM2_2   "Second CPT-4/HCPCS modifier 2"
 CPTM2_3   "Second CPT-4/HCPCS modifier 3"
 CPTM2_4   "Second CPT-4/HCPCS modifier 4"
 CPTM2_5   "Second CPT-4/HCPCS modifier 5"
 CPTM2_6   "Second CPT-4/HCPCS modifier 6"
 CPTM2_7   "Second CPT-4/HCPCS modifier 7"
 CPTM2_8   "Second CPT-4/HCPCS modifier 8"
 CPTM2_9   "Second CPT-4/HCPCS modifier 9"
 CPTM2_10  "Second CPT-4/HCPCS modifier 10"
 CPTM2_11  "Second CPT-4/HCPCS modifier 11"
 CPTM2_12  "Second CPT-4/HCPCS modifier 12"
 CPTM2_13  "Second CPT-4/HCPCS modifier 13"
 CPTM2_14  "Second CPT-4/HCPCS modifier 14"
 CPTM2_15  "Second CPT-4/HCPCS modifier 15"
 CPTM2_16  "Second CPT-4/HCPCS modifier 16"
 CPTM2_17  "Second CPT-4/HCPCS modifier 17"
 CPTM2_18  "Second CPT-4/HCPCS modifier 18"
 CPTM2_19  "Second CPT-4/HCPCS modifier 19"
 CPTM2_20  "Second CPT-4/HCPCS modifier 20"
 CPTM2_21  "Second CPT-4/HCPCS modifier 21"
 CPTM2_22  "Second CPT-4/HCPCS modifier 22"
 CPTM2_23  "Second CPT-4/HCPCS modifier 23"
 CPTM2_24  "Second CPT-4/HCPCS modifier 24"
 CPTM2_25  "Second CPT-4/HCPCS modifier 25"
 CPTM2_26  "Second CPT-4/HCPCS modifier 26"
 CPTM2_27  "Second CPT-4/HCPCS modifier 27"
 CPTM2_28  "Second CPT-4/HCPCS modifier 28"
 CPTM2_29  "Second CPT-4/HCPCS modifier 29"
 CPTM2_30  "Second CPT-4/HCPCS modifier 30"
 DIED      "Died during hospitalization"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 MDSPEC1   "Physician 1 specialty (as received from source)"
 MDSPEC2   "Physician 2 specialty (as received from source)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 MRN_R     "Medical record number (re-identified)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 PAY1      "Primary expected payer (uniform)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NHCS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO     "Patient state/county FIPS code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 YEAR      "Calendar year"
 ZIP3      "Patient ZIP Code, first 3 digits"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 ZIP_S     "Patient ZIP Code (synthetic)"
 AGEGROUP  " "
 HOSPID    "HCUP hospital identification number"
 AYEAR     "Admission year"
 DMONTH    "Discharge month" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY30
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NHCS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEGROUP
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'ME_SASD_2006_CORE.SAV' /COMPRESSED.
