/*******************************************************************
*   CO_SASD_2006_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'CO_SASD_2006_CORE.ASC' FIXED / 
 KEY                        1-  14
 AGE                       15-  17
 AGEDAY                    18-  20
 AGEMONTH                  21-  23
 AMONTH                    24-  25
 ASOURCE                   26-  27
 ASOURCE_                  28     (A)
 ASOURCEU                  29     (A)
 AWEEKEND                  30-  31
 CPT1                      32-  36 (A)
 CPT2                      37-  41 (A)
 CPT3                      42-  46 (A)
 CPT4                      47-  51 (A)
 CPT5                      52-  56 (A)
 CPT6                      57-  61 (A)
 CPT7                      62-  66 (A)
 CPT8                      67-  71 (A)
 CPT9                      72-  76 (A)
 CPT10                     77-  81 (A)
 CPT11                     82-  86 (A)
 CPT12                     87-  91 (A)
 CPT13                     92-  96 (A)
 CPT14                     97- 101 (A)
 CPT15                    102- 106 (A)
 DIED                     107- 108
 DISP_X                   109- 110 (A)
 DISPUB92                 111- 112
 DISPUNIF                 113- 114
 DQTR                     115- 116
 DSHOSPID                 117- 129 (A)
 DX1                      130- 134 (A)
 DX2                      135- 139 (A)
 DX3                      140- 144 (A)
 DX4                      145- 149 (A)
 DX5                      150- 154 (A)
 DX6                      155- 159 (A)
 DX7                      160- 164 (A)
 DX8                      165- 169 (A)
 DX9                      170- 174 (A)
 DX10                     175- 179 (A)
 DX11                     180- 184 (A)
 DX12                     185- 189 (A)
 DX13                     190- 194 (A)
 DX14                     195- 199 (A)
 DX15                     200- 204 (A)
 DXCCS1                   205- 208
 DXCCS2                   209- 212
 DXCCS3                   213- 216
 DXCCS4                   217- 220
 DXCCS5                   221- 224
 DXCCS6                   225- 228
 DXCCS7                   229- 232
 DXCCS8                   233- 236
 DXCCS9                   237- 240
 DXCCS10                  241- 244
 DXCCS11                  245- 248
 DXCCS12                  249- 252
 DXCCS13                  253- 256
 DXCCS14                  257- 260
 DXCCS15                  261- 264
 ECODE1                   265- 269 (A)
 ECODE2                   270- 274 (A)
 ECODE3                   275- 279 (A)
 ECODE4                   280- 284 (A)
 ECODE5                   285- 289 (A)
 ECODE6                   290- 294 (A)
 E_CCS1                   295- 298
 E_CCS2                   299- 302
 E_CCS3                   303- 306
 E_CCS4                   307- 310
 E_CCS5                   311- 314
 E_CCS6                   315- 318
 FEMALE                   319- 320
 HCUP_AS                  321- 322
 HCUP_ED                  323- 324
 HCUP_OS                  325- 326
 Homeless                 327- 328
 HOSPBRTH                 329- 331
 HOSPST                   332- 333 (A)
 LOS                      334- 338
 LOS_X                    339- 344
 MDNUM1_R                 345- 353
 MDNUM2_R                 354- 362
 MEDINCST                 363- 364
 MRN_R                    365- 373
 NCPT                     374- 376
 NDX                      377- 378
 NECODE                   379- 380
 NEOMAT                   381- 382
 NPR                      383- 384
 PAY1                     385- 386
 PAY1_X                   387- 388 (A)
 PL_CBSA                  389- 391
 PL_MSA19                 392- 394
 PL_NHCS2                 395- 396
 PL_RUCA1                 397- 398
 PL_RUCA2                 399- 402
 PL_RUCA4                 403- 404
 PL_RUCC2                 405- 406
 PL_UIC20                 407- 408
 PL_UR_CA                 409- 410
 PL_UR_CA                 411- 412
 PR1                      413- 416 (A)
 PR2                      417- 420 (A)
 PR3                      421- 424 (A)
 PR4                      425- 428 (A)
 PR5                      429- 432 (A)
 PR6                      433- 436 (A)
 PR7                      437- 440 (A)
 PR8                      441- 444 (A)
 PR9                      445- 448 (A)
 PR10                     449- 452 (A)
 PR11                     453- 456 (A)
 PR12                     457- 460 (A)
 PR13                     461- 464 (A)
 PR14                     465- 468 (A)
 PR15                     469- 472 (A)
 PRCCS1                   473- 475
 PRCCS2                   476- 478
 PRCCS3                   479- 481
 PRCCS4                   482- 484
 PRCCS5                   485- 487
 PRCCS6                   488- 490
 PRCCS7                   491- 493
 PRCCS8                   494- 496
 PRCCS9                   497- 499
 PRCCS10                  500- 502
 PRCCS11                  503- 505
 PRCCS12                  506- 508
 PRCCS13                  509- 511
 PRCCS14                  512- 514
 PRCCS15                  515- 517
 PRDAY1                   518- 522
 PROCTYPE                 523- 525
 PSTATE                   526- 527 (A)
 PSTCO                    528- 532
 PSTCO2                   533- 537
 RACE                     538- 539
 RACE_X                   540     (A)
 STATE_AS                 541- 542
 STATE_ED                 543- 544
 STATE_OS                 545- 546
 TOTCHG                   547- 556
 TOTCHG_X                 557- 571
 YEAR                     572- 575
 ZIPINC_Q                 576- 578
 ZIP                      579- 583 (A)
 AYEAR                    584- 587
 DMONTH                   588- 589
 PRMNTH1                  590- 591
 PRYEAR1                  592- 595.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUB92                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 Homeless                (F3.0) /
 HOSPBRTH                (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MEDINCST                (F3.0) /
 MRN_R                   (F5.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NHCS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRDAY1                  (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 PRMNTH1                 (F3.0) /
 PRYEAR1                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 Homeless  "Indicator that patient is homeless"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDNUM1_R  "Physician 1 number (re-identified)"
 MDNUM2_R  "Physician 2 number (re-identified)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 MRN_R     "Medical record number (re-identified)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NHCS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRDAY1    "Number of days from admission to PR1"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO     "Patient state/county FIPS code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 PRMNTH1   "Month of procedure 1"
 PRYEAR1   "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NHCS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'CO_SASD_2006_CORE.SAV' /COMPRESSED.
