/*****************************************************************************/
/* SPSSload_NRD_2017_Core.SPS                                          */
/* Created on 11/22/2019.                                       */
/* This program will load the NRD_2017_Core CSV File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NRD_2017_Core.csv"
    /delimiters = ',' 
    /variables = 
    AGE                      F3.0
    AWEEKEND                 F2.0
    DIED                     F2.0
    DISCWT                   F11.7
    DISPUNIFORM              F2.0
    DMONTH                   F2.0
    DQTR                     F2.0
    DRG                      F3.0
    DRGVER                   F2.0
    DRG_NoPOA                F3.0
    I10_DX1                  A7
    I10_DX2                  A7
    I10_DX3                  A7
    I10_DX4                  A7
    I10_DX5                  A7
    I10_DX6                  A7
    I10_DX7                  A7
    I10_DX8                  A7
    I10_DX9                  A7
    I10_DX10                 A7
    I10_DX11                 A7
    I10_DX12                 A7
    I10_DX13                 A7
    I10_DX14                 A7
    I10_DX15                 A7
    I10_DX16                 A7
    I10_DX17                 A7
    I10_DX18                 A7
    I10_DX19                 A7
    I10_DX20                 A7
    I10_DX21                 A7
    I10_DX22                 A7
    I10_DX23                 A7
    I10_DX24                 A7
    I10_DX25                 A7
    I10_DX26                 A7
    I10_DX27                 A7
    I10_DX28                 A7
    I10_DX29                 A7
    I10_DX30                 A7
    I10_DX31                 A7
    I10_DX32                 A7
    I10_DX33                 A7
    I10_DX34                 A7
    I10_DX35                 A7
    I10_DX36                 A7
    I10_DX37                 A7
    I10_DX38                 A7
    I10_DX39                 A7
    I10_DX40                 A7
    ELECTIVE                 F2.0
    FEMALE                   F2.0
    HCUP_ED                  F2.0
    HOSP_NRD                 F5.0
    KEY_NRD                  F15.0
    LOS                      F5.0
    MDC                      F2.0
    MDC_NoPOA                F2.0
    I10_NDX                  F3.0
    I10_NPR                  F3.0
    NRD_DaysToEvent          F10.0
    NRD_STRATUM              F5.0
    NRD_VisitLink            A7
    PAY1                     F2.0
    PL_NCHS                  F3.0
    I10_PR1                  A7
    I10_PR2                  A7
    I10_PR3                  A7
    I10_PR4                  A7
    I10_PR5                  A7
    I10_PR6                  A7
    I10_PR7                  A7
    I10_PR8                  A7
    I10_PR9                  A7
    I10_PR10                 A7
    I10_PR11                 A7
    I10_PR12                 A7
    I10_PR13                 A7
    I10_PR14                 A7
    I10_PR15                 A7
    I10_PR16                 A7
    I10_PR17                 A7
    I10_PR18                 A7
    I10_PR19                 A7
    I10_PR20                 A7
    I10_PR21                 A7
    I10_PR22                 A7
    I10_PR23                 A7
    I10_PR24                 A7
    I10_PR25                 A7
    PRDAY1                   F3.0
    PRDAY2                   F3.0
    PRDAY3                   F3.0
    PRDAY4                   F3.0
    PRDAY5                   F3.0
    PRDAY6                   F3.0
    PRDAY7                   F3.0
    PRDAY8                   F3.0
    PRDAY9                   F3.0
    PRDAY10                  F3.0
    PRDAY11                  F3.0
    PRDAY12                  F3.0
    PRDAY13                  F3.0
    PRDAY14                  F3.0
    PRDAY15                  F3.0
    PRDAY16                  F3.0
    PRDAY17                  F3.0
    PRDAY18                  F3.0
    PRDAY19                  F3.0
    PRDAY20                  F3.0
    PRDAY21                  F3.0
    PRDAY22                  F3.0
    PRDAY23                  F3.0
    PRDAY24                  F3.0
    PRDAY25                  F3.0
    REHABTRANSFER            F2.0
    RESIDENT                 F2.0
    SAMEDAYEVENT             A2
    TOTCHG                   F10.0
    YEAR                     F4.0
    ZIPINC_QRTL              F2.0
    DXVER                    F2.0
    PRVER                    F2.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "Weight to discharges in AHA universe"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DMONTH                   "Discharge month"
    DQTR                     "Discharge quarter"
    DRG                      "DRG in effect on discharge date"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    I10_DX1                  "ICD-10-CM Diagnosis 1"
    I10_DX2                  "ICD-10-CM Diagnosis 2"
    I10_DX3                  "ICD-10-CM Diagnosis 3"
    I10_DX4                  "ICD-10-CM Diagnosis 4"
    I10_DX5                  "ICD-10-CM Diagnosis 5"
    I10_DX6                  "ICD-10-CM Diagnosis 6"
    I10_DX7                  "ICD-10-CM Diagnosis 7"
    I10_DX8                  "ICD-10-CM Diagnosis 8"
    I10_DX9                  "ICD-10-CM Diagnosis 9"
    I10_DX10                 "ICD-10-CM Diagnosis 10"
    I10_DX11                 "ICD-10-CM Diagnosis 11"
    I10_DX12                 "ICD-10-CM Diagnosis 12"
    I10_DX13                 "ICD-10-CM Diagnosis 13"
    I10_DX14                 "ICD-10-CM Diagnosis 14"
    I10_DX15                 "ICD-10-CM Diagnosis 15"
    I10_DX16                 "ICD-10-CM Diagnosis 16"
    I10_DX17                 "ICD-10-CM Diagnosis 17"
    I10_DX18                 "ICD-10-CM Diagnosis 18"
    I10_DX19                 "ICD-10-CM Diagnosis 19"
    I10_DX20                 "ICD-10-CM Diagnosis 20"
    I10_DX21                 "ICD-10-CM Diagnosis 21"
    I10_DX22                 "ICD-10-CM Diagnosis 22"
    I10_DX23                 "ICD-10-CM Diagnosis 23"
    I10_DX24                 "ICD-10-CM Diagnosis 24"
    I10_DX25                 "ICD-10-CM Diagnosis 25"
    I10_DX26                 "ICD-10-CM Diagnosis 26"
    I10_DX27                 "ICD-10-CM Diagnosis 27"
    I10_DX28                 "ICD-10-CM Diagnosis 28"
    I10_DX29                 "ICD-10-CM Diagnosis 29"
    I10_DX30                 "ICD-10-CM Diagnosis 30"
    I10_DX31                 "ICD-10-CM Diagnosis 31"
    I10_DX32                 "ICD-10-CM Diagnosis 32"
    I10_DX33                 "ICD-10-CM Diagnosis 33"
    I10_DX34                 "ICD-10-CM Diagnosis 34"
    I10_DX35                 "ICD-10-CM Diagnosis 35"
    I10_DX36                 "ICD-10-CM Diagnosis 36"
    I10_DX37                 "ICD-10-CM Diagnosis 37"
    I10_DX38                 "ICD-10-CM Diagnosis 38"
    I10_DX39                 "ICD-10-CM Diagnosis 39"
    I10_DX40                 "ICD-10-CM Diagnosis 40"
    ELECTIVE                 "Elective versus non-elective admission"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    HOSP_NRD                 "NRD hospital identifier"
    KEY_NRD                  "NRD record identifier"
    LOS                      "Length of stay (cleaned)"
    MDC                      "MDC in effect on discharge date"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
    I10_NPR                  "ICD-10-PCS Number of procedures on this record"
    NRD_DaysToEvent          "Timing variable used to identify days between admissions"
    NRD_STRATUM              "NRD stratum used for weighting"
    NRD_VisitLink            "NRD visitlink"
    PAY1                     "Primary expected payer (uniform)"
    PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
    I10_PR1                  "ICD-10-PCS Procedure 1"
    I10_PR2                  "ICD-10-PCS Procedure 2"
    I10_PR3                  "ICD-10-PCS Procedure 3"
    I10_PR4                  "ICD-10-PCS Procedure 4"
    I10_PR5                  "ICD-10-PCS Procedure 5"
    I10_PR6                  "ICD-10-PCS Procedure 6"
    I10_PR7                  "ICD-10-PCS Procedure 7"
    I10_PR8                  "ICD-10-PCS Procedure 8"
    I10_PR9                  "ICD-10-PCS Procedure 9"
    I10_PR10                 "ICD-10-PCS Procedure 10"
    I10_PR11                 "ICD-10-PCS Procedure 11"
    I10_PR12                 "ICD-10-PCS Procedure 12"
    I10_PR13                 "ICD-10-PCS Procedure 13"
    I10_PR14                 "ICD-10-PCS Procedure 14"
    I10_PR15                 "ICD-10-PCS Procedure 15"
    I10_PR16                 "ICD-10-PCS Procedure 16"
    I10_PR17                 "ICD-10-PCS Procedure 17"
    I10_PR18                 "ICD-10-PCS Procedure 18"
    I10_PR19                 "ICD-10-PCS Procedure 19"
    I10_PR20                 "ICD-10-PCS Procedure 20"
    I10_PR21                 "ICD-10-PCS Procedure 21"
    I10_PR22                 "ICD-10-PCS Procedure 22"
    I10_PR23                 "ICD-10-PCS Procedure 23"
    I10_PR24                 "ICD-10-PCS Procedure 24"
    I10_PR25                 "ICD-10-PCS Procedure 25"
    PRDAY1                   "Number of days from admission to I10_PR1"
    PRDAY2                   "Number of days from admission to I10_PR2"
    PRDAY3                   "Number of days from admission to I10_PR3"
    PRDAY4                   "Number of days from admission to I10_PR4"
    PRDAY5                   "Number of days from admission to I10_PR5"
    PRDAY6                   "Number of days from admission to I10_PR6"
    PRDAY7                   "Number of days from admission to I10_PR7"
    PRDAY8                   "Number of days from admission to I10_PR8"
    PRDAY9                   "Number of days from admission to I10_PR9"
    PRDAY10                  "Number of days from admission to I10_PR10"
    PRDAY11                  "Number of days from admission to I10_PR11"
    PRDAY12                  "Number of days from admission to I10_PR12"
    PRDAY13                  "Number of days from admission to I10_PR13"
    PRDAY14                  "Number of days from admission to I10_PR14"
    PRDAY15                  "Number of days from admission to I10_PR15"
    PRDAY16                  "Number of days from admission to I10_PR16"
    PRDAY17                  "Number of days from admission to I10_PR17"
    PRDAY18                  "Number of days from admission to I10_PR18"
    PRDAY19                  "Number of days from admission to I10_PR19"
    PRDAY20                  "Number of days from admission to I10_PR20"
    PRDAY21                  "Number of days from admission to I10_PR21"
    PRDAY22                  "Number of days from admission to I10_PR22"
    PRDAY23                  "Number of days from admission to I10_PR23"
    PRDAY24                  "Number of days from admission to I10_PR24"
    PRDAY25                  "Number of days from admission to I10_PR25"
    REHABTRANSFER            "A combined record involving rehab transfer"
    RESIDENT                 "Patient State is the same as Hospital State"
    SAMEDAYEVENT             "Transfer flag indicating combination of discharges involve same day events"
    TOTCHG                   "Total charges (cleaned)"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
    DXVER                    "Diagnosis Version"
    PRVER                    "Procedure Version" .

/* Convert special values to system missing values */
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_NRD                 (-9999 -8888 -6666=SYSMIS).
RECODE KEY_NRD                  (-99999999999999 -88888888888888 -66666666666666=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE I10_NDX                  (-99 -88 -66=SYSMIS).
RECODE I10_NPR                  (-99 -88 -66=SYSMIS).
RECODE NRD_DaysToEvent          (-999999999 -888888888 -666666666=SYSMIS).
RECODE NRD_STRATUM              (-9999 -8888 -6666=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS                  (-99 -88 -66=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE PRDAY16                  (-99 -88 -66=SYSMIS).
RECODE PRDAY17                  (-99 -88 -66=SYSMIS).
RECODE PRDAY18                  (-99 -88 -66=SYSMIS).
RECODE PRDAY19                  (-99 -88 -66=SYSMIS).
RECODE PRDAY20                  (-99 -88 -66=SYSMIS).
RECODE PRDAY21                  (-99 -88 -66=SYSMIS).
RECODE PRDAY22                  (-99 -88 -66=SYSMIS).
RECODE PRDAY23                  (-99 -88 -66=SYSMIS).
RECODE PRDAY24                  (-99 -88 -66=SYSMIS).
RECODE PRDAY25                  (-99 -88 -66=SYSMIS).
RECODE REHABTRANSFER            (-9 -8 -6 -5=SYSMIS).
RECODE RESIDENT                 (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).
RECODE DXVER                    (-9 -8 -6 -5=SYSMIS).
RECODE PRVER                    (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NRD_2017_Core.SAV' / COMPRESSED.
