/*****************************************************************************/
/* SPSSload_NRD_2015_Core.SPS                                          */
/* Created on 10/31/2017.                                       */
/* This program will load the NRD_2015_Core CSV File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NRD_2015_Core.csv"
    /delimiters = ',' 
    /variables = 
    AGE                      F3.0
    AWEEKEND                 F2.0
    DIED                     F2.0
    DISCWT                   F11.7
    DISPUNIFORM              F2.0
    DMONTH                   F2.0
    DQTR                     F2.0
    ELECTIVE                 F2.0
    FEMALE                   F2.0
    HCUP_ED                  F2.0
    HOSP_NRD                 F5.0
    KEY_NRD                  F15.0
    LOS                      F5.0
    NRD_DaysToEvent          F10.0
    NRD_STRATUM              F5.0
    NRD_VisitLink            A7
    PAY1                     F2.0
    PL_NCHS                  F3.0
    REHABTRANSFER            F2.0
    RESIDENT                 F2.0
    SAMEDAYEVENT             A2
    TOTCHG                   F10.0
    YEAR                     F4.0
    ZIPINC_QRTL              F2.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "Weight to discharges in AHA universe"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DMONTH                   "Discharge month"
    DQTR                     "Discharge quarter"
    ELECTIVE                 "Elective versus non-elective admission"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    HOSP_NRD                 "NRD hospital identifier"
    KEY_NRD                  "NRD record identifier"
    LOS                      "Length of stay (cleaned)"
    NRD_DaysToEvent          "Timing variable used to identify days between admissions"
    NRD_STRATUM              "NRD stratum used for weighting"
    NRD_VisitLink            "NRD visitlink"
    PAY1                     "Primary expected payer (uniform)"
    PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
    REHABTRANSFER            "A combined record involving rehab transfer"
    RESIDENT                 "Patient State is the same as Hospital State"
    SAMEDAYEVENT             "Transfer flag indicating combination of discharges involve same day events"
    TOTCHG                   "Total charges (cleaned)"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

/* Convert special values to system missing values */
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_NRD                 (-9999 -8888 -6666=SYSMIS).
RECODE KEY_NRD                  (-99999999999999 -88888888888888 -66666666666666=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE NRD_DaysToEvent          (-999999999 -888888888 -666666666=SYSMIS).
RECODE NRD_STRATUM              (-9999 -8888 -6666=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS                  (-99 -88 -66=SYSMIS).
RECODE REHABTRANSFER            (-9 -8 -6 -5=SYSMIS).
RECODE RESIDENT                 (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NRD_2015_Core.SAV' / COMPRESSED.
