/*****************************************************************************/
/* SPSSload_NRD_2015Q4_DX_PR_GRPS.SPS                                          */
/* Created on 10/31/2017.                                       */
/* This program will load the NRD_2015Q4_DX_PR_GRPS CSV File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NRD_2015Q4_DX_PR_GRPS.csv"
    /delimiters = ',' 
    /variables = 
    DRG                      F3.0
    DRGVER                   F2.0
    DRG_NoPOA                F3.0
    DXVER                    F2.0
    HOSP_NRD                 F5.0
    I10_DX1                  A7
    I10_DX2                  A7
    I10_DX3                  A7
    I10_DX4                  A7
    I10_DX5                  A7
    I10_DX6                  A7
    I10_DX7                  A7
    I10_DX8                  A7
    I10_DX9                  A7
    I10_DX10                 A7
    I10_DX11                 A7
    I10_DX12                 A7
    I10_DX13                 A7
    I10_DX14                 A7
    I10_DX15                 A7
    I10_DX16                 A7
    I10_DX17                 A7
    I10_DX18                 A7
    I10_DX19                 A7
    I10_DX20                 A7
    I10_DX21                 A7
    I10_DX22                 A7
    I10_DX23                 A7
    I10_DX24                 A7
    I10_DX25                 A7
    I10_DX26                 A7
    I10_DX27                 A7
    I10_DX28                 A7
    I10_DX29                 A7
    I10_DX30                 A7
    I10_ECAUSE1              A7
    I10_ECAUSE2              A7
    I10_ECAUSE3              A7
    I10_ECAUSE4              A7
    I10_NDX                  F3.0
    I10_NECAUSE              F3.0
    I10_NPR                  F3.0
    I10_PR1                  A7
    I10_PR2                  A7
    I10_PR3                  A7
    I10_PR4                  A7
    I10_PR5                  A7
    I10_PR6                  A7
    I10_PR7                  A7
    I10_PR8                  A7
    I10_PR9                  A7
    I10_PR10                 A7
    I10_PR11                 A7
    I10_PR12                 A7
    I10_PR13                 A7
    I10_PR14                 A7
    I10_PR15                 A7
    KEY_NRD                  F15.0
    MDC                      F2.0
    MDC_NoPOA                F2.0
    PRDAY1                   F3.0
    PRDAY2                   F3.0
    PRDAY3                   F3.0
    PRDAY4                   F3.0
    PRDAY5                   F3.0
    PRDAY6                   F3.0
    PRDAY7                   F3.0
    PRDAY8                   F3.0
    PRDAY9                   F3.0
    PRDAY10                  F3.0
    PRDAY11                  F3.0
    PRDAY12                  F3.0
    PRDAY13                  F3.0
    PRDAY14                  F3.0
    PRDAY15                  F3.0
    PRVER                    F2.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    DRG                      "DRG in effect on discharge date"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    DXVER                    "Diagnosis Version"
    HOSP_NRD                 "NRD hospital identifier"
    I10_DX1                  "ICD-10-CM Diagnosis 1"
    I10_DX2                  "ICD-10-CM Diagnosis 2"
    I10_DX3                  "ICD-10-CM Diagnosis 3"
    I10_DX4                  "ICD-10-CM Diagnosis 4"
    I10_DX5                  "ICD-10-CM Diagnosis 5"
    I10_DX6                  "ICD-10-CM Diagnosis 6"
    I10_DX7                  "ICD-10-CM Diagnosis 7"
    I10_DX8                  "ICD-10-CM Diagnosis 8"
    I10_DX9                  "ICD-10-CM Diagnosis 9"
    I10_DX10                 "ICD-10-CM Diagnosis 10"
    I10_DX11                 "ICD-10-CM Diagnosis 11"
    I10_DX12                 "ICD-10-CM Diagnosis 12"
    I10_DX13                 "ICD-10-CM Diagnosis 13"
    I10_DX14                 "ICD-10-CM Diagnosis 14"
    I10_DX15                 "ICD-10-CM Diagnosis 15"
    I10_DX16                 "ICD-10-CM Diagnosis 16"
    I10_DX17                 "ICD-10-CM Diagnosis 17"
    I10_DX18                 "ICD-10-CM Diagnosis 18"
    I10_DX19                 "ICD-10-CM Diagnosis 19"
    I10_DX20                 "ICD-10-CM Diagnosis 20"
    I10_DX21                 "ICD-10-CM Diagnosis 21"
    I10_DX22                 "ICD-10-CM Diagnosis 22"
    I10_DX23                 "ICD-10-CM Diagnosis 23"
    I10_DX24                 "ICD-10-CM Diagnosis 24"
    I10_DX25                 "ICD-10-CM Diagnosis 25"
    I10_DX26                 "ICD-10-CM Diagnosis 26"
    I10_DX27                 "ICD-10-CM Diagnosis 27"
    I10_DX28                 "ICD-10-CM Diagnosis 28"
    I10_DX29                 "ICD-10-CM Diagnosis 29"
    I10_DX30                 "ICD-10-CM Diagnosis 30"
    I10_ECAUSE1              "ICD-10-CM External cause 1"
    I10_ECAUSE2              "ICD-10-CM External cause 2"
    I10_ECAUSE3              "ICD-10-CM External cause 3"
    I10_ECAUSE4              "ICD-10-CM External cause 4"
    I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
    I10_NECAUSE              "ICD-10-CM Number of external cause codes on this record"
    I10_NPR                  "ICD-10-PCS Number of procedures on this record"
    I10_PR1                  "ICD-10-PCS Procedure 1"
    I10_PR2                  "ICD-10-PCS Procedure 2"
    I10_PR3                  "ICD-10-PCS Procedure 3"
    I10_PR4                  "ICD-10-PCS Procedure 4"
    I10_PR5                  "ICD-10-PCS Procedure 5"
    I10_PR6                  "ICD-10-PCS Procedure 6"
    I10_PR7                  "ICD-10-PCS Procedure 7"
    I10_PR8                  "ICD-10-PCS Procedure 8"
    I10_PR9                  "ICD-10-PCS Procedure 9"
    I10_PR10                 "ICD-10-PCS Procedure 10"
    I10_PR11                 "ICD-10-PCS Procedure 11"
    I10_PR12                 "ICD-10-PCS Procedure 12"
    I10_PR13                 "ICD-10-PCS Procedure 13"
    I10_PR14                 "ICD-10-PCS Procedure 14"
    I10_PR15                 "ICD-10-PCS Procedure 15"
    KEY_NRD                  "NRD record identifier"
    MDC                      "MDC in effect on discharge date"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    PRDAY1                   "Number of days from admission to I10_PR1"
    PRDAY2                   "Number of days from admission to I10_PR2"
    PRDAY3                   "Number of days from admission to I10_PR3"
    PRDAY4                   "Number of days from admission to I10_PR4"
    PRDAY5                   "Number of days from admission to I10_PR5"
    PRDAY6                   "Number of days from admission to I10_PR6"
    PRDAY7                   "Number of days from admission to I10_PR7"
    PRDAY8                   "Number of days from admission to I10_PR8"
    PRDAY9                   "Number of days from admission to I10_PR9"
    PRDAY10                  "Number of days from admission to I10_PR10"
    PRDAY11                  "Number of days from admission to I10_PR11"
    PRDAY12                  "Number of days from admission to I10_PR12"
    PRDAY13                  "Number of days from admission to I10_PR13"
    PRDAY14                  "Number of days from admission to I10_PR14"
    PRDAY15                  "Number of days from admission to I10_PR15"
    PRVER                    "Procedure Version" .

/* Convert special values to system missing values */
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE DXVER                    (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_NRD                 (-9999 -8888 -6666=SYSMIS).
RECODE I10_NDX                  (-99 -88 -66=SYSMIS).
RECODE I10_NECAUSE              (-99 -88 -66=SYSMIS).
RECODE I10_NPR                  (-99 -88 -66=SYSMIS).
RECODE KEY_NRD                  (-99999999999999 -88888888888888 -66666666666666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE PRVER                    (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NRD_2015Q4_DX_PR_GRPS.SAV' / COMPRESSED.
