/*****************************************************************************/
/* SPSSload_NRD_2018_Severity.SPS                                          */
/* Created on 11/30/2020.                                       */
/* This program will load the NRD_2018_Severity CSV File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NRD_2018_Severity.csv"
    /delimiters = ',' 
    /variables = 
    APRDRG                   F4.0
    APRDRG_Risk_Mortality    F2.0
    APRDRG_Severity          F2.0
    HOSP_NRD                 F5.0
    KEY_NRD                  F15.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    APRDRG                   "All Patient Refined DRG"
    APRDRG_Risk_Mortality    "All Patient Refined DRG: Risk of Mortality Subclass"
    APRDRG_Severity          "All Patient Refined DRG: Severity of Illness Subclass"
    HOSP_NRD                 "NRD hospital identifier"
    KEY_NRD                  "NRD record identifier" .

/* Convert special values to system missing values */
RECODE APRDRG                   (-999 -888 -666=SYSMIS).
RECODE APRDRG_Risk_Mortality    (-9 -8 -6 -5=SYSMIS).
RECODE APRDRG_Severity          (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_NRD                 (-9999 -8888 -6666=SYSMIS).
RECODE KEY_NRD                  (-99999999999999 -88888888888888 -66666666666666=SYSMIS).

SAVE OUTFILE = 'NRD_2018_Severity.SAV' / COMPRESSED.
