/*****************************************************************************
* Stataload_NIS_1995_Supplemental.Do
* This program will load the 1995 NIS ASCII Supplemental File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix double TRENDWT                     1- 11   ///
      double SEQ                        12- 24   ///
      byte   AWEEKEND                   25- 26   ///
      byte   DISPUNIFORM                27- 28   ///
      byte   FEMALE                     29- 30   ///
      int    PRCCS1                     31- 33   ///
      int    PRCCS2                     34- 36   ///
      int    PRCCS3                     37- 39   ///
      int    PRCCS4                     40- 42   ///
      int    PRCCS5                     43- 45   ///
      int    PRCCS6                     46- 48   ///
      int    PRCCS7                     49- 51   ///
      int    PRCCS8                     52- 54   ///
      int    PRCCS9                     55- 57   ///
      int    PRCCS10                    58- 60   ///
      int    PRCCS11                    61- 63   ///
      int    PRCCS12                    64- 66   ///
      int    PRCCS13                    67- 69   ///
      int    PRCCS14                    70- 72   ///
      int    PRCCS15                    73- 75   ///
      int    NIS_STRATUM                76- 79   ///
      long   TOTAL_DISC                 80- 85   ///
      byte   HOSP_BEDSIZE               86- 87   ///
      byte   HOSP_CONTROL               88- 89   ///
      byte   HOSP_LOCATION              90- 91   ///
      byte   HOSP_LOCTEACH              92- 93   ///
      byte   HOSP_REGION                94- 95   ///
      byte   HOSP_TEACH                 96- 97   ///
      byte   NDX                        98- 99   ///
      int    DXCCS1                    100-102   ///
      int    DXCCS2                    103-105   ///
      int    DXCCS3                    106-108   ///
      int    DXCCS4                    109-111   ///
      int    DXCCS5                    112-114   ///
      int    DXCCS6                    115-117   ///
      int    DXCCS7                    118-120   ///
      int    DXCCS8                    121-123   ///
      int    DXCCS9                    124-126   ///
      int    DXCCS10                   127-129   ///
      int    DXCCS11                   130-132   ///
      int    DXCCS12                   133-135   ///
      int    DXCCS13                   136-138   ///
      int    DXCCS14                   139-141   ///
      int    DXCCS15                   142-144   ///
      int    E_CCS1                    145-148   ///
      int    E_CCS2                    149-152   ///
      int    E_CCS3                    153-156   ///
      int    E_CCS4                    157-160   ///
      byte   ELECTIVE                  161-162   ///
      int    NECODE                    163-165   ///
      str    DX1                       166-170   ///
      str    PR1                       171-174   ///
      str    DX2                       175-179   ///
      str    DX3                       180-184   ///
      str    DX4                       185-189   ///
      str    DX5                       190-194   ///
      str    DX6                       195-199   ///
      str    DX7                       200-204   ///
      str    DX8                       205-209   ///
      str    DX9                       210-214   ///
      str    DX10                      215-219   ///
      str    DX11                      220-224   ///
      str    DX12                      225-229   ///
      str    DX13                      230-234   ///
      str    DX14                      235-239   ///
      str    DX15                      240-244   ///
      str    PR2                       245-248   ///
      str    PR3                       249-252   ///
      str    PR4                       253-256   ///
      str    PR5                       257-260   ///
      str    PR6                       261-264   ///
      str    PR7                       265-268   ///
      str    PR8                       269-272   ///
      str    PR9                       273-276   ///
      str    PR10                      277-280   ///
      str    PR11                      281-284   ///
      str    PR12                      285-288   ///
      str    PR13                      289-292   ///
      str    PR14                      293-296   ///
      str    PR15                      297-300   ///
      str    ECODE1                    301-305   ///
      str    ECODE2                    306-310   ///
      str    ECODE3                    311-315   ///
      str    ECODE4                    316-320   ///
      str    MDNUM1_S                  321-336   ///
      str    MDNUM2_S                  337-352   ///
      using  "NIS_1995_Supplemental.ASC"

***  Assign labels to the data elements ***
label var TRENDWT                  "Trend weight to discharges in the universe"
label var SEQ                      "I:HCUP-3 record sequence number"
label var AWEEKEND                 "Admission day is a weekend"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var FEMALE                   "Indicator of sex"
label var PRCCS1                   "CCS: principal procedure"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRCCS7                   "CCS: procedure 7"
label var PRCCS8                   "CCS: procedure 8"
label var PRCCS9                   "CCS: procedure 9"
label var PRCCS10                  "CCS: procedure 10"
label var PRCCS11                  "CCS: procedure 11"
label var PRCCS12                  "CCS: procedure 12"
label var PRCCS13                  "CCS: procedure 13"
label var PRCCS14                  "CCS: procedure 14"
label var PRCCS15                  "CCS: procedure 15"
label var NIS_STRATUM              "H:Stratum used to post-stratify hospital"
label var TOTAL_DISC               "H:Total hospital discharges"
label var HOSP_BEDSIZE             "Bed size of hospital"
label var HOSP_CONTROL             "Control/ownership of hospital"
label var HOSP_LOCATION            "Location (urban/rural) of hospital"
label var HOSP_LOCTEACH            "Location/teaching status of hospital"
label var HOSP_REGION              "Region of hospital"
label var HOSP_TEACH               "Teaching status of hospital"
label var NDX                      "I:Number of diagnoses on this discharge"
label var DXCCS1                   "CCS: principal diagnosis"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXCCS10                  "CCS: diagnosis 10"
label var DXCCS11                  "CCS: diagnosis 11"
label var DXCCS12                  "CCS: diagnosis 12"
label var DXCCS13                  "CCS: diagnosis 13"
label var DXCCS14                  "CCS: diagnosis 14"
label var DXCCS15                  "CCS: diagnosis 15"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var ELECTIVE                 "Elective versus non-elective admission"
label var NECODE                   "Number of E codes on this record"
label var DX1                      "I:Principal diagnosis"
label var PR1                      "I:Principal procedure"
label var DX2                      "I:Diagnosis 2"
label var DX3                      "I:Diagnosis 3"
label var DX4                      "I:Diagnosis 4"
label var DX5                      "I:Diagnosis 5"
label var DX6                      "I:Diagnosis 6"
label var DX7                      "I:Diagnosis 7"
label var DX8                      "I:Diagnosis 8"
label var DX9                      "I:Diagnosis 9"
label var DX10                     "I:Diagnosis 10"
label var DX11                     "I:Diagnosis 11"
label var DX12                     "I:Diagnosis 12"
label var DX13                     "I:Diagnosis 13"
label var DX14                     "I:Diagnosis 14"
label var DX15                     "I:Diagnosis 15"
label var PR2                      "I:Procedure 2"
label var PR3                      "I:Procedure 3"
label var PR4                      "I:Procedure 4"
label var PR5                      "I:Procedure 5"
label var PR6                      "I:Procedure 6"
label var PR7                      "I:Procedure 7"
label var PR8                      "I:Procedure 8"
label var PR9                      "I:Procedure 9"
label var PR10                     "I:Procedure 10"
label var PR11                     "I:Procedure 11"
label var PR12                     "I:Procedure 12"
label var PR13                     "I:Procedure 13"
label var PR14                     "I:Procedure 14"
label var PR15                     "I:Procedure 15"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var MDNUM1_S                 "Physician 1 number (synthetic)"
label var MDNUM2_S                 "Physician 2 number (synthetic)"

*** Convert special values to missing values ***
recode TRENDWT                   (-99.9999999 -88.8888888 -66.6666666=.)
recode SEQ                       (-999999999999 -888888888888 -666666666666=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRCCS7                    (-99 -88 -66=.)
recode PRCCS8                    (-99 -88 -66=.)
recode PRCCS9                    (-99 -88 -66=.)
recode PRCCS10                   (-99 -88 -66=.)
recode PRCCS11                   (-99 -88 -66=.)
recode PRCCS12                   (-99 -88 -66=.)
recode PRCCS13                   (-99 -88 -66=.)
recode PRCCS14                   (-99 -88 -66=.)
recode PRCCS15                   (-99 -88 -66=.)
recode NIS_STRATUM               (-999 -888 -666=.)
recode TOTAL_DISC                (-99999 -88888 -66666=.)
recode HOSP_BEDSIZE              (-9 -8 -6 -5=.)
recode HOSP_CONTROL              (-9 -8 -6 -5=.)
recode HOSP_LOCATION             (-9 -8 -6 -5=.)
recode HOSP_LOCTEACH             (-9 -8 -6 -5=.)
recode HOSP_REGION               (-9 -8 -6 -5=.)
recode HOSP_TEACH                (-9 -8 -6 -5=.)
recode NDX                       (-9 -8 -6 -5=.)
recode DXCCS1                    (-99 -88 -66=.)
recode DXCCS2                    (-99 -88 -66=.)
recode DXCCS3                    (-99 -88 -66=.)
recode DXCCS4                    (-99 -88 -66=.)
recode DXCCS5                    (-99 -88 -66=.)
recode DXCCS6                    (-99 -88 -66=.)
recode DXCCS7                    (-99 -88 -66=.)
recode DXCCS8                    (-99 -88 -66=.)
recode DXCCS9                    (-99 -88 -66=.)
recode DXCCS10                   (-99 -88 -66=.)
recode DXCCS11                   (-99 -88 -66=.)
recode DXCCS12                   (-99 -88 -66=.)
recode DXCCS13                   (-99 -88 -66=.)
recode DXCCS14                   (-99 -88 -66=.)
recode DXCCS15                   (-99 -88 -66=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode ELECTIVE                  (-9 -8 -6 -5=.)
recode NECODE                    (-99 -88 -66=.)

save "NIS_1995_Supplemental.dta", replace
