/*****************************************************************************
* Stataload_NIS_2015Q4_Severity.Do
* This program will load the NIS_2015Q4_Severity ASCII File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix int    APRDRG                       1-   4   ///
      byte   APRDRG_Risk_Mortality        5-   6   ///
      byte   APRDRG_Severity              7-   8   ///
      long   HOSP_NIS                     9-  13   ///
      double KEY_NIS                     14-  23   ///
      using  "NIS_2015Q4_Severity.ASC"

***  Assign labels to the data elements ***
label var APRDRG                   "All Patient Refined DRG"
label var APRDRG_Risk_Mortality    "All Patient Refined DRG: Risk of Mortality Subclass"
label var APRDRG_Severity          "All Patient Refined DRG: Severity of Illness Subclass"
label var HOSP_NIS                 "NIS hospital number"
label var KEY_NIS                  "NIS record number"

*** Convert special values to missing values ***
recode APRDRG                    (-999 -888 -666=.)
recode APRDRG_Risk_Mortality     (-9 -8 -6 -5=.)
recode APRDRG_Severity           (-9 -8 -6 -5=.)
recode HOSP_NIS                  (-9999 -8888 -6666=.)
recode KEY_NIS                   (-999999999 -888888888 -666666666=.)

save "NIS_2015Q4_Severity.dta", replace
