/*****************************************************************************
* Stataload_NIS_2014_DX_PR_GRPS.Do
* This program will load the 2014 NIS ASCII DX_PR_GRPS File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix long   HOSP_NIS                     1-   5   ///
      double KEY_NIS                      6-  15   ///
      int    BODYSYSTEM1                 16-  18   ///
      int    BODYSYSTEM2                 19-  21   ///
      int    BODYSYSTEM3                 22-  24   ///
      int    BODYSYSTEM4                 25-  27   ///
      int    BODYSYSTEM5                 28-  30   ///
      int    BODYSYSTEM6                 31-  33   ///
      int    BODYSYSTEM7                 34-  36   ///
      int    BODYSYSTEM8                 37-  39   ///
      int    BODYSYSTEM9                 40-  42   ///
      int    BODYSYSTEM10                43-  45   ///
      int    BODYSYSTEM11                46-  48   ///
      int    BODYSYSTEM12                49-  51   ///
      int    BODYSYSTEM13                52-  54   ///
      int    BODYSYSTEM14                55-  57   ///
      int    BODYSYSTEM15                58-  60   ///
      int    BODYSYSTEM16                61-  63   ///
      int    BODYSYSTEM17                64-  66   ///
      int    BODYSYSTEM18                67-  69   ///
      int    BODYSYSTEM19                70-  72   ///
      int    BODYSYSTEM20                73-  75   ///
      int    BODYSYSTEM21                76-  78   ///
      int    BODYSYSTEM22                79-  81   ///
      int    BODYSYSTEM23                82-  84   ///
      int    BODYSYSTEM24                85-  87   ///
      int    BODYSYSTEM25                88-  90   ///
      int    BODYSYSTEM26                91-  93   ///
      int    BODYSYSTEM27                94-  96   ///
      int    BODYSYSTEM28                97-  99   ///
      int    BODYSYSTEM29               100- 102   ///
      int    BODYSYSTEM30               103- 105   ///
      int    CHRON1                     106- 108   ///
      int    CHRON2                     109- 111   ///
      int    CHRON3                     112- 114   ///
      int    CHRON4                     115- 117   ///
      int    CHRON5                     118- 120   ///
      int    CHRON6                     121- 123   ///
      int    CHRON7                     124- 126   ///
      int    CHRON8                     127- 129   ///
      int    CHRON9                     130- 132   ///
      int    CHRON10                    133- 135   ///
      int    CHRON11                    136- 138   ///
      int    CHRON12                    139- 141   ///
      int    CHRON13                    142- 144   ///
      int    CHRON14                    145- 147   ///
      int    CHRON15                    148- 150   ///
      int    CHRON16                    151- 153   ///
      int    CHRON17                    154- 156   ///
      int    CHRON18                    157- 159   ///
      int    CHRON19                    160- 162   ///
      int    CHRON20                    163- 165   ///
      int    CHRON21                    166- 168   ///
      int    CHRON22                    169- 171   ///
      int    CHRON23                    172- 174   ///
      int    CHRON24                    175- 177   ///
      int    CHRON25                    178- 180   ///
      int    CHRON26                    181- 183   ///
      int    CHRON27                    184- 186   ///
      int    CHRON28                    187- 189   ///
      int    CHRON29                    190- 192   ///
      int    CHRON30                    193- 195   ///
      str    DXMCCS1                    196- 206   ///
      str    E_MCCS1                    207- 217   ///
      int    PCLASS1                    218- 220   ///
      int    PCLASS2                    221- 223   ///
      int    PCLASS3                    224- 226   ///
      int    PCLASS4                    227- 229   ///
      int    PCLASS5                    230- 232   ///
      int    PCLASS6                    233- 235   ///
      int    PCLASS7                    236- 238   ///
      int    PCLASS8                    239- 241   ///
      int    PCLASS9                    242- 244   ///
      int    PCLASS10                   245- 247   ///
      int    PCLASS11                   248- 250   ///
      int    PCLASS12                   251- 253   ///
      int    PCLASS13                   254- 256   ///
      int    PCLASS14                   257- 259   ///
      int    PCLASS15                   260- 262   ///
      str    PRMCCS1                    263- 270   ///
      using  "NIS_2014_DX_PR_GRPS.ASC"

***  Assign labels to the data elements ***
label var HOSP_NIS                 "NIS hospital number"
label var KEY_NIS                  "NIS record number"
label var BODYSYSTEM1              "Body system 1"
label var BODYSYSTEM2              "Body system 2"
label var BODYSYSTEM3              "Body system 3"
label var BODYSYSTEM4              "Body system 4"
label var BODYSYSTEM5              "Body system 5"
label var BODYSYSTEM6              "Body system 6"
label var BODYSYSTEM7              "Body system 7"
label var BODYSYSTEM8              "Body system 8"
label var BODYSYSTEM9              "Body system 9"
label var BODYSYSTEM10             "Body system 10"
label var BODYSYSTEM11             "Body system 11"
label var BODYSYSTEM12             "Body system 12"
label var BODYSYSTEM13             "Body system 13"
label var BODYSYSTEM14             "Body system 14"
label var BODYSYSTEM15             "Body system 15"
label var BODYSYSTEM16             "Body system 16"
label var BODYSYSTEM17             "Body system 17"
label var BODYSYSTEM18             "Body system 18"
label var BODYSYSTEM19             "Body system 19"
label var BODYSYSTEM20             "Body system 20"
label var BODYSYSTEM21             "Body system 21"
label var BODYSYSTEM22             "Body system 22"
label var BODYSYSTEM23             "Body system 23"
label var BODYSYSTEM24             "Body system 24"
label var BODYSYSTEM25             "Body system 25"
label var BODYSYSTEM26             "Body system 26"
label var BODYSYSTEM27             "Body system 27"
label var BODYSYSTEM28             "Body system 28"
label var BODYSYSTEM29             "Body system 29"
label var BODYSYSTEM30             "Body system 30"
label var CHRON1                   "Chronic condition indicator 1"
label var CHRON2                   "Chronic condition indicator 2"
label var CHRON3                   "Chronic condition indicator 3"
label var CHRON4                   "Chronic condition indicator 4"
label var CHRON5                   "Chronic condition indicator 5"
label var CHRON6                   "Chronic condition indicator 6"
label var CHRON7                   "Chronic condition indicator 7"
label var CHRON8                   "Chronic condition indicator 8"
label var CHRON9                   "Chronic condition indicator 9"
label var CHRON10                  "Chronic condition indicator 10"
label var CHRON11                  "Chronic condition indicator 11"
label var CHRON12                  "Chronic condition indicator 12"
label var CHRON13                  "Chronic condition indicator 13"
label var CHRON14                  "Chronic condition indicator 14"
label var CHRON15                  "Chronic condition indicator 15"
label var CHRON16                  "Chronic condition indicator 16"
label var CHRON17                  "Chronic condition indicator 17"
label var CHRON18                  "Chronic condition indicator 18"
label var CHRON19                  "Chronic condition indicator 19"
label var CHRON20                  "Chronic condition indicator 20"
label var CHRON21                  "Chronic condition indicator 21"
label var CHRON22                  "Chronic condition indicator 22"
label var CHRON23                  "Chronic condition indicator 23"
label var CHRON24                  "Chronic condition indicator 24"
label var CHRON25                  "Chronic condition indicator 25"
label var CHRON26                  "Chronic condition indicator 26"
label var CHRON27                  "Chronic condition indicator 27"
label var CHRON28                  "Chronic condition indicator 28"
label var CHRON29                  "Chronic condition indicator 29"
label var CHRON30                  "Chronic condition indicator 30"
label var DXMCCS1                  "Multi-Level CCS:  Diagnosis 1"
label var E_MCCS1                  "Multi-Level CCS:  E Code 1"
label var PCLASS1                  "Procedure class 1"
label var PCLASS2                  "Procedure class 2"
label var PCLASS3                  "Procedure class 3"
label var PCLASS4                  "Procedure class 4"
label var PCLASS5                  "Procedure class 5"
label var PCLASS6                  "Procedure class 6"
label var PCLASS7                  "Procedure class 7"
label var PCLASS8                  "Procedure class 8"
label var PCLASS9                  "Procedure class 9"
label var PCLASS10                 "Procedure class 10"
label var PCLASS11                 "Procedure class 11"
label var PCLASS12                 "Procedure class 12"
label var PCLASS13                 "Procedure class 13"
label var PCLASS14                 "Procedure class 14"
label var PCLASS15                 "Procedure class 15"
label var PRMCCS1                  "Multi-Level CCS:  Procedure 1"

*** Convert special values to missing values ***
recode HOSP_NIS                  (-9999 -8888 -6666=.)
recode KEY_NIS                   (-999999999 -888888888 -666666666=.)
recode BODYSYSTEM1               (-99 -88 -66=.)
recode BODYSYSTEM2               (-99 -88 -66=.)
recode BODYSYSTEM3               (-99 -88 -66=.)
recode BODYSYSTEM4               (-99 -88 -66=.)
recode BODYSYSTEM5               (-99 -88 -66=.)
recode BODYSYSTEM6               (-99 -88 -66=.)
recode BODYSYSTEM7               (-99 -88 -66=.)
recode BODYSYSTEM8               (-99 -88 -66=.)
recode BODYSYSTEM9               (-99 -88 -66=.)
recode BODYSYSTEM10              (-99 -88 -66=.)
recode BODYSYSTEM11              (-99 -88 -66=.)
recode BODYSYSTEM12              (-99 -88 -66=.)
recode BODYSYSTEM13              (-99 -88 -66=.)
recode BODYSYSTEM14              (-99 -88 -66=.)
recode BODYSYSTEM15              (-99 -88 -66=.)
recode BODYSYSTEM16              (-99 -88 -66=.)
recode BODYSYSTEM17              (-99 -88 -66=.)
recode BODYSYSTEM18              (-99 -88 -66=.)
recode BODYSYSTEM19              (-99 -88 -66=.)
recode BODYSYSTEM20              (-99 -88 -66=.)
recode BODYSYSTEM21              (-99 -88 -66=.)
recode BODYSYSTEM22              (-99 -88 -66=.)
recode BODYSYSTEM23              (-99 -88 -66=.)
recode BODYSYSTEM24              (-99 -88 -66=.)
recode BODYSYSTEM25              (-99 -88 -66=.)
recode BODYSYSTEM26              (-99 -88 -66=.)
recode BODYSYSTEM27              (-99 -88 -66=.)
recode BODYSYSTEM28              (-99 -88 -66=.)
recode BODYSYSTEM29              (-99 -88 -66=.)
recode BODYSYSTEM30              (-99 -88 -66=.)
recode CHRON1                    (-99 -88 -66=.)
recode CHRON2                    (-99 -88 -66=.)
recode CHRON3                    (-99 -88 -66=.)
recode CHRON4                    (-99 -88 -66=.)
recode CHRON5                    (-99 -88 -66=.)
recode CHRON6                    (-99 -88 -66=.)
recode CHRON7                    (-99 -88 -66=.)
recode CHRON8                    (-99 -88 -66=.)
recode CHRON9                    (-99 -88 -66=.)
recode CHRON10                   (-99 -88 -66=.)
recode CHRON11                   (-99 -88 -66=.)
recode CHRON12                   (-99 -88 -66=.)
recode CHRON13                   (-99 -88 -66=.)
recode CHRON14                   (-99 -88 -66=.)
recode CHRON15                   (-99 -88 -66=.)
recode CHRON16                   (-99 -88 -66=.)
recode CHRON17                   (-99 -88 -66=.)
recode CHRON18                   (-99 -88 -66=.)
recode CHRON19                   (-99 -88 -66=.)
recode CHRON20                   (-99 -88 -66=.)
recode CHRON21                   (-99 -88 -66=.)
recode CHRON22                   (-99 -88 -66=.)
recode CHRON23                   (-99 -88 -66=.)
recode CHRON24                   (-99 -88 -66=.)
recode CHRON25                   (-99 -88 -66=.)
recode CHRON26                   (-99 -88 -66=.)
recode CHRON27                   (-99 -88 -66=.)
recode CHRON28                   (-99 -88 -66=.)
recode CHRON29                   (-99 -88 -66=.)
recode CHRON30                   (-99 -88 -66=.)
recode PCLASS1                   (-99 -88 -66=.)
recode PCLASS2                   (-99 -88 -66=.)
recode PCLASS3                   (-99 -88 -66=.)
recode PCLASS4                   (-99 -88 -66=.)
recode PCLASS5                   (-99 -88 -66=.)
recode PCLASS6                   (-99 -88 -66=.)
recode PCLASS7                   (-99 -88 -66=.)
recode PCLASS8                   (-99 -88 -66=.)
recode PCLASS9                   (-99 -88 -66=.)
recode PCLASS10                  (-99 -88 -66=.)
recode PCLASS11                  (-99 -88 -66=.)
recode PCLASS12                  (-99 -88 -66=.)
recode PCLASS13                  (-99 -88 -66=.)
recode PCLASS14                  (-99 -88 -66=.)
recode PCLASS15                  (-99 -88 -66=.)

save "NIS_2014_DX_PR_GRPS.dta", replace
