/*****************************************************************************
* Stataload_NIS_2008_DX_PR_GRPS.Do
* This program will load the 2008 NIS ASCII DX_PR_GRPS File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix long   HOSPID                      1-  5   ///
      double KEY                         6- 19   ///
      int    CHRON1                     20- 22   ///
      int    CHRON2                     23- 25   ///
      int    CHRON3                     26- 28   ///
      int    CHRON4                     29- 31   ///
      int    CHRON5                     32- 34   ///
      int    CHRON6                     35- 37   ///
      int    CHRON7                     38- 40   ///
      int    CHRON8                     41- 43   ///
      int    CHRON9                     44- 46   ///
      int    CHRON10                    47- 49   ///
      int    CHRON11                    50- 52   ///
      int    CHRON12                    53- 55   ///
      int    CHRON13                    56- 58   ///
      int    CHRON14                    59- 61   ///
      int    CHRON15                    62- 64   ///
      int    CHRONB1                    65- 67   ///
      int    CHRONB2                    68- 70   ///
      int    CHRONB3                    71- 73   ///
      int    CHRONB4                    74- 76   ///
      int    CHRONB5                    77- 79   ///
      int    CHRONB6                    80- 82   ///
      int    CHRONB7                    83- 85   ///
      int    CHRONB8                    86- 88   ///
      int    CHRONB9                    89- 91   ///
      int    CHRONB10                   92- 94   ///
      int    CHRONB11                   95- 97   ///
      int    CHRONB12                   98-100   ///
      int    CHRONB13                  101-103   ///
      int    CHRONB14                  104-106   ///
      int    CHRONB15                  107-109   ///
      int    PCLASS1                   110-112   ///
      int    PCLASS2                   113-115   ///
      int    PCLASS3                   116-118   ///
      int    PCLASS4                   119-121   ///
      int    PCLASS5                   122-124   ///
      int    PCLASS6                   125-127   ///
      int    PCLASS7                   128-130   ///
      int    PCLASS8                   131-133   ///
      int    PCLASS9                   134-136   ///
      int    PCLASS10                  137-139   ///
      int    PCLASS11                  140-142   ///
      int    PCLASS12                  143-145   ///
      int    PCLASS13                  146-148   ///
      int    PCLASS14                  149-151   ///
      int    PCLASS15                  152-154   ///
      using  "NIS_2008_DX_PR_GRPS.ASC"

***  Assign labels to the data elements ***
label var HOSPID                   "HCUP hospital identification number"
label var KEY                      "HCUP record identifier"
label var CHRON1                   "Chronic condition indicator 1"
label var CHRON2                   "Chronic condition indicator 2"
label var CHRON3                   "Chronic condition indicator 3"
label var CHRON4                   "Chronic condition indicator 4"
label var CHRON5                   "Chronic condition indicator 5"
label var CHRON6                   "Chronic condition indicator 6"
label var CHRON7                   "Chronic condition indicator 7"
label var CHRON8                   "Chronic condition indicator 8"
label var CHRON9                   "Chronic condition indicator 9"
label var CHRON10                  "Chronic condition indicator 10"
label var CHRON11                  "Chronic condition indicator 11"
label var CHRON12                  "Chronic condition indicator 12"
label var CHRON13                  "Chronic condition indicator 13"
label var CHRON14                  "Chronic condition indicator 14"
label var CHRON15                  "Chronic condition indicator 15"
label var CHRONB1                  "Chronic condition body system 1"
label var CHRONB2                  "Chronic condition body system 2"
label var CHRONB3                  "Chronic condition body system 3"
label var CHRONB4                  "Chronic condition body system 4"
label var CHRONB5                  "Chronic condition body system 5"
label var CHRONB6                  "Chronic condition body system 6"
label var CHRONB7                  "Chronic condition body system 7"
label var CHRONB8                  "Chronic condition body system 8"
label var CHRONB9                  "Chronic condition body system 9"
label var CHRONB10                 "Chronic condition body system 10"
label var CHRONB11                 "Chronic condition body system 11"
label var CHRONB12                 "Chronic condition body system 12"
label var CHRONB13                 "Chronic condition body system 13"
label var CHRONB14                 "Chronic condition body system 14"
label var CHRONB15                 "Chronic condition body system 15"
label var PCLASS1                  "Procedure class 1"
label var PCLASS2                  "Procedure class 2"
label var PCLASS3                  "Procedure class 3"
label var PCLASS4                  "Procedure class 4"
label var PCLASS5                  "Procedure class 5"
label var PCLASS6                  "Procedure class 6"
label var PCLASS7                  "Procedure class 7"
label var PCLASS8                  "Procedure class 8"
label var PCLASS9                  "Procedure class 9"
label var PCLASS10                 "Procedure class 10"
label var PCLASS11                 "Procedure class 11"
label var PCLASS12                 "Procedure class 12"
label var PCLASS13                 "Procedure class 13"
label var PCLASS14                 "Procedure class 14"
label var PCLASS15                 "Procedure class 15"

*** Convert special values to missing values ***
recode CHRON1                    (-99 -88 -66=.)
recode CHRON2                    (-99 -88 -66=.)
recode CHRON3                    (-99 -88 -66=.)
recode CHRON4                    (-99 -88 -66=.)
recode CHRON5                    (-99 -88 -66=.)
recode CHRON6                    (-99 -88 -66=.)
recode CHRON7                    (-99 -88 -66=.)
recode CHRON8                    (-99 -88 -66=.)
recode CHRON9                    (-99 -88 -66=.)
recode CHRON10                   (-99 -88 -66=.)
recode CHRON11                   (-99 -88 -66=.)
recode CHRON12                   (-99 -88 -66=.)
recode CHRON13                   (-99 -88 -66=.)
recode CHRON14                   (-99 -88 -66=.)
recode CHRON15                   (-99 -88 -66=.)
recode CHRONB1                   (-99 -88 -66=.)
recode CHRONB2                   (-99 -88 -66=.)
recode CHRONB3                   (-99 -88 -66=.)
recode CHRONB4                   (-99 -88 -66=.)
recode CHRONB5                   (-99 -88 -66=.)
recode CHRONB6                   (-99 -88 -66=.)
recode CHRONB7                   (-99 -88 -66=.)
recode CHRONB8                   (-99 -88 -66=.)
recode CHRONB9                   (-99 -88 -66=.)
recode CHRONB10                  (-99 -88 -66=.)
recode CHRONB11                  (-99 -88 -66=.)
recode CHRONB12                  (-99 -88 -66=.)
recode CHRONB13                  (-99 -88 -66=.)
recode CHRONB14                  (-99 -88 -66=.)
recode CHRONB15                  (-99 -88 -66=.)
recode PCLASS1                   (-99 -88 -66=.)
recode PCLASS2                   (-99 -88 -66=.)
recode PCLASS3                   (-99 -88 -66=.)
recode PCLASS4                   (-99 -88 -66=.)
recode PCLASS5                   (-99 -88 -66=.)
recode PCLASS6                   (-99 -88 -66=.)
recode PCLASS7                   (-99 -88 -66=.)
recode PCLASS8                   (-99 -88 -66=.)
recode PCLASS9                   (-99 -88 -66=.)
recode PCLASS10                  (-99 -88 -66=.)
recode PCLASS11                  (-99 -88 -66=.)
recode PCLASS12                  (-99 -88 -66=.)
recode PCLASS13                  (-99 -88 -66=.)
recode PCLASS14                  (-99 -88 -66=.)
recode PCLASS15                  (-99 -88 -66=.)

save "NIS_2008_DX_PR_GRPS.dta", replace
