/*****************************************************************************
* Stataload_NIS_2007_Core.Do
* This program will load the 2007 NIS ASCII Core File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix int    AGE                         1-  3   ///
      int    AGEDAY                      4-  6   ///
      byte   AMONTH                      7-  8   ///
      byte   ASOURCE                     9- 10   ///
      str    ASOURCEUB92                11       ///
      str    ASOURCE_X                  12- 19   ///
      byte   ATYPE                      20- 21   ///
      byte   AWEEKEND                   22- 23   ///
      byte   DIED                       24- 25   ///
      double DISCWT                     26- 36   ///
      byte   DISPUB04                   37- 38   ///
      byte   DISPUNIFORM                39- 40   ///
      byte   DQTR                       41- 42   ///
      byte   DQTR_X                     43- 44   ///
      int    DRG                        45- 47   ///
      int    DRG24                      48- 50   ///
      byte   DRGVER                     51- 52   ///
      str    DSHOSPID                   53- 65   ///
      str    DX1                        66- 70   ///
      str    DX2                        71- 75   ///
      str    DX3                        76- 80   ///
      str    DX4                        81- 85   ///
      str    DX5                        86- 90   ///
      str    DX6                        91- 95   ///
      str    DX7                        96-100   ///
      str    DX8                       101-105   ///
      str    DX9                       106-110   ///
      str    DX10                      111-115   ///
      str    DX11                      116-120   ///
      str    DX12                      121-125   ///
      str    DX13                      126-130   ///
      str    DX14                      131-135   ///
      str    DX15                      136-140   ///
      int    DXCCS1                    141-143   ///
      int    DXCCS2                    144-146   ///
      int    DXCCS3                    147-149   ///
      int    DXCCS4                    150-152   ///
      int    DXCCS5                    153-155   ///
      int    DXCCS6                    156-158   ///
      int    DXCCS7                    159-161   ///
      int    DXCCS8                    162-164   ///
      int    DXCCS9                    165-167   ///
      int    DXCCS10                   168-170   ///
      int    DXCCS11                   171-173   ///
      int    DXCCS12                   174-176   ///
      int    DXCCS13                   177-179   ///
      int    DXCCS14                   180-182   ///
      int    DXCCS15                   183-185   ///
      str    ECODE1                    186-190   ///
      str    ECODE2                    191-195   ///
      str    ECODE3                    196-200   ///
      str    ECODE4                    201-205   ///
      byte   ELECTIVE                  206-207   ///
      int    E_CCS1                    208-211   ///
      int    E_CCS2                    212-215   ///
      int    E_CCS3                    216-219   ///
      int    E_CCS4                    220-223   ///
      byte   FEMALE                    224-225   ///
      int    HCUP_ED                   226-228   ///
      byte   HOSPBRTH                  229-230   ///
      long   HOSPID                    231-235   ///
      str    HOSPST                    236-237   ///
      double KEY                       238-251   ///
      long   LOS                       252-256   ///
      long   LOS_X                     257-262   ///
      byte   MDC                       263-264   ///
      byte   MDC24                     265-266   ///
      long   MDNUM1_R                  267-271   ///
      long   MDNUM2_R                  272-276   ///
      byte   NDX                       277-278   ///
      int    NECODE                    279-281   ///
      byte   NEOMAT                    282-283   ///
      int    NIS_STRATUM               284-287   ///
      byte   NPR                       288-289   ///
      byte   PAY1                      290-291   ///
      str    PAY1_X                    292-301   ///
      byte   PAY2                      302-303   ///
      str    PAY2_X                    304-313   ///
      int    PL_NCHS2006               314-316   ///
      str    PR1                       317-320   ///
      str    PR2                       321-324   ///
      str    PR3                       325-328   ///
      str    PR4                       329-332   ///
      str    PR5                       333-336   ///
      str    PR6                       337-340   ///
      str    PR7                       341-344   ///
      str    PR8                       345-348   ///
      str    PR9                       349-352   ///
      str    PR10                      353-356   ///
      str    PR11                      357-360   ///
      str    PR12                      361-364   ///
      str    PR13                      365-368   ///
      str    PR14                      369-372   ///
      str    PR15                      373-376   ///
      int    PRCCS1                    377-379   ///
      int    PRCCS2                    380-382   ///
      int    PRCCS3                    383-385   ///
      int    PRCCS4                    386-388   ///
      int    PRCCS5                    389-391   ///
      int    PRCCS6                    392-394   ///
      int    PRCCS7                    395-397   ///
      int    PRCCS8                    398-400   ///
      int    PRCCS9                    401-403   ///
      int    PRCCS10                   404-406   ///
      int    PRCCS11                   407-409   ///
      int    PRCCS12                   410-412   ///
      int    PRCCS13                   413-415   ///
      int    PRCCS14                   416-418   ///
      int    PRCCS15                   419-421   ///
      int    PRDAY1                    422-424   ///
      int    PRDAY2                    425-427   ///
      int    PRDAY3                    428-430   ///
      int    PRDAY4                    431-433   ///
      int    PRDAY5                    434-436   ///
      int    PRDAY6                    437-439   ///
      int    PRDAY7                    440-442   ///
      int    PRDAY8                    443-445   ///
      int    PRDAY9                    446-448   ///
      int    PRDAY10                   449-451   ///
      int    PRDAY11                   452-454   ///
      int    PRDAY12                   455-457   ///
      int    PRDAY13                   458-460   ///
      int    PRDAY14                   461-463   ///
      int    PRDAY15                   464-466   ///
      str    PointOfOriginUB04         467       ///
      str    PointOfOrigin_X           468-475   ///
      byte   RACE                      476-477   ///
      double TOTCHG                    478-487   ///
      double TOTCHG_X                  488-502   ///
      int    YEAR                      503-506   ///
      byte   ZIPINC_QRTL               507-508   ///
      using  "NIS_2007_Core.ASC"

***  Assign labels to the data elements ***
label var AGE                      "Age in years at admission"
label var AGEDAY                   "Age in days (when age < 1 year)"
label var AMONTH                   "Admission month"
label var ASOURCE                  "Admission source (uniform)"
label var ASOURCEUB92              "Admission source (UB-92 standard coding)"
label var ASOURCE_X                "Admission source (as received from source)"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var DIED                     "Died during hospitalization"
label var DISCWT                   "Weight to discharges in AHA universe"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DQTR                     "Discharge quarter"
label var DQTR_X                   "Discharge quarter (as received from source)"
label var DRG                      "DRG in effect on discharge date"
label var DRG24                    "DRG, version 24"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DSHOSPID                 "Data source hospital identifier"
label var DX1                      "Diagnosis 1"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DX10                     "Diagnosis 10"
label var DX11                     "Diagnosis 11"
label var DX12                     "Diagnosis 12"
label var DX13                     "Diagnosis 13"
label var DX14                     "Diagnosis 14"
label var DX15                     "Diagnosis 15"
label var DXCCS1                   "CCS: diagnosis 1"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXCCS10                  "CCS: diagnosis 10"
label var DXCCS11                  "CCS: diagnosis 11"
label var DXCCS12                  "CCS: diagnosis 12"
label var DXCCS13                  "CCS: diagnosis 13"
label var DXCCS14                  "CCS: diagnosis 14"
label var DXCCS15                  "CCS: diagnosis 15"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var ELECTIVE                 "Elective versus non-elective admission"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HOSPBRTH                 "Indicator of birth in this hospital"
label var HOSPID                   "HCUP hospital identification number"
label var HOSPST                   "Hospital state postal code"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDC                      "MDC in effect on discharge date"
label var MDC24                    "MDC, version 24"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MDNUM2_R                 "Physician 2 number (re-identified)"
label var NDX                      "Number of diagnoses on this record"
label var NECODE                   "Number of E codes on this record"
label var NEOMAT                   "Neonatal and/or maternal DX and/or PR"
label var NIS_STRATUM              "Stratum used to sample hospital"
label var NPR                      "Number of procedures on this record"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PAY2                     "Secondary expected payer (uniform)"
label var PAY2_X                   "Secondary expected payer (as received from source)"
label var PL_NCHS2006              "Patient Location: NCHS Urban-Rural Code (V2006)"
label var PR1                      "Procedure 1"
label var PR2                      "Procedure 2"
label var PR3                      "Procedure 3"
label var PR4                      "Procedure 4"
label var PR5                      "Procedure 5"
label var PR6                      "Procedure 6"
label var PR7                      "Procedure 7"
label var PR8                      "Procedure 8"
label var PR9                      "Procedure 9"
label var PR10                     "Procedure 10"
label var PR11                     "Procedure 11"
label var PR12                     "Procedure 12"
label var PR13                     "Procedure 13"
label var PR14                     "Procedure 14"
label var PR15                     "Procedure 15"
label var PRCCS1                   "CCS: procedure 1"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRCCS7                   "CCS: procedure 7"
label var PRCCS8                   "CCS: procedure 8"
label var PRCCS9                   "CCS: procedure 9"
label var PRCCS10                  "CCS: procedure 10"
label var PRCCS11                  "CCS: procedure 11"
label var PRCCS12                  "CCS: procedure 12"
label var PRCCS13                  "CCS: procedure 13"
label var PRCCS14                  "CCS: procedure 14"
label var PRCCS15                  "CCS: procedure 15"
label var PRDAY1                   "Number of days from admission to PR1"
label var PRDAY2                   "Number of days from admission to PR2"
label var PRDAY3                   "Number of days from admission to PR3"
label var PRDAY4                   "Number of days from admission to PR4"
label var PRDAY5                   "Number of days from admission to PR5"
label var PRDAY6                   "Number of days from admission to PR6"
label var PRDAY7                   "Number of days from admission to PR7"
label var PRDAY8                   "Number of days from admission to PR8"
label var PRDAY9                   "Number of days from admission to PR9"
label var PRDAY10                  "Number of days from admission to PR10"
label var PRDAY11                  "Number of days from admission to PR11"
label var PRDAY12                  "Number of days from admission to PR12"
label var PRDAY13                  "Number of days from admission to PR13"
label var PRDAY14                  "Number of days from admission to PR14"
label var PRDAY15                  "Number of days from admission to PR15"
label var PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
label var PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
label var RACE                     "Race (uniform)"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var YEAR                     "Calendar year"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"

*** Convert special values to missing values ***
recode AGE                       (-99 -88 -66=.)
recode AGEDAY                    (-99 -88 -66=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode ASOURCE                   (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISCWT                    (-99.9999999 -88.8888888 -66.6666666=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DQTR_X                    (-9 -8 -6 -5=.)
recode DRG                       (-99 -88 -66=.)
recode DRG24                     (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode DXCCS1                    (-99 -88 -66=.)
recode DXCCS2                    (-99 -88 -66=.)
recode DXCCS3                    (-99 -88 -66=.)
recode DXCCS4                    (-99 -88 -66=.)
recode DXCCS5                    (-99 -88 -66=.)
recode DXCCS6                    (-99 -88 -66=.)
recode DXCCS7                    (-99 -88 -66=.)
recode DXCCS8                    (-99 -88 -66=.)
recode DXCCS9                    (-99 -88 -66=.)
recode DXCCS10                   (-99 -88 -66=.)
recode DXCCS11                   (-99 -88 -66=.)
recode DXCCS12                   (-99 -88 -66=.)
recode DXCCS13                   (-99 -88 -66=.)
recode DXCCS14                   (-99 -88 -66=.)
recode DXCCS15                   (-99 -88 -66=.)
recode ELECTIVE                  (-9 -8 -6 -5=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-99 -88 -66=.)
recode HOSPBRTH                  (-9 -8 -6 -5=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC24                     (-9 -8 -6 -5=.)
recode MDNUM1_R                  (-9999 -8888 -6666=.)
recode MDNUM2_R                  (-9999 -8888 -6666=.)
recode NDX                       (-9 -8 -6 -5=.)
recode NECODE                    (-99 -88 -66=.)
recode NEOMAT                    (-9 -8 -6 -5=.)
recode NIS_STRATUM               (-999 -888 -666=.)
recode NPR                       (-9 -8 -6 -5=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PAY2                      (-9 -8 -6 -5=.)
recode PL_NCHS2006               (-99 -88 -66=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRCCS7                    (-99 -88 -66=.)
recode PRCCS8                    (-99 -88 -66=.)
recode PRCCS9                    (-99 -88 -66=.)
recode PRCCS10                   (-99 -88 -66=.)
recode PRCCS11                   (-99 -88 -66=.)
recode PRCCS12                   (-99 -88 -66=.)
recode PRCCS13                   (-99 -88 -66=.)
recode PRCCS14                   (-99 -88 -66=.)
recode PRCCS15                   (-99 -88 -66=.)
recode PRDAY1                    (-99 -88 -66=.)
recode PRDAY2                    (-99 -88 -66=.)
recode PRDAY3                    (-99 -88 -66=.)
recode PRDAY4                    (-99 -88 -66=.)
recode PRDAY5                    (-99 -88 -66=.)
recode PRDAY6                    (-99 -88 -66=.)
recode PRDAY7                    (-99 -88 -66=.)
recode PRDAY8                    (-99 -88 -66=.)
recode PRDAY9                    (-99 -88 -66=.)
recode PRDAY10                   (-99 -88 -66=.)
recode PRDAY11                   (-99 -88 -66=.)
recode PRDAY12                   (-99 -88 -66=.)
recode PRDAY13                   (-99 -88 -66=.)
recode PRDAY14                   (-99 -88 -66=.)
recode PRDAY15                   (-99 -88 -66=.)
recode RACE                      (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-9 -8 -6 -5=.)

save "NIS_2007_Core.dta", replace
