/*****************************************************************************
* Stataload_NIS_2013_Core.Do
* This program will load the 2013 NIS ASCII Core File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix int    AGE                         1-  3   ///
      byte   AGE_NEONATE                 4-  5   ///
      byte   AMONTH                      6-  7   ///
      byte   AWEEKEND                    8-  9   ///
      byte   DIED                       10- 11   ///
      double DISCWT                     12- 22   ///
      byte   DISPUNIFORM                23- 24   ///
      byte   DQTR                       25- 26   ///
      int    DRG                        27- 29   ///
      int    DRG24                      30- 32   ///
      byte   DRGVER                     33- 34   ///
      int    DRG_NoPOA                  35- 37   ///
      str    DX1                        38- 42   ///
      str    DX2                        43- 47   ///
      str    DX3                        48- 52   ///
      str    DX4                        53- 57   ///
      str    DX5                        58- 62   ///
      str    DX6                        63- 67   ///
      str    DX7                        68- 72   ///
      str    DX8                        73- 77   ///
      str    DX9                        78- 82   ///
      str    DX10                       83- 87   ///
      str    DX11                       88- 92   ///
      str    DX12                       93- 97   ///
      str    DX13                       98-102   ///
      str    DX14                      103-107   ///
      str    DX15                      108-112   ///
      str    DX16                      113-117   ///
      str    DX17                      118-122   ///
      str    DX18                      123-127   ///
      str    DX19                      128-132   ///
      str    DX20                      133-137   ///
      str    DX21                      138-142   ///
      str    DX22                      143-147   ///
      str    DX23                      148-152   ///
      str    DX24                      153-157   ///
      str    DX25                      158-162   ///
      int    DXCCS1                    163-165   ///
      int    DXCCS2                    166-168   ///
      int    DXCCS3                    169-171   ///
      int    DXCCS4                    172-174   ///
      int    DXCCS5                    175-177   ///
      int    DXCCS6                    178-180   ///
      int    DXCCS7                    181-183   ///
      int    DXCCS8                    184-186   ///
      int    DXCCS9                    187-189   ///
      int    DXCCS10                   190-192   ///
      int    DXCCS11                   193-195   ///
      int    DXCCS12                   196-198   ///
      int    DXCCS13                   199-201   ///
      int    DXCCS14                   202-204   ///
      int    DXCCS15                   205-207   ///
      int    DXCCS16                   208-210   ///
      int    DXCCS17                   211-213   ///
      int    DXCCS18                   214-216   ///
      int    DXCCS19                   217-219   ///
      int    DXCCS20                   220-222   ///
      int    DXCCS21                   223-225   ///
      int    DXCCS22                   226-228   ///
      int    DXCCS23                   229-231   ///
      int    DXCCS24                   232-234   ///
      int    DXCCS25                   235-237   ///
      str    ECODE1                    238-242   ///
      str    ECODE2                    243-247   ///
      str    ECODE3                    248-252   ///
      str    ECODE4                    253-257   ///
      byte   ELECTIVE                  258-259   ///
      int    E_CCS1                    260-263   ///
      int    E_CCS2                    264-267   ///
      int    E_CCS3                    268-271   ///
      int    E_CCS4                    272-275   ///
      byte   FEMALE                    276-277   ///
      int    HCUP_ED                   278-280   ///
      byte   HOSPBRTH                  281-282   ///
      byte   HOSP_DIVISION             283-284   ///
      long   HOSP_NIS                  285-289   ///
      double KEY_NIS                   290-299   ///
      long   LOS                       300-304   ///
      byte   MDC                       305-306   ///
      byte   MDC24                     307-308   ///
      byte   MDC_NoPOA                 309-310   ///
      byte   NCHRONIC                  311-312   ///
      byte   NDX                       313-314   ///
      int    NECODE                    315-317   ///
      byte   NEOMAT                    318-319   ///
      int    NIS_STRATUM               320-323   ///
      byte   NPR                       324-325   ///
      byte   ORPROC                    326-327   ///
      byte   PAY1                      328-329   ///
      int    PL_NCHS                   330-332   ///
      str    PR1                       333-336   ///
      str    PR2                       337-340   ///
      str    PR3                       341-344   ///
      str    PR4                       345-348   ///
      str    PR5                       349-352   ///
      str    PR6                       353-356   ///
      str    PR7                       357-360   ///
      str    PR8                       361-364   ///
      str    PR9                       365-368   ///
      str    PR10                      369-372   ///
      str    PR11                      373-376   ///
      str    PR12                      377-380   ///
      str    PR13                      381-384   ///
      str    PR14                      385-388   ///
      str    PR15                      389-392   ///
      int    PRCCS1                    393-395   ///
      int    PRCCS2                    396-398   ///
      int    PRCCS3                    399-401   ///
      int    PRCCS4                    402-404   ///
      int    PRCCS5                    405-407   ///
      int    PRCCS6                    408-410   ///
      int    PRCCS7                    411-413   ///
      int    PRCCS8                    414-416   ///
      int    PRCCS9                    417-419   ///
      int    PRCCS10                   420-422   ///
      int    PRCCS11                   423-425   ///
      int    PRCCS12                   426-428   ///
      int    PRCCS13                   429-431   ///
      int    PRCCS14                   432-434   ///
      int    PRCCS15                   435-437   ///
      int    PRDAY1                    438-440   ///
      int    PRDAY2                    441-443   ///
      int    PRDAY3                    444-446   ///
      int    PRDAY4                    447-449   ///
      int    PRDAY5                    450-452   ///
      int    PRDAY6                    453-455   ///
      int    PRDAY7                    456-458   ///
      int    PRDAY8                    459-461   ///
      int    PRDAY9                    462-464   ///
      int    PRDAY10                   465-467   ///
      int    PRDAY11                   468-470   ///
      int    PRDAY12                   471-473   ///
      int    PRDAY13                   474-476   ///
      int    PRDAY14                   477-479   ///
      int    PRDAY15                   480-482   ///
      byte   RACE                      483-484   ///
      double TOTCHG                    485-494   ///
      byte   TRAN_IN                   495-496   ///
      byte   TRAN_OUT                  497-498   ///
      int    YEAR                      499-502   ///
      byte   ZIPINC_QRTL               503-504   ///
      using  "NIS_2013_Core.ASC"

***  Assign labels to the data elements ***
label var AGE                      "Age in years at admission"
label var AGE_NEONATE              "Neonatal age (first 28 days after birth) indicator"
label var AMONTH                   "Admission month"
label var AWEEKEND                 "Admission day is a weekend"
label var DIED                     "Died during hospitalization"
label var DISCWT                   "NIS discharge weight"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DQTR                     "Discharge quarter"
label var DRG                      "DRG in effect on discharge date"
label var DRG24                    "DRG, version 24"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
label var DX1                      "Diagnosis 1"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DX10                     "Diagnosis 10"
label var DX11                     "Diagnosis 11"
label var DX12                     "Diagnosis 12"
label var DX13                     "Diagnosis 13"
label var DX14                     "Diagnosis 14"
label var DX15                     "Diagnosis 15"
label var DX16                     "Diagnosis 16"
label var DX17                     "Diagnosis 17"
label var DX18                     "Diagnosis 18"
label var DX19                     "Diagnosis 19"
label var DX20                     "Diagnosis 20"
label var DX21                     "Diagnosis 21"
label var DX22                     "Diagnosis 22"
label var DX23                     "Diagnosis 23"
label var DX24                     "Diagnosis 24"
label var DX25                     "Diagnosis 25"
label var DXCCS1                   "CCS: diagnosis 1"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXCCS10                  "CCS: diagnosis 10"
label var DXCCS11                  "CCS: diagnosis 11"
label var DXCCS12                  "CCS: diagnosis 12"
label var DXCCS13                  "CCS: diagnosis 13"
label var DXCCS14                  "CCS: diagnosis 14"
label var DXCCS15                  "CCS: diagnosis 15"
label var DXCCS16                  "CCS: diagnosis 16"
label var DXCCS17                  "CCS: diagnosis 17"
label var DXCCS18                  "CCS: diagnosis 18"
label var DXCCS19                  "CCS: diagnosis 19"
label var DXCCS20                  "CCS: diagnosis 20"
label var DXCCS21                  "CCS: diagnosis 21"
label var DXCCS22                  "CCS: diagnosis 22"
label var DXCCS23                  "CCS: diagnosis 23"
label var DXCCS24                  "CCS: diagnosis 24"
label var DXCCS25                  "CCS: diagnosis 25"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var ELECTIVE                 "Elective versus non-elective admission"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HOSPBRTH                 "Indicator of birth in this hospital"
label var HOSP_DIVISION            "Census Division of hospital"
label var HOSP_NIS                 "NIS hospital number"
label var KEY_NIS                  "NIS record number"
label var LOS                      "Length of stay (cleaned)"
label var MDC                      "MDC in effect on discharge date"
label var MDC24                    "MDC, version 24"
label var MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
label var NCHRONIC                 "Number of chronic conditions"
label var NDX                      "Number of diagnoses on this record"
label var NECODE                   "Number of E codes on this record"
label var NEOMAT                   "Neonatal and/or maternal DX and/or PR"
label var NIS_STRATUM              "NIS hospital stratum"
label var NPR                      "Number of procedures on this record"
label var ORPROC                   "Major operating room procedure indicator"
label var PAY1                     "Primary expected payer (uniform)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PR1                      "Procedure 1"
label var PR2                      "Procedure 2"
label var PR3                      "Procedure 3"
label var PR4                      "Procedure 4"
label var PR5                      "Procedure 5"
label var PR6                      "Procedure 6"
label var PR7                      "Procedure 7"
label var PR8                      "Procedure 8"
label var PR9                      "Procedure 9"
label var PR10                     "Procedure 10"
label var PR11                     "Procedure 11"
label var PR12                     "Procedure 12"
label var PR13                     "Procedure 13"
label var PR14                     "Procedure 14"
label var PR15                     "Procedure 15"
label var PRCCS1                   "CCS: procedure 1"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRCCS7                   "CCS: procedure 7"
label var PRCCS8                   "CCS: procedure 8"
label var PRCCS9                   "CCS: procedure 9"
label var PRCCS10                  "CCS: procedure 10"
label var PRCCS11                  "CCS: procedure 11"
label var PRCCS12                  "CCS: procedure 12"
label var PRCCS13                  "CCS: procedure 13"
label var PRCCS14                  "CCS: procedure 14"
label var PRCCS15                  "CCS: procedure 15"
label var PRDAY1                   "Number of days from admission to PR1"
label var PRDAY2                   "Number of days from admission to PR2"
label var PRDAY3                   "Number of days from admission to PR3"
label var PRDAY4                   "Number of days from admission to PR4"
label var PRDAY5                   "Number of days from admission to PR5"
label var PRDAY6                   "Number of days from admission to PR6"
label var PRDAY7                   "Number of days from admission to PR7"
label var PRDAY8                   "Number of days from admission to PR8"
label var PRDAY9                   "Number of days from admission to PR9"
label var PRDAY10                  "Number of days from admission to PR10"
label var PRDAY11                  "Number of days from admission to PR11"
label var PRDAY12                  "Number of days from admission to PR12"
label var PRDAY13                  "Number of days from admission to PR13"
label var PRDAY14                  "Number of days from admission to PR14"
label var PRDAY15                  "Number of days from admission to PR15"
label var RACE                     "Race (uniform)"
label var TOTCHG                   "Total charges (cleaned)"
label var TRAN_IN                  "Transfer in indicator"
label var TRAN_OUT                 "Transfer out indicator"
label var YEAR                     "Calendar year"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"

*** Convert special values to missing values ***
recode AGE                       (-99 -88 -66=.)
recode AGE_NEONATE               (-9 -8 -6 -5=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISCWT                    (-99.9999999 -88.8888888 -66.6666666=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DRG                       (-99 -88 -66=.)
recode DRG24                     (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode DRG_NoPOA                 (-99 -88 -66=.)
recode DXCCS1                    (-99 -88 -66=.)
recode DXCCS2                    (-99 -88 -66=.)
recode DXCCS3                    (-99 -88 -66=.)
recode DXCCS4                    (-99 -88 -66=.)
recode DXCCS5                    (-99 -88 -66=.)
recode DXCCS6                    (-99 -88 -66=.)
recode DXCCS7                    (-99 -88 -66=.)
recode DXCCS8                    (-99 -88 -66=.)
recode DXCCS9                    (-99 -88 -66=.)
recode DXCCS10                   (-99 -88 -66=.)
recode DXCCS11                   (-99 -88 -66=.)
recode DXCCS12                   (-99 -88 -66=.)
recode DXCCS13                   (-99 -88 -66=.)
recode DXCCS14                   (-99 -88 -66=.)
recode DXCCS15                   (-99 -88 -66=.)
recode DXCCS16                   (-99 -88 -66=.)
recode DXCCS17                   (-99 -88 -66=.)
recode DXCCS18                   (-99 -88 -66=.)
recode DXCCS19                   (-99 -88 -66=.)
recode DXCCS20                   (-99 -88 -66=.)
recode DXCCS21                   (-99 -88 -66=.)
recode DXCCS22                   (-99 -88 -66=.)
recode DXCCS23                   (-99 -88 -66=.)
recode DXCCS24                   (-99 -88 -66=.)
recode DXCCS25                   (-99 -88 -66=.)
recode ELECTIVE                  (-9 -8 -6 -5=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-99 -88 -66=.)
recode HOSPBRTH                  (-9 -8 -6 -5=.)
recode HOSP_DIVISION             (-9 -8 -6 -5=.)
recode HOSP_NIS                  (-9999 -8888 -6666=.)
recode KEY_NIS                   (-999999999 -888888888 -666666666=.)
recode LOS                       (-9999 -8888 -6666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC24                     (-9 -8 -6 -5=.)
recode MDC_NoPOA                 (-9 -8 -6 -5=.)
recode NCHRONIC                  (-9 -8 -6 -5=.)
recode NDX                       (-9 -8 -6 -5=.)
recode NECODE                    (-99 -88 -66=.)
recode NEOMAT                    (-9 -8 -6 -5=.)
recode NIS_STRATUM               (-999 -888 -666=.)
recode NPR                       (-9 -8 -6 -5=.)
recode ORPROC                    (-9 -8 -6 -5=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PL_NCHS                   (-99 -88 -66=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRCCS7                    (-99 -88 -66=.)
recode PRCCS8                    (-99 -88 -66=.)
recode PRCCS9                    (-99 -88 -66=.)
recode PRCCS10                   (-99 -88 -66=.)
recode PRCCS11                   (-99 -88 -66=.)
recode PRCCS12                   (-99 -88 -66=.)
recode PRCCS13                   (-99 -88 -66=.)
recode PRCCS14                   (-99 -88 -66=.)
recode PRCCS15                   (-99 -88 -66=.)
recode PRDAY1                    (-99 -88 -66=.)
recode PRDAY2                    (-99 -88 -66=.)
recode PRDAY3                    (-99 -88 -66=.)
recode PRDAY4                    (-99 -88 -66=.)
recode PRDAY5                    (-99 -88 -66=.)
recode PRDAY6                    (-99 -88 -66=.)
recode PRDAY7                    (-99 -88 -66=.)
recode PRDAY8                    (-99 -88 -66=.)
recode PRDAY9                    (-99 -88 -66=.)
recode PRDAY10                   (-99 -88 -66=.)
recode PRDAY11                   (-99 -88 -66=.)
recode PRDAY12                   (-99 -88 -66=.)
recode PRDAY13                   (-99 -88 -66=.)
recode PRDAY14                   (-99 -88 -66=.)
recode PRDAY15                   (-99 -88 -66=.)
recode RACE                      (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TRAN_IN                   (-9 -8 -6 -5=.)
recode TRAN_OUT                  (-9 -8 -6 -5=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-9 -8 -6 -5=.)

save "NIS_2013_Core.dta", replace
