/*******************************************************************
*   SPSSload_NIS_2003_10PCT_SAMPLE_A.SPS:                               
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII NIS            
*      INPATIENT STAY 10PCT_SAMPLE_A FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'NIS_2003_10PCT_SAMPLE_A.ASC' FIXED / 
 KEY                  1- 14
 AGE                 15- 17
 AGEDAY              18- 20
 AMONTH              21- 22
 ASOURCE             23- 24
 ASOURCEU            25     (A)
 ASOURCE_            26- 33 (A)
 ATYPE               34- 35
 AWEEKEND            36- 37
 DIED                38- 39
 DISCWT10            40- 49
 DISPUB92            50- 51
 DISPUNIF            52- 53
 DQTR                54- 55
 DRG                 56- 58
 DRG18               59- 61
 DRGVER              62- 63
 DSHOSPID            64- 76 (A)
 DX1                 77- 81 (A)
 DX2                 82- 86 (A)
 DX3                 87- 91 (A)
 DX4                 92- 96 (A)
 DX5                 97-101 (A)
 DX6                102-106 (A)
 DX7                107-111 (A)
 DX8                112-116 (A)
 DX9                117-121 (A)
 DX10               122-126 (A)
 DX11               127-131 (A)
 DX12               132-136 (A)
 DX13               137-141 (A)
 DX14               142-146 (A)
 DX15               147-151 (A)
 DXCCS1             152-155
 DXCCS2             156-159
 DXCCS3             160-163
 DXCCS4             164-167
 DXCCS5             168-171
 DXCCS6             172-175
 DXCCS7             176-179
 DXCCS8             180-183
 DXCCS9             184-187
 DXCCS10            188-191
 DXCCS11            192-195
 DXCCS12            196-199
 DXCCS13            200-203
 DXCCS14            204-207
 DXCCS15            208-211
 ECODE1             212-216 (A)
 ECODE2             217-221 (A)
 ECODE3             222-226 (A)
 ECODE4             227-231 (A)
 E_CCS1             232-235
 E_CCS2             236-239
 E_CCS3             240-243
 E_CCS4             244-247
 ELECTIVE           248-249
 FEMALE             250-251
 HOSPID             252-256
 HOSPST             257-258 (A)
 LOS                259-263
 LOS_X              264-269
 MDC                270-271
 MDC18              272-273
 MDNUM1_R           274-278
 MDNUM2_R           279-283
 NDX                284-285
 NECODE             286-288
 NEOMAT             289-290
 NIS_STRA           291-294
 NPR                295-296
 PAY1               297-298
 PAY1_X             299-308 (A)
 PAY2               309-310
 PAY2_X             311-320 (A)
 PL_UR_CA           321-322
 PR1                323-326 (A)
 PR2                327-330 (A)
 PR3                331-334 (A)
 PR4                335-338 (A)
 PR5                339-342 (A)
 PR6                343-346 (A)
 PR7                347-350 (A)
 PR8                351-354 (A)
 PR9                355-358 (A)
 PR10               359-362 (A)
 PR11               363-366 (A)
 PR12               367-370 (A)
 PR13               371-374 (A)
 PR14               375-378 (A)
 PR15               379-382 (A)
 PRCCS1             383-385
 PRCCS2             386-388
 PRCCS3             389-391
 PRCCS4             392-394
 PRCCS5             395-397
 PRCCS6             398-400
 PRCCS7             401-403
 PRCCS8             404-406
 PRCCS9             407-409
 PRCCS10            410-412
 PRCCS11            413-415
 PRCCS12            416-418
 PRCCS13            419-421
 PRCCS14            422-424
 PRCCS15            425-427
 PRDAY1             428-430
 PRDAY2             431-433
 PRDAY3             434-436
 PRDAY4             437-439
 PRDAY5             440-442
 PRDAY6             443-445
 PRDAY7             446-448
 PRDAY8             449-451
 PRDAY9             452-454
 PRDAY10            455-457
 PRDAY11            458-460
 PRDAY12            461-463
 PRDAY13            464-466
 PRDAY14            467-469
 PRDAY15            470-472
 RACE               473-474
 TOTCHG             475-484
 TOTCHG_X           485-499
 YEAR               500-503
 ZIPInc_Q           504-505.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AMONTH              (F3.0) /
 ASOURCE             (F3.0) /
 ATYPE               (F3.0) /
 AWEEKEND            (F3.0) /
 DIED                (F3.0) /
 DISCWT10            (F8.4) /
 DISPUB92            (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DRG                 (F3.0) /
 DRG18               (F3.0) /
 DRGVER              (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 DXCCS10             (F4.0) /
 DXCCS11             (F4.0) /
 DXCCS12             (F4.0) /
 DXCCS13             (F4.0) /
 DXCCS14             (F4.0) /
 DXCCS15             (F4.0) /
 E_CCS1              (F3.0) /
 E_CCS2              (F3.0) /
 E_CCS3              (F3.0) /
 E_CCS4              (F3.0) /
 ELECTIVE            (F3.0) /
 FEMALE              (F3.0) /
 HOSPID              (F4.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 MDC                 (F3.0) /
 MDC18               (F3.0) /
 MDNUM1_R            (F5.0) /
 MDNUM2_R            (F5.0) /
 NDX                 (F3.0) /
 NECODE              (F3.0) /
 NEOMAT              (F3.0) /
 NIS_STRA            (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PAY2                (F3.0) /
 PL_UR_CA            (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRCCS7              (F3.0) /
 PRCCS8              (F3.0) /
 PRCCS9              (F3.0) /
 PRCCS10             (F3.0) /
 PRCCS11             (F3.0) /
 PRCCS12             (F3.0) /
 PRCCS13             (F3.0) /
 PRCCS14             (F3.0) /
 PRCCS15             (F3.0) /
 PRDAY1              (F4.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 PRDAY4              (F4.0) /
 PRDAY5              (F4.0) /
 PRDAY6              (F4.0) /
 PRDAY7              (F4.0) /
 PRDAY8              (F4.0) /
 PRDAY9              (F4.0) /
 PRDAY10             (F4.0) /
 PRDAY11             (F4.0) /
 PRDAY12             (F4.0) /
 PRDAY13             (F4.0) /
 PRDAY14             (F4.0) /
 PRDAY15             (F4.0) /
 RACE                (F3.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) /
 ZIPInc_Q            (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ASOURCE_  "Admission source (as received from source)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 DIED      "Died during hospitalization"
 DISCWT10  "10% subsample weight to discharges in AHA universe"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG18     "DRG, version 18"
 DRGVER    "DRG grouper version used on discharge date"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 ELECTIVE  "Elective versus non-elective admission"
 FEMALE    "Indicator of sex"
 HOSPID    "HCUP hospital identification number"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC18     "MDC, version 18"
 MDNUM1_R  "Physician 1 number (re-identified)"
 MDNUM2_R  "Physician 2 number (re-identified)"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NIS_STRA  "Stratum used to sample hospital"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2      "Secondary expected payer (uniform)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PRDAY7    "Number of days from admission to PR7"
 PRDAY8    "Number of days from admission to PR8"
 PRDAY9    "Number of days from admission to PR9"
 PRDAY10   "Number of days from admission to PR10"
 PRDAY11   "Number of days from admission to PR11"
 PRDAY12   "Number of days from admission to PR12"
 PRDAY13   "Number of days from admission to PR13"
 PRDAY14   "Number of days from admission to PR14"
 PRDAY15   "Number of days from admission to PR15"
 RACE      "Race (uniform)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPInc_Q  "Median household income quartile for patient's ZIP Code" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISCWT10
 (-9999.9999,-8888.8888,-6666.6666,-5555.5555=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE ELECTIVE
 (-9,-8,-6,-5=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE MDNUM2_R
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-99,-88,-66,-55=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NIS_STRA
 (-999,-888,-666,-555=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPInc_Q
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'NIS_2003_10PCT_SAMPLE_A.SAV' /COMPRESSED.
