/*****************************************************************************
* SPSSload_NIS_1998_Supplemental.SPS
* This program will load the 1998 NIS ASCII Supplemental File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_1998_Supplemental.ASC' FIXED / 
    TRENDWT                    1- 11
    NDX                       12- 13
    DXCCS1                    14- 16
    DXCCS2                    17- 19
    DXCCS3                    20- 22
    DXCCS4                    23- 25
    DXCCS5                    26- 28
    DXCCS6                    29- 31
    DXCCS7                    32- 34
    DXCCS8                    35- 37
    DXCCS9                    38- 40
    DXCCS10                   41- 43
    DXCCS11                   44- 46
    DXCCS12                   47- 49
    DXCCS13                   50- 52
    DXCCS14                   53- 55
    DXCCS15                   56- 58
    E_CCS1                    59- 62
    E_CCS2                    63- 66
    E_CCS3                    67- 70
    E_CCS4                    71- 74
    ELECTIVE                  75- 76
    NECODE                    77- 79
    ZipInc_Qrtl               80- 81
    KEY                       82- 96
    DX1                       97-101 (A)
    DX2                      102-106 (A)
    DX3                      107-111 (A)
    DX4                      112-116 (A)
    DX5                      117-121 (A)
    DX6                      122-126 (A)
    DX7                      127-131 (A)
    DX8                      132-136 (A)
    DX9                      137-141 (A)
    DX10                     142-146 (A)
    DX11                     147-151 (A)
    DX12                     152-156 (A)
    DX13                     157-161 (A)
    DX14                     162-166 (A)
    DX15                     167-171 (A)
    ECODE1                   172-176 (A)
    ECODE2                   177-181 (A)
    ECODE3                   182-186 (A)
    ECODE4                   187-191 (A)
    MDNUM1_S                 192-207 (A)
    MDNUM2_S                 208-223 (A).

***  Specify write formats  ***.
FORMATS
    TRENDWT                  (F11.7) /
    NDX                      (F2.0) /
    DXCCS1                   (F3.0) /
    DXCCS2                   (F3.0) /
    DXCCS3                   (F3.0) /
    DXCCS4                   (F3.0) /
    DXCCS5                   (F3.0) /
    DXCCS6                   (F3.0) /
    DXCCS7                   (F3.0) /
    DXCCS8                   (F3.0) /
    DXCCS9                   (F3.0) /
    DXCCS10                  (F3.0) /
    DXCCS11                  (F3.0) /
    DXCCS12                  (F3.0) /
    DXCCS13                  (F3.0) /
    DXCCS14                  (F3.0) /
    DXCCS15                  (F3.0) /
    E_CCS1                   (F4.0) /
    E_CCS2                   (F4.0) /
    E_CCS3                   (F4.0) /
    E_CCS4                   (F4.0) /
    ELECTIVE                 (F2.0) /
    NECODE                   (F3.0) /
    ZipInc_Qrtl              (F2.0) /
    KEY                      (F15.0) /
.

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    TRENDWT                  "Trend weight to discharges in the universe"
    NDX                      "I:Number of diagnoses on this discharge"
    DXCCS1                   "CCS: principal diagnosis"
    DXCCS2                   "CCS: diagnosis 2"
    DXCCS3                   "CCS: diagnosis 3"
    DXCCS4                   "CCS: diagnosis 4"
    DXCCS5                   "CCS: diagnosis 5"
    DXCCS6                   "CCS: diagnosis 6"
    DXCCS7                   "CCS: diagnosis 7"
    DXCCS8                   "CCS: diagnosis 8"
    DXCCS9                   "CCS: diagnosis 9"
    DXCCS10                  "CCS: diagnosis 10"
    DXCCS11                  "CCS: diagnosis 11"
    DXCCS12                  "CCS: diagnosis 12"
    DXCCS13                  "CCS: diagnosis 13"
    DXCCS14                  "CCS: diagnosis 14"
    DXCCS15                  "CCS: diagnosis 15"
    E_CCS1                   "CCS: E Code 1"
    E_CCS2                   "CCS: E Code 2"
    E_CCS3                   "CCS: E Code 3"
    E_CCS4                   "CCS: E Code 4"
    ELECTIVE                 "Elective versus non-elective admission"
    NECODE                   "Number of E codes on this record"
    ZipInc_Qrtl              "Median Household Income Quartiles for Patient's ZIP Code"
    KEY                      "HCUP record identifier"
    DX1                      "Principal diagnosis"
    DX2                      "Diagnosis 2"
    DX3                      "Diagnosis 3"
    DX4                      "Diagnosis 4"
    DX5                      "Diagnosis 5"
    DX6                      "Diagnosis 6"
    DX7                      "Diagnosis 7"
    DX8                      "Diagnosis 8"
    DX9                      "Diagnosis 9"
    DX10                     "Diagnosis 10"
    DX11                     "Diagnosis 11"
    DX12                     "Diagnosis 12"
    DX13                     "Diagnosis 13"
    DX14                     "Diagnosis 14"
    DX15                     "Diagnosis 15"
    ECODE1                   "E code 1"
    ECODE2                   "E code 2"
    ECODE3                   "E code 3"
    ECODE4                   "E code 4"
    MDNUM1_S                 "Physician 1 number (synthetic)"
    MDNUM2_S                 "Physician 2 number (synthetic)" .

*** Convert special values to system missing values ***.
RECODE TRENDWT                  (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE NDX                      (-9 -8 -6 -5=SYSMIS).
RECODE DXCCS1                   (-99 -88 -66=SYSMIS).
RECODE DXCCS2                   (-99 -88 -66=SYSMIS).
RECODE DXCCS3                   (-99 -88 -66=SYSMIS).
RECODE DXCCS4                   (-99 -88 -66=SYSMIS).
RECODE DXCCS5                   (-99 -88 -66=SYSMIS).
RECODE DXCCS6                   (-99 -88 -66=SYSMIS).
RECODE DXCCS7                   (-99 -88 -66=SYSMIS).
RECODE DXCCS8                   (-99 -88 -66=SYSMIS).
RECODE DXCCS9                   (-99 -88 -66=SYSMIS).
RECODE DXCCS10                  (-99 -88 -66=SYSMIS).
RECODE DXCCS11                  (-99 -88 -66=SYSMIS).
RECODE DXCCS12                  (-99 -88 -66=SYSMIS).
RECODE DXCCS13                  (-99 -88 -66=SYSMIS).
RECODE DXCCS14                  (-99 -88 -66=SYSMIS).
RECODE DXCCS15                  (-99 -88 -66=SYSMIS).
RECODE E_CCS1                   (-999 -888 -666=SYSMIS).
RECODE E_CCS2                   (-999 -888 -666=SYSMIS).
RECODE E_CCS3                   (-999 -888 -666=SYSMIS).
RECODE E_CCS4                   (-999 -888 -666=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE NECODE                   (-99 -88 -66=SYSMIS).
RECODE ZipInc_Qrtl              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NIS_1998_Supplemental.SAV' / COMPRESSED.
