/*****************************************************************************
* SPSSload_NIS_2015Q4_Severity.SPS
* This program will load the NIS_2015Q4_Severity ASCII File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2015Q4_Severity.ASC' FIXED / 
    APRDRG                     1-  4
    APRDRG_Risk_Mortality      5-  6
    APRDRG_Severity            7-  8
    HOSP_NIS                   9- 13
    KEY_NIS                   14- 23.

***  Specify write formats  ***.
FORMATS
    APRDRG                   (F4.0) /
    APRDRG_Risk_Mortality    (F2.0) /
    APRDRG_Severity          (F2.0) /
    HOSP_NIS                 (F5.0) /
    KEY_NIS                  (F10.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    APRDRG                   "All Patient Refined DRG"
    APRDRG_Risk_Mortality    "All Patient Refined DRG: Risk of Mortality Subclass"
    APRDRG_Severity          "All Patient Refined DRG: Severity of Illness Subclass"
    HOSP_NIS                 "NIS hospital number"
    KEY_NIS                  "NIS record number" .

*** Convert special values to system missing values ***.
RECODE APRDRG                   (-999 -888 -666=SYSMIS).
RECODE APRDRG_Risk_Mortality    (-9 -8 -6 -5=SYSMIS).
RECODE APRDRG_Severity          (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_NIS                 (-9999 -8888 -6666=SYSMIS).
RECODE KEY_NIS                  (-999999999 -888888888 -666666666=SYSMIS).

SAVE OUTFILE = 'NIS_2015Q4_Severity.SAV' / COMPRESSED.
