/*******************************************************************
*   NIS_1999_CORE10B.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL CONVERT THE ASCII NIS         
*      INPATIENT STAY CORE10B FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'NIS_1999_CORE10B.ASC' FIXED / 
 KEY                  1- 14
 AGE                 15- 17
 AGEDAY              18- 20
 AMONTH              21- 22
 ASOURCE             23- 24
 ASOURCE_            25- 27 (A)
 ATYPE               28- 29
 AWEEKEND            30- 31
 DIED                32- 33
 DISCWT10            34- 43
 DISPUB92            44- 45
 DISPUNIF            46- 47
 DQTR                48- 49
 DRG                 50- 52
 DRG10               53- 55
 DRG18               56- 58
 DRGVER              59- 60
 DSHOSPID            61- 73 (A)
 DX1                 74- 78 (A)
 DX2                 79- 83 (A)
 DX3                 84- 88 (A)
 DX4                 89- 93 (A)
 DX5                 94- 98 (A)
 DX6                 99-103 (A)
 DX7                104-108 (A)
 DX8                109-113 (A)
 DX9                114-118 (A)
 DX10               119-123 (A)
 DX11               124-128 (A)
 DX12               129-133 (A)
 DX13               134-138 (A)
 DX14               139-143 (A)
 DX15               144-148 (A)
 DXCCS1             149-152
 DXCCS2             153-156
 DXCCS3             157-160
 DXCCS4             161-164
 DXCCS5             165-168
 DXCCS6             169-172
 DXCCS7             173-176
 DXCCS8             177-180
 DXCCS9             181-184
 DXCCS10            185-188
 DXCCS11            189-192
 DXCCS12            193-196
 DXCCS13            197-200
 DXCCS14            201-204
 DXCCS15            205-208
 FEMALE             209-210
 HOSPID             211-215
 HOSPST             216-217 (A)
 HOSPSTCO           218-222
 LOS                223-227
 LOS_X              228-233
 MDC                234-235
 MDC10              236-237
 MDC18              238-239
 MDID_S             240-255 (A)
 NDX                256-257
 NEOMAT             258-259
 NPR                260-261
 PAY1               262-263
 PAY1_X             264-273 (A)
 PAY2               274-275
 PAY2_X             276-285 (A)
 PR1                286-289 (A)
 PR2                290-293 (A)
 PR3                294-297 (A)
 PR4                298-301 (A)
 PR5                302-305 (A)
 PR6                306-309 (A)
 PR7                310-313 (A)
 PR8                314-317 (A)
 PR9                318-321 (A)
 PR10               322-325 (A)
 PR11               326-329 (A)
 PR12               330-333 (A)
 PR13               334-337 (A)
 PR14               338-341 (A)
 PR15               342-345 (A)
 PRCCS1             346-348
 PRCCS2             349-351
 PRCCS3             352-354
 PRCCS4             355-357
 PRCCS5             358-360
 PRCCS6             361-363
 PRCCS7             364-366
 PRCCS8             367-369
 PRCCS9             370-372
 PRCCS10            373-375
 PRCCS11            376-378
 PRCCS12            379-381
 PRCCS13            382-384
 PRCCS14            385-387
 PRCCS15            388-390
 PRDAY1             391-393
 PRDAY2             394-396
 PRDAY3             397-399
 PRDAY4             400-402
 PRDAY5             403-405
 PRDAY6             406-408
 PRDAY7             409-411
 PRDAY8             412-414
 PRDAY9             415-417
 PRDAY10            418-420
 PRDAY11            421-423
 PRDAY12            424-426
 PRDAY13            427-429
 PRDAY14            430-432
 PRDAY15            433-435
 RACE               436-437
 SURGID_S           438-453 (A)
 TOTCHG             454-463
 TOTCHG_X           464-478
 YEAR               479-482
 ZIPINC             483-484.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AMONTH              (F3.0) /
 ASOURCE             (F3.0) /
 ATYPE               (F3.0) /
 AWEEKEND            (F3.0) /
 DIED                (F3.0) /
 DISCWT10            (F8.4) /
 DISPUB92            (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DRG                 (F3.0) /
 DRG10               (F3.0) /
 DRG18               (F3.0) /
 DRGVER              (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 DXCCS10             (F4.0) /
 DXCCS11             (F4.0) /
 DXCCS12             (F4.0) /
 DXCCS13             (F4.0) /
 DXCCS14             (F4.0) /
 DXCCS15             (F4.0) /
 FEMALE              (F3.0) /
 HOSPID              (F4.0) /
 HOSPSTCO            (F4.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 MDC                 (F3.0) /
 MDC10               (F3.0) /
 MDC18               (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PAY2                (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRCCS7              (F3.0) /
 PRCCS8              (F3.0) /
 PRCCS9              (F3.0) /
 PRCCS10             (F3.0) /
 PRCCS11             (F3.0) /
 PRCCS12             (F3.0) /
 PRCCS13             (F3.0) /
 PRCCS14             (F3.0) /
 PRCCS15             (F3.0) /
 PRDAY1              (F4.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 PRDAY4              (F4.0) /
 PRDAY5              (F4.0) /
 PRDAY6              (F4.0) /
 PRDAY7              (F4.0) /
 PRDAY8              (F4.0) /
 PRDAY9              (F4.0) /
 PRDAY10             (F4.0) /
 PRDAY11             (F4.0) /
 PRDAY12             (F4.0) /
 PRDAY13             (F4.0) /
 PRDAY14             (F4.0) /
 PRDAY15             (F4.0) /
 RACE                (F3.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) /
 ZIPINC              (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY          "HCUP record identifier"
 AGE          "Age in years at admission"
 AGEDAY       "Age in days (when age < 1 year)"
 AMONTH       "Admission month"
 ASOURCE      "Admission source (uniform)"
 ASOURCE_     "Admission source (as received from source)"
 ATYPE        "Admission type"
 AWEEKEND     "Admission day is a weekend"
 DIED         "Died during hospitalization"
 DISCWT10     "10% sample weight to discharges in AHA universe"
 DISPUB92     "Disposition of patient (UB-92 standard coding)"
 DISPUNIF     "Disposition of patient (uniform)"
 DQTR         "Discharge quarter"
 DRG          "DRG in effect on discharge date"
 DRG10        "DRG, version 10"
 DRG18        "DRG, version 18"
 DRGVER       "DRG grouper version used on discharge date"
 DSHOSPID     "Data source hospital identifier"
 DX1          "Principal diagnosis"
 DX2          "Diagnosis 2"
 DX3          "Diagnosis 3"
 DX4          "Diagnosis 4"
 DX5          "Diagnosis 5"
 DX6          "Diagnosis 6"
 DX7          "Diagnosis 7"
 DX8          "Diagnosis 8"
 DX9          "Diagnosis 9"
 DX10         "Diagnosis 10"
 DX11         "Diagnosis 11"
 DX12         "Diagnosis 12"
 DX13         "Diagnosis 13"
 DX14         "Diagnosis 14"
 DX15         "Diagnosis 15"
 DXCCS1       "CCS: principal diagnosis"
 DXCCS2       "CCS: diagnosis 2"
 DXCCS3       "CCS: diagnosis 3"
 DXCCS4       "CCS: diagnosis 4"
 DXCCS5       "CCS: diagnosis 5"
 DXCCS6       "CCS: diagnosis 6"
 DXCCS7       "CCS: diagnosis 7"
 DXCCS8       "CCS: diagnosis 8"
 DXCCS9       "CCS: diagnosis 9"
 DXCCS10      "CCS: diagnosis 10"
 DXCCS11      "CCS: diagnosis 11"
 DXCCS12      "CCS: diagnosis 12"
 DXCCS13      "CCS: diagnosis 13"
 DXCCS14      "CCS: diagnosis 14"
 DXCCS15      "CCS: diagnosis 15"
 FEMALE       "Indicator of sex"
 HOSPID       "HCUP hospital identification number"
 HOSPST       "Hospital state postal code"
 HOSPSTCO     "Hospital modified FIPS state/county code"
 LOS          "Length of stay (cleaned)"
 LOS_X        "Length of stay (uncleaned)"
 MDC          "MDC in effect on discharge date"
 MDC10        "MDC, version 10"
 MDC18        "MDC, version 18"
 MDID_S       "Attending physician number (synthetic)"
 NDX          "Number of diagnoses on this record"
 NEOMAT       "Neonatal and/or maternal DX and/or PR"
 NPR          "Number of procedures on this record"
 PAY1         "Primary expected payer (uniform)"
 PAY1_X       "Primary expected payer (as received from source)"
 PAY2         "Secondary expected payer (uniform)"
 PAY2_X       "Secondary expected payer (as received from source)"
 PR1          "Principal procedure"
 PR2          "Procedure 2"
 PR3          "Procedure 3"
 PR4          "Procedure 4"
 PR5          "Procedure 5"
 PR6          "Procedure 6"
 PR7          "Procedure 7"
 PR8          "Procedure 8"
 PR9          "Procedure 9"
 PR10         "Procedure 10"
 PR11         "Procedure 11"
 PR12         "Procedure 12"
 PR13         "Procedure 13"
 PR14         "Procedure 14"
 PR15         "Procedure 15"
 PRCCS1       "CCS: principal procedure"
 PRCCS2       "CCS: procedure 2"
 PRCCS3       "CCS: procedure 3"
 PRCCS4       "CCS: procedure 4"
 PRCCS5       "CCS: procedure 5"
 PRCCS6       "CCS: procedure 6"
 PRCCS7       "CCS: procedure 7"
 PRCCS8       "CCS: procedure 8"
 PRCCS9       "CCS: procedure 9"
 PRCCS10      "CCS: procedure 10"
 PRCCS11      "CCS: procedure 11"
 PRCCS12      "CCS: procedure 12"
 PRCCS13      "CCS: procedure 13"
 PRCCS14      "CCS: procedure 14"
 PRCCS15      "CCS: procedure 15"
 PRDAY1       "Number of days from admission to PR1"
 PRDAY2       "Number of days from admission to PR2"
 PRDAY3       "Number of days from admission to PR3"
 PRDAY4       "Number of days from admission to PR4"
 PRDAY5       "Number of days from admission to PR5"
 PRDAY6       "Number of days from admission to PR6"
 PRDAY7       "Number of days from admission to PR7"
 PRDAY8       "Number of days from admission to PR8"
 PRDAY9       "Number of days from admission to PR9"
 PRDAY10      "Number of days from admission to PR10"
 PRDAY11      "Number of days from admission to PR11"
 PRDAY12      "Number of days from admission to PR12"
 PRDAY13      "Number of days from admission to PR13"
 PRDAY14      "Number of days from admission to PR14"
 PRDAY15      "Number of days from admission to PR15"
 RACE         "Race (uniform)"
 SURGID_S     "Primary surgeon number (synthetic)"
 TOTCHG       "Total charges (cleaned)"
 TOTCHG_X     "Total charges (as received from source)"
 YEAR         "Calendar year"
 ZIPINC       "Median household income category for patient's zip code".


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISCWT10
 (-9999.9999,-8888.8888,-6666.6666,-5555.5555=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG10
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC10
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'NIS_1999_CORE10B.SAV' /COMPRESSED.
