/*****************************************************************************
* SASload_NIS_2018_DX_PR_GRPS.SAS
* This program will load the NIS_2018_DX_PR_GRPS ASCII File into SAS.
*****************************************************************************/

Options Compress=Yes;

*** Create SAS informats for missing values ***;
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

*** Data Step to load the file ***;
DATA NIS_2018_DX_PR_GRPS; 
INFILE 'NIS_2018_DX_PR_GRPS.ASC' LRECL = 567;

*** Define data element attributes ***;
ATTRIB 
  HOSP_NIS                   LENGTH=4            FORMAT=5.
  LABEL="NIS hospital number"

  KEY_NIS                    LENGTH=5            FORMAT=8.
  LABEL="NIS record number"

  DXCCSR_BLD001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD001"

  DXCCSR_BLD002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD002"

  DXCCSR_BLD003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD003"

  DXCCSR_BLD004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD004"

  DXCCSR_BLD005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD005"

  DXCCSR_BLD006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD006"

  DXCCSR_BLD007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD007"

  DXCCSR_BLD008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD008"

  DXCCSR_BLD009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD009"

  DXCCSR_BLD010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD010"

  DXCCSR_CIR001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR001"

  DXCCSR_CIR002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR002"

  DXCCSR_CIR003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR003"

  DXCCSR_CIR004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR004"

  DXCCSR_CIR005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR005"

  DXCCSR_CIR006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR006"

  DXCCSR_CIR007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR007"

  DXCCSR_CIR008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR008"

  DXCCSR_CIR009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR009"

  DXCCSR_CIR010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR010"

  DXCCSR_CIR011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR011"

  DXCCSR_CIR012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR012"

  DXCCSR_CIR013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR013"

  DXCCSR_CIR014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR014"

  DXCCSR_CIR015              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR015"

  DXCCSR_CIR016              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR016"

  DXCCSR_CIR017              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR017"

  DXCCSR_CIR018              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR018"

  DXCCSR_CIR019              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR019"

  DXCCSR_CIR020              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR020"

  DXCCSR_CIR021              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR021"

  DXCCSR_CIR022              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR022"

  DXCCSR_CIR023              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR023"

  DXCCSR_CIR024              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR024"

  DXCCSR_CIR025              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR025"

  DXCCSR_CIR026              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR026"

  DXCCSR_CIR027              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR027"

  DXCCSR_CIR028              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR028"

  DXCCSR_CIR029              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR029"

  DXCCSR_CIR030              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR030"

  DXCCSR_CIR031              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR031"

  DXCCSR_CIR032              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR032"

  DXCCSR_CIR033              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR033"

  DXCCSR_CIR034              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR034"

  DXCCSR_CIR035              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR035"

  DXCCSR_CIR036              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR036"

  DXCCSR_CIR037              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR037"

  DXCCSR_CIR038              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR038"

  DXCCSR_CIR039              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR039"

  DXCCSR_DIG001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG001"

  DXCCSR_DIG002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG002"

  DXCCSR_DIG003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG003"

  DXCCSR_DIG004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG004"

  DXCCSR_DIG005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG005"

  DXCCSR_DIG006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG006"

  DXCCSR_DIG007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG007"

  DXCCSR_DIG008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG008"

  DXCCSR_DIG009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG009"

  DXCCSR_DIG010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG010"

  DXCCSR_DIG011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG011"

  DXCCSR_DIG012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG012"

  DXCCSR_DIG013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG013"

  DXCCSR_DIG014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG014"

  DXCCSR_DIG015              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG015"

  DXCCSR_DIG016              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG016"

  DXCCSR_DIG017              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG017"

  DXCCSR_DIG018              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG018"

  DXCCSR_DIG019              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG019"

  DXCCSR_DIG020              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG020"

  DXCCSR_DIG021              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG021"

  DXCCSR_DIG022              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG022"

  DXCCSR_DIG023              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG023"

  DXCCSR_DIG024              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG024"

  DXCCSR_DIG025              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG025"

  DXCCSR_EAR001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR001"

  DXCCSR_EAR002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR002"

  DXCCSR_EAR003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR003"

  DXCCSR_EAR004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR004"

  DXCCSR_EAR005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR005"

  DXCCSR_EAR006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR006"

  DXCCSR_END001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END001"

  DXCCSR_END002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END002"

  DXCCSR_END003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END003"

  DXCCSR_END004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END004"

  DXCCSR_END005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END005"

  DXCCSR_END006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END006"

  DXCCSR_END007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END007"

  DXCCSR_END008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END008"

  DXCCSR_END009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END009"

  DXCCSR_END010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END010"

  DXCCSR_END011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END011"

  DXCCSR_END012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END012"

  DXCCSR_END013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END013"

  DXCCSR_END014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END014"

  DXCCSR_END015              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END015"

  DXCCSR_END016              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END016"

  DXCCSR_END017              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END017"

  DXCCSR_EXT001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT001"

  DXCCSR_EXT002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT002"

  DXCCSR_EXT003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT003"

  DXCCSR_EXT004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT004"

  DXCCSR_EXT005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT005"

  DXCCSR_EXT006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT006"

  DXCCSR_EXT007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT007"

  DXCCSR_EXT008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT008"

  DXCCSR_EXT009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT009"

  DXCCSR_EXT010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT010"

  DXCCSR_EXT011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT011"

  DXCCSR_EXT012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT012"

  DXCCSR_EXT013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT013"

  DXCCSR_EXT014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT014"

  DXCCSR_EXT015              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT015"

  DXCCSR_EXT016              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT016"

  DXCCSR_EXT017              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT017"

  DXCCSR_EXT018              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT018"

  DXCCSR_EXT019              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT019"

  DXCCSR_EXT020              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT020"

  DXCCSR_EXT021              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT021"

  DXCCSR_EXT022              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT022"

  DXCCSR_EXT023              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT023"

  DXCCSR_EXT024              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT024"

  DXCCSR_EXT025              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT025"

  DXCCSR_EXT026              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT026"

  DXCCSR_EXT027              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT027"

  DXCCSR_EXT028              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT028"

  DXCCSR_EXT029              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT029"

  DXCCSR_EXT030              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT030"

  DXCCSR_EYE001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE001"

  DXCCSR_EYE002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE002"

  DXCCSR_EYE003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE003"

  DXCCSR_EYE004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE004"

  DXCCSR_EYE005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE005"

  DXCCSR_EYE006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE006"

  DXCCSR_EYE007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE007"

  DXCCSR_EYE008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE008"

  DXCCSR_EYE009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE009"

  DXCCSR_EYE010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE010"

  DXCCSR_EYE011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE011"

  DXCCSR_EYE012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE012"

  DXCCSR_FAC001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC001"

  DXCCSR_FAC002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC002"

  DXCCSR_FAC003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC003"

  DXCCSR_FAC004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC004"

  DXCCSR_FAC005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC005"

  DXCCSR_FAC006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC006"

  DXCCSR_FAC007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC007"

  DXCCSR_FAC008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC008"

  DXCCSR_FAC009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC009"

  DXCCSR_FAC010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC010"

  DXCCSR_FAC011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC011"

  DXCCSR_FAC012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC012"

  DXCCSR_FAC013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC013"

  DXCCSR_FAC014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC014"

  DXCCSR_FAC015              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC015"

  DXCCSR_FAC016              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC016"

  DXCCSR_FAC017              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC017"

  DXCCSR_FAC018              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC018"

  DXCCSR_FAC019              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC019"

  DXCCSR_FAC020              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC020"

  DXCCSR_FAC021              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC021"

  DXCCSR_FAC022              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC022"

  DXCCSR_FAC023              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC023"

  DXCCSR_FAC024              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC024"

  DXCCSR_FAC025              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC025"

  DXCCSR_GEN001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN001"

  DXCCSR_GEN002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN002"

  DXCCSR_GEN003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN003"

  DXCCSR_GEN004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN004"

  DXCCSR_GEN005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN005"

  DXCCSR_GEN006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN006"

  DXCCSR_GEN007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN007"

  DXCCSR_GEN008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN008"

  DXCCSR_GEN009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN009"

  DXCCSR_GEN010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN010"

  DXCCSR_GEN011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN011"

  DXCCSR_GEN012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN012"

  DXCCSR_GEN013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN013"

  DXCCSR_GEN014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN014"

  DXCCSR_GEN015              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN015"

  DXCCSR_GEN016              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN016"

  DXCCSR_GEN017              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN017"

  DXCCSR_GEN018              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN018"

  DXCCSR_GEN019              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN019"

  DXCCSR_GEN020              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN020"

  DXCCSR_GEN021              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN021"

  DXCCSR_GEN022              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN022"

  DXCCSR_GEN023              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN023"

  DXCCSR_GEN024              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN024"

  DXCCSR_GEN025              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN025"

  DXCCSR_GEN026              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN026"

  DXCCSR_INF001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF001"

  DXCCSR_INF002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF002"

  DXCCSR_INF003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF003"

  DXCCSR_INF004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF004"

  DXCCSR_INF005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF005"

  DXCCSR_INF006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF006"

  DXCCSR_INF007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF007"

  DXCCSR_INF008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF008"

  DXCCSR_INF009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF009"

  DXCCSR_INF010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF010"

  DXCCSR_INF011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF011"

  DXCCSR_INF012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF012"

  DXCCSR_INJ001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ001"

  DXCCSR_INJ002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ002"

  DXCCSR_INJ003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ003"

  DXCCSR_INJ004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ004"

  DXCCSR_INJ005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ005"

  DXCCSR_INJ006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ006"

  DXCCSR_INJ007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ007"

  DXCCSR_INJ008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ008"

  DXCCSR_INJ009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ009"

  DXCCSR_INJ010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ010"

  DXCCSR_INJ011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ011"

  DXCCSR_INJ012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ012"

  DXCCSR_INJ013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ013"

  DXCCSR_INJ014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ014"

  DXCCSR_INJ015              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ015"

  DXCCSR_INJ016              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ016"

  DXCCSR_INJ017              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ017"

  DXCCSR_INJ018              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ018"

  DXCCSR_INJ019              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ019"

  DXCCSR_INJ020              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ020"

  DXCCSR_INJ021              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ021"

  DXCCSR_INJ022              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ022"

  DXCCSR_INJ023              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ023"

  DXCCSR_INJ024              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ024"

  DXCCSR_INJ025              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ025"

  DXCCSR_INJ026              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ026"

  DXCCSR_INJ027              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ027"

  DXCCSR_INJ028              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ028"

  DXCCSR_INJ029              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ029"

  DXCCSR_INJ030              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ030"

  DXCCSR_INJ031              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ031"

  DXCCSR_INJ032              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ032"

  DXCCSR_INJ033              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ033"

  DXCCSR_INJ034              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ034"

  DXCCSR_INJ035              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ035"

  DXCCSR_INJ036              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ036"

  DXCCSR_INJ037              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ037"

  DXCCSR_INJ038              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ038"

  DXCCSR_INJ039              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ039"

  DXCCSR_INJ040              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ040"

  DXCCSR_INJ041              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ041"

  DXCCSR_INJ042              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ042"

  DXCCSR_INJ043              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ043"

  DXCCSR_INJ044              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ044"

  DXCCSR_INJ045              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ045"

  DXCCSR_INJ046              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ046"

  DXCCSR_INJ047              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ047"

  DXCCSR_INJ048              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ048"

  DXCCSR_INJ049              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ049"

  DXCCSR_INJ050              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ050"

  DXCCSR_INJ051              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ051"

  DXCCSR_INJ052              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ052"

  DXCCSR_INJ053              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ053"

  DXCCSR_INJ054              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ054"

  DXCCSR_INJ055              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ055"

  DXCCSR_INJ056              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ056"

  DXCCSR_INJ057              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ057"

  DXCCSR_INJ058              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ058"

  DXCCSR_INJ059              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ059"

  DXCCSR_INJ060              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ060"

  DXCCSR_INJ061              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ061"

  DXCCSR_INJ062              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ062"

  DXCCSR_INJ063              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ063"

  DXCCSR_INJ064              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ064"

  DXCCSR_INJ065              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ065"

  DXCCSR_INJ066              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ066"

  DXCCSR_INJ067              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ067"

  DXCCSR_INJ068              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ068"

  DXCCSR_INJ069              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ069"

  DXCCSR_INJ070              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ070"

  DXCCSR_INJ071              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ071"

  DXCCSR_INJ072              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ072"

  DXCCSR_INJ073              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ073"

  DXCCSR_INJ074              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ074"

  DXCCSR_INJ075              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ075"

  DXCCSR_INJ076              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ076"

  DXCCSR_MAL001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL001"

  DXCCSR_MAL002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL002"

  DXCCSR_MAL003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL003"

  DXCCSR_MAL004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL004"

  DXCCSR_MAL005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL005"

  DXCCSR_MAL006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL006"

  DXCCSR_MAL007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL007"

  DXCCSR_MAL008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL008"

  DXCCSR_MAL009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL009"

  DXCCSR_MAL010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL010"

  DXCCSR_MBD001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD001"

  DXCCSR_MBD002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD002"

  DXCCSR_MBD003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD003"

  DXCCSR_MBD004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD004"

  DXCCSR_MBD005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD005"

  DXCCSR_MBD006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD006"

  DXCCSR_MBD007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD007"

  DXCCSR_MBD008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD008"

  DXCCSR_MBD009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD009"

  DXCCSR_MBD010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD010"

  DXCCSR_MBD011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD011"

  DXCCSR_MBD012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD012"

  DXCCSR_MBD013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD013"

  DXCCSR_MBD014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD014"

  DXCCSR_MBD017              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD017"

  DXCCSR_MBD018              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD018"

  DXCCSR_MBD019              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD019"

  DXCCSR_MBD020              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD020"

  DXCCSR_MBD021              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD021"

  DXCCSR_MBD022              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD022"

  DXCCSR_MBD023              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD023"

  DXCCSR_MBD024              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD024"

  DXCCSR_MBD025              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD025"

  DXCCSR_MBD026              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD026"

  DXCCSR_MBD027              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD027"

  DXCCSR_MBD028              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD028"

  DXCCSR_MBD029              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD029"

  DXCCSR_MBD030              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD030"

  DXCCSR_MBD031              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD031"

  DXCCSR_MBD032              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD032"

  DXCCSR_MBD033              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD033"

  DXCCSR_MBD034              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD034"

  DXCCSR_MUS001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS001"

  DXCCSR_MUS002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS002"

  DXCCSR_MUS003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS003"

  DXCCSR_MUS004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS004"

  DXCCSR_MUS005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS005"

  DXCCSR_MUS006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS006"

  DXCCSR_MUS007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS007"

  DXCCSR_MUS008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS008"

  DXCCSR_MUS009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS009"

  DXCCSR_MUS010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS010"

  DXCCSR_MUS011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS011"

  DXCCSR_MUS012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS012"

  DXCCSR_MUS013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS013"

  DXCCSR_MUS014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS014"

  DXCCSR_MUS015              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS015"

  DXCCSR_MUS016              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS016"

  DXCCSR_MUS017              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS017"

  DXCCSR_MUS018              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS018"

  DXCCSR_MUS019              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS019"

  DXCCSR_MUS020              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS020"

  DXCCSR_MUS021              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS021"

  DXCCSR_MUS022              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS022"

  DXCCSR_MUS023              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS023"

  DXCCSR_MUS024              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS024"

  DXCCSR_MUS025              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS025"

  DXCCSR_MUS026              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS026"

  DXCCSR_MUS027              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS027"

  DXCCSR_MUS028              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS028"

  DXCCSR_MUS029              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS029"

  DXCCSR_MUS030              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS030"

  DXCCSR_MUS031              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS031"

  DXCCSR_MUS032              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS032"

  DXCCSR_MUS033              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS033"

  DXCCSR_MUS034              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS034"

  DXCCSR_MUS035              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS035"

  DXCCSR_MUS036              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS036"

  DXCCSR_MUS037              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS037"

  DXCCSR_MUS038              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS038"

  DXCCSR_NEO001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO001"

  DXCCSR_NEO002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO002"

  DXCCSR_NEO003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO003"

  DXCCSR_NEO004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO004"

  DXCCSR_NEO005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO005"

  DXCCSR_NEO006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO006"

  DXCCSR_NEO007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO007"

  DXCCSR_NEO008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO008"

  DXCCSR_NEO009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO009"

  DXCCSR_NEO010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO010"

  DXCCSR_NEO011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO011"

  DXCCSR_NEO012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO012"

  DXCCSR_NEO013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO013"

  DXCCSR_NEO014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO014"

  DXCCSR_NEO015              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO015"

  DXCCSR_NEO016              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO016"

  DXCCSR_NEO017              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO017"

  DXCCSR_NEO018              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO018"

  DXCCSR_NEO019              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO019"

  DXCCSR_NEO020              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO020"

  DXCCSR_NEO021              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO021"

  DXCCSR_NEO022              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO022"

  DXCCSR_NEO023              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO023"

  DXCCSR_NEO024              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO024"

  DXCCSR_NEO025              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO025"

  DXCCSR_NEO026              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO026"

  DXCCSR_NEO027              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO027"

  DXCCSR_NEO028              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO028"

  DXCCSR_NEO029              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO029"

  DXCCSR_NEO030              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO030"

  DXCCSR_NEO031              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO031"

  DXCCSR_NEO032              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO032"

  DXCCSR_NEO033              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO033"

  DXCCSR_NEO034              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO034"

  DXCCSR_NEO035              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO035"

  DXCCSR_NEO036              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO036"

  DXCCSR_NEO037              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO037"

  DXCCSR_NEO038              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO038"

  DXCCSR_NEO039              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO039"

  DXCCSR_NEO040              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO040"

  DXCCSR_NEO041              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO041"

  DXCCSR_NEO042              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO042"

  DXCCSR_NEO043              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO043"

  DXCCSR_NEO044              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO044"

  DXCCSR_NEO045              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO045"

  DXCCSR_NEO046              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO046"

  DXCCSR_NEO047              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO047"

  DXCCSR_NEO048              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO048"

  DXCCSR_NEO049              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO049"

  DXCCSR_NEO050              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO050"

  DXCCSR_NEO051              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO051"

  DXCCSR_NEO052              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO052"

  DXCCSR_NEO053              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO053"

  DXCCSR_NEO054              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO054"

  DXCCSR_NEO055              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO055"

  DXCCSR_NEO056              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO056"

  DXCCSR_NEO057              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO057"

  DXCCSR_NEO058              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO058"

  DXCCSR_NEO059              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO059"

  DXCCSR_NEO060              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO060"

  DXCCSR_NEO061              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO061"

  DXCCSR_NEO062              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO062"

  DXCCSR_NEO063              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO063"

  DXCCSR_NEO064              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO064"

  DXCCSR_NEO065              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO065"

  DXCCSR_NEO066              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO066"

  DXCCSR_NEO067              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO067"

  DXCCSR_NEO068              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO068"

  DXCCSR_NEO069              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO069"

  DXCCSR_NEO070              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO070"

  DXCCSR_NEO071              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO071"

  DXCCSR_NEO072              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO072"

  DXCCSR_NEO073              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO073"

  DXCCSR_NEO074              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO074"

  DXCCSR_NVS001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS001"

  DXCCSR_NVS002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS002"

  DXCCSR_NVS003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS003"

  DXCCSR_NVS004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS004"

  DXCCSR_NVS005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS005"

  DXCCSR_NVS006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS006"

  DXCCSR_NVS007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS007"

  DXCCSR_NVS008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS008"

  DXCCSR_NVS009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS009"

  DXCCSR_NVS010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS010"

  DXCCSR_NVS011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS011"

  DXCCSR_NVS012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS012"

  DXCCSR_NVS013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS013"

  DXCCSR_NVS014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS014"

  DXCCSR_NVS015              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS015"

  DXCCSR_NVS016              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS016"

  DXCCSR_NVS017              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS017"

  DXCCSR_NVS018              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS018"

  DXCCSR_NVS019              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS019"

  DXCCSR_NVS020              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS020"

  DXCCSR_NVS021              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS021"

  DXCCSR_NVS022              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS022"

  DXCCSR_PNL001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL001"

  DXCCSR_PNL002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL002"

  DXCCSR_PNL003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL003"

  DXCCSR_PNL004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL004"

  DXCCSR_PNL005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL005"

  DXCCSR_PNL006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL006"

  DXCCSR_PNL007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL007"

  DXCCSR_PNL008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL008"

  DXCCSR_PNL009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL009"

  DXCCSR_PNL010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL010"

  DXCCSR_PNL011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL011"

  DXCCSR_PNL012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL012"

  DXCCSR_PNL013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL013"

  DXCCSR_PNL014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL014"

  DXCCSR_PNL015              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL015"

  DXCCSR_PRG001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG001"

  DXCCSR_PRG002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG002"

  DXCCSR_PRG003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG003"

  DXCCSR_PRG004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG004"

  DXCCSR_PRG005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG005"

  DXCCSR_PRG006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG006"

  DXCCSR_PRG007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG007"

  DXCCSR_PRG008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG008"

  DXCCSR_PRG009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG009"

  DXCCSR_PRG010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG010"

  DXCCSR_PRG011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG011"

  DXCCSR_PRG012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG012"

  DXCCSR_PRG013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG013"

  DXCCSR_PRG014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG014"

  DXCCSR_PRG015              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG015"

  DXCCSR_PRG016              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG016"

  DXCCSR_PRG017              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG017"

  DXCCSR_PRG018              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG018"

  DXCCSR_PRG019              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG019"

  DXCCSR_PRG020              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG020"

  DXCCSR_PRG021              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG021"

  DXCCSR_PRG022              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG022"

  DXCCSR_PRG023              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG023"

  DXCCSR_PRG024              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG024"

  DXCCSR_PRG025              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG025"

  DXCCSR_PRG026              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG026"

  DXCCSR_PRG027              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG027"

  DXCCSR_PRG028              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG028"

  DXCCSR_PRG029              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG029"

  DXCCSR_PRG030              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG030"

  DXCCSR_RSP001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP001"

  DXCCSR_RSP002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP002"

  DXCCSR_RSP003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP003"

  DXCCSR_RSP004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP004"

  DXCCSR_RSP005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP005"

  DXCCSR_RSP006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP006"

  DXCCSR_RSP007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP007"

  DXCCSR_RSP008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP008"

  DXCCSR_RSP009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP009"

  DXCCSR_RSP010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP010"

  DXCCSR_RSP011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP011"

  DXCCSR_RSP012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP012"

  DXCCSR_RSP013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP013"

  DXCCSR_RSP014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP014"

  DXCCSR_RSP015              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP015"

  DXCCSR_RSP016              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP016"

  DXCCSR_RSP017              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP017"

  DXCCSR_SKN001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN001"

  DXCCSR_SKN002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN002"

  DXCCSR_SKN003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN003"

  DXCCSR_SKN004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN004"

  DXCCSR_SKN005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN005"

  DXCCSR_SKN006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN006"

  DXCCSR_SKN007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN007"

  DXCCSR_SYM001              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM001"

  DXCCSR_SYM002              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM002"

  DXCCSR_SYM003              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM003"

  DXCCSR_SYM004              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM004"

  DXCCSR_SYM005              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM005"

  DXCCSR_SYM006              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM006"

  DXCCSR_SYM007              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM007"

  DXCCSR_SYM008              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM008"

  DXCCSR_SYM009              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM009"

  DXCCSR_SYM010              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM010"

  DXCCSR_SYM011              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM011"

  DXCCSR_SYM012              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM012"

  DXCCSR_SYM013              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM013"

  DXCCSR_SYM014              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM014"

  DXCCSR_SYM015              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM015"

  DXCCSR_SYM016              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM016"

  DXCCSR_SYM017              LENGTH=3
  LABEL="Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM017"

  DXCCSR_DEFAULT_DX1         LENGTH=$6
  LABEL="Default CCSR for principal/first-listed ICD-10-CM diagnosis"

  DXCCSR_VERSION             LENGTH=$6
  LABEL="Version of CCSR for ICD-10-CM diagnoses"
  ;

*** Read data elements from the ASCII file ***;
INPUT 
      @1      HOSP_NIS                 N5PF.
      @6      KEY_NIS                  N10PF.
      @16     DXCCSR_BLD001            1.
      @17     DXCCSR_BLD002            1.
      @18     DXCCSR_BLD003            1.
      @19     DXCCSR_BLD004            1.
      @20     DXCCSR_BLD005            1.
      @21     DXCCSR_BLD006            1.
      @22     DXCCSR_BLD007            1.
      @23     DXCCSR_BLD008            1.
      @24     DXCCSR_BLD009            1.
      @25     DXCCSR_BLD010            1.
      @26     DXCCSR_CIR001            1.
      @27     DXCCSR_CIR002            1.
      @28     DXCCSR_CIR003            1.
      @29     DXCCSR_CIR004            1.
      @30     DXCCSR_CIR005            1.
      @31     DXCCSR_CIR006            1.
      @32     DXCCSR_CIR007            1.
      @33     DXCCSR_CIR008            1.
      @34     DXCCSR_CIR009            1.
      @35     DXCCSR_CIR010            1.
      @36     DXCCSR_CIR011            1.
      @37     DXCCSR_CIR012            1.
      @38     DXCCSR_CIR013            1.
      @39     DXCCSR_CIR014            1.
      @40     DXCCSR_CIR015            1.
      @41     DXCCSR_CIR016            1.
      @42     DXCCSR_CIR017            1.
      @43     DXCCSR_CIR018            1.
      @44     DXCCSR_CIR019            1.
      @45     DXCCSR_CIR020            1.
      @46     DXCCSR_CIR021            1.
      @47     DXCCSR_CIR022            1.
      @48     DXCCSR_CIR023            1.
      @49     DXCCSR_CIR024            1.
      @50     DXCCSR_CIR025            1.
      @51     DXCCSR_CIR026            1.
      @52     DXCCSR_CIR027            1.
      @53     DXCCSR_CIR028            1.
      @54     DXCCSR_CIR029            1.
      @55     DXCCSR_CIR030            1.
      @56     DXCCSR_CIR031            1.
      @57     DXCCSR_CIR032            1.
      @58     DXCCSR_CIR033            1.
      @59     DXCCSR_CIR034            1.
      @60     DXCCSR_CIR035            1.
      @61     DXCCSR_CIR036            1.
      @62     DXCCSR_CIR037            1.
      @63     DXCCSR_CIR038            1.
      @64     DXCCSR_CIR039            1.
      @65     DXCCSR_DIG001            1.
      @66     DXCCSR_DIG002            1.
      @67     DXCCSR_DIG003            1.
      @68     DXCCSR_DIG004            1.
      @69     DXCCSR_DIG005            1.
      @70     DXCCSR_DIG006            1.
      @71     DXCCSR_DIG007            1.
      @72     DXCCSR_DIG008            1.
      @73     DXCCSR_DIG009            1.
      @74     DXCCSR_DIG010            1.
      @75     DXCCSR_DIG011            1.
      @76     DXCCSR_DIG012            1.
      @77     DXCCSR_DIG013            1.
      @78     DXCCSR_DIG014            1.
      @79     DXCCSR_DIG015            1.
      @80     DXCCSR_DIG016            1.
      @81     DXCCSR_DIG017            1.
      @82     DXCCSR_DIG018            1.
      @83     DXCCSR_DIG019            1.
      @84     DXCCSR_DIG020            1.
      @85     DXCCSR_DIG021            1.
      @86     DXCCSR_DIG022            1.
      @87     DXCCSR_DIG023            1.
      @88     DXCCSR_DIG024            1.
      @89     DXCCSR_DIG025            1.
      @90     DXCCSR_EAR001            1.
      @91     DXCCSR_EAR002            1.
      @92     DXCCSR_EAR003            1.
      @93     DXCCSR_EAR004            1.
      @94     DXCCSR_EAR005            1.
      @95     DXCCSR_EAR006            1.
      @96     DXCCSR_END001            1.
      @97     DXCCSR_END002            1.
      @98     DXCCSR_END003            1.
      @99     DXCCSR_END004            1.
      @100    DXCCSR_END005            1.
      @101    DXCCSR_END006            1.
      @102    DXCCSR_END007            1.
      @103    DXCCSR_END008            1.
      @104    DXCCSR_END009            1.
      @105    DXCCSR_END010            1.
      @106    DXCCSR_END011            1.
      @107    DXCCSR_END012            1.
      @108    DXCCSR_END013            1.
      @109    DXCCSR_END014            1.
      @110    DXCCSR_END015            1.
      @111    DXCCSR_END016            1.
      @112    DXCCSR_END017            1.
      @113    DXCCSR_EXT001            1.
      @114    DXCCSR_EXT002            1.
      @115    DXCCSR_EXT003            1.
      @116    DXCCSR_EXT004            1.
      @117    DXCCSR_EXT005            1.
      @118    DXCCSR_EXT006            1.
      @119    DXCCSR_EXT007            1.
      @120    DXCCSR_EXT008            1.
      @121    DXCCSR_EXT009            1.
      @122    DXCCSR_EXT010            1.
      @123    DXCCSR_EXT011            1.
      @124    DXCCSR_EXT012            1.
      @125    DXCCSR_EXT013            1.
      @126    DXCCSR_EXT014            1.
      @127    DXCCSR_EXT015            1.
      @128    DXCCSR_EXT016            1.
      @129    DXCCSR_EXT017            1.
      @130    DXCCSR_EXT018            1.
      @131    DXCCSR_EXT019            1.
      @132    DXCCSR_EXT020            1.
      @133    DXCCSR_EXT021            1.
      @134    DXCCSR_EXT022            1.
      @135    DXCCSR_EXT023            1.
      @136    DXCCSR_EXT024            1.
      @137    DXCCSR_EXT025            1.
      @138    DXCCSR_EXT026            1.
      @139    DXCCSR_EXT027            1.
      @140    DXCCSR_EXT028            1.
      @141    DXCCSR_EXT029            1.
      @142    DXCCSR_EXT030            1.
      @143    DXCCSR_EYE001            1.
      @144    DXCCSR_EYE002            1.
      @145    DXCCSR_EYE003            1.
      @146    DXCCSR_EYE004            1.
      @147    DXCCSR_EYE005            1.
      @148    DXCCSR_EYE006            1.
      @149    DXCCSR_EYE007            1.
      @150    DXCCSR_EYE008            1.
      @151    DXCCSR_EYE009            1.
      @152    DXCCSR_EYE010            1.
      @153    DXCCSR_EYE011            1.
      @154    DXCCSR_EYE012            1.
      @155    DXCCSR_FAC001            1.
      @156    DXCCSR_FAC002            1.
      @157    DXCCSR_FAC003            1.
      @158    DXCCSR_FAC004            1.
      @159    DXCCSR_FAC005            1.
      @160    DXCCSR_FAC006            1.
      @161    DXCCSR_FAC007            1.
      @162    DXCCSR_FAC008            1.
      @163    DXCCSR_FAC009            1.
      @164    DXCCSR_FAC010            1.
      @165    DXCCSR_FAC011            1.
      @166    DXCCSR_FAC012            1.
      @167    DXCCSR_FAC013            1.
      @168    DXCCSR_FAC014            1.
      @169    DXCCSR_FAC015            1.
      @170    DXCCSR_FAC016            1.
      @171    DXCCSR_FAC017            1.
      @172    DXCCSR_FAC018            1.
      @173    DXCCSR_FAC019            1.
      @174    DXCCSR_FAC020            1.
      @175    DXCCSR_FAC021            1.
      @176    DXCCSR_FAC022            1.
      @177    DXCCSR_FAC023            1.
      @178    DXCCSR_FAC024            1.
      @179    DXCCSR_FAC025            1.
      @180    DXCCSR_GEN001            1.
      @181    DXCCSR_GEN002            1.
      @182    DXCCSR_GEN003            1.
      @183    DXCCSR_GEN004            1.
      @184    DXCCSR_GEN005            1.
      @185    DXCCSR_GEN006            1.
      @186    DXCCSR_GEN007            1.
      @187    DXCCSR_GEN008            1.
      @188    DXCCSR_GEN009            1.
      @189    DXCCSR_GEN010            1.
      @190    DXCCSR_GEN011            1.
      @191    DXCCSR_GEN012            1.
      @192    DXCCSR_GEN013            1.
      @193    DXCCSR_GEN014            1.
      @194    DXCCSR_GEN015            1.
      @195    DXCCSR_GEN016            1.
      @196    DXCCSR_GEN017            1.
      @197    DXCCSR_GEN018            1.
      @198    DXCCSR_GEN019            1.
      @199    DXCCSR_GEN020            1.
      @200    DXCCSR_GEN021            1.
      @201    DXCCSR_GEN022            1.
      @202    DXCCSR_GEN023            1.
      @203    DXCCSR_GEN024            1.
      @204    DXCCSR_GEN025            1.
      @205    DXCCSR_GEN026            1.
      @206    DXCCSR_INF001            1.
      @207    DXCCSR_INF002            1.
      @208    DXCCSR_INF003            1.
      @209    DXCCSR_INF004            1.
      @210    DXCCSR_INF005            1.
      @211    DXCCSR_INF006            1.
      @212    DXCCSR_INF007            1.
      @213    DXCCSR_INF008            1.
      @214    DXCCSR_INF009            1.
      @215    DXCCSR_INF010            1.
      @216    DXCCSR_INF011            1.
      @217    DXCCSR_INF012            1.
      @218    DXCCSR_INJ001            1.
      @219    DXCCSR_INJ002            1.
      @220    DXCCSR_INJ003            1.
      @221    DXCCSR_INJ004            1.
      @222    DXCCSR_INJ005            1.
      @223    DXCCSR_INJ006            1.
      @224    DXCCSR_INJ007            1.
      @225    DXCCSR_INJ008            1.
      @226    DXCCSR_INJ009            1.
      @227    DXCCSR_INJ010            1.
      @228    DXCCSR_INJ011            1.
      @229    DXCCSR_INJ012            1.
      @230    DXCCSR_INJ013            1.
      @231    DXCCSR_INJ014            1.
      @232    DXCCSR_INJ015            1.
      @233    DXCCSR_INJ016            1.
      @234    DXCCSR_INJ017            1.
      @235    DXCCSR_INJ018            1.
      @236    DXCCSR_INJ019            1.
      @237    DXCCSR_INJ020            1.
      @238    DXCCSR_INJ021            1.
      @239    DXCCSR_INJ022            1.
      @240    DXCCSR_INJ023            1.
      @241    DXCCSR_INJ024            1.
      @242    DXCCSR_INJ025            1.
      @243    DXCCSR_INJ026            1.
      @244    DXCCSR_INJ027            1.
      @245    DXCCSR_INJ028            1.
      @246    DXCCSR_INJ029            1.
      @247    DXCCSR_INJ030            1.
      @248    DXCCSR_INJ031            1.
      @249    DXCCSR_INJ032            1.
      @250    DXCCSR_INJ033            1.
      @251    DXCCSR_INJ034            1.
      @252    DXCCSR_INJ035            1.
      @253    DXCCSR_INJ036            1.
      @254    DXCCSR_INJ037            1.
      @255    DXCCSR_INJ038            1.
      @256    DXCCSR_INJ039            1.
      @257    DXCCSR_INJ040            1.
      @258    DXCCSR_INJ041            1.
      @259    DXCCSR_INJ042            1.
      @260    DXCCSR_INJ043            1.
      @261    DXCCSR_INJ044            1.
      @262    DXCCSR_INJ045            1.
      @263    DXCCSR_INJ046            1.
      @264    DXCCSR_INJ047            1.
      @265    DXCCSR_INJ048            1.
      @266    DXCCSR_INJ049            1.
      @267    DXCCSR_INJ050            1.
      @268    DXCCSR_INJ051            1.
      @269    DXCCSR_INJ052            1.
      @270    DXCCSR_INJ053            1.
      @271    DXCCSR_INJ054            1.
      @272    DXCCSR_INJ055            1.
      @273    DXCCSR_INJ056            1.
      @274    DXCCSR_INJ057            1.
      @275    DXCCSR_INJ058            1.
      @276    DXCCSR_INJ059            1.
      @277    DXCCSR_INJ060            1.
      @278    DXCCSR_INJ061            1.
      @279    DXCCSR_INJ062            1.
      @280    DXCCSR_INJ063            1.
      @281    DXCCSR_INJ064            1.
      @282    DXCCSR_INJ065            1.
      @283    DXCCSR_INJ066            1.
      @284    DXCCSR_INJ067            1.
      @285    DXCCSR_INJ068            1.
      @286    DXCCSR_INJ069            1.
      @287    DXCCSR_INJ070            1.
      @288    DXCCSR_INJ071            1.
      @289    DXCCSR_INJ072            1.
      @290    DXCCSR_INJ073            1.
      @291    DXCCSR_INJ074            1.
      @292    DXCCSR_INJ075            1.
      @293    DXCCSR_INJ076            1.
      @294    DXCCSR_MAL001            1.
      @295    DXCCSR_MAL002            1.
      @296    DXCCSR_MAL003            1.
      @297    DXCCSR_MAL004            1.
      @298    DXCCSR_MAL005            1.
      @299    DXCCSR_MAL006            1.
      @300    DXCCSR_MAL007            1.
      @301    DXCCSR_MAL008            1.
      @302    DXCCSR_MAL009            1.
      @303    DXCCSR_MAL010            1.
      @304    DXCCSR_MBD001            1.
      @305    DXCCSR_MBD002            1.
      @306    DXCCSR_MBD003            1.
      @307    DXCCSR_MBD004            1.
      @308    DXCCSR_MBD005            1.
      @309    DXCCSR_MBD006            1.
      @310    DXCCSR_MBD007            1.
      @311    DXCCSR_MBD008            1.
      @312    DXCCSR_MBD009            1.
      @313    DXCCSR_MBD010            1.
      @314    DXCCSR_MBD011            1.
      @315    DXCCSR_MBD012            1.
      @316    DXCCSR_MBD013            1.
      @317    DXCCSR_MBD014            1.
      @318    DXCCSR_MBD017            1.
      @319    DXCCSR_MBD018            1.
      @320    DXCCSR_MBD019            1.
      @321    DXCCSR_MBD020            1.
      @322    DXCCSR_MBD021            1.
      @323    DXCCSR_MBD022            1.
      @324    DXCCSR_MBD023            1.
      @325    DXCCSR_MBD024            1.
      @326    DXCCSR_MBD025            1.
      @327    DXCCSR_MBD026            1.
      @328    DXCCSR_MBD027            1.
      @329    DXCCSR_MBD028            1.
      @330    DXCCSR_MBD029            1.
      @331    DXCCSR_MBD030            1.
      @332    DXCCSR_MBD031            1.
      @333    DXCCSR_MBD032            1.
      @334    DXCCSR_MBD033            1.
      @335    DXCCSR_MBD034            1.
      @336    DXCCSR_MUS001            1.
      @337    DXCCSR_MUS002            1.
      @338    DXCCSR_MUS003            1.
      @339    DXCCSR_MUS004            1.
      @340    DXCCSR_MUS005            1.
      @341    DXCCSR_MUS006            1.
      @342    DXCCSR_MUS007            1.
      @343    DXCCSR_MUS008            1.
      @344    DXCCSR_MUS009            1.
      @345    DXCCSR_MUS010            1.
      @346    DXCCSR_MUS011            1.
      @347    DXCCSR_MUS012            1.
      @348    DXCCSR_MUS013            1.
      @349    DXCCSR_MUS014            1.
      @350    DXCCSR_MUS015            1.
      @351    DXCCSR_MUS016            1.
      @352    DXCCSR_MUS017            1.
      @353    DXCCSR_MUS018            1.
      @354    DXCCSR_MUS019            1.
      @355    DXCCSR_MUS020            1.
      @356    DXCCSR_MUS021            1.
      @357    DXCCSR_MUS022            1.
      @358    DXCCSR_MUS023            1.
      @359    DXCCSR_MUS024            1.
      @360    DXCCSR_MUS025            1.
      @361    DXCCSR_MUS026            1.
      @362    DXCCSR_MUS027            1.
      @363    DXCCSR_MUS028            1.
      @364    DXCCSR_MUS029            1.
      @365    DXCCSR_MUS030            1.
      @366    DXCCSR_MUS031            1.
      @367    DXCCSR_MUS032            1.
      @368    DXCCSR_MUS033            1.
      @369    DXCCSR_MUS034            1.
      @370    DXCCSR_MUS035            1.
      @371    DXCCSR_MUS036            1.
      @372    DXCCSR_MUS037            1.
      @373    DXCCSR_MUS038            1.
      @374    DXCCSR_NEO001            1.
      @375    DXCCSR_NEO002            1.
      @376    DXCCSR_NEO003            1.
      @377    DXCCSR_NEO004            1.
      @378    DXCCSR_NEO005            1.
      @379    DXCCSR_NEO006            1.
      @380    DXCCSR_NEO007            1.
      @381    DXCCSR_NEO008            1.
      @382    DXCCSR_NEO009            1.
      @383    DXCCSR_NEO010            1.
      @384    DXCCSR_NEO011            1.
      @385    DXCCSR_NEO012            1.
      @386    DXCCSR_NEO013            1.
      @387    DXCCSR_NEO014            1.
      @388    DXCCSR_NEO015            1.
      @389    DXCCSR_NEO016            1.
      @390    DXCCSR_NEO017            1.
      @391    DXCCSR_NEO018            1.
      @392    DXCCSR_NEO019            1.
      @393    DXCCSR_NEO020            1.
      @394    DXCCSR_NEO021            1.
      @395    DXCCSR_NEO022            1.
      @396    DXCCSR_NEO023            1.
      @397    DXCCSR_NEO024            1.
      @398    DXCCSR_NEO025            1.
      @399    DXCCSR_NEO026            1.
      @400    DXCCSR_NEO027            1.
      @401    DXCCSR_NEO028            1.
      @402    DXCCSR_NEO029            1.
      @403    DXCCSR_NEO030            1.
      @404    DXCCSR_NEO031            1.
      @405    DXCCSR_NEO032            1.
      @406    DXCCSR_NEO033            1.
      @407    DXCCSR_NEO034            1.
      @408    DXCCSR_NEO035            1.
      @409    DXCCSR_NEO036            1.
      @410    DXCCSR_NEO037            1.
      @411    DXCCSR_NEO038            1.
      @412    DXCCSR_NEO039            1.
      @413    DXCCSR_NEO040            1.
      @414    DXCCSR_NEO041            1.
      @415    DXCCSR_NEO042            1.
      @416    DXCCSR_NEO043            1.
      @417    DXCCSR_NEO044            1.
      @418    DXCCSR_NEO045            1.
      @419    DXCCSR_NEO046            1.
      @420    DXCCSR_NEO047            1.
      @421    DXCCSR_NEO048            1.
      @422    DXCCSR_NEO049            1.
      @423    DXCCSR_NEO050            1.
      @424    DXCCSR_NEO051            1.
      @425    DXCCSR_NEO052            1.
      @426    DXCCSR_NEO053            1.
      @427    DXCCSR_NEO054            1.
      @428    DXCCSR_NEO055            1.
      @429    DXCCSR_NEO056            1.
      @430    DXCCSR_NEO057            1.
      @431    DXCCSR_NEO058            1.
      @432    DXCCSR_NEO059            1.
      @433    DXCCSR_NEO060            1.
      @434    DXCCSR_NEO061            1.
      @435    DXCCSR_NEO062            1.
      @436    DXCCSR_NEO063            1.
      @437    DXCCSR_NEO064            1.
      @438    DXCCSR_NEO065            1.
      @439    DXCCSR_NEO066            1.
      @440    DXCCSR_NEO067            1.
      @441    DXCCSR_NEO068            1.
      @442    DXCCSR_NEO069            1.
      @443    DXCCSR_NEO070            1.
      @444    DXCCSR_NEO071            1.
      @445    DXCCSR_NEO072            1.
      @446    DXCCSR_NEO073            1.
      @447    DXCCSR_NEO074            1.
      @448    DXCCSR_NVS001            1.
      @449    DXCCSR_NVS002            1.
      @450    DXCCSR_NVS003            1.
      @451    DXCCSR_NVS004            1.
      @452    DXCCSR_NVS005            1.
      @453    DXCCSR_NVS006            1.
      @454    DXCCSR_NVS007            1.
      @455    DXCCSR_NVS008            1.
      @456    DXCCSR_NVS009            1.
      @457    DXCCSR_NVS010            1.
      @458    DXCCSR_NVS011            1.
      @459    DXCCSR_NVS012            1.
      @460    DXCCSR_NVS013            1.
      @461    DXCCSR_NVS014            1.
      @462    DXCCSR_NVS015            1.
      @463    DXCCSR_NVS016            1.
      @464    DXCCSR_NVS017            1.
      @465    DXCCSR_NVS018            1.
      @466    DXCCSR_NVS019            1.
      @467    DXCCSR_NVS020            1.
      @468    DXCCSR_NVS021            1.
      @469    DXCCSR_NVS022            1.
      @470    DXCCSR_PNL001            1.
      @471    DXCCSR_PNL002            1.
      @472    DXCCSR_PNL003            1.
      @473    DXCCSR_PNL004            1.
      @474    DXCCSR_PNL005            1.
      @475    DXCCSR_PNL006            1.
      @476    DXCCSR_PNL007            1.
      @477    DXCCSR_PNL008            1.
      @478    DXCCSR_PNL009            1.
      @479    DXCCSR_PNL010            1.
      @480    DXCCSR_PNL011            1.
      @481    DXCCSR_PNL012            1.
      @482    DXCCSR_PNL013            1.
      @483    DXCCSR_PNL014            1.
      @484    DXCCSR_PNL015            1.
      @485    DXCCSR_PRG001            1.
      @486    DXCCSR_PRG002            1.
      @487    DXCCSR_PRG003            1.
      @488    DXCCSR_PRG004            1.
      @489    DXCCSR_PRG005            1.
      @490    DXCCSR_PRG006            1.
      @491    DXCCSR_PRG007            1.
      @492    DXCCSR_PRG008            1.
      @493    DXCCSR_PRG009            1.
      @494    DXCCSR_PRG010            1.
      @495    DXCCSR_PRG011            1.
      @496    DXCCSR_PRG012            1.
      @497    DXCCSR_PRG013            1.
      @498    DXCCSR_PRG014            1.
      @499    DXCCSR_PRG015            1.
      @500    DXCCSR_PRG016            1.
      @501    DXCCSR_PRG017            1.
      @502    DXCCSR_PRG018            1.
      @503    DXCCSR_PRG019            1.
      @504    DXCCSR_PRG020            1.
      @505    DXCCSR_PRG021            1.
      @506    DXCCSR_PRG022            1.
      @507    DXCCSR_PRG023            1.
      @508    DXCCSR_PRG024            1.
      @509    DXCCSR_PRG025            1.
      @510    DXCCSR_PRG026            1.
      @511    DXCCSR_PRG027            1.
      @512    DXCCSR_PRG028            1.
      @513    DXCCSR_PRG029            1.
      @514    DXCCSR_PRG030            1.
      @515    DXCCSR_RSP001            1.
      @516    DXCCSR_RSP002            1.
      @517    DXCCSR_RSP003            1.
      @518    DXCCSR_RSP004            1.
      @519    DXCCSR_RSP005            1.
      @520    DXCCSR_RSP006            1.
      @521    DXCCSR_RSP007            1.
      @522    DXCCSR_RSP008            1.
      @523    DXCCSR_RSP009            1.
      @524    DXCCSR_RSP010            1.
      @525    DXCCSR_RSP011            1.
      @526    DXCCSR_RSP012            1.
      @527    DXCCSR_RSP013            1.
      @528    DXCCSR_RSP014            1.
      @529    DXCCSR_RSP015            1.
      @530    DXCCSR_RSP016            1.
      @531    DXCCSR_RSP017            1.
      @532    DXCCSR_SKN001            1.
      @533    DXCCSR_SKN002            1.
      @534    DXCCSR_SKN003            1.
      @535    DXCCSR_SKN004            1.
      @536    DXCCSR_SKN005            1.
      @537    DXCCSR_SKN006            1.
      @538    DXCCSR_SKN007            1.
      @539    DXCCSR_SYM001            1.
      @540    DXCCSR_SYM002            1.
      @541    DXCCSR_SYM003            1.
      @542    DXCCSR_SYM004            1.
      @543    DXCCSR_SYM005            1.
      @544    DXCCSR_SYM006            1.
      @545    DXCCSR_SYM007            1.
      @546    DXCCSR_SYM008            1.
      @547    DXCCSR_SYM009            1.
      @548    DXCCSR_SYM010            1.
      @549    DXCCSR_SYM011            1.
      @550    DXCCSR_SYM012            1.
      @551    DXCCSR_SYM013            1.
      @552    DXCCSR_SYM014            1.
      @553    DXCCSR_SYM015            1.
      @554    DXCCSR_SYM016            1.
      @555    DXCCSR_SYM017            1.
      @556    DXCCSR_DEFAULT_DX1       $CHAR6.
      @562    DXCCSR_VERSION           $CHAR6.
      ;
RUN;
