/*****************************************************************************
 * Stataload_NEDS_2020_IP.Do
 * This program will load the NEDS 2020 IP csv File into Stata.
 * created on 09/09/2022.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NEDS_2020_IP.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      long   hosp_ed
      double key_ed
      byte   disp_ip
      int    drg
      byte   drgver
      int    drg_nopoa
      int    i10_npr_ip
      str7   i10_pr_ip1
      str7   i10_pr_ip2
      str7   i10_pr_ip3
      str7   i10_pr_ip4
      str7   i10_pr_ip5
      str7   i10_pr_ip6
      str7   i10_pr_ip7
      str7   i10_pr_ip8
      str7   i10_pr_ip9
      str7   i10_pr_ip10
      str7   i10_pr_ip11
      str7   i10_pr_ip12
      str7   i10_pr_ip13
      str7   i10_pr_ip14
      str7   i10_pr_ip15
      long   los_ip
      byte   mdc
      byte   mdc_nopoa
      int    pclass1
      int    pclass2
      int    pclass3
      int    pclass4
      int    pclass5
      int    pclass6
      int    pclass7
      int    pclass8
      int    pclass9
      int    pclass10
      int    pclass11
      int    pclass12
      int    pclass13
      int    pclass14
      int    pclass15
      str6   pclass_version
      byte   prccsr_adm001
      byte   prccsr_adm002
      byte   prccsr_adm003
      byte   prccsr_adm004
      byte   prccsr_adm005
      byte   prccsr_adm006
      byte   prccsr_adm007
      byte   prccsr_adm008
      byte   prccsr_adm009
      byte   prccsr_adm010
      byte   prccsr_adm011
      byte   prccsr_adm012
      byte   prccsr_adm013
      byte   prccsr_adm014
      byte   prccsr_adm015
      byte   prccsr_adm016
      byte   prccsr_adm017
      byte   prccsr_adm018
      byte   prccsr_adm019
      byte   prccsr_adm020
      byte   prccsr_adm021
      byte   prccsr_adm022
      byte   prccsr_car001
      byte   prccsr_car002
      byte   prccsr_car003
      byte   prccsr_car004
      byte   prccsr_car005
      byte   prccsr_car006
      byte   prccsr_car007
      byte   prccsr_car008
      byte   prccsr_car009
      byte   prccsr_car010
      byte   prccsr_car011
      byte   prccsr_car012
      byte   prccsr_car013
      byte   prccsr_car014
      byte   prccsr_car015
      byte   prccsr_car016
      byte   prccsr_car017
      byte   prccsr_car018
      byte   prccsr_car019
      byte   prccsr_car020
      byte   prccsr_car021
      byte   prccsr_car022
      byte   prccsr_car023
      byte   prccsr_car024
      byte   prccsr_car025
      byte   prccsr_car026
      byte   prccsr_car027
      byte   prccsr_car028
      byte   prccsr_car029
      byte   prccsr_chp001
      byte   prccsr_cns001
      byte   prccsr_cns002
      byte   prccsr_cns003
      byte   prccsr_cns004
      byte   prccsr_cns005
      byte   prccsr_cns006
      byte   prccsr_cns007
      byte   prccsr_cns008
      byte   prccsr_cns009
      byte   prccsr_cns010
      byte   prccsr_cns011
      byte   prccsr_cns012
      byte   prccsr_cns013
      byte   prccsr_cns014
      byte   prccsr_enp001
      byte   prccsr_enp002
      byte   prccsr_enp003
      byte   prccsr_enp004
      byte   prccsr_enp005
      byte   prccsr_enp006
      byte   prccsr_ent001
      byte   prccsr_ent002
      byte   prccsr_ent003
      byte   prccsr_ent004
      byte   prccsr_ent005
      byte   prccsr_ent006
      byte   prccsr_ent007
      byte   prccsr_ent008
      byte   prccsr_ent009
      byte   prccsr_ent010
      byte   prccsr_ent011
      byte   prccsr_ent012
      byte   prccsr_ent013
      byte   prccsr_ent014
      byte   prccsr_ent015
      byte   prccsr_ent016
      byte   prccsr_ent017
      byte   prccsr_esa001
      byte   prccsr_esa002
      byte   prccsr_esa003
      byte   prccsr_esa004
      byte   prccsr_esa005
      byte   prccsr_esa006
      byte   prccsr_esa007
      byte   prccsr_esa008
      byte   prccsr_esa009
      byte   prccsr_esa010
      byte   prccsr_esa011
      byte   prccsr_est001
      byte   prccsr_est002
      byte   prccsr_est003
      byte   prccsr_est004
      byte   prccsr_est005
      byte   prccsr_eyp001
      byte   prccsr_eyp002
      byte   prccsr_frs001
      byte   prccsr_frs002
      byte   prccsr_frs003
      byte   prccsr_frs004
      byte   prccsr_frs005
      byte   prccsr_frs006
      byte   prccsr_frs007
      byte   prccsr_frs008
      byte   prccsr_frs009
      byte   prccsr_frs010
      byte   prccsr_frs011
      byte   prccsr_frs012
      byte   prccsr_frs013
      byte   prccsr_frs014
      byte   prccsr_frs015
      byte   prccsr_gis001
      byte   prccsr_gis002
      byte   prccsr_gis003
      byte   prccsr_gis004
      byte   prccsr_gis005
      byte   prccsr_gis006
      byte   prccsr_gis007
      byte   prccsr_gis008
      byte   prccsr_gis009
      byte   prccsr_gis010
      byte   prccsr_gis011
      byte   prccsr_gis012
      byte   prccsr_gis013
      byte   prccsr_gis014
      byte   prccsr_gis015
      byte   prccsr_gis016
      byte   prccsr_gis017
      byte   prccsr_gis018
      byte   prccsr_gis019
      byte   prccsr_gis020
      byte   prccsr_gis021
      byte   prccsr_gis022
      byte   prccsr_gis023
      byte   prccsr_gis024
      byte   prccsr_gis025
      byte   prccsr_gis026
      byte   prccsr_gis027
      byte   prccsr_gis028
      byte   prccsr_gis029
      byte   prccsr_gnr001
      byte   prccsr_gnr002
      byte   prccsr_gnr003
      byte   prccsr_gnr004
      byte   prccsr_gnr005
      byte   prccsr_gnr006
      byte   prccsr_gnr007
      byte   prccsr_gnr008
      byte   prccsr_gnr009
      byte   prccsr_gnr010
      byte   prccsr_hep001
      byte   prccsr_hep002
      byte   prccsr_hep003
      byte   prccsr_hep004
      byte   prccsr_hep005
      byte   prccsr_hep006
      byte   prccsr_hep007
      byte   prccsr_hep008
      byte   prccsr_hep009
      byte   prccsr_hep010
      byte   prccsr_hep011
      byte   prccsr_hep012
      byte   prccsr_hep013
      byte   prccsr_img001
      byte   prccsr_img002
      byte   prccsr_img003
      byte   prccsr_img004
      byte   prccsr_img005
      byte   prccsr_img006
      byte   prccsr_img007
      byte   prccsr_img008
      byte   prccsr_img009
      byte   prccsr_img010
      byte   prccsr_lym001
      byte   prccsr_lym002
      byte   prccsr_lym003
      byte   prccsr_lym004
      byte   prccsr_lym005
      byte   prccsr_lym006
      byte   prccsr_lym007
      byte   prccsr_lym008
      byte   prccsr_lym009
      byte   prccsr_lym010
      byte   prccsr_lym011
      byte   prccsr_mam001
      byte   prccsr_mam002
      byte   prccsr_mam003
      byte   prccsr_mam004
      byte   prccsr_mam005
      byte   prccsr_mam006
      byte   prccsr_mam007
      byte   prccsr_mam008
      byte   prccsr_mam009
      byte   prccsr_mam010
      byte   prccsr_mam011
      byte   prccsr_mam012
      byte   prccsr_mam013
      byte   prccsr_mam014
      byte   prccsr_mam015
      byte   prccsr_mht001
      byte   prccsr_mht002
      byte   prccsr_mht003
      byte   prccsr_mht004
      byte   prccsr_mht005
      byte   prccsr_mrs001
      byte   prccsr_mrs002
      byte   prccsr_mrs003
      byte   prccsr_mrs004
      byte   prccsr_mrs005
      byte   prccsr_mrs006
      byte   prccsr_mrs007
      byte   prccsr_mst001
      byte   prccsr_mst002
      byte   prccsr_mst003
      byte   prccsr_mst004
      byte   prccsr_mst005
      byte   prccsr_mst006
      byte   prccsr_mst007
      byte   prccsr_mst008
      byte   prccsr_mst009
      byte   prccsr_mst010
      byte   prccsr_mst011
      byte   prccsr_mst012
      byte   prccsr_mst013
      byte   prccsr_mst014
      byte   prccsr_mst015
      byte   prccsr_mst016
      byte   prccsr_mst017
      byte   prccsr_mst018
      byte   prccsr_mst019
      byte   prccsr_mst020
      byte   prccsr_mst021
      byte   prccsr_mst022
      byte   prccsr_mst023
      byte   prccsr_mst024
      byte   prccsr_mst025
      byte   prccsr_mst026
      byte   prccsr_mst027
      byte   prccsr_mst028
      byte   prccsr_mst029
      byte   prccsr_mst030
      byte   prccsr_ncm001
      byte   prccsr_ncm002
      byte   prccsr_ncm003
      byte   prccsr_ncm004
      byte   prccsr_ost001
      byte   prccsr_otr001
      byte   prccsr_otr002
      byte   prccsr_otr003
      byte   prccsr_otr004
      byte   prccsr_otr005
      byte   prccsr_pgn001
      byte   prccsr_pgn002
      byte   prccsr_pgn003
      byte   prccsr_pgn004
      byte   prccsr_pgn005
      byte   prccsr_pgn006
      byte   prccsr_pgn007
      byte   prccsr_pgn008
      byte   prccsr_pgn009
      byte   prccsr_plc001
      byte   prccsr_plc002
      byte   prccsr_pns001
      byte   prccsr_pns002
      byte   prccsr_pns003
      byte   prccsr_pns004
      byte   prccsr_pns005
      byte   prccsr_pns006
      byte   prccsr_rad001
      byte   prccsr_rad002
      byte   prccsr_rad003
      byte   prccsr_rad004
      byte   prccsr_res001
      byte   prccsr_res002
      byte   prccsr_res003
      byte   prccsr_res004
      byte   prccsr_res005
      byte   prccsr_res006
      byte   prccsr_res007
      byte   prccsr_res008
      byte   prccsr_res009
      byte   prccsr_res010
      byte   prccsr_res011
      byte   prccsr_res012
      byte   prccsr_res013
      byte   prccsr_res014
      byte   prccsr_rhb001
      byte   prccsr_rhb002
      byte   prccsr_rhb003
      byte   prccsr_rhb004
      byte   prccsr_skb001
      byte   prccsr_skb002
      byte   prccsr_skb003
      byte   prccsr_skb004
      byte   prccsr_skb005
      byte   prccsr_skb006
      byte   prccsr_skb007
      byte   prccsr_skb008
      byte   prccsr_skb009
      byte   prccsr_skb010
      byte   prccsr_sud001
      byte   prccsr_sud002
      byte   prccsr_sud003
      byte   prccsr_sud004
      byte   prccsr_urn001
      byte   prccsr_urn002
      byte   prccsr_urn003
      byte   prccsr_urn004
      byte   prccsr_urn005
      byte   prccsr_urn006
      byte   prccsr_urn007
      byte   prccsr_urn008
      byte   prccsr_urn009
      byte   prccsr_urn010
      byte   prccsr_urn011
      byte   prccsr_urn012
      str6   prccsr_version
      double totchg_ip
using NEDS_2020_IP.csv;

/*  Assign labels to the data elements */
label var hosp_ed                  "HCUP ED hospital identifier" ;
label var key_ed                   "HCUP NEDS record identifier" ;
label var disp_ip                  "Disposition of patient (uniform) from IP" ;
label var drg                      "DRG in effect on discharge date" ;
label var drgver                   "DRG grouper version used on discharge date" ;
label var drg_nopoa                "DRG in use on discharge date, calculated without POA" ;
label var i10_npr_ip               "Number of ICD-10-PCS procedures from inpatient discharge record" ;
label var i10_pr_ip1               "ICD-10-PCS Procedure 1 from inpatient discharge record" ;
label var i10_pr_ip2               "ICD-10-PCS Procedure 2 from inpatient discharge record" ;
label var i10_pr_ip3               "ICD-10-PCS Procedure 3 from inpatient discharge record" ;
label var i10_pr_ip4               "ICD-10-PCS Procedure 4 from inpatient discharge record" ;
label var i10_pr_ip5               "ICD-10-PCS Procedure 5 from inpatient discharge record" ;
label var i10_pr_ip6               "ICD-10-PCS Procedure 6 from inpatient discharge record" ;
label var i10_pr_ip7               "ICD-10-PCS Procedure 7 from inpatient discharge record" ;
label var i10_pr_ip8               "ICD-10-PCS Procedure 8 from inpatient discharge record" ;
label var i10_pr_ip9               "ICD-10-PCS Procedure 9 from inpatient discharge record" ;
label var i10_pr_ip10              "ICD-10-PCS Procedure 10 from inpatient discharge record" ;
label var i10_pr_ip11              "ICD-10-PCS Procedure 11 from inpatient discharge record" ;
label var i10_pr_ip12              "ICD-10-PCS Procedure 12 from inpatient discharge record" ;
label var i10_pr_ip13              "ICD-10-PCS Procedure 13 from inpatient discharge record" ;
label var i10_pr_ip14              "ICD-10-PCS Procedure 14 from inpatient discharge record" ;
label var i10_pr_ip15              "ICD-10-PCS Procedure 15 from inpatient discharge record" ;
label var los_ip                   "Length of stay (cleaned) from IP" ;
label var mdc                      "MDC in effect on discharge date" ;
label var mdc_nopoa                "MDC in use on discharge date, calculated without POA" ;
label var pclass1                  "ICD-10-PCS Procedure class 1" ;
label var pclass2                  "ICD-10-PCS Procedure class 2" ;
label var pclass3                  "ICD-10-PCS Procedure class 3" ;
label var pclass4                  "ICD-10-PCS Procedure class 4" ;
label var pclass5                  "ICD-10-PCS Procedure class 5" ;
label var pclass6                  "ICD-10-PCS Procedure class 6" ;
label var pclass7                  "ICD-10-PCS Procedure class 7" ;
label var pclass8                  "ICD-10-PCS Procedure class 8" ;
label var pclass9                  "ICD-10-PCS Procedure class 9" ;
label var pclass10                 "ICD-10-PCS Procedure class 10" ;
label var pclass11                 "ICD-10-PCS Procedure class 11" ;
label var pclass12                 "ICD-10-PCS Procedure class 12" ;
label var pclass13                 "ICD-10-PCS Procedure class 13" ;
label var pclass14                 "ICD-10-PCS Procedure class 14" ;
label var pclass15                 "ICD-10-PCS Procedure class 15" ;
label var pclass_version           "Version of ICD-10-PCS Procedure class" ;
label var prccsr_adm001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM001" ;
label var prccsr_adm002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM002" ;
label var prccsr_adm003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM003" ;
label var prccsr_adm004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM004" ;
label var prccsr_adm005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM005" ;
label var prccsr_adm006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM006" ;
label var prccsr_adm007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM007" ;
label var prccsr_adm008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM008" ;
label var prccsr_adm009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM009" ;
label var prccsr_adm010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM010" ;
label var prccsr_adm011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM011" ;
label var prccsr_adm012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM012" ;
label var prccsr_adm013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM013" ;
label var prccsr_adm014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM014" ;
label var prccsr_adm015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM015" ;
label var prccsr_adm016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM016" ;
label var prccsr_adm017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM017" ;
label var prccsr_adm018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM018" ;
label var prccsr_adm019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM019" ;
label var prccsr_adm020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM020" ;
label var prccsr_adm021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM021" ;
label var prccsr_adm022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM022" ;
label var prccsr_car001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR001" ;
label var prccsr_car002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR002" ;
label var prccsr_car003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR003" ;
label var prccsr_car004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR004" ;
label var prccsr_car005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR005" ;
label var prccsr_car006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR006" ;
label var prccsr_car007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR007" ;
label var prccsr_car008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR008" ;
label var prccsr_car009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR009" ;
label var prccsr_car010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR010" ;
label var prccsr_car011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR011" ;
label var prccsr_car012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR012" ;
label var prccsr_car013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR013" ;
label var prccsr_car014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR014" ;
label var prccsr_car015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR015" ;
label var prccsr_car016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR016" ;
label var prccsr_car017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR017" ;
label var prccsr_car018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR018" ;
label var prccsr_car019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR019" ;
label var prccsr_car020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR020" ;
label var prccsr_car021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR021" ;
label var prccsr_car022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR022" ;
label var prccsr_car023            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR023" ;
label var prccsr_car024            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR024" ;
label var prccsr_car025            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR025" ;
label var prccsr_car026            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR026" ;
label var prccsr_car027            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR027" ;
label var prccsr_car028            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR028" ;
label var prccsr_car029            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR029" ;
label var prccsr_chp001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CHP001" ;
label var prccsr_cns001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS001" ;
label var prccsr_cns002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS002" ;
label var prccsr_cns003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS003" ;
label var prccsr_cns004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS004" ;
label var prccsr_cns005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS005" ;
label var prccsr_cns006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS006" ;
label var prccsr_cns007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS007" ;
label var prccsr_cns008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS008" ;
label var prccsr_cns009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS009" ;
label var prccsr_cns010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS010" ;
label var prccsr_cns011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS011" ;
label var prccsr_cns012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS012" ;
label var prccsr_cns013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS013" ;
label var prccsr_cns014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS014" ;
label var prccsr_enp001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP001" ;
label var prccsr_enp002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP002" ;
label var prccsr_enp003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP003" ;
label var prccsr_enp004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP004" ;
label var prccsr_enp005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP005" ;
label var prccsr_enp006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP006" ;
label var prccsr_ent001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT001" ;
label var prccsr_ent002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT002" ;
label var prccsr_ent003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT003" ;
label var prccsr_ent004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT004" ;
label var prccsr_ent005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT005" ;
label var prccsr_ent006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT006" ;
label var prccsr_ent007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT007" ;
label var prccsr_ent008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT008" ;
label var prccsr_ent009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT009" ;
label var prccsr_ent010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT010" ;
label var prccsr_ent011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT011" ;
label var prccsr_ent012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT012" ;
label var prccsr_ent013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT013" ;
label var prccsr_ent014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT014" ;
label var prccsr_ent015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT015" ;
label var prccsr_ent016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT016" ;
label var prccsr_ent017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT017" ;
label var prccsr_esa001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA001" ;
label var prccsr_esa002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA002" ;
label var prccsr_esa003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA003" ;
label var prccsr_esa004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA004" ;
label var prccsr_esa005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA005" ;
label var prccsr_esa006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA006" ;
label var prccsr_esa007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA007" ;
label var prccsr_esa008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA008" ;
label var prccsr_esa009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA009" ;
label var prccsr_esa010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA010" ;
label var prccsr_esa011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA011" ;
label var prccsr_est001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST001" ;
label var prccsr_est002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST002" ;
label var prccsr_est003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST003" ;
label var prccsr_est004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST004" ;
label var prccsr_est005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST005" ;
label var prccsr_eyp001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EYP001" ;
label var prccsr_eyp002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EYP002" ;
label var prccsr_frs001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS001" ;
label var prccsr_frs002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS002" ;
label var prccsr_frs003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS003" ;
label var prccsr_frs004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS004" ;
label var prccsr_frs005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS005" ;
label var prccsr_frs006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS006" ;
label var prccsr_frs007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS007" ;
label var prccsr_frs008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS008" ;
label var prccsr_frs009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS009" ;
label var prccsr_frs010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS010" ;
label var prccsr_frs011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS011" ;
label var prccsr_frs012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS012" ;
label var prccsr_frs013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS013" ;
label var prccsr_frs014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS014" ;
label var prccsr_frs015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS015" ;
label var prccsr_gis001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS001" ;
label var prccsr_gis002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS002" ;
label var prccsr_gis003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS003" ;
label var prccsr_gis004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS004" ;
label var prccsr_gis005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS005" ;
label var prccsr_gis006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS006" ;
label var prccsr_gis007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS007" ;
label var prccsr_gis008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS008" ;
label var prccsr_gis009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS009" ;
label var prccsr_gis010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS010" ;
label var prccsr_gis011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS011" ;
label var prccsr_gis012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS012" ;
label var prccsr_gis013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS013" ;
label var prccsr_gis014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS014" ;
label var prccsr_gis015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS015" ;
label var prccsr_gis016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS016" ;
label var prccsr_gis017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS017" ;
label var prccsr_gis018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS018" ;
label var prccsr_gis019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS019" ;
label var prccsr_gis020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS020" ;
label var prccsr_gis021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS021" ;
label var prccsr_gis022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS022" ;
label var prccsr_gis023            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS023" ;
label var prccsr_gis024            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS024" ;
label var prccsr_gis025            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS025" ;
label var prccsr_gis026            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS026" ;
label var prccsr_gis027            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS027" ;
label var prccsr_gis028            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS028" ;
label var prccsr_gis029            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS029" ;
label var prccsr_gnr001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR001" ;
label var prccsr_gnr002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR002" ;
label var prccsr_gnr003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR003" ;
label var prccsr_gnr004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR004" ;
label var prccsr_gnr005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR005" ;
label var prccsr_gnr006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR006" ;
label var prccsr_gnr007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR007" ;
label var prccsr_gnr008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR008" ;
label var prccsr_gnr009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR009" ;
label var prccsr_gnr010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR010" ;
label var prccsr_hep001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP001" ;
label var prccsr_hep002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP002" ;
label var prccsr_hep003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP003" ;
label var prccsr_hep004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP004" ;
label var prccsr_hep005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP005" ;
label var prccsr_hep006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP006" ;
label var prccsr_hep007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP007" ;
label var prccsr_hep008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP008" ;
label var prccsr_hep009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP009" ;
label var prccsr_hep010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP010" ;
label var prccsr_hep011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP011" ;
label var prccsr_hep012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP012" ;
label var prccsr_hep013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP013" ;
label var prccsr_img001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG001" ;
label var prccsr_img002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG002" ;
label var prccsr_img003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG003" ;
label var prccsr_img004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG004" ;
label var prccsr_img005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG005" ;
label var prccsr_img006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG006" ;
label var prccsr_img007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG007" ;
label var prccsr_img008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG008" ;
label var prccsr_img009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG009" ;
label var prccsr_img010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG010" ;
label var prccsr_lym001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM001" ;
label var prccsr_lym002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM002" ;
label var prccsr_lym003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM003" ;
label var prccsr_lym004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM004" ;
label var prccsr_lym005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM005" ;
label var prccsr_lym006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM006" ;
label var prccsr_lym007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM007" ;
label var prccsr_lym008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM008" ;
label var prccsr_lym009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM009" ;
label var prccsr_lym010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM010" ;
label var prccsr_lym011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM011" ;
label var prccsr_mam001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM001" ;
label var prccsr_mam002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM002" ;
label var prccsr_mam003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM003" ;
label var prccsr_mam004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM004" ;
label var prccsr_mam005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM005" ;
label var prccsr_mam006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM006" ;
label var prccsr_mam007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM007" ;
label var prccsr_mam008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM008" ;
label var prccsr_mam009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM009" ;
label var prccsr_mam010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM010" ;
label var prccsr_mam011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM011" ;
label var prccsr_mam012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM012" ;
label var prccsr_mam013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM013" ;
label var prccsr_mam014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM014" ;
label var prccsr_mam015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM015" ;
label var prccsr_mht001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT001" ;
label var prccsr_mht002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT002" ;
label var prccsr_mht003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT003" ;
label var prccsr_mht004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT004" ;
label var prccsr_mht005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT005" ;
label var prccsr_mrs001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS001" ;
label var prccsr_mrs002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS002" ;
label var prccsr_mrs003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS003" ;
label var prccsr_mrs004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS004" ;
label var prccsr_mrs005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS005" ;
label var prccsr_mrs006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS006" ;
label var prccsr_mrs007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS007" ;
label var prccsr_mst001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST001" ;
label var prccsr_mst002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST002" ;
label var prccsr_mst003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST003" ;
label var prccsr_mst004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST004" ;
label var prccsr_mst005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST005" ;
label var prccsr_mst006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST006" ;
label var prccsr_mst007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST007" ;
label var prccsr_mst008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST008" ;
label var prccsr_mst009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST009" ;
label var prccsr_mst010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST010" ;
label var prccsr_mst011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST011" ;
label var prccsr_mst012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST012" ;
label var prccsr_mst013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST013" ;
label var prccsr_mst014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST014" ;
label var prccsr_mst015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST015" ;
label var prccsr_mst016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST016" ;
label var prccsr_mst017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST017" ;
label var prccsr_mst018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST018" ;
label var prccsr_mst019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST019" ;
label var prccsr_mst020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST020" ;
label var prccsr_mst021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST021" ;
label var prccsr_mst022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST022" ;
label var prccsr_mst023            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST023" ;
label var prccsr_mst024            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST024" ;
label var prccsr_mst025            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST025" ;
label var prccsr_mst026            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST026" ;
label var prccsr_mst027            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST027" ;
label var prccsr_mst028            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST028" ;
label var prccsr_mst029            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST029" ;
label var prccsr_mst030            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST030" ;
label var prccsr_ncm001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM001" ;
label var prccsr_ncm002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM002" ;
label var prccsr_ncm003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM003" ;
label var prccsr_ncm004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM004" ;
label var prccsr_ost001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OST001" ;
label var prccsr_otr001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR001" ;
label var prccsr_otr002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR002" ;
label var prccsr_otr003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR003" ;
label var prccsr_otr004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR004" ;
label var prccsr_otr005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR005" ;
label var prccsr_pgn001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN001" ;
label var prccsr_pgn002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN002" ;
label var prccsr_pgn003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN003" ;
label var prccsr_pgn004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN004" ;
label var prccsr_pgn005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN005" ;
label var prccsr_pgn006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN006" ;
label var prccsr_pgn007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN007" ;
label var prccsr_pgn008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN008" ;
label var prccsr_pgn009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN009" ;
label var prccsr_plc001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PLC001" ;
label var prccsr_plc002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PLC002" ;
label var prccsr_pns001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS001" ;
label var prccsr_pns002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS002" ;
label var prccsr_pns003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS003" ;
label var prccsr_pns004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS004" ;
label var prccsr_pns005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS005" ;
label var prccsr_pns006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS006" ;
label var prccsr_rad001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD001" ;
label var prccsr_rad002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD002" ;
label var prccsr_rad003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD003" ;
label var prccsr_rad004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD004" ;
label var prccsr_res001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES001" ;
label var prccsr_res002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES002" ;
label var prccsr_res003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES003" ;
label var prccsr_res004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES004" ;
label var prccsr_res005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES005" ;
label var prccsr_res006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES006" ;
label var prccsr_res007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES007" ;
label var prccsr_res008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES008" ;
label var prccsr_res009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES009" ;
label var prccsr_res010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES010" ;
label var prccsr_res011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES011" ;
label var prccsr_res012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES012" ;
label var prccsr_res013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES013" ;
label var prccsr_res014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES014" ;
label var prccsr_rhb001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB001" ;
label var prccsr_rhb002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB002" ;
label var prccsr_rhb003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB003" ;
label var prccsr_rhb004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB004" ;
label var prccsr_skb001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB001" ;
label var prccsr_skb002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB002" ;
label var prccsr_skb003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB003" ;
label var prccsr_skb004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB004" ;
label var prccsr_skb005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB005" ;
label var prccsr_skb006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB006" ;
label var prccsr_skb007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB007" ;
label var prccsr_skb008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB008" ;
label var prccsr_skb009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB009" ;
label var prccsr_skb010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB010" ;
label var prccsr_sud001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD001" ;
label var prccsr_sud002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD002" ;
label var prccsr_sud003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD003" ;
label var prccsr_sud004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD004" ;
label var prccsr_urn001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN001" ;
label var prccsr_urn002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN002" ;
label var prccsr_urn003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN003" ;
label var prccsr_urn004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN004" ;
label var prccsr_urn005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN005" ;
label var prccsr_urn006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN006" ;
label var prccsr_urn007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN007" ;
label var prccsr_urn008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN008" ;
label var prccsr_urn009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN009" ;
label var prccsr_urn010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN010" ;
label var prccsr_urn011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN011" ;
label var prccsr_urn012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN012" ;
label var prccsr_version           "Version of CCSR for ICD-10-PCS procedures" ;
label var totchg_ip                "Total charge for ED and inpatient services" ;

/* Convert special values to missing values */
recode hosp_ed                   (-9999 -8888 -6666=.) ;
recode key_ed                    (-999999999999999 -888888888888888 -666666666666666=.) ;
recode disp_ip                   (-9 -8 -6 -5=.) ;
recode drg                       (-99 -88 -66=.) ;
recode drgver                    (-9 -8 -6 -5=.) ;
recode drg_nopoa                 (-99 -88 -66=.) ;
recode i10_npr_ip                (-99 -88 -66=.) ;
recode los_ip                    (-9999 -8888 -6666=.) ;
recode mdc                       (-9 -8 -6 -5=.) ;
recode mdc_nopoa                 (-9 -8 -6 -5=.) ;
recode pclass1                   (-99 -88 -66=.) ;
recode pclass2                   (-99 -88 -66=.) ;
recode pclass3                   (-99 -88 -66=.) ;
recode pclass4                   (-99 -88 -66=.) ;
recode pclass5                   (-99 -88 -66=.) ;
recode pclass6                   (-99 -88 -66=.) ;
recode pclass7                   (-99 -88 -66=.) ;
recode pclass8                   (-99 -88 -66=.) ;
recode pclass9                   (-99 -88 -66=.) ;
recode pclass10                  (-99 -88 -66=.) ;
recode pclass11                  (-99 -88 -66=.) ;
recode pclass12                  (-99 -88 -66=.) ;
recode pclass13                  (-99 -88 -66=.) ;
recode pclass14                  (-99 -88 -66=.) ;
recode pclass15                  (-99 -88 -66=.) ;
recode prccsr_adm001             (-9 -8 -6 -5=.) ;
recode prccsr_adm002             (-9 -8 -6 -5=.) ;
recode prccsr_adm003             (-9 -8 -6 -5=.) ;
recode prccsr_adm004             (-9 -8 -6 -5=.) ;
recode prccsr_adm005             (-9 -8 -6 -5=.) ;
recode prccsr_adm006             (-9 -8 -6 -5=.) ;
recode prccsr_adm007             (-9 -8 -6 -5=.) ;
recode prccsr_adm008             (-9 -8 -6 -5=.) ;
recode prccsr_adm009             (-9 -8 -6 -5=.) ;
recode prccsr_adm010             (-9 -8 -6 -5=.) ;
recode prccsr_adm011             (-9 -8 -6 -5=.) ;
recode prccsr_adm012             (-9 -8 -6 -5=.) ;
recode prccsr_adm013             (-9 -8 -6 -5=.) ;
recode prccsr_adm014             (-9 -8 -6 -5=.) ;
recode prccsr_adm015             (-9 -8 -6 -5=.) ;
recode prccsr_adm016             (-9 -8 -6 -5=.) ;
recode prccsr_adm017             (-9 -8 -6 -5=.) ;
recode prccsr_adm018             (-9 -8 -6 -5=.) ;
recode prccsr_adm019             (-9 -8 -6 -5=.) ;
recode prccsr_adm020             (-9 -8 -6 -5=.) ;
recode prccsr_adm021             (-9 -8 -6 -5=.) ;
recode prccsr_adm022             (-9 -8 -6 -5=.) ;
recode prccsr_car001             (-9 -8 -6 -5=.) ;
recode prccsr_car002             (-9 -8 -6 -5=.) ;
recode prccsr_car003             (-9 -8 -6 -5=.) ;
recode prccsr_car004             (-9 -8 -6 -5=.) ;
recode prccsr_car005             (-9 -8 -6 -5=.) ;
recode prccsr_car006             (-9 -8 -6 -5=.) ;
recode prccsr_car007             (-9 -8 -6 -5=.) ;
recode prccsr_car008             (-9 -8 -6 -5=.) ;
recode prccsr_car009             (-9 -8 -6 -5=.) ;
recode prccsr_car010             (-9 -8 -6 -5=.) ;
recode prccsr_car011             (-9 -8 -6 -5=.) ;
recode prccsr_car012             (-9 -8 -6 -5=.) ;
recode prccsr_car013             (-9 -8 -6 -5=.) ;
recode prccsr_car014             (-9 -8 -6 -5=.) ;
recode prccsr_car015             (-9 -8 -6 -5=.) ;
recode prccsr_car016             (-9 -8 -6 -5=.) ;
recode prccsr_car017             (-9 -8 -6 -5=.) ;
recode prccsr_car018             (-9 -8 -6 -5=.) ;
recode prccsr_car019             (-9 -8 -6 -5=.) ;
recode prccsr_car020             (-9 -8 -6 -5=.) ;
recode prccsr_car021             (-9 -8 -6 -5=.) ;
recode prccsr_car022             (-9 -8 -6 -5=.) ;
recode prccsr_car023             (-9 -8 -6 -5=.) ;
recode prccsr_car024             (-9 -8 -6 -5=.) ;
recode prccsr_car025             (-9 -8 -6 -5=.) ;
recode prccsr_car026             (-9 -8 -6 -5=.) ;
recode prccsr_car027             (-9 -8 -6 -5=.) ;
recode prccsr_car028             (-9 -8 -6 -5=.) ;
recode prccsr_car029             (-9 -8 -6 -5=.) ;
recode prccsr_chp001             (-9 -8 -6 -5=.) ;
recode prccsr_cns001             (-9 -8 -6 -5=.) ;
recode prccsr_cns002             (-9 -8 -6 -5=.) ;
recode prccsr_cns003             (-9 -8 -6 -5=.) ;
recode prccsr_cns004             (-9 -8 -6 -5=.) ;
recode prccsr_cns005             (-9 -8 -6 -5=.) ;
recode prccsr_cns006             (-9 -8 -6 -5=.) ;
recode prccsr_cns007             (-9 -8 -6 -5=.) ;
recode prccsr_cns008             (-9 -8 -6 -5=.) ;
recode prccsr_cns009             (-9 -8 -6 -5=.) ;
recode prccsr_cns010             (-9 -8 -6 -5=.) ;
recode prccsr_cns011             (-9 -8 -6 -5=.) ;
recode prccsr_cns012             (-9 -8 -6 -5=.) ;
recode prccsr_cns013             (-9 -8 -6 -5=.) ;
recode prccsr_cns014             (-9 -8 -6 -5=.) ;
recode prccsr_enp001             (-9 -8 -6 -5=.) ;
recode prccsr_enp002             (-9 -8 -6 -5=.) ;
recode prccsr_enp003             (-9 -8 -6 -5=.) ;
recode prccsr_enp004             (-9 -8 -6 -5=.) ;
recode prccsr_enp005             (-9 -8 -6 -5=.) ;
recode prccsr_enp006             (-9 -8 -6 -5=.) ;
recode prccsr_ent001             (-9 -8 -6 -5=.) ;
recode prccsr_ent002             (-9 -8 -6 -5=.) ;
recode prccsr_ent003             (-9 -8 -6 -5=.) ;
recode prccsr_ent004             (-9 -8 -6 -5=.) ;
recode prccsr_ent005             (-9 -8 -6 -5=.) ;
recode prccsr_ent006             (-9 -8 -6 -5=.) ;
recode prccsr_ent007             (-9 -8 -6 -5=.) ;
recode prccsr_ent008             (-9 -8 -6 -5=.) ;
recode prccsr_ent009             (-9 -8 -6 -5=.) ;
recode prccsr_ent010             (-9 -8 -6 -5=.) ;
recode prccsr_ent011             (-9 -8 -6 -5=.) ;
recode prccsr_ent012             (-9 -8 -6 -5=.) ;
recode prccsr_ent013             (-9 -8 -6 -5=.) ;
recode prccsr_ent014             (-9 -8 -6 -5=.) ;
recode prccsr_ent015             (-9 -8 -6 -5=.) ;
recode prccsr_ent016             (-9 -8 -6 -5=.) ;
recode prccsr_ent017             (-9 -8 -6 -5=.) ;
recode prccsr_esa001             (-9 -8 -6 -5=.) ;
recode prccsr_esa002             (-9 -8 -6 -5=.) ;
recode prccsr_esa003             (-9 -8 -6 -5=.) ;
recode prccsr_esa004             (-9 -8 -6 -5=.) ;
recode prccsr_esa005             (-9 -8 -6 -5=.) ;
recode prccsr_esa006             (-9 -8 -6 -5=.) ;
recode prccsr_esa007             (-9 -8 -6 -5=.) ;
recode prccsr_esa008             (-9 -8 -6 -5=.) ;
recode prccsr_esa009             (-9 -8 -6 -5=.) ;
recode prccsr_esa010             (-9 -8 -6 -5=.) ;
recode prccsr_esa011             (-9 -8 -6 -5=.) ;
recode prccsr_est001             (-9 -8 -6 -5=.) ;
recode prccsr_est002             (-9 -8 -6 -5=.) ;
recode prccsr_est003             (-9 -8 -6 -5=.) ;
recode prccsr_est004             (-9 -8 -6 -5=.) ;
recode prccsr_est005             (-9 -8 -6 -5=.) ;
recode prccsr_eyp001             (-9 -8 -6 -5=.) ;
recode prccsr_eyp002             (-9 -8 -6 -5=.) ;
recode prccsr_frs001             (-9 -8 -6 -5=.) ;
recode prccsr_frs002             (-9 -8 -6 -5=.) ;
recode prccsr_frs003             (-9 -8 -6 -5=.) ;
recode prccsr_frs004             (-9 -8 -6 -5=.) ;
recode prccsr_frs005             (-9 -8 -6 -5=.) ;
recode prccsr_frs006             (-9 -8 -6 -5=.) ;
recode prccsr_frs007             (-9 -8 -6 -5=.) ;
recode prccsr_frs008             (-9 -8 -6 -5=.) ;
recode prccsr_frs009             (-9 -8 -6 -5=.) ;
recode prccsr_frs010             (-9 -8 -6 -5=.) ;
recode prccsr_frs011             (-9 -8 -6 -5=.) ;
recode prccsr_frs012             (-9 -8 -6 -5=.) ;
recode prccsr_frs013             (-9 -8 -6 -5=.) ;
recode prccsr_frs014             (-9 -8 -6 -5=.) ;
recode prccsr_frs015             (-9 -8 -6 -5=.) ;
recode prccsr_gis001             (-9 -8 -6 -5=.) ;
recode prccsr_gis002             (-9 -8 -6 -5=.) ;
recode prccsr_gis003             (-9 -8 -6 -5=.) ;
recode prccsr_gis004             (-9 -8 -6 -5=.) ;
recode prccsr_gis005             (-9 -8 -6 -5=.) ;
recode prccsr_gis006             (-9 -8 -6 -5=.) ;
recode prccsr_gis007             (-9 -8 -6 -5=.) ;
recode prccsr_gis008             (-9 -8 -6 -5=.) ;
recode prccsr_gis009             (-9 -8 -6 -5=.) ;
recode prccsr_gis010             (-9 -8 -6 -5=.) ;
recode prccsr_gis011             (-9 -8 -6 -5=.) ;
recode prccsr_gis012             (-9 -8 -6 -5=.) ;
recode prccsr_gis013             (-9 -8 -6 -5=.) ;
recode prccsr_gis014             (-9 -8 -6 -5=.) ;
recode prccsr_gis015             (-9 -8 -6 -5=.) ;
recode prccsr_gis016             (-9 -8 -6 -5=.) ;
recode prccsr_gis017             (-9 -8 -6 -5=.) ;
recode prccsr_gis018             (-9 -8 -6 -5=.) ;
recode prccsr_gis019             (-9 -8 -6 -5=.) ;
recode prccsr_gis020             (-9 -8 -6 -5=.) ;
recode prccsr_gis021             (-9 -8 -6 -5=.) ;
recode prccsr_gis022             (-9 -8 -6 -5=.) ;
recode prccsr_gis023             (-9 -8 -6 -5=.) ;
recode prccsr_gis024             (-9 -8 -6 -5=.) ;
recode prccsr_gis025             (-9 -8 -6 -5=.) ;
recode prccsr_gis026             (-9 -8 -6 -5=.) ;
recode prccsr_gis027             (-9 -8 -6 -5=.) ;
recode prccsr_gis028             (-9 -8 -6 -5=.) ;
recode prccsr_gis029             (-9 -8 -6 -5=.) ;
recode prccsr_gnr001             (-9 -8 -6 -5=.) ;
recode prccsr_gnr002             (-9 -8 -6 -5=.) ;
recode prccsr_gnr003             (-9 -8 -6 -5=.) ;
recode prccsr_gnr004             (-9 -8 -6 -5=.) ;
recode prccsr_gnr005             (-9 -8 -6 -5=.) ;
recode prccsr_gnr006             (-9 -8 -6 -5=.) ;
recode prccsr_gnr007             (-9 -8 -6 -5=.) ;
recode prccsr_gnr008             (-9 -8 -6 -5=.) ;
recode prccsr_gnr009             (-9 -8 -6 -5=.) ;
recode prccsr_gnr010             (-9 -8 -6 -5=.) ;
recode prccsr_hep001             (-9 -8 -6 -5=.) ;
recode prccsr_hep002             (-9 -8 -6 -5=.) ;
recode prccsr_hep003             (-9 -8 -6 -5=.) ;
recode prccsr_hep004             (-9 -8 -6 -5=.) ;
recode prccsr_hep005             (-9 -8 -6 -5=.) ;
recode prccsr_hep006             (-9 -8 -6 -5=.) ;
recode prccsr_hep007             (-9 -8 -6 -5=.) ;
recode prccsr_hep008             (-9 -8 -6 -5=.) ;
recode prccsr_hep009             (-9 -8 -6 -5=.) ;
recode prccsr_hep010             (-9 -8 -6 -5=.) ;
recode prccsr_hep011             (-9 -8 -6 -5=.) ;
recode prccsr_hep012             (-9 -8 -6 -5=.) ;
recode prccsr_hep013             (-9 -8 -6 -5=.) ;
recode prccsr_img001             (-9 -8 -6 -5=.) ;
recode prccsr_img002             (-9 -8 -6 -5=.) ;
recode prccsr_img003             (-9 -8 -6 -5=.) ;
recode prccsr_img004             (-9 -8 -6 -5=.) ;
recode prccsr_img005             (-9 -8 -6 -5=.) ;
recode prccsr_img006             (-9 -8 -6 -5=.) ;
recode prccsr_img007             (-9 -8 -6 -5=.) ;
recode prccsr_img008             (-9 -8 -6 -5=.) ;
recode prccsr_img009             (-9 -8 -6 -5=.) ;
recode prccsr_img010             (-9 -8 -6 -5=.) ;
recode prccsr_lym001             (-9 -8 -6 -5=.) ;
recode prccsr_lym002             (-9 -8 -6 -5=.) ;
recode prccsr_lym003             (-9 -8 -6 -5=.) ;
recode prccsr_lym004             (-9 -8 -6 -5=.) ;
recode prccsr_lym005             (-9 -8 -6 -5=.) ;
recode prccsr_lym006             (-9 -8 -6 -5=.) ;
recode prccsr_lym007             (-9 -8 -6 -5=.) ;
recode prccsr_lym008             (-9 -8 -6 -5=.) ;
recode prccsr_lym009             (-9 -8 -6 -5=.) ;
recode prccsr_lym010             (-9 -8 -6 -5=.) ;
recode prccsr_lym011             (-9 -8 -6 -5=.) ;
recode prccsr_mam001             (-9 -8 -6 -5=.) ;
recode prccsr_mam002             (-9 -8 -6 -5=.) ;
recode prccsr_mam003             (-9 -8 -6 -5=.) ;
recode prccsr_mam004             (-9 -8 -6 -5=.) ;
recode prccsr_mam005             (-9 -8 -6 -5=.) ;
recode prccsr_mam006             (-9 -8 -6 -5=.) ;
recode prccsr_mam007             (-9 -8 -6 -5=.) ;
recode prccsr_mam008             (-9 -8 -6 -5=.) ;
recode prccsr_mam009             (-9 -8 -6 -5=.) ;
recode prccsr_mam010             (-9 -8 -6 -5=.) ;
recode prccsr_mam011             (-9 -8 -6 -5=.) ;
recode prccsr_mam012             (-9 -8 -6 -5=.) ;
recode prccsr_mam013             (-9 -8 -6 -5=.) ;
recode prccsr_mam014             (-9 -8 -6 -5=.) ;
recode prccsr_mam015             (-9 -8 -6 -5=.) ;
recode prccsr_mht001             (-9 -8 -6 -5=.) ;
recode prccsr_mht002             (-9 -8 -6 -5=.) ;
recode prccsr_mht003             (-9 -8 -6 -5=.) ;
recode prccsr_mht004             (-9 -8 -6 -5=.) ;
recode prccsr_mht005             (-9 -8 -6 -5=.) ;
recode prccsr_mrs001             (-9 -8 -6 -5=.) ;
recode prccsr_mrs002             (-9 -8 -6 -5=.) ;
recode prccsr_mrs003             (-9 -8 -6 -5=.) ;
recode prccsr_mrs004             (-9 -8 -6 -5=.) ;
recode prccsr_mrs005             (-9 -8 -6 -5=.) ;
recode prccsr_mrs006             (-9 -8 -6 -5=.) ;
recode prccsr_mrs007             (-9 -8 -6 -5=.) ;
recode prccsr_mst001             (-9 -8 -6 -5=.) ;
recode prccsr_mst002             (-9 -8 -6 -5=.) ;
recode prccsr_mst003             (-9 -8 -6 -5=.) ;
recode prccsr_mst004             (-9 -8 -6 -5=.) ;
recode prccsr_mst005             (-9 -8 -6 -5=.) ;
recode prccsr_mst006             (-9 -8 -6 -5=.) ;
recode prccsr_mst007             (-9 -8 -6 -5=.) ;
recode prccsr_mst008             (-9 -8 -6 -5=.) ;
recode prccsr_mst009             (-9 -8 -6 -5=.) ;
recode prccsr_mst010             (-9 -8 -6 -5=.) ;
recode prccsr_mst011             (-9 -8 -6 -5=.) ;
recode prccsr_mst012             (-9 -8 -6 -5=.) ;
recode prccsr_mst013             (-9 -8 -6 -5=.) ;
recode prccsr_mst014             (-9 -8 -6 -5=.) ;
recode prccsr_mst015             (-9 -8 -6 -5=.) ;
recode prccsr_mst016             (-9 -8 -6 -5=.) ;
recode prccsr_mst017             (-9 -8 -6 -5=.) ;
recode prccsr_mst018             (-9 -8 -6 -5=.) ;
recode prccsr_mst019             (-9 -8 -6 -5=.) ;
recode prccsr_mst020             (-9 -8 -6 -5=.) ;
recode prccsr_mst021             (-9 -8 -6 -5=.) ;
recode prccsr_mst022             (-9 -8 -6 -5=.) ;
recode prccsr_mst023             (-9 -8 -6 -5=.) ;
recode prccsr_mst024             (-9 -8 -6 -5=.) ;
recode prccsr_mst025             (-9 -8 -6 -5=.) ;
recode prccsr_mst026             (-9 -8 -6 -5=.) ;
recode prccsr_mst027             (-9 -8 -6 -5=.) ;
recode prccsr_mst028             (-9 -8 -6 -5=.) ;
recode prccsr_mst029             (-9 -8 -6 -5=.) ;
recode prccsr_mst030             (-9 -8 -6 -5=.) ;
recode prccsr_ncm001             (-9 -8 -6 -5=.) ;
recode prccsr_ncm002             (-9 -8 -6 -5=.) ;
recode prccsr_ncm003             (-9 -8 -6 -5=.) ;
recode prccsr_ncm004             (-9 -8 -6 -5=.) ;
recode prccsr_ost001             (-9 -8 -6 -5=.) ;
recode prccsr_otr001             (-9 -8 -6 -5=.) ;
recode prccsr_otr002             (-9 -8 -6 -5=.) ;
recode prccsr_otr003             (-9 -8 -6 -5=.) ;
recode prccsr_otr004             (-9 -8 -6 -5=.) ;
recode prccsr_otr005             (-9 -8 -6 -5=.) ;
recode prccsr_pgn001             (-9 -8 -6 -5=.) ;
recode prccsr_pgn002             (-9 -8 -6 -5=.) ;
recode prccsr_pgn003             (-9 -8 -6 -5=.) ;
recode prccsr_pgn004             (-9 -8 -6 -5=.) ;
recode prccsr_pgn005             (-9 -8 -6 -5=.) ;
recode prccsr_pgn006             (-9 -8 -6 -5=.) ;
recode prccsr_pgn007             (-9 -8 -6 -5=.) ;
recode prccsr_pgn008             (-9 -8 -6 -5=.) ;
recode prccsr_pgn009             (-9 -8 -6 -5=.) ;
recode prccsr_plc001             (-9 -8 -6 -5=.) ;
recode prccsr_plc002             (-9 -8 -6 -5=.) ;
recode prccsr_pns001             (-9 -8 -6 -5=.) ;
recode prccsr_pns002             (-9 -8 -6 -5=.) ;
recode prccsr_pns003             (-9 -8 -6 -5=.) ;
recode prccsr_pns004             (-9 -8 -6 -5=.) ;
recode prccsr_pns005             (-9 -8 -6 -5=.) ;
recode prccsr_pns006             (-9 -8 -6 -5=.) ;
recode prccsr_rad001             (-9 -8 -6 -5=.) ;
recode prccsr_rad002             (-9 -8 -6 -5=.) ;
recode prccsr_rad003             (-9 -8 -6 -5=.) ;
recode prccsr_rad004             (-9 -8 -6 -5=.) ;
recode prccsr_res001             (-9 -8 -6 -5=.) ;
recode prccsr_res002             (-9 -8 -6 -5=.) ;
recode prccsr_res003             (-9 -8 -6 -5=.) ;
recode prccsr_res004             (-9 -8 -6 -5=.) ;
recode prccsr_res005             (-9 -8 -6 -5=.) ;
recode prccsr_res006             (-9 -8 -6 -5=.) ;
recode prccsr_res007             (-9 -8 -6 -5=.) ;
recode prccsr_res008             (-9 -8 -6 -5=.) ;
recode prccsr_res009             (-9 -8 -6 -5=.) ;
recode prccsr_res010             (-9 -8 -6 -5=.) ;
recode prccsr_res011             (-9 -8 -6 -5=.) ;
recode prccsr_res012             (-9 -8 -6 -5=.) ;
recode prccsr_res013             (-9 -8 -6 -5=.) ;
recode prccsr_res014             (-9 -8 -6 -5=.) ;
recode prccsr_rhb001             (-9 -8 -6 -5=.) ;
recode prccsr_rhb002             (-9 -8 -6 -5=.) ;
recode prccsr_rhb003             (-9 -8 -6 -5=.) ;
recode prccsr_rhb004             (-9 -8 -6 -5=.) ;
recode prccsr_skb001             (-9 -8 -6 -5=.) ;
recode prccsr_skb002             (-9 -8 -6 -5=.) ;
recode prccsr_skb003             (-9 -8 -6 -5=.) ;
recode prccsr_skb004             (-9 -8 -6 -5=.) ;
recode prccsr_skb005             (-9 -8 -6 -5=.) ;
recode prccsr_skb006             (-9 -8 -6 -5=.) ;
recode prccsr_skb007             (-9 -8 -6 -5=.) ;
recode prccsr_skb008             (-9 -8 -6 -5=.) ;
recode prccsr_skb009             (-9 -8 -6 -5=.) ;
recode prccsr_skb010             (-9 -8 -6 -5=.) ;
recode prccsr_sud001             (-9 -8 -6 -5=.) ;
recode prccsr_sud002             (-9 -8 -6 -5=.) ;
recode prccsr_sud003             (-9 -8 -6 -5=.) ;
recode prccsr_sud004             (-9 -8 -6 -5=.) ;
recode prccsr_urn001             (-9 -8 -6 -5=.) ;
recode prccsr_urn002             (-9 -8 -6 -5=.) ;
recode prccsr_urn003             (-9 -8 -6 -5=.) ;
recode prccsr_urn004             (-9 -8 -6 -5=.) ;
recode prccsr_urn005             (-9 -8 -6 -5=.) ;
recode prccsr_urn006             (-9 -8 -6 -5=.) ;
recode prccsr_urn007             (-9 -8 -6 -5=.) ;
recode prccsr_urn008             (-9 -8 -6 -5=.) ;
recode prccsr_urn009             (-9 -8 -6 -5=.) ;
recode prccsr_urn010             (-9 -8 -6 -5=.) ;
recode prccsr_urn011             (-9 -8 -6 -5=.) ;
recode prccsr_urn012             (-9 -8 -6 -5=.) ;
recode totchg_ip                 (-99999999.99 -88888888.88 -66666666.66=.) ;

describe;

save "NEDS_2020_IP.dta", replace;
#delimit cr
