/*****************************************************************************
 * Stataload_NEDS_2013_IP.Do
 * This program will load the 2013 NEDS CSV IP File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NEDS_2013_IP.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      double discwt
      long   hosp_ed
      double key_ed
      long   neds_stratum
      byte   disp_ip
      int    drg
      byte   drgver
      int    drg_nopoa
      long   los_ip
      byte   mdc
      byte   mdc_nopoa
      int    npr_ip
      int    pclass_ip1
      int    pclass_ip2
      int    pclass_ip3
      int    pclass_ip4
      int    pclass_ip5
      int    pclass_ip6
      int    pclass_ip7
      int    pclass_ip8
      int    pclass_ip9
      str4   pr_ip1
      str4   pr_ip2
      str4   pr_ip3
      str4   pr_ip4
      str4   pr_ip5
      str4   pr_ip6
      str4   pr_ip7
      str4   pr_ip8
      str4   pr_ip9
      int    prccs_ip1
      int    prccs_ip2
      int    prccs_ip3
      int    prccs_ip4
      int    prccs_ip5
      int    prccs_ip6
      int    prccs_ip7
      int    prccs_ip8
      int    prccs_ip9
      double totchg_ip
using NEDS_2013_IP.csv;

/*  Assign labels to the data elements */
label var discwt                   "Weight to ED Visits in AHA universe" ;
label var hosp_ed                  "HCUP ED hospital identifier" ;
label var key_ed                   "HCUP NEDS record identifier" ;
label var neds_stratum             "Stratum used to sample hospital" ;
label var disp_ip                  "Disposition of patient (uniform) from IP" ;
label var drg                      "DRG in effect on discharge date" ;
label var drgver                   "DRG grouper version used on discharge date" ;
label var drg_nopoa                "DRG in use on discharge date, calculated without POA" ;
label var los_ip                   "Length of stay (cleaned) from IP" ;
label var mdc                      "MDC in effect on discharge date" ;
label var mdc_nopoa                "MDC in use on discharge date, calculated without POA" ;
label var npr_ip                   "Number of procedures from inpatient discharge record" ;
label var pclass_ip1               "Principal procedure class for inpatient procedure" ;
label var pclass_ip2               "Procedure class 2 for inpatient procedure" ;
label var pclass_ip3               "Procedure class 3 for inpatient procedure" ;
label var pclass_ip4               "Procedure class 4 for inpatient procedure" ;
label var pclass_ip5               "Procedure class 5 for inpatient procedure" ;
label var pclass_ip6               "Procedure class 6 for inpatient procedure" ;
label var pclass_ip7               "Procedure class 7 for inpatient procedure" ;
label var pclass_ip8               "Procedure class 8 for inpatient procedure" ;
label var pclass_ip9               "Procedure class 9 for inpatient procedure" ;
label var pr_ip1                   "Principal procedure from inpatient discharge record" ;
label var pr_ip2                   "Procedure 2 from inpatient discharge record" ;
label var pr_ip3                   "Procedure 3 from inpatient discharge record" ;
label var pr_ip4                   "Procedure 4 from inpatient discharge record" ;
label var pr_ip5                   "Procedure 5 from inpatient discharge record" ;
label var pr_ip6                   "Procedure 6 from inpatient discharge record" ;
label var pr_ip7                   "Procedure 7 from inpatient discharge record" ;
label var pr_ip8                   "Procedure 8 from inpatient discharge record" ;
label var pr_ip9                   "Procedure 9 from inpatient discharge record" ;
label var prccs_ip1                "CCS: principal procedure from inpatient discharge record" ;
label var prccs_ip2                "CCS: procedure 2 from inpatient discharge record" ;
label var prccs_ip3                "CCS: procedure 3 from inpatient discharge record" ;
label var prccs_ip4                "CCS: procedure 4 from inpatient discharge record" ;
label var prccs_ip5                "CCS: procedure 5 from inpatient discharge record" ;
label var prccs_ip6                "CCS: procedure 6 from inpatient discharge record" ;
label var prccs_ip7                "CCS: procedure 7 from inpatient discharge record" ;
label var prccs_ip8                "CCS: procedure 8 from inpatient discharge record" ;
label var prccs_ip9                "CCS: procedure 9 from inpatient discharge record" ;
label var totchg_ip                "Total charge for ED and inpatient services" ;

/* Convert special values to missing values */
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.) ;
recode hosp_ed                   (-9999 -8888 -6666=.) ;
recode key_ed                    (-999999999999999 -888888888888888 -666666666666666=.) ;
recode neds_stratum              (-9999 -8888 -6666=.) ;
recode disp_ip                   (-9 -8 -6 -5=.) ;
recode drg                       (-99 -88 -66=.) ;
recode drgver                    (-9 -8 -6 -5=.) ;
recode drg_nopoa                 (-99 -88 -66=.) ;
recode los_ip                    (-9999 -8888 -6666=.) ;
recode mdc                       (-9 -8 -6 -5=.) ;
recode mdc_nopoa                 (-9 -8 -6 -5=.) ;
recode npr_ip                    (-99 -88 -66=.) ;
recode pclass_ip1                (-99 -88 -66=.) ;
recode pclass_ip2                (-99 -88 -66=.) ;
recode pclass_ip3                (-99 -88 -66=.) ;
recode pclass_ip4                (-99 -88 -66=.) ;
recode pclass_ip5                (-99 -88 -66=.) ;
recode pclass_ip6                (-99 -88 -66=.) ;
recode pclass_ip7                (-99 -88 -66=.) ;
recode pclass_ip8                (-99 -88 -66=.) ;
recode pclass_ip9                (-99 -88 -66=.) ;
recode prccs_ip1                 (-99 -88 -66=.) ;
recode prccs_ip2                 (-99 -88 -66=.) ;
recode prccs_ip3                 (-99 -88 -66=.) ;
recode prccs_ip4                 (-99 -88 -66=.) ;
recode prccs_ip5                 (-99 -88 -66=.) ;
recode prccs_ip6                 (-99 -88 -66=.) ;
recode prccs_ip7                 (-99 -88 -66=.) ;
recode prccs_ip8                 (-99 -88 -66=.) ;
recode prccs_ip9                 (-99 -88 -66=.) ;
recode totchg_ip                 (-99999999.99 -88888888.88 -66666666.66=.) ;

describe;

save "NEDS_2013_IP.dta", replace;
#delimit cr
