/*****************************************************************************
 * Stataload_NEDS_2011_Core.Do
 * This program will load the 2011 NEDS CSV Core File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NEDS_2011_Core.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      int    age
      byte   amonth
      byte   aweekend
      int    chron1
      int    chron2
      int    chron3
      int    chron4
      int    chron5
      int    chron6
      int    chron7
      int    chron8
      int    chron9
      int    chron10
      int    chron11
      int    chron12
      int    chron13
      int    chron14
      int    chron15
      byte   died_visit
      double discwt
      byte   disp_ed
      byte   dqtr
      str5   dx1
      str5   dx2
      str5   dx3
      str5   dx4
      str5   dx5
      str5   dx6
      str5   dx7
      str5   dx8
      str5   dx9
      str5   dx10
      str5   dx11
      str5   dx12
      str5   dx13
      str5   dx14
      str5   dx15
      int    dxccs1
      int    dxccs2
      int    dxccs3
      int    dxccs4
      int    dxccs5
      int    dxccs6
      int    dxccs7
      int    dxccs8
      int    dxccs9
      int    dxccs10
      int    dxccs11
      int    dxccs12
      int    dxccs13
      int    dxccs14
      int    dxccs15
      str5   ecode1
      str5   ecode2
      str5   ecode3
      str5   ecode4
      byte   edevent
      int    e_ccs1
      int    e_ccs2
      int    e_ccs3
      int    e_ccs4
      byte   female
      str4   hcupfile
      long   hosp_ed
      byte   injury
      byte   injury_cut
      byte   injury_drown
      byte   injury_fall
      byte   injury_fire
      byte   injury_firearm
      byte   injury_machinery
      byte   injury_mvt
      byte   injury_nature
      byte   injury_poison
      byte   injury_severity
      byte   injury_struck
      byte   injury_suffocation
      byte   intent_assault
      byte   intent_self_harm
      byte   intent_unintentional
      double key_ed
      byte   multinjury
      int    ndx
      int    necode
      long   neds_stratum
      byte   pay1
      byte   pay2
      int    pl_nchs2006
      double totchg_ed
      int    year
      byte   zipinc_qrtl
using NEDS_2011_Core.csv;

/*  Assign labels to the data elements */
label var age                      "Age in years at admission" ;
label var amonth                   "Admission month" ;
label var aweekend                 "Admission day is a weekend" ;
label var chron1                   "Chronic condition indicator 1" ;
label var chron2                   "Chronic condition indicator 2" ;
label var chron3                   "Chronic condition indicator 3" ;
label var chron4                   "Chronic condition indicator 4" ;
label var chron5                   "Chronic condition indicator 5" ;
label var chron6                   "Chronic condition indicator 6" ;
label var chron7                   "Chronic condition indicator 7" ;
label var chron8                   "Chronic condition indicator 8" ;
label var chron9                   "Chronic condition indicator 9" ;
label var chron10                  "Chronic condition indicator 10" ;
label var chron11                  "Chronic condition indicator 11" ;
label var chron12                  "Chronic condition indicator 12" ;
label var chron13                  "Chronic condition indicator 13" ;
label var chron14                  "Chronic condition indicator 14" ;
label var chron15                  "Chronic condition indicator 15" ;
label var died_visit               "Died in the ED (1), Died in the hospital (2), did not die (0)" ;
label var discwt                   "Weight to ED Visits in AHA universe" ;
label var disp_ed                  "Disposition of patient (uniform) from ED" ;
label var dqtr                     "Discharge quarter" ;
label var dx1                      "Diagnosis 1" ;
label var dx2                      "Diagnosis 2" ;
label var dx3                      "Diagnosis 3" ;
label var dx4                      "Diagnosis 4" ;
label var dx5                      "Diagnosis 5" ;
label var dx6                      "Diagnosis 6" ;
label var dx7                      "Diagnosis 7" ;
label var dx8                      "Diagnosis 8" ;
label var dx9                      "Diagnosis 9" ;
label var dx10                     "Diagnosis 10" ;
label var dx11                     "Diagnosis 11" ;
label var dx12                     "Diagnosis 12" ;
label var dx13                     "Diagnosis 13" ;
label var dx14                     "Diagnosis 14" ;
label var dx15                     "Diagnosis 15" ;
label var dxccs1                   "CCS: diagnosis 1" ;
label var dxccs2                   "CCS: diagnosis 2" ;
label var dxccs3                   "CCS: diagnosis 3" ;
label var dxccs4                   "CCS: diagnosis 4" ;
label var dxccs5                   "CCS: diagnosis 5" ;
label var dxccs6                   "CCS: diagnosis 6" ;
label var dxccs7                   "CCS: diagnosis 7" ;
label var dxccs8                   "CCS: diagnosis 8" ;
label var dxccs9                   "CCS: diagnosis 9" ;
label var dxccs10                  "CCS: diagnosis 10" ;
label var dxccs11                  "CCS: diagnosis 11" ;
label var dxccs12                  "CCS: diagnosis 12" ;
label var dxccs13                  "CCS: diagnosis 13" ;
label var dxccs14                  "CCS: diagnosis 14" ;
label var dxccs15                  "CCS: diagnosis 15" ;
label var ecode1                   "E code 1" ;
label var ecode2                   "E code 2" ;
label var ecode3                   "E code 3" ;
label var ecode4                   "E code 4" ;
label var edevent                  "Type of ED Event" ;
label var e_ccs1                   "CCS: E Code 1" ;
label var e_ccs2                   "CCS: E Code 2" ;
label var e_ccs3                   "CCS: E Code 3" ;
label var e_ccs4                   "CCS: E Code 4" ;
label var female                   "Indicator of sex" ;
label var hcupfile                 "Source of HCUP Record (SID or SEDD)" ;
label var hosp_ed                  "HCUP ED hospital identifier" ;
label var injury                   "Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)" ;
label var injury_cut               "Injury by cutting or piercing (by E codes)" ;
label var injury_drown             "Injury by drowning or submersion (by E codes)" ;
label var injury_fall              "Injury by falling (by E codes)" ;
label var injury_fire              "Injury by fire, flame or hot object (by E codes)" ;
label var injury_firearm           "Injury by firearm (by E codes)" ;
label var injury_machinery         "Injury by machinery (by E codes)" ;
label var injury_mvt               "Injury involving motor vehicle traffic (by E codes)" ;
label var injury_nature            "Injury involving nature or environmental factors (by E codes)" ;
label var injury_poison            "Injury by poison (by E codes)" ;
label var injury_severity          "Injury severity score assigned by ICDPIC Stata program" ;
label var injury_struck            "Injury from being struck by or against (by E codes)" ;
label var injury_suffocation       "Injury by suffocation (by E codes)" ;
label var intent_assault           "Injury by assault indicated on the record (by E codes)" ;
label var intent_self_harm         "Intentional self harm indicated on the record (by diagnosis and/or E codes)" ;
label var intent_unintentional     "Unintentional injury indicated on the record (by E codes)" ;
label var key_ed                   "HCUP NEDS record identifier" ;
label var multinjury               "More than one injury diagnosis reported on record" ;
label var ndx                      "Number of diagnoses on this record" ;
label var necode                   "Number of E codes on this record" ;
label var neds_stratum             "Stratum used to sample hospital" ;
label var pay1                     "Primary expected payer (uniform)" ;
label var pay2                     "Secondary expected payer (uniform)" ;
label var pl_nchs2006              "Patient Location: NCHS Urban-Rural Code (V2006)" ;
label var totchg_ed                "Total charge for ED services" ;
label var year                     "Calendar year" ;
label var zipinc_qrtl              "Median household income national quartile for patient ZIP Code" ;

/* Convert special values to missing values */
recode age                       (-99 -88 -66=.) ;
recode amonth                    (-9 -8 -6 -5=.) ;
recode aweekend                  (-9 -8 -6 -5=.) ;
recode chron1                    (-99 -88 -66=.) ;
recode chron2                    (-99 -88 -66=.) ;
recode chron3                    (-99 -88 -66=.) ;
recode chron4                    (-99 -88 -66=.) ;
recode chron5                    (-99 -88 -66=.) ;
recode chron6                    (-99 -88 -66=.) ;
recode chron7                    (-99 -88 -66=.) ;
recode chron8                    (-99 -88 -66=.) ;
recode chron9                    (-99 -88 -66=.) ;
recode chron10                   (-99 -88 -66=.) ;
recode chron11                   (-99 -88 -66=.) ;
recode chron12                   (-99 -88 -66=.) ;
recode chron13                   (-99 -88 -66=.) ;
recode chron14                   (-99 -88 -66=.) ;
recode chron15                   (-99 -88 -66=.) ;
recode died_visit                (-9 -8 -6 -5=.) ;
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.) ;
recode disp_ed                   (-9 -8 -6 -5=.) ;
recode dqtr                      (-9 -8 -6 -5=.) ;
recode dxccs1                    (-99 -88 -66=.) ;
recode dxccs2                    (-99 -88 -66=.) ;
recode dxccs3                    (-99 -88 -66=.) ;
recode dxccs4                    (-99 -88 -66=.) ;
recode dxccs5                    (-99 -88 -66=.) ;
recode dxccs6                    (-99 -88 -66=.) ;
recode dxccs7                    (-99 -88 -66=.) ;
recode dxccs8                    (-99 -88 -66=.) ;
recode dxccs9                    (-99 -88 -66=.) ;
recode dxccs10                   (-99 -88 -66=.) ;
recode dxccs11                   (-99 -88 -66=.) ;
recode dxccs12                   (-99 -88 -66=.) ;
recode dxccs13                   (-99 -88 -66=.) ;
recode dxccs14                   (-99 -88 -66=.) ;
recode dxccs15                   (-99 -88 -66=.) ;
recode edevent                   (-9 -8 -6 -5=.) ;
recode e_ccs1                    (-999 -888 -666=.) ;
recode e_ccs2                    (-999 -888 -666=.) ;
recode e_ccs3                    (-999 -888 -666=.) ;
recode e_ccs4                    (-999 -888 -666=.) ;
recode female                    (-9 -8 -6 -5=.) ;
recode hosp_ed                   (-9999 -8888 -6666=.) ;
recode injury                    (-9 -8 -6 -5=.) ;
recode injury_cut                (-9 -8 -6 -5=.) ;
recode injury_drown              (-9 -8 -6 -5=.) ;
recode injury_fall               (-9 -8 -6 -5=.) ;
recode injury_fire               (-9 -8 -6 -5=.) ;
recode injury_firearm            (-9 -8 -6 -5=.) ;
recode injury_machinery          (-9 -8 -6 -5=.) ;
recode injury_mvt                (-9 -8 -6 -5=.) ;
recode injury_nature             (-9 -8 -6 -5=.) ;
recode injury_poison             (-9 -8 -6 -5=.) ;
recode injury_severity           (-9 -8 -6 -5=.) ;
recode injury_struck             (-9 -8 -6 -5=.) ;
recode injury_suffocation        (-9 -8 -6 -5=.) ;
recode intent_assault            (-9 -8 -6 -5=.) ;
recode intent_self_harm          (-9 -8 -6 -5=.) ;
recode intent_unintentional      (-9 -8 -6 -5=.) ;
recode key_ed                    (-999999999999999 -888888888888888 -666666666666666=.) ;
recode multinjury                (-9 -8 -6 -5=.) ;
recode ndx                       (-99 -88 -66=.) ;
recode necode                    (-99 -88 -66=.) ;
recode neds_stratum              (-9999 -8888 -6666=.) ;
recode pay1                      (-9 -8 -6 -5=.) ;
recode pay2                      (-9 -8 -6 -5=.) ;
recode pl_nchs2006               (-99 -88 -66=.) ;
recode totchg_ed                 (-99999999.99 -88888888.88 -66666666.66=.) ;
recode year                      (-999 -888 -666=.) ;
recode zipinc_qrtl               (-9 -8 -6 -5=.) ;

describe;

save "NEDS_2011_Core.dta", replace;
#delimit cr
