/*****************************************************************************
* Stataload_NEDS_2006_ED.Do
* This program will load the 2006 NEDS CSV ED File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 1100m

*** Read data elements from the csv file ***
insheet      DISCWT                              ///
             HCUPFILE                            ///
             HOSP_ED                             ///
             KEY_ED                              ///
             CPT1                                ///
             CPT2                                ///
             CPT3                                ///
             CPT4                                ///
             CPT5                                ///
             CPT6                                ///
             CPT7                                ///
             CPT8                                ///
             CPT9                                ///
             CPT10                               ///
             CPT11                               ///
             CPT12                               ///
             CPT13                               ///
             CPT14                               ///
             CPT15                               ///
             NCPT                                ///
             NPR_ED                              ///
             PCLS_ED1                            ///
             PCLS_ED2                            ///
             PCLS_ED3                            ///
             PCLS_ED4                            ///
             PCLS_ED5                            ///
             PCLS_ED6                            ///
             PCLS_ED7                            ///
             PCLS_ED8                            ///
             PCLS_ED9                            ///
             PR_ED1                              ///
             PR_ED2                              ///
             PR_ED3                              ///
             PR_ED4                              ///
             PR_ED5                              ///
             PR_ED6                              ///
             PR_ED7                              ///
             PR_ED8                              ///
             PR_ED9                              ///
             PRCCSED1                            ///
             PRCCSED2                            ///
             PRCCSED3                            ///
             PRCCSED4                            ///
             PRCCSED5                            ///
             PRCCSED6                            ///
             PRCCSED7                            ///
             PRCCSED8                            ///
             PRCCSED9                            ///
      using  "NEDS_2006_ED.csv"

***  Assign labels to the data elements ***
label var discwt                   "Weight to ED Visits in AHA universe"
label var hcupfile                 "Source of HCUP Record (SID or SEDD)"
label var hosp_ed                  "HCUP ED hospital identifier"
label var key_ed                   "HCUP NEDS record identifier"
label var cpt1                     "CPT/HCPCS procedure code 1"
label var cpt2                     "CPT/HCPCS procedure code 2"
label var cpt3                     "CPT/HCPCS procedure code 3"
label var cpt4                     "CPT/HCPCS procedure code 4"
label var cpt5                     "CPT/HCPCS procedure code 5"
label var cpt6                     "CPT/HCPCS procedure code 6"
label var cpt7                     "CPT/HCPCS procedure code 7"
label var cpt8                     "CPT/HCPCS procedure code 8"
label var cpt9                     "CPT/HCPCS procedure code 9"
label var cpt10                    "CPT/HCPCS procedure code 10"
label var cpt11                    "CPT/HCPCS procedure code 11"
label var cpt12                    "CPT/HCPCS procedure code 12"
label var cpt13                    "CPT/HCPCS procedure code 13"
label var cpt14                    "CPT/HCPCS procedure code 14"
label var cpt15                    "CPT/HCPCS procedure code 15"
label var ncpt                     "Number of CPT/HCPCS procedures on this record"
label var npr_ed                   "Number of procedures from ED"
label var pcls_ed1                 "Principal procedure class for ED procedure"
label var pcls_ed2                 "Procedure class 2 for ED procedure"
label var pcls_ed3                 "Procedure class 3 for ED procedure"
label var pcls_ed4                 "Procedure class 4 for ED procedure"
label var pcls_ed5                 "Procedure class 5 for ED procedure"
label var pcls_ed6                 "Procedure class 6 for ED procedure"
label var pcls_ed7                 "Procedure class 7 for ED procedure"
label var pcls_ed8                 "Procedure class 8 for ED procedure"
label var pcls_ed9                 "Procedure class 9 for ED procedure"
label var pr_ed1                   "Principal procedure from ED"
label var pr_ed2                   "Procedure 2 from ED"
label var pr_ed3                   "Procedure 3 from ED"
label var pr_ed4                   "Procedure 4 from ED"
label var pr_ed5                   "Procedure 5 from ED"
label var pr_ed6                   "Procedure 6 from ED"
label var pr_ed7                   "Procedure 7 from ED"
label var pr_ed8                   "Procedure 8 from ED"
label var pr_ed9                   "Procedure 9 from ED"
label var prccsed1                 "CCS: principal procedure from ED"
label var prccsed2                 "CCS: procedure 2 from ED"
label var prccsed3                 "CCS: procedure 3 from ED"
label var prccsed4                 "CCS: procedure 4 from ED"
label var prccsed5                 "CCS: procedure 5 from ED"
label var prccsed6                 "CCS: procedure 6 from ED"
label var prccsed7                 "CCS: procedure 7 from ED"
label var prccsed8                 "CCS: procedure 8 from ED"
label var prccsed9                 "CCS: procedure 9 from ED"

*** Convert special values to missing values ***
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.)
recode hosp_ed                   (-9999 -8888 -6666=.)
recode key_ed                    (-999999999999999 -888888888888888 -666666666666666=.)
recode ncpt                      (-9 -8 -6 -5=.)
recode npr_ed                    (-9 -8 -6 -5=.)
recode pcls_ed1                  (-99 -88 -66=.)
recode pcls_ed2                  (-99 -88 -66=.)
recode pcls_ed3                  (-99 -88 -66=.)
recode pcls_ed4                  (-99 -88 -66=.)
recode pcls_ed5                  (-99 -88 -66=.)
recode pcls_ed6                  (-99 -88 -66=.)
recode pcls_ed7                  (-99 -88 -66=.)
recode pcls_ed8                  (-99 -88 -66=.)
recode pcls_ed9                  (-99 -88 -66=.)
recode prccsed1                  (-99 -88 -66=.)
recode prccsed2                  (-99 -88 -66=.)
recode prccsed3                  (-99 -88 -66=.)
recode prccsed4                  (-99 -88 -66=.)
recode prccsed5                  (-99 -88 -66=.)
recode prccsed6                  (-99 -88 -66=.)
recode prccsed7                  (-99 -88 -66=.)
recode prccsed8                  (-99 -88 -66=.)
recode prccsed9                  (-99 -88 -66=.)

save "NEDS_2006_ED.dta", replace
