/*****************************************************************************/
/* SPSSload_NEDS_2023_HOSPITAL.SPS                                          */
/* This program will load the NEDS 2023 HOSPITAL csv File into SPSS.         */
/* created on 12/23/2025.                                    */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NEDS_2023_HOSPITAL.csv"
    /delimiters = ',' 
    /variables = 
    HOSP_ED                  F5.0
    NEDS_STRATUM             F5.0
    DISCWT                   F11.7
    HOSPWT                   F11.7
    HOSP_CONTROL             F2.0
    HOSP_TRAUMA              F2.0
    HOSP_URCAT4              F2.0
    HOSP_UR_TEACH            F2.0
    N_DISC_U                 F8.0
    N_HOSP_U                 F4.0
    S_DISC_U                 F8.0
    S_HOSP_U                 F4.0
    TOTAL_EDVisits           F8.0
    YEAR                     F4.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    HOSP_ED                  "NEDS Hospital Number"
    NEDS_STRATUM             "NEDS Hospital Stratum Number"
    DISCWT                   "Weight to ED Visits in AHA universe"
    HOSPWT                   "Weight to hospitals in AHA universe"
    HOSP_CONTROL             "Control/ownership of hospital (original)"
    HOSP_TRAUMA              "Trauma level designation (original)"
    HOSP_URCAT4              "Hospital urban-rural designation (original)"
    HOSP_UR_TEACH            "Teaching status and urban/rural designation of hospital (original)"
    N_DISC_U                 "Number of AHA universe ED visits in NEDS_STRATUM"
    N_HOSP_U                 "Number of AHA universe hospitals in NEDS_STRATUM"
    S_DISC_U                 "Number of sample discharges in NEDS_STRATUM"
    S_HOSP_U                 "Number of sample hospitals in NEDS_STRATUM"
    TOTAL_EDVisits           "Total number of ED visits from this hospital in the NEDS"
    YEAR                     "Calendar Year" .

/* Convert special values to system missing values */
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE NEDS_STRATUM             (-9999 -8888 -6666=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE HOSPWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE HOSP_CONTROL             (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_TRAUMA              (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_URCAT4              (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_UR_TEACH            (-9 -8 -6 -5=SYSMIS).
RECODE N_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE N_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE S_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE S_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE TOTAL_EDVisits           (-9999999 -8888888 -6666666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).

SAVE OUTFILE = 'NEDS_2023_HOSPITAL.SAV' / COMPRESSED.
