/*****************************************************************************/
/* SPSSload_NEDS_2015Q4_IP.SPS                                          */
/* This program will load the NEDS 2015 Q4 IP csv File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NEDS_2015Q4_IP.csv"
    /delimiters = ',' 
    /variables = 
    DISP_IP                  F2.0
    DRG                      F3.0
    DRGVER                   F2.0
    DRG_NOPOA                F3.0
    DXVER                    F2.0
    HCUPFILE                 A4
    HOSP_ED                  F5.0
    I10_DX1                  A7
    I10_DX2                  A7
    I10_DX3                  A7
    I10_DX4                  A7
    I10_DX5                  A7
    I10_DX6                  A7
    I10_DX7                  A7
    I10_DX8                  A7
    I10_DX9                  A7
    I10_DX10                 A7
    I10_DX11                 A7
    I10_DX12                 A7
    I10_DX13                 A7
    I10_DX14                 A7
    I10_DX15                 A7
    I10_DX16                 A7
    I10_DX17                 A7
    I10_DX18                 A7
    I10_DX19                 A7
    I10_DX20                 A7
    I10_DX21                 A7
    I10_DX22                 A7
    I10_DX23                 A7
    I10_DX24                 A7
    I10_DX25                 A7
    I10_DX26                 A7
    I10_DX27                 A7
    I10_DX28                 A7
    I10_DX29                 A7
    I10_DX30                 A7
    I10_ECAUSE1              A7
    I10_ECAUSE2              A7
    I10_ECAUSE3              A7
    I10_ECAUSE4              A7
    I10_NDX                  F3.0
    I10_NECAUSE              F3.0
    I10_NPR_IP               F3.0
    I10_PR_IP1               A7
    I10_PR_IP2               A7
    I10_PR_IP3               A7
    I10_PR_IP4               A7
    I10_PR_IP5               A7
    I10_PR_IP6               A7
    I10_PR_IP7               A7
    I10_PR_IP8               A7
    I10_PR_IP9               A7
    KEY_ED                   F16.0
    LOS_IP                   F5.0
    MDC                      F2.0
    MDC_NOPOA                F2.0
    PRVER                    F2.0
    TOTCHG_IP                F12.2
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    DISP_IP                  "Disposition of patient (uniform) from IP"
    DRG                      "DRG in effect on discharge date"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NOPOA                "DRG in use on discharge date, calculated without POA"
    DXVER                    "Diagnosis Version"
    HCUPFILE                 "Source of HCUP Record (SID or SEDD)"
    HOSP_ED                  "HCUP ED hospital identifier"
    I10_DX1                  "ICD-10-CM Diagnosis 1"
    I10_DX2                  "ICD-10-CM Diagnosis 2"
    I10_DX3                  "ICD-10-CM Diagnosis 3"
    I10_DX4                  "ICD-10-CM Diagnosis 4"
    I10_DX5                  "ICD-10-CM Diagnosis 5"
    I10_DX6                  "ICD-10-CM Diagnosis 6"
    I10_DX7                  "ICD-10-CM Diagnosis 7"
    I10_DX8                  "ICD-10-CM Diagnosis 8"
    I10_DX9                  "ICD-10-CM Diagnosis 9"
    I10_DX10                 "ICD-10-CM Diagnosis 10"
    I10_DX11                 "ICD-10-CM Diagnosis 11"
    I10_DX12                 "ICD-10-CM Diagnosis 12"
    I10_DX13                 "ICD-10-CM Diagnosis 13"
    I10_DX14                 "ICD-10-CM Diagnosis 14"
    I10_DX15                 "ICD-10-CM Diagnosis 15"
    I10_DX16                 "ICD-10-CM Diagnosis 16"
    I10_DX17                 "ICD-10-CM Diagnosis 17"
    I10_DX18                 "ICD-10-CM Diagnosis 18"
    I10_DX19                 "ICD-10-CM Diagnosis 19"
    I10_DX20                 "ICD-10-CM Diagnosis 20"
    I10_DX21                 "ICD-10-CM Diagnosis 21"
    I10_DX22                 "ICD-10-CM Diagnosis 22"
    I10_DX23                 "ICD-10-CM Diagnosis 23"
    I10_DX24                 "ICD-10-CM Diagnosis 24"
    I10_DX25                 "ICD-10-CM Diagnosis 25"
    I10_DX26                 "ICD-10-CM Diagnosis 26"
    I10_DX27                 "ICD-10-CM Diagnosis 27"
    I10_DX28                 "ICD-10-CM Diagnosis 28"
    I10_DX29                 "ICD-10-CM Diagnosis 29"
    I10_DX30                 "ICD-10-CM Diagnosis 30"
    I10_ECAUSE1              "ICD-10-CM External cause 1"
    I10_ECAUSE2              "ICD-10-CM External cause 2"
    I10_ECAUSE3              "ICD-10-CM External cause 3"
    I10_ECAUSE4              "ICD-10-CM External cause 4"
    I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
    I10_NECAUSE              "ICD-10-CM Number of external cause codes on this record"
    I10_NPR_IP               "ICD-10-PCS Number of procedures on this record"
    I10_PR_IP1               "ICD-10-PCS Principal procedure from inpatient discharge record"
    I10_PR_IP2               "ICD-10-PCS Procedure 2 from inpatient discharge record"
    I10_PR_IP3               "ICD-10-PCS Procedure 3 from inpatient discharge record"
    I10_PR_IP4               "ICD-10-PCS Procedure 4 from inpatient discharge record"
    I10_PR_IP5               "ICD-10-PCS Procedure 5 from inpatient discharge record"
    I10_PR_IP6               "ICD-10-PCS Procedure 6 from inpatient discharge record"
    I10_PR_IP7               "ICD-10-PCS Procedure 7 from inpatient discharge record"
    I10_PR_IP8               "ICD-10-PCS Procedure 8 from inpatient discharge record"
    I10_PR_IP9               "ICD-10-PCS Procedure 9 from inpatient discharge record"
    KEY_ED                   "HCUP NEDS record identifier"
    LOS_IP                   "Length of stay (cleaned) from IP"
    MDC                      "MDC in effect on discharge date"
    MDC_NOPOA                "MDC in use on discharge date, calculated without POA"
    PRVER                    "Procedure Version"
    TOTCHG_IP                "Total charge for ED and inpatient services" .

/* Convert special values to system missing values */
RECODE DISP_IP                  (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NOPOA                (-99 -88 -66=SYSMIS).
RECODE DXVER                    (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE I10_NDX                  (-99 -88 -66=SYSMIS).
RECODE I10_NECAUSE              (-99 -88 -66=SYSMIS).
RECODE I10_NPR_IP               (-99 -88 -66=SYSMIS).
RECODE KEY_ED                   (-999999999999999 -888888888888888 -666666666666666=SYSMIS).
RECODE LOS_IP                   (-9999 -8888 -6666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NOPOA                (-9 -8 -6 -5=SYSMIS).
RECODE PRVER                    (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG_IP                (-99999999.99 -88888888.88 -66666666.66=SYSMIS).

SAVE OUTFILE = 'NEDS_2015Q4_IP.SAV' / COMPRESSED.
