/*****************************************************************************
* SPSSload_NEDS_2007_Hospital.SPS
* This program will load the 2007 NEDS csv Hospital File into SPSS.
*****************************************************************************/

*** Read data elements from the csv file ***.
get data /type = txt
    /file = "NEDS_2007_Hospital.csv"
    /delimiters = ',' 
    /variables = 
    DISCWT                   F11.7
    HOSPWT                   F11.7
    CONTROL                  F2.0
    HOSP_ED                  F5.0
    REGION                   F2.0
    TRAUMA                   F2.0
    URCAT4                   F2.0
    UR_TEACH                 F2.0
    NEDS_STR                 F5.0
    N_DISC_U                 F8.0
    N_HOSP_U                 F4.0
    S_DISC_U                 F8.0
    S_HOSP_U                 F6.0
    EDVISITS                 F8.0
    YEAR                     F4.0
.

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    DISCWT                   "Weight to ED Visits in AHA universe"
    HOSPWT                   "Weight to hospitals in AHA universe"
    CONTROL                  "Control/ownership of hospital"
    HOSP_ED                  "HCUP ED hospital identifier"
    REGION                   "Region of hospital"
    TRAUMA                   "Trauma level designation"
    URCAT4                   "Hospital urban-rural designation"
    UR_TEACH                 "Teaching status of hospital"
    NEDS_STR                 "Stratum used to sample hospital"
    N_DISC_U                 "Number of AHA universe ED visits in NEDS_STRATUM"
    N_HOSP_U                 "Number of AHA universe hospitals in NEDS_STRATUM"
    S_DISC_U                 "Number of sample discharges in NEDS_STRATUM"
    S_HOSP_U                 "Number of sample hospitals in NEDS_STRATUM"
    EDVISITS                 "Total number of ED visits from this hospital in the NEDS"
    YEAR                     "Calendar Year" .

*** Convert special values to system missing values ***.
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE HOSPWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE CONTROL                  (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE REGION                   (-9 -8 -6 -5=SYSMIS).
RECODE TRAUMA                   (-9 -8 -6 -5=SYSMIS).
RECODE URCAT4                   (-9 -8 -6 -5=SYSMIS).
RECODE UR_TEACH                 (-9 -8 -6 -5=SYSMIS).
RECODE NEDS_STR                 (-9999 -8888 -6666=SYSMIS).
RECODE N_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE N_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE S_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE S_HOSP_U                 (-99999 -88888 -66666=SYSMIS).
RECODE EDVISITS                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).

SAVE OUTFILE = 'NEDS_2007_Hospital.SAV' / COMPRESSED.
