/*****************************************************************************
 * Stataload_NASS_2020_Supplemental.Do
 * This program will load the NASS 2020 Supplemental csv File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NASS_2020_Supplemental.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      long   hosp_nass
      long   key_nass
      int    year
      int    ncpt_notinscope
      int    supcptccs1
      int    supcptccs2
      int    supcptccs3
      int    supcptccs4
      int    supcptccs5
      int    supcptccs6
      int    supcptccs7
      int    supcptccs8
      int    supcptccs9
      int    supcptccs10
      int    supcptccs11
      int    supcptccs12
      int    supcptccs13
      int    supcptccs14
      int    supcptccs15
      int    supcptccs16
      int    supcptccs17
      int    supcptccs18
      int    supcptccs19
      int    supcptccs20
      int    supcptccs21
      int    supcptccs22
      int    supcptccs23
      int    supcptccs24
      int    supcptccs25
      int    supcptccs26
      int    supcptccs27
      int    supcptccs28
      int    supcptccs29
      int    supcptccs30
      str5   supcpt1
      str5   supcpt2
      str5   supcpt3
      str5   supcpt4
      str5   supcpt5
      str5   supcpt6
      str5   supcpt7
      str5   supcpt8
      str5   supcpt9
      str5   supcpt10
      str5   supcpt11
      str5   supcpt12
      str5   supcpt13
      str5   supcpt14
      str5   supcpt15
      str5   supcpt16
      str5   supcpt17
      str5   supcpt18
      str5   supcpt19
      str5   supcpt20
      str5   supcpt21
      str5   supcpt22
      str5   supcpt23
      str5   supcpt24
      str5   supcpt25
      str5   supcpt26
      str5   supcpt27
      str5   supcpt28
      str5   supcpt29
      str5   supcpt30
using NASS_2020_Supplemental.csv;

/*  Assign labels to the data elements */
label var hosp_nass                "NASS Hospital Number" ;
label var key_nass                 "NASS record number" ;
label var year                     "Data Year" ;
label var ncpt_notinscope          "# Out-of-scope CPTs for this encounter" ;
label var supcptccs1               "CPT 1 Procedure CCS" ;
label var supcptccs2               "CPT 2 Procedure CCS" ;
label var supcptccs3               "CPT 3 Procedure CCS" ;
label var supcptccs4               "CPT 4 Procedure CCS" ;
label var supcptccs5               "CPT 5 Procedure CCS" ;
label var supcptccs6               "CPT 6 Procedure CCS" ;
label var supcptccs7               "CPT 7 Procedure CCS" ;
label var supcptccs8               "CPT 8 Procedure CCS" ;
label var supcptccs9               "CPT 9 Procedure CCS" ;
label var supcptccs10              "CPT 10 Procedure CCS" ;
label var supcptccs11              "CPT 11 Procedure CCS" ;
label var supcptccs12              "CPT 12 Procedure CCS" ;
label var supcptccs13              "CPT 13 Procedure CCS" ;
label var supcptccs14              "CPT 14 Procedure CCS" ;
label var supcptccs15              "CPT 15 Procedure CCS" ;
label var supcptccs16              "CPT 16 Procedure CCS" ;
label var supcptccs17              "CPT 17 Procedure CCS" ;
label var supcptccs18              "CPT 18 Procedure CCS" ;
label var supcptccs19              "CPT 19 Procedure CCS" ;
label var supcptccs20              "CPT 20 Procedure CCS" ;
label var supcptccs21              "CPT 21 Procedure CCS" ;
label var supcptccs22              "CPT 22 Procedure CCS" ;
label var supcptccs23              "CPT 23 Procedure CCS" ;
label var supcptccs24              "CPT 24 Procedure CCS" ;
label var supcptccs25              "CPT 25 Procedure CCS" ;
label var supcptccs26              "CPT 26 Procedure CCS" ;
label var supcptccs27              "CPT 27 Procedure CCS" ;
label var supcptccs28              "CPT 28 Procedure CCS" ;
label var supcptccs29              "CPT 29 Procedure CCS" ;
label var supcptccs30              "CPT 30 Procedure CCS" ;
label var supcpt1                  "CPT Procedure 1" ;
label var supcpt2                  "CPT Procedure 2" ;
label var supcpt3                  "CPT Procedure 3" ;
label var supcpt4                  "CPT Procedure 4" ;
label var supcpt5                  "CPT Procedure 5" ;
label var supcpt6                  "CPT Procedure 6" ;
label var supcpt7                  "CPT Procedure 7" ;
label var supcpt8                  "CPT Procedure 8" ;
label var supcpt9                  "CPT Procedure 9" ;
label var supcpt10                 "CPT Procedure 10" ;
label var supcpt11                 "CPT Procedure 11" ;
label var supcpt12                 "CPT Procedure 12" ;
label var supcpt13                 "CPT Procedure 13" ;
label var supcpt14                 "CPT Procedure 14" ;
label var supcpt15                 "CPT Procedure 15" ;
label var supcpt16                 "CPT Procedure 16" ;
label var supcpt17                 "CPT Procedure 17" ;
label var supcpt18                 "CPT Procedure 18" ;
label var supcpt19                 "CPT Procedure 19" ;
label var supcpt20                 "CPT Procedure 20" ;
label var supcpt21                 "CPT Procedure 21" ;
label var supcpt22                 "CPT Procedure 22" ;
label var supcpt23                 "CPT Procedure 23" ;
label var supcpt24                 "CPT Procedure 24" ;
label var supcpt25                 "CPT Procedure 25" ;
label var supcpt26                 "CPT Procedure 26" ;
label var supcpt27                 "CPT Procedure 27" ;
label var supcpt28                 "CPT Procedure 28" ;
label var supcpt29                 "CPT Procedure 29" ;
label var supcpt30                 "CPT Procedure 30" ;

/* Convert special values to missing values */
recode hosp_nass                 (-9999 -8888 -6666=.) ;
recode key_nass                  (-9999999 -8888888 -6666666=.) ;
recode year                      (-999 -888 -666=.) ;
recode ncpt_notinscope           (-99 -88 -66=.) ;
recode supcptccs1                (-999 -888 -666=.) ;
recode supcptccs2                (-999 -888 -666=.) ;
recode supcptccs3                (-999 -888 -666=.) ;
recode supcptccs4                (-999 -888 -666=.) ;
recode supcptccs5                (-999 -888 -666=.) ;
recode supcptccs6                (-999 -888 -666=.) ;
recode supcptccs7                (-999 -888 -666=.) ;
recode supcptccs8                (-999 -888 -666=.) ;
recode supcptccs9                (-999 -888 -666=.) ;
recode supcptccs10               (-999 -888 -666=.) ;
recode supcptccs11               (-999 -888 -666=.) ;
recode supcptccs12               (-999 -888 -666=.) ;
recode supcptccs13               (-999 -888 -666=.) ;
recode supcptccs14               (-999 -888 -666=.) ;
recode supcptccs15               (-999 -888 -666=.) ;
recode supcptccs16               (-999 -888 -666=.) ;
recode supcptccs17               (-999 -888 -666=.) ;
recode supcptccs18               (-999 -888 -666=.) ;
recode supcptccs19               (-999 -888 -666=.) ;
recode supcptccs20               (-999 -888 -666=.) ;
recode supcptccs21               (-999 -888 -666=.) ;
recode supcptccs22               (-999 -888 -666=.) ;
recode supcptccs23               (-999 -888 -666=.) ;
recode supcptccs24               (-999 -888 -666=.) ;
recode supcptccs25               (-999 -888 -666=.) ;
recode supcptccs26               (-999 -888 -666=.) ;
recode supcptccs27               (-999 -888 -666=.) ;
recode supcptccs28               (-999 -888 -666=.) ;
recode supcptccs29               (-999 -888 -666=.) ;
recode supcptccs30               (-999 -888 -666=.) ;

describe;

save "NASS_2020_Supplemental.dta", replace;
#delimit cr
