/*****************************************************************************
 * Stataload_NASS_2021_DX_PR_GRPS.Do
 * This program will load the NASS 2021 DX PR GRPS csv File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NASS_2021_DX_PR_GRPS.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      long   hosp_nass
      long   key_nass
      str6   dxccsr_default_dx1
      int    dxccsr_bld001
      int    dxccsr_bld002
      int    dxccsr_bld003
      int    dxccsr_bld004
      int    dxccsr_bld005
      int    dxccsr_bld006
      int    dxccsr_bld007
      int    dxccsr_bld008
      int    dxccsr_bld009
      int    dxccsr_bld010
      int    dxccsr_cir001
      int    dxccsr_cir002
      int    dxccsr_cir003
      int    dxccsr_cir004
      int    dxccsr_cir005
      int    dxccsr_cir006
      int    dxccsr_cir007
      int    dxccsr_cir008
      int    dxccsr_cir009
      int    dxccsr_cir010
      int    dxccsr_cir011
      int    dxccsr_cir012
      int    dxccsr_cir013
      int    dxccsr_cir014
      int    dxccsr_cir015
      int    dxccsr_cir016
      int    dxccsr_cir017
      int    dxccsr_cir018
      int    dxccsr_cir019
      int    dxccsr_cir020
      int    dxccsr_cir021
      int    dxccsr_cir022
      int    dxccsr_cir023
      int    dxccsr_cir024
      int    dxccsr_cir025
      int    dxccsr_cir026
      int    dxccsr_cir027
      int    dxccsr_cir028
      int    dxccsr_cir029
      int    dxccsr_cir030
      int    dxccsr_cir031
      int    dxccsr_cir032
      int    dxccsr_cir033
      int    dxccsr_cir034
      int    dxccsr_cir035
      int    dxccsr_cir036
      int    dxccsr_cir037
      int    dxccsr_cir038
      int    dxccsr_cir039
      int    dxccsr_den001
      int    dxccsr_den002
      int    dxccsr_den003
      int    dxccsr_dig001
      int    dxccsr_dig002
      int    dxccsr_dig003
      int    dxccsr_dig004
      int    dxccsr_dig005
      int    dxccsr_dig006
      int    dxccsr_dig007
      int    dxccsr_dig008
      int    dxccsr_dig009
      int    dxccsr_dig010
      int    dxccsr_dig011
      int    dxccsr_dig012
      int    dxccsr_dig013
      int    dxccsr_dig014
      int    dxccsr_dig015
      int    dxccsr_dig016
      int    dxccsr_dig017
      int    dxccsr_dig018
      int    dxccsr_dig019
      int    dxccsr_dig020
      int    dxccsr_dig021
      int    dxccsr_dig022
      int    dxccsr_dig023
      int    dxccsr_dig024
      int    dxccsr_dig025
      int    dxccsr_ear001
      int    dxccsr_ear002
      int    dxccsr_ear003
      int    dxccsr_ear004
      int    dxccsr_ear005
      int    dxccsr_ear006
      int    dxccsr_end001
      int    dxccsr_end002
      int    dxccsr_end003
      int    dxccsr_end004
      int    dxccsr_end005
      int    dxccsr_end006
      int    dxccsr_end007
      int    dxccsr_end008
      int    dxccsr_end009
      int    dxccsr_end010
      int    dxccsr_end011
      int    dxccsr_end012
      int    dxccsr_end013
      int    dxccsr_end014
      int    dxccsr_end015
      int    dxccsr_end016
      int    dxccsr_end017
      int    dxccsr_ext001
      int    dxccsr_ext002
      int    dxccsr_ext003
      int    dxccsr_ext004
      int    dxccsr_ext005
      int    dxccsr_ext006
      int    dxccsr_ext007
      int    dxccsr_ext008
      int    dxccsr_ext009
      int    dxccsr_ext010
      int    dxccsr_ext011
      int    dxccsr_ext012
      int    dxccsr_ext013
      int    dxccsr_ext014
      int    dxccsr_ext015
      int    dxccsr_ext016
      int    dxccsr_ext017
      int    dxccsr_ext018
      int    dxccsr_ext019
      int    dxccsr_ext020
      int    dxccsr_ext021
      int    dxccsr_ext022
      int    dxccsr_ext023
      int    dxccsr_ext024
      int    dxccsr_ext025
      int    dxccsr_ext026
      int    dxccsr_ext027
      int    dxccsr_ext028
      int    dxccsr_ext029
      int    dxccsr_ext030
      int    dxccsr_eye001
      int    dxccsr_eye002
      int    dxccsr_eye003
      int    dxccsr_eye004
      int    dxccsr_eye005
      int    dxccsr_eye006
      int    dxccsr_eye007
      int    dxccsr_eye008
      int    dxccsr_eye009
      int    dxccsr_eye010
      int    dxccsr_eye011
      int    dxccsr_eye012
      int    dxccsr_fac001
      int    dxccsr_fac002
      int    dxccsr_fac003
      int    dxccsr_fac004
      int    dxccsr_fac005
      int    dxccsr_fac006
      int    dxccsr_fac007
      int    dxccsr_fac008
      int    dxccsr_fac009
      int    dxccsr_fac010
      int    dxccsr_fac011
      int    dxccsr_fac012
      int    dxccsr_fac013
      int    dxccsr_fac014
      int    dxccsr_fac015
      int    dxccsr_fac016
      int    dxccsr_fac017
      int    dxccsr_fac018
      int    dxccsr_fac019
      int    dxccsr_fac020
      int    dxccsr_fac021
      int    dxccsr_fac022
      int    dxccsr_fac023
      int    dxccsr_fac024
      int    dxccsr_fac025
      int    dxccsr_gen001
      int    dxccsr_gen002
      int    dxccsr_gen003
      int    dxccsr_gen004
      int    dxccsr_gen005
      int    dxccsr_gen006
      int    dxccsr_gen007
      int    dxccsr_gen008
      int    dxccsr_gen009
      int    dxccsr_gen010
      int    dxccsr_gen011
      int    dxccsr_gen012
      int    dxccsr_gen013
      int    dxccsr_gen014
      int    dxccsr_gen015
      int    dxccsr_gen016
      int    dxccsr_gen017
      int    dxccsr_gen018
      int    dxccsr_gen019
      int    dxccsr_gen020
      int    dxccsr_gen021
      int    dxccsr_gen022
      int    dxccsr_gen023
      int    dxccsr_gen024
      int    dxccsr_gen025
      int    dxccsr_gen026
      int    dxccsr_inf001
      int    dxccsr_inf002
      int    dxccsr_inf003
      int    dxccsr_inf004
      int    dxccsr_inf005
      int    dxccsr_inf006
      int    dxccsr_inf007
      int    dxccsr_inf008
      int    dxccsr_inf009
      int    dxccsr_inf010
      int    dxccsr_inf011
      int    dxccsr_inf012
      int    dxccsr_inj001
      int    dxccsr_inj002
      int    dxccsr_inj003
      int    dxccsr_inj004
      int    dxccsr_inj005
      int    dxccsr_inj006
      int    dxccsr_inj007
      int    dxccsr_inj008
      int    dxccsr_inj009
      int    dxccsr_inj010
      int    dxccsr_inj011
      int    dxccsr_inj012
      int    dxccsr_inj013
      int    dxccsr_inj014
      int    dxccsr_inj015
      int    dxccsr_inj016
      int    dxccsr_inj017
      int    dxccsr_inj018
      int    dxccsr_inj019
      int    dxccsr_inj020
      int    dxccsr_inj021
      int    dxccsr_inj022
      int    dxccsr_inj023
      int    dxccsr_inj024
      int    dxccsr_inj025
      int    dxccsr_inj026
      int    dxccsr_inj027
      int    dxccsr_inj028
      int    dxccsr_inj029
      int    dxccsr_inj030
      int    dxccsr_inj031
      int    dxccsr_inj032
      int    dxccsr_inj033
      int    dxccsr_inj034
      int    dxccsr_inj035
      int    dxccsr_inj036
      int    dxccsr_inj037
      int    dxccsr_inj038
      int    dxccsr_inj039
      int    dxccsr_inj040
      int    dxccsr_inj041
      int    dxccsr_inj042
      int    dxccsr_inj043
      int    dxccsr_inj044
      int    dxccsr_inj045
      int    dxccsr_inj046
      int    dxccsr_inj047
      int    dxccsr_inj048
      int    dxccsr_inj049
      int    dxccsr_inj050
      int    dxccsr_inj051
      int    dxccsr_inj052
      int    dxccsr_inj053
      int    dxccsr_inj054
      int    dxccsr_inj055
      int    dxccsr_inj056
      int    dxccsr_inj057
      int    dxccsr_inj058
      int    dxccsr_inj059
      int    dxccsr_inj060
      int    dxccsr_inj061
      int    dxccsr_inj062
      int    dxccsr_inj063
      int    dxccsr_inj064
      int    dxccsr_inj065
      int    dxccsr_inj066
      int    dxccsr_inj067
      int    dxccsr_inj068
      int    dxccsr_inj069
      int    dxccsr_inj070
      int    dxccsr_inj071
      int    dxccsr_inj072
      int    dxccsr_inj073
      int    dxccsr_inj074
      int    dxccsr_inj075
      int    dxccsr_inj076
      int    dxccsr_mal001
      int    dxccsr_mal002
      int    dxccsr_mal003
      int    dxccsr_mal004
      int    dxccsr_mal005
      int    dxccsr_mal006
      int    dxccsr_mal007
      int    dxccsr_mal008
      int    dxccsr_mal009
      int    dxccsr_mal010
      int    dxccsr_mbd001
      int    dxccsr_mbd002
      int    dxccsr_mbd003
      int    dxccsr_mbd004
      int    dxccsr_mbd005
      int    dxccsr_mbd006
      int    dxccsr_mbd007
      int    dxccsr_mbd008
      int    dxccsr_mbd009
      int    dxccsr_mbd010
      int    dxccsr_mbd011
      int    dxccsr_mbd012
      int    dxccsr_mbd013
      int    dxccsr_mbd014
      int    dxccsr_mbd017
      int    dxccsr_mbd018
      int    dxccsr_mbd019
      int    dxccsr_mbd020
      int    dxccsr_mbd021
      int    dxccsr_mbd022
      int    dxccsr_mbd023
      int    dxccsr_mbd024
      int    dxccsr_mbd025
      int    dxccsr_mbd026
      int    dxccsr_mbd027
      int    dxccsr_mbd028
      int    dxccsr_mbd029
      int    dxccsr_mbd030
      int    dxccsr_mbd031
      int    dxccsr_mbd032
      int    dxccsr_mbd033
      int    dxccsr_mbd034
      int    dxccsr_mus001
      int    dxccsr_mus002
      int    dxccsr_mus003
      int    dxccsr_mus004
      int    dxccsr_mus005
      int    dxccsr_mus006
      int    dxccsr_mus007
      int    dxccsr_mus008
      int    dxccsr_mus009
      int    dxccsr_mus010
      int    dxccsr_mus011
      int    dxccsr_mus012
      int    dxccsr_mus013
      int    dxccsr_mus014
      int    dxccsr_mus015
      int    dxccsr_mus016
      int    dxccsr_mus017
      int    dxccsr_mus018
      int    dxccsr_mus019
      int    dxccsr_mus020
      int    dxccsr_mus021
      int    dxccsr_mus022
      int    dxccsr_mus023
      int    dxccsr_mus024
      int    dxccsr_mus025
      int    dxccsr_mus026
      int    dxccsr_mus027
      int    dxccsr_mus028
      int    dxccsr_mus029
      int    dxccsr_mus030
      int    dxccsr_mus031
      int    dxccsr_mus032
      int    dxccsr_mus033
      int    dxccsr_mus034
      int    dxccsr_mus035
      int    dxccsr_mus036
      int    dxccsr_mus037
      int    dxccsr_mus038
      int    dxccsr_neo001
      int    dxccsr_neo002
      int    dxccsr_neo003
      int    dxccsr_neo004
      int    dxccsr_neo005
      int    dxccsr_neo006
      int    dxccsr_neo007
      int    dxccsr_neo008
      int    dxccsr_neo009
      int    dxccsr_neo010
      int    dxccsr_neo011
      int    dxccsr_neo012
      int    dxccsr_neo013
      int    dxccsr_neo014
      int    dxccsr_neo015
      int    dxccsr_neo016
      int    dxccsr_neo017
      int    dxccsr_neo018
      int    dxccsr_neo019
      int    dxccsr_neo020
      int    dxccsr_neo021
      int    dxccsr_neo022
      int    dxccsr_neo023
      int    dxccsr_neo024
      int    dxccsr_neo025
      int    dxccsr_neo026
      int    dxccsr_neo027
      int    dxccsr_neo028
      int    dxccsr_neo029
      int    dxccsr_neo030
      int    dxccsr_neo031
      int    dxccsr_neo032
      int    dxccsr_neo033
      int    dxccsr_neo034
      int    dxccsr_neo035
      int    dxccsr_neo036
      int    dxccsr_neo037
      int    dxccsr_neo038
      int    dxccsr_neo039
      int    dxccsr_neo040
      int    dxccsr_neo041
      int    dxccsr_neo042
      int    dxccsr_neo043
      int    dxccsr_neo044
      int    dxccsr_neo045
      int    dxccsr_neo046
      int    dxccsr_neo047
      int    dxccsr_neo048
      int    dxccsr_neo049
      int    dxccsr_neo050
      int    dxccsr_neo051
      int    dxccsr_neo052
      int    dxccsr_neo053
      int    dxccsr_neo054
      int    dxccsr_neo055
      int    dxccsr_neo056
      int    dxccsr_neo057
      int    dxccsr_neo058
      int    dxccsr_neo059
      int    dxccsr_neo060
      int    dxccsr_neo061
      int    dxccsr_neo062
      int    dxccsr_neo063
      int    dxccsr_neo064
      int    dxccsr_neo065
      int    dxccsr_neo066
      int    dxccsr_neo067
      int    dxccsr_neo068
      int    dxccsr_neo069
      int    dxccsr_neo070
      int    dxccsr_neo071
      int    dxccsr_neo072
      int    dxccsr_neo073
      int    dxccsr_neo074
      int    dxccsr_nvs001
      int    dxccsr_nvs002
      int    dxccsr_nvs003
      int    dxccsr_nvs004
      int    dxccsr_nvs005
      int    dxccsr_nvs006
      int    dxccsr_nvs007
      int    dxccsr_nvs008
      int    dxccsr_nvs009
      int    dxccsr_nvs010
      int    dxccsr_nvs011
      int    dxccsr_nvs012
      int    dxccsr_nvs013
      int    dxccsr_nvs014
      int    dxccsr_nvs015
      int    dxccsr_nvs016
      int    dxccsr_nvs017
      int    dxccsr_nvs018
      int    dxccsr_nvs019
      int    dxccsr_nvs020
      int    dxccsr_nvs021
      int    dxccsr_nvs022
      int    dxccsr_pnl001
      int    dxccsr_pnl002
      int    dxccsr_pnl003
      int    dxccsr_pnl004
      int    dxccsr_pnl005
      int    dxccsr_pnl006
      int    dxccsr_pnl007
      int    dxccsr_pnl008
      int    dxccsr_pnl009
      int    dxccsr_pnl010
      int    dxccsr_pnl011
      int    dxccsr_pnl012
      int    dxccsr_pnl013
      int    dxccsr_pnl014
      int    dxccsr_pnl015
      int    dxccsr_prg001
      int    dxccsr_prg002
      int    dxccsr_prg003
      int    dxccsr_prg004
      int    dxccsr_prg005
      int    dxccsr_prg006
      int    dxccsr_prg007
      int    dxccsr_prg008
      int    dxccsr_prg009
      int    dxccsr_prg010
      int    dxccsr_prg011
      int    dxccsr_prg012
      int    dxccsr_prg013
      int    dxccsr_prg014
      int    dxccsr_prg015
      int    dxccsr_prg016
      int    dxccsr_prg017
      int    dxccsr_prg018
      int    dxccsr_prg019
      int    dxccsr_prg020
      int    dxccsr_prg021
      int    dxccsr_prg022
      int    dxccsr_prg023
      int    dxccsr_prg024
      int    dxccsr_prg025
      int    dxccsr_prg026
      int    dxccsr_prg027
      int    dxccsr_prg028
      int    dxccsr_prg029
      int    dxccsr_prg030
      int    dxccsr_rsp001
      int    dxccsr_rsp002
      int    dxccsr_rsp003
      int    dxccsr_rsp004
      int    dxccsr_rsp005
      int    dxccsr_rsp006
      int    dxccsr_rsp007
      int    dxccsr_rsp008
      int    dxccsr_rsp009
      int    dxccsr_rsp010
      int    dxccsr_rsp011
      int    dxccsr_rsp012
      int    dxccsr_rsp013
      int    dxccsr_rsp014
      int    dxccsr_rsp015
      int    dxccsr_rsp016
      int    dxccsr_rsp017
      int    dxccsr_skn001
      int    dxccsr_skn002
      int    dxccsr_skn003
      int    dxccsr_skn004
      int    dxccsr_skn005
      int    dxccsr_skn006
      int    dxccsr_skn007
      int    dxccsr_sym001
      int    dxccsr_sym002
      int    dxccsr_sym003
      int    dxccsr_sym004
      int    dxccsr_sym005
      int    dxccsr_sym006
      int    dxccsr_sym007
      int    dxccsr_sym008
      int    dxccsr_sym009
      int    dxccsr_sym010
      int    dxccsr_sym011
      int    dxccsr_sym012
      int    dxccsr_sym013
      int    dxccsr_sym014
      int    dxccsr_sym015
      int    dxccsr_sym016
      int    dxccsr_sym017
      str6   dxccsr_version
      int    cmr_aids
      int    cmr_alcohol
      int    cmr_autoimmune
      int    cmr_cancer_lymph
      int    cmr_cancer_leuk
      int    cmr_cancer_mets
      int    cmr_cancer_nsitu
      int    cmr_cancer_solid
      int    cmr_dementia
      int    cmr_depress
      int    cmr_diab_uncx
      int    cmr_diab_cx
      int    cmr_drug_abuse
      int    cmr_htn_cx
      int    cmr_htn_uncx
      int    cmr_lung_chronic
      int    cmr_obese
      int    cmr_perivasc
      int    cmr_thyroid_hypo
      int    cmr_thyroid_oth
      str6   cmr_version
using NASS_2021_DX_PR_GRPS.csv;

/*  Assign labels to the data elements */
label var hosp_nass                "NASS Hospital Number" ;
label var key_nass                 "NASS Record Number" ;
label var dxccsr_default_dx1       "Default CCSR for principal/first-listed ICD-10-CM diagnosis" ;
label var dxccsr_bld001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD001" ;
label var dxccsr_bld002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD002" ;
label var dxccsr_bld003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD003" ;
label var dxccsr_bld004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD004" ;
label var dxccsr_bld005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD005" ;
label var dxccsr_bld006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD006" ;
label var dxccsr_bld007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD007" ;
label var dxccsr_bld008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD008" ;
label var dxccsr_bld009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD009" ;
label var dxccsr_bld010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD010" ;
label var dxccsr_cir001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR001" ;
label var dxccsr_cir002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR002" ;
label var dxccsr_cir003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR003" ;
label var dxccsr_cir004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR004" ;
label var dxccsr_cir005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR005" ;
label var dxccsr_cir006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR006" ;
label var dxccsr_cir007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR007" ;
label var dxccsr_cir008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR008" ;
label var dxccsr_cir009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR009" ;
label var dxccsr_cir010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR010" ;
label var dxccsr_cir011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR011" ;
label var dxccsr_cir012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR012" ;
label var dxccsr_cir013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR013" ;
label var dxccsr_cir014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR014" ;
label var dxccsr_cir015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR015" ;
label var dxccsr_cir016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR016" ;
label var dxccsr_cir017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR017" ;
label var dxccsr_cir018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR018" ;
label var dxccsr_cir019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR019" ;
label var dxccsr_cir020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR020" ;
label var dxccsr_cir021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR021" ;
label var dxccsr_cir022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR022" ;
label var dxccsr_cir023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR023" ;
label var dxccsr_cir024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR024" ;
label var dxccsr_cir025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR025" ;
label var dxccsr_cir026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR026" ;
label var dxccsr_cir027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR027" ;
label var dxccsr_cir028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR028" ;
label var dxccsr_cir029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR029" ;
label var dxccsr_cir030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR030" ;
label var dxccsr_cir031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR031" ;
label var dxccsr_cir032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR032" ;
label var dxccsr_cir033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR033" ;
label var dxccsr_cir034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR034" ;
label var dxccsr_cir035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR035" ;
label var dxccsr_cir036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR036" ;
label var dxccsr_cir037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR037" ;
label var dxccsr_cir038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR038" ;
label var dxccsr_cir039            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR039" ;
label var dxccsr_den001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN001" ;
label var dxccsr_den002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN002" ;
label var dxccsr_den003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN003" ;
label var dxccsr_dig001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG001" ;
label var dxccsr_dig002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG002" ;
label var dxccsr_dig003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG003" ;
label var dxccsr_dig004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG004" ;
label var dxccsr_dig005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG005" ;
label var dxccsr_dig006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG006" ;
label var dxccsr_dig007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG007" ;
label var dxccsr_dig008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG008" ;
label var dxccsr_dig009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG009" ;
label var dxccsr_dig010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG010" ;
label var dxccsr_dig011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG011" ;
label var dxccsr_dig012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG012" ;
label var dxccsr_dig013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG013" ;
label var dxccsr_dig014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG014" ;
label var dxccsr_dig015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG015" ;
label var dxccsr_dig016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG016" ;
label var dxccsr_dig017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG017" ;
label var dxccsr_dig018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG018" ;
label var dxccsr_dig019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG019" ;
label var dxccsr_dig020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG020" ;
label var dxccsr_dig021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG021" ;
label var dxccsr_dig022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG022" ;
label var dxccsr_dig023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG023" ;
label var dxccsr_dig024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG024" ;
label var dxccsr_dig025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG025" ;
label var dxccsr_ear001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR001" ;
label var dxccsr_ear002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR002" ;
label var dxccsr_ear003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR003" ;
label var dxccsr_ear004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR004" ;
label var dxccsr_ear005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR005" ;
label var dxccsr_ear006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR006" ;
label var dxccsr_end001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END001" ;
label var dxccsr_end002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END002" ;
label var dxccsr_end003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END003" ;
label var dxccsr_end004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END004" ;
label var dxccsr_end005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END005" ;
label var dxccsr_end006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END006" ;
label var dxccsr_end007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END007" ;
label var dxccsr_end008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END008" ;
label var dxccsr_end009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END009" ;
label var dxccsr_end010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END010" ;
label var dxccsr_end011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END011" ;
label var dxccsr_end012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END012" ;
label var dxccsr_end013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END013" ;
label var dxccsr_end014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END014" ;
label var dxccsr_end015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END015" ;
label var dxccsr_end016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END016" ;
label var dxccsr_end017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END017" ;
label var dxccsr_ext001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT001" ;
label var dxccsr_ext002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT002" ;
label var dxccsr_ext003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT003" ;
label var dxccsr_ext004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT004" ;
label var dxccsr_ext005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT005" ;
label var dxccsr_ext006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT006" ;
label var dxccsr_ext007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT007" ;
label var dxccsr_ext008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT008" ;
label var dxccsr_ext009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT009" ;
label var dxccsr_ext010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT010" ;
label var dxccsr_ext011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT011" ;
label var dxccsr_ext012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT012" ;
label var dxccsr_ext013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT013" ;
label var dxccsr_ext014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT014" ;
label var dxccsr_ext015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT015" ;
label var dxccsr_ext016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT016" ;
label var dxccsr_ext017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT017" ;
label var dxccsr_ext018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT018" ;
label var dxccsr_ext019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT019" ;
label var dxccsr_ext020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT020" ;
label var dxccsr_ext021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT021" ;
label var dxccsr_ext022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT022" ;
label var dxccsr_ext023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT023" ;
label var dxccsr_ext024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT024" ;
label var dxccsr_ext025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT025" ;
label var dxccsr_ext026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT026" ;
label var dxccsr_ext027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT027" ;
label var dxccsr_ext028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT028" ;
label var dxccsr_ext029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT029" ;
label var dxccsr_ext030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT030" ;
label var dxccsr_eye001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE001" ;
label var dxccsr_eye002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE002" ;
label var dxccsr_eye003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE003" ;
label var dxccsr_eye004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE004" ;
label var dxccsr_eye005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE005" ;
label var dxccsr_eye006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE006" ;
label var dxccsr_eye007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE007" ;
label var dxccsr_eye008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE008" ;
label var dxccsr_eye009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE009" ;
label var dxccsr_eye010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE010" ;
label var dxccsr_eye011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE011" ;
label var dxccsr_eye012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE012" ;
label var dxccsr_fac001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC001" ;
label var dxccsr_fac002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC002" ;
label var dxccsr_fac003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC003" ;
label var dxccsr_fac004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC004" ;
label var dxccsr_fac005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC005" ;
label var dxccsr_fac006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC006" ;
label var dxccsr_fac007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC007" ;
label var dxccsr_fac008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC008" ;
label var dxccsr_fac009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC009" ;
label var dxccsr_fac010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC010" ;
label var dxccsr_fac011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC011" ;
label var dxccsr_fac012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC012" ;
label var dxccsr_fac013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC013" ;
label var dxccsr_fac014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC014" ;
label var dxccsr_fac015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC015" ;
label var dxccsr_fac016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC016" ;
label var dxccsr_fac017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC017" ;
label var dxccsr_fac018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC018" ;
label var dxccsr_fac019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC019" ;
label var dxccsr_fac020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC020" ;
label var dxccsr_fac021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC021" ;
label var dxccsr_fac022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC022" ;
label var dxccsr_fac023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC023" ;
label var dxccsr_fac024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC024" ;
label var dxccsr_fac025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC025" ;
label var dxccsr_gen001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN001" ;
label var dxccsr_gen002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN002" ;
label var dxccsr_gen003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN003" ;
label var dxccsr_gen004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN004" ;
label var dxccsr_gen005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN005" ;
label var dxccsr_gen006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN006" ;
label var dxccsr_gen007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN007" ;
label var dxccsr_gen008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN008" ;
label var dxccsr_gen009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN009" ;
label var dxccsr_gen010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN010" ;
label var dxccsr_gen011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN011" ;
label var dxccsr_gen012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN012" ;
label var dxccsr_gen013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN013" ;
label var dxccsr_gen014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN014" ;
label var dxccsr_gen015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN015" ;
label var dxccsr_gen016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN016" ;
label var dxccsr_gen017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN017" ;
label var dxccsr_gen018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN018" ;
label var dxccsr_gen019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN019" ;
label var dxccsr_gen020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN020" ;
label var dxccsr_gen021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN021" ;
label var dxccsr_gen022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN022" ;
label var dxccsr_gen023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN023" ;
label var dxccsr_gen024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN024" ;
label var dxccsr_gen025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN025" ;
label var dxccsr_gen026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN026" ;
label var dxccsr_inf001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF001" ;
label var dxccsr_inf002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF002" ;
label var dxccsr_inf003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF003" ;
label var dxccsr_inf004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF004" ;
label var dxccsr_inf005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF005" ;
label var dxccsr_inf006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF006" ;
label var dxccsr_inf007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF007" ;
label var dxccsr_inf008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF008" ;
label var dxccsr_inf009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF009" ;
label var dxccsr_inf010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF010" ;
label var dxccsr_inf011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF011" ;
label var dxccsr_inf012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF012" ;
label var dxccsr_inj001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ001" ;
label var dxccsr_inj002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ002" ;
label var dxccsr_inj003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ003" ;
label var dxccsr_inj004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ004" ;
label var dxccsr_inj005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ005" ;
label var dxccsr_inj006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ006" ;
label var dxccsr_inj007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ007" ;
label var dxccsr_inj008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ008" ;
label var dxccsr_inj009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ009" ;
label var dxccsr_inj010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ010" ;
label var dxccsr_inj011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ011" ;
label var dxccsr_inj012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ012" ;
label var dxccsr_inj013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ013" ;
label var dxccsr_inj014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ014" ;
label var dxccsr_inj015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ015" ;
label var dxccsr_inj016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ016" ;
label var dxccsr_inj017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ017" ;
label var dxccsr_inj018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ018" ;
label var dxccsr_inj019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ019" ;
label var dxccsr_inj020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ020" ;
label var dxccsr_inj021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ021" ;
label var dxccsr_inj022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ022" ;
label var dxccsr_inj023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ023" ;
label var dxccsr_inj024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ024" ;
label var dxccsr_inj025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ025" ;
label var dxccsr_inj026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ026" ;
label var dxccsr_inj027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ027" ;
label var dxccsr_inj028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ028" ;
label var dxccsr_inj029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ029" ;
label var dxccsr_inj030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ030" ;
label var dxccsr_inj031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ031" ;
label var dxccsr_inj032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ032" ;
label var dxccsr_inj033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ033" ;
label var dxccsr_inj034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ034" ;
label var dxccsr_inj035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ035" ;
label var dxccsr_inj036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ036" ;
label var dxccsr_inj037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ037" ;
label var dxccsr_inj038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ038" ;
label var dxccsr_inj039            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ039" ;
label var dxccsr_inj040            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ040" ;
label var dxccsr_inj041            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ041" ;
label var dxccsr_inj042            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ042" ;
label var dxccsr_inj043            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ043" ;
label var dxccsr_inj044            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ044" ;
label var dxccsr_inj045            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ045" ;
label var dxccsr_inj046            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ046" ;
label var dxccsr_inj047            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ047" ;
label var dxccsr_inj048            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ048" ;
label var dxccsr_inj049            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ049" ;
label var dxccsr_inj050            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ050" ;
label var dxccsr_inj051            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ051" ;
label var dxccsr_inj052            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ052" ;
label var dxccsr_inj053            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ053" ;
label var dxccsr_inj054            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ054" ;
label var dxccsr_inj055            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ055" ;
label var dxccsr_inj056            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ056" ;
label var dxccsr_inj057            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ057" ;
label var dxccsr_inj058            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ058" ;
label var dxccsr_inj059            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ059" ;
label var dxccsr_inj060            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ060" ;
label var dxccsr_inj061            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ061" ;
label var dxccsr_inj062            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ062" ;
label var dxccsr_inj063            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ063" ;
label var dxccsr_inj064            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ064" ;
label var dxccsr_inj065            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ065" ;
label var dxccsr_inj066            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ066" ;
label var dxccsr_inj067            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ067" ;
label var dxccsr_inj068            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ068" ;
label var dxccsr_inj069            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ069" ;
label var dxccsr_inj070            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ070" ;
label var dxccsr_inj071            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ071" ;
label var dxccsr_inj072            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ072" ;
label var dxccsr_inj073            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ073" ;
label var dxccsr_inj074            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ074" ;
label var dxccsr_inj075            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ075" ;
label var dxccsr_inj076            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ076" ;
label var dxccsr_mal001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL001" ;
label var dxccsr_mal002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL002" ;
label var dxccsr_mal003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL003" ;
label var dxccsr_mal004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL004" ;
label var dxccsr_mal005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL005" ;
label var dxccsr_mal006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL006" ;
label var dxccsr_mal007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL007" ;
label var dxccsr_mal008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL008" ;
label var dxccsr_mal009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL009" ;
label var dxccsr_mal010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL010" ;
label var dxccsr_mbd001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD001" ;
label var dxccsr_mbd002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD002" ;
label var dxccsr_mbd003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD003" ;
label var dxccsr_mbd004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD004" ;
label var dxccsr_mbd005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD005" ;
label var dxccsr_mbd006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD006" ;
label var dxccsr_mbd007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD007" ;
label var dxccsr_mbd008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD008" ;
label var dxccsr_mbd009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD009" ;
label var dxccsr_mbd010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD010" ;
label var dxccsr_mbd011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD011" ;
label var dxccsr_mbd012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD012" ;
label var dxccsr_mbd013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD013" ;
label var dxccsr_mbd014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD014" ;
label var dxccsr_mbd017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD017" ;
label var dxccsr_mbd018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD018" ;
label var dxccsr_mbd019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD019" ;
label var dxccsr_mbd020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD020" ;
label var dxccsr_mbd021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD021" ;
label var dxccsr_mbd022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD022" ;
label var dxccsr_mbd023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD023" ;
label var dxccsr_mbd024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD024" ;
label var dxccsr_mbd025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD025" ;
label var dxccsr_mbd026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD026" ;
label var dxccsr_mbd027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD027" ;
label var dxccsr_mbd028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD028" ;
label var dxccsr_mbd029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD029" ;
label var dxccsr_mbd030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD030" ;
label var dxccsr_mbd031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD031" ;
label var dxccsr_mbd032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD032" ;
label var dxccsr_mbd033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD033" ;
label var dxccsr_mbd034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD034" ;
label var dxccsr_mus001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS001" ;
label var dxccsr_mus002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS002" ;
label var dxccsr_mus003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS003" ;
label var dxccsr_mus004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS004" ;
label var dxccsr_mus005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS005" ;
label var dxccsr_mus006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS006" ;
label var dxccsr_mus007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS007" ;
label var dxccsr_mus008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS008" ;
label var dxccsr_mus009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS009" ;
label var dxccsr_mus010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS010" ;
label var dxccsr_mus011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS011" ;
label var dxccsr_mus012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS012" ;
label var dxccsr_mus013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS013" ;
label var dxccsr_mus014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS014" ;
label var dxccsr_mus015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS015" ;
label var dxccsr_mus016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS016" ;
label var dxccsr_mus017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS017" ;
label var dxccsr_mus018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS018" ;
label var dxccsr_mus019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS019" ;
label var dxccsr_mus020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS020" ;
label var dxccsr_mus021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS021" ;
label var dxccsr_mus022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS022" ;
label var dxccsr_mus023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS023" ;
label var dxccsr_mus024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS024" ;
label var dxccsr_mus025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS025" ;
label var dxccsr_mus026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS026" ;
label var dxccsr_mus027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS027" ;
label var dxccsr_mus028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS028" ;
label var dxccsr_mus029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS029" ;
label var dxccsr_mus030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS030" ;
label var dxccsr_mus031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS031" ;
label var dxccsr_mus032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS032" ;
label var dxccsr_mus033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS033" ;
label var dxccsr_mus034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS034" ;
label var dxccsr_mus035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS035" ;
label var dxccsr_mus036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS036" ;
label var dxccsr_mus037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS037" ;
label var dxccsr_mus038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS038" ;
label var dxccsr_neo001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO001" ;
label var dxccsr_neo002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO002" ;
label var dxccsr_neo003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO003" ;
label var dxccsr_neo004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO004" ;
label var dxccsr_neo005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO005" ;
label var dxccsr_neo006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO006" ;
label var dxccsr_neo007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO007" ;
label var dxccsr_neo008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO008" ;
label var dxccsr_neo009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO009" ;
label var dxccsr_neo010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO010" ;
label var dxccsr_neo011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO011" ;
label var dxccsr_neo012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO012" ;
label var dxccsr_neo013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO013" ;
label var dxccsr_neo014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO014" ;
label var dxccsr_neo015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO015" ;
label var dxccsr_neo016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO016" ;
label var dxccsr_neo017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO017" ;
label var dxccsr_neo018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO018" ;
label var dxccsr_neo019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO019" ;
label var dxccsr_neo020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO020" ;
label var dxccsr_neo021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO021" ;
label var dxccsr_neo022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO022" ;
label var dxccsr_neo023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO023" ;
label var dxccsr_neo024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO024" ;
label var dxccsr_neo025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO025" ;
label var dxccsr_neo026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO026" ;
label var dxccsr_neo027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO027" ;
label var dxccsr_neo028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO028" ;
label var dxccsr_neo029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO029" ;
label var dxccsr_neo030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO030" ;
label var dxccsr_neo031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO031" ;
label var dxccsr_neo032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO032" ;
label var dxccsr_neo033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO033" ;
label var dxccsr_neo034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO034" ;
label var dxccsr_neo035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO035" ;
label var dxccsr_neo036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO036" ;
label var dxccsr_neo037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO037" ;
label var dxccsr_neo038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO038" ;
label var dxccsr_neo039            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO039" ;
label var dxccsr_neo040            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO040" ;
label var dxccsr_neo041            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO041" ;
label var dxccsr_neo042            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO042" ;
label var dxccsr_neo043            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO043" ;
label var dxccsr_neo044            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO044" ;
label var dxccsr_neo045            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO045" ;
label var dxccsr_neo046            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO046" ;
label var dxccsr_neo047            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO047" ;
label var dxccsr_neo048            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO048" ;
label var dxccsr_neo049            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO049" ;
label var dxccsr_neo050            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO050" ;
label var dxccsr_neo051            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO051" ;
label var dxccsr_neo052            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO052" ;
label var dxccsr_neo053            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO053" ;
label var dxccsr_neo054            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO054" ;
label var dxccsr_neo055            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO055" ;
label var dxccsr_neo056            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO056" ;
label var dxccsr_neo057            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO057" ;
label var dxccsr_neo058            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO058" ;
label var dxccsr_neo059            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO059" ;
label var dxccsr_neo060            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO060" ;
label var dxccsr_neo061            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO061" ;
label var dxccsr_neo062            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO062" ;
label var dxccsr_neo063            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO063" ;
label var dxccsr_neo064            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO064" ;
label var dxccsr_neo065            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO065" ;
label var dxccsr_neo066            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO066" ;
label var dxccsr_neo067            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO067" ;
label var dxccsr_neo068            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO068" ;
label var dxccsr_neo069            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO069" ;
label var dxccsr_neo070            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO070" ;
label var dxccsr_neo071            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO071" ;
label var dxccsr_neo072            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO072" ;
label var dxccsr_neo073            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO073" ;
label var dxccsr_neo074            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO074" ;
label var dxccsr_nvs001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS001" ;
label var dxccsr_nvs002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS002" ;
label var dxccsr_nvs003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS003" ;
label var dxccsr_nvs004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS004" ;
label var dxccsr_nvs005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS005" ;
label var dxccsr_nvs006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS006" ;
label var dxccsr_nvs007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS007" ;
label var dxccsr_nvs008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS008" ;
label var dxccsr_nvs009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS009" ;
label var dxccsr_nvs010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS010" ;
label var dxccsr_nvs011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS011" ;
label var dxccsr_nvs012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS012" ;
label var dxccsr_nvs013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS013" ;
label var dxccsr_nvs014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS014" ;
label var dxccsr_nvs015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS015" ;
label var dxccsr_nvs016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS016" ;
label var dxccsr_nvs017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS017" ;
label var dxccsr_nvs018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS018" ;
label var dxccsr_nvs019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS019" ;
label var dxccsr_nvs020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS020" ;
label var dxccsr_nvs021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS021" ;
label var dxccsr_nvs022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS022" ;
label var dxccsr_pnl001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL001" ;
label var dxccsr_pnl002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL002" ;
label var dxccsr_pnl003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL003" ;
label var dxccsr_pnl004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL004" ;
label var dxccsr_pnl005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL005" ;
label var dxccsr_pnl006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL006" ;
label var dxccsr_pnl007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL007" ;
label var dxccsr_pnl008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL008" ;
label var dxccsr_pnl009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL009" ;
label var dxccsr_pnl010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL010" ;
label var dxccsr_pnl011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL011" ;
label var dxccsr_pnl012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL012" ;
label var dxccsr_pnl013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL013" ;
label var dxccsr_pnl014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL014" ;
label var dxccsr_pnl015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL015" ;
label var dxccsr_prg001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG001" ;
label var dxccsr_prg002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG002" ;
label var dxccsr_prg003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG003" ;
label var dxccsr_prg004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG004" ;
label var dxccsr_prg005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG005" ;
label var dxccsr_prg006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG006" ;
label var dxccsr_prg007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG007" ;
label var dxccsr_prg008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG008" ;
label var dxccsr_prg009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG009" ;
label var dxccsr_prg010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG010" ;
label var dxccsr_prg011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG011" ;
label var dxccsr_prg012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG012" ;
label var dxccsr_prg013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG013" ;
label var dxccsr_prg014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG014" ;
label var dxccsr_prg015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG015" ;
label var dxccsr_prg016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG016" ;
label var dxccsr_prg017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG017" ;
label var dxccsr_prg018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG018" ;
label var dxccsr_prg019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG019" ;
label var dxccsr_prg020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG020" ;
label var dxccsr_prg021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG021" ;
label var dxccsr_prg022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG022" ;
label var dxccsr_prg023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG023" ;
label var dxccsr_prg024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG024" ;
label var dxccsr_prg025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG025" ;
label var dxccsr_prg026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG026" ;
label var dxccsr_prg027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG027" ;
label var dxccsr_prg028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG028" ;
label var dxccsr_prg029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG029" ;
label var dxccsr_prg030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG030" ;
label var dxccsr_rsp001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP001" ;
label var dxccsr_rsp002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP002" ;
label var dxccsr_rsp003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP003" ;
label var dxccsr_rsp004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP004" ;
label var dxccsr_rsp005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP005" ;
label var dxccsr_rsp006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP006" ;
label var dxccsr_rsp007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP007" ;
label var dxccsr_rsp008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP008" ;
label var dxccsr_rsp009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP009" ;
label var dxccsr_rsp010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP010" ;
label var dxccsr_rsp011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP011" ;
label var dxccsr_rsp012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP012" ;
label var dxccsr_rsp013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP013" ;
label var dxccsr_rsp014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP014" ;
label var dxccsr_rsp015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP015" ;
label var dxccsr_rsp016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP016" ;
label var dxccsr_rsp017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP017" ;
label var dxccsr_skn001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN001" ;
label var dxccsr_skn002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN002" ;
label var dxccsr_skn003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN003" ;
label var dxccsr_skn004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN004" ;
label var dxccsr_skn005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN005" ;
label var dxccsr_skn006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN006" ;
label var dxccsr_skn007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN007" ;
label var dxccsr_sym001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM001" ;
label var dxccsr_sym002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM002" ;
label var dxccsr_sym003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM003" ;
label var dxccsr_sym004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM004" ;
label var dxccsr_sym005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM005" ;
label var dxccsr_sym006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM006" ;
label var dxccsr_sym007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM007" ;
label var dxccsr_sym008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM008" ;
label var dxccsr_sym009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM009" ;
label var dxccsr_sym010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM010" ;
label var dxccsr_sym011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM011" ;
label var dxccsr_sym012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM012" ;
label var dxccsr_sym013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM013" ;
label var dxccsr_sym014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM014" ;
label var dxccsr_sym015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM015" ;
label var dxccsr_sym016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM016" ;
label var dxccsr_sym017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM017" ;
label var dxccsr_version           "Version of CCSR for ICD-10-CM diagnoses" ;
label var cmr_aids                 "Acquired immune deficiency syndrome" ;
label var cmr_alcohol              "Alcohol abuse" ;
label var cmr_autoimmune           "Autoimmune conditions" ;
label var cmr_cancer_lymph         "Lymphoma" ;
label var cmr_cancer_leuk          "Leukemia" ;
label var cmr_cancer_mets          "Metastatic cancer" ;
label var cmr_cancer_nsitu         "Solid tumor without metastasis, in situ" ;
label var cmr_cancer_solid         "Solid tumor without metastasis, malignant" ;
label var cmr_dementia             "Dementia" ;
label var cmr_depress              "Depression" ;
label var cmr_diab_uncx            "Diabetes without chronic complications" ;
label var cmr_diab_cx              "Diabetes with chronic complications" ;
label var cmr_drug_abuse           "Drug abuse" ;
label var cmr_htn_cx               "Hypertension, complicated" ;
label var cmr_htn_uncx             "Hypertension, uncomplicated" ;
label var cmr_lung_chronic         "Chronic pulmonary disease" ;
label var cmr_obese                "Obesity" ;
label var cmr_perivasc             "Peripheral vascular disease" ;
label var cmr_thyroid_hypo         "Hypothyroidism" ;
label var cmr_thyroid_oth          "Other thyroid disorders" ;
label var cmr_version              "Version of Elixhauser Comorbidity Software Refined" ;

/* Convert special values to missing values */
recode hosp_nass                 (-9999 -8888 -6666=.) ;
recode key_nass                  (-9999999 -8888888 -6666666=.) ;
recode dxccsr_bld001             (-99 -88 -66=.) ;
recode dxccsr_bld002             (-99 -88 -66=.) ;
recode dxccsr_bld003             (-99 -88 -66=.) ;
recode dxccsr_bld004             (-99 -88 -66=.) ;
recode dxccsr_bld005             (-99 -88 -66=.) ;
recode dxccsr_bld006             (-99 -88 -66=.) ;
recode dxccsr_bld007             (-99 -88 -66=.) ;
recode dxccsr_bld008             (-99 -88 -66=.) ;
recode dxccsr_bld009             (-99 -88 -66=.) ;
recode dxccsr_bld010             (-99 -88 -66=.) ;
recode dxccsr_cir001             (-99 -88 -66=.) ;
recode dxccsr_cir002             (-99 -88 -66=.) ;
recode dxccsr_cir003             (-99 -88 -66=.) ;
recode dxccsr_cir004             (-99 -88 -66=.) ;
recode dxccsr_cir005             (-99 -88 -66=.) ;
recode dxccsr_cir006             (-99 -88 -66=.) ;
recode dxccsr_cir007             (-99 -88 -66=.) ;
recode dxccsr_cir008             (-99 -88 -66=.) ;
recode dxccsr_cir009             (-99 -88 -66=.) ;
recode dxccsr_cir010             (-99 -88 -66=.) ;
recode dxccsr_cir011             (-99 -88 -66=.) ;
recode dxccsr_cir012             (-99 -88 -66=.) ;
recode dxccsr_cir013             (-99 -88 -66=.) ;
recode dxccsr_cir014             (-99 -88 -66=.) ;
recode dxccsr_cir015             (-99 -88 -66=.) ;
recode dxccsr_cir016             (-99 -88 -66=.) ;
recode dxccsr_cir017             (-99 -88 -66=.) ;
recode dxccsr_cir018             (-99 -88 -66=.) ;
recode dxccsr_cir019             (-99 -88 -66=.) ;
recode dxccsr_cir020             (-99 -88 -66=.) ;
recode dxccsr_cir021             (-99 -88 -66=.) ;
recode dxccsr_cir022             (-99 -88 -66=.) ;
recode dxccsr_cir023             (-99 -88 -66=.) ;
recode dxccsr_cir024             (-99 -88 -66=.) ;
recode dxccsr_cir025             (-99 -88 -66=.) ;
recode dxccsr_cir026             (-99 -88 -66=.) ;
recode dxccsr_cir027             (-99 -88 -66=.) ;
recode dxccsr_cir028             (-99 -88 -66=.) ;
recode dxccsr_cir029             (-99 -88 -66=.) ;
recode dxccsr_cir030             (-99 -88 -66=.) ;
recode dxccsr_cir031             (-99 -88 -66=.) ;
recode dxccsr_cir032             (-99 -88 -66=.) ;
recode dxccsr_cir033             (-99 -88 -66=.) ;
recode dxccsr_cir034             (-99 -88 -66=.) ;
recode dxccsr_cir035             (-99 -88 -66=.) ;
recode dxccsr_cir036             (-99 -88 -66=.) ;
recode dxccsr_cir037             (-99 -88 -66=.) ;
recode dxccsr_cir038             (-99 -88 -66=.) ;
recode dxccsr_cir039             (-99 -88 -66=.) ;
recode dxccsr_den001             (-99 -88 -66=.) ;
recode dxccsr_den002             (-99 -88 -66=.) ;
recode dxccsr_den003             (-99 -88 -66=.) ;
recode dxccsr_dig001             (-99 -88 -66=.) ;
recode dxccsr_dig002             (-99 -88 -66=.) ;
recode dxccsr_dig003             (-99 -88 -66=.) ;
recode dxccsr_dig004             (-99 -88 -66=.) ;
recode dxccsr_dig005             (-99 -88 -66=.) ;
recode dxccsr_dig006             (-99 -88 -66=.) ;
recode dxccsr_dig007             (-99 -88 -66=.) ;
recode dxccsr_dig008             (-99 -88 -66=.) ;
recode dxccsr_dig009             (-99 -88 -66=.) ;
recode dxccsr_dig010             (-99 -88 -66=.) ;
recode dxccsr_dig011             (-99 -88 -66=.) ;
recode dxccsr_dig012             (-99 -88 -66=.) ;
recode dxccsr_dig013             (-99 -88 -66=.) ;
recode dxccsr_dig014             (-99 -88 -66=.) ;
recode dxccsr_dig015             (-99 -88 -66=.) ;
recode dxccsr_dig016             (-99 -88 -66=.) ;
recode dxccsr_dig017             (-99 -88 -66=.) ;
recode dxccsr_dig018             (-99 -88 -66=.) ;
recode dxccsr_dig019             (-99 -88 -66=.) ;
recode dxccsr_dig020             (-99 -88 -66=.) ;
recode dxccsr_dig021             (-99 -88 -66=.) ;
recode dxccsr_dig022             (-99 -88 -66=.) ;
recode dxccsr_dig023             (-99 -88 -66=.) ;
recode dxccsr_dig024             (-99 -88 -66=.) ;
recode dxccsr_dig025             (-99 -88 -66=.) ;
recode dxccsr_ear001             (-99 -88 -66=.) ;
recode dxccsr_ear002             (-99 -88 -66=.) ;
recode dxccsr_ear003             (-99 -88 -66=.) ;
recode dxccsr_ear004             (-99 -88 -66=.) ;
recode dxccsr_ear005             (-99 -88 -66=.) ;
recode dxccsr_ear006             (-99 -88 -66=.) ;
recode dxccsr_end001             (-99 -88 -66=.) ;
recode dxccsr_end002             (-99 -88 -66=.) ;
recode dxccsr_end003             (-99 -88 -66=.) ;
recode dxccsr_end004             (-99 -88 -66=.) ;
recode dxccsr_end005             (-99 -88 -66=.) ;
recode dxccsr_end006             (-99 -88 -66=.) ;
recode dxccsr_end007             (-99 -88 -66=.) ;
recode dxccsr_end008             (-99 -88 -66=.) ;
recode dxccsr_end009             (-99 -88 -66=.) ;
recode dxccsr_end010             (-99 -88 -66=.) ;
recode dxccsr_end011             (-99 -88 -66=.) ;
recode dxccsr_end012             (-99 -88 -66=.) ;
recode dxccsr_end013             (-99 -88 -66=.) ;
recode dxccsr_end014             (-99 -88 -66=.) ;
recode dxccsr_end015             (-99 -88 -66=.) ;
recode dxccsr_end016             (-99 -88 -66=.) ;
recode dxccsr_end017             (-99 -88 -66=.) ;
recode dxccsr_ext001             (-99 -88 -66=.) ;
recode dxccsr_ext002             (-99 -88 -66=.) ;
recode dxccsr_ext003             (-99 -88 -66=.) ;
recode dxccsr_ext004             (-99 -88 -66=.) ;
recode dxccsr_ext005             (-99 -88 -66=.) ;
recode dxccsr_ext006             (-99 -88 -66=.) ;
recode dxccsr_ext007             (-99 -88 -66=.) ;
recode dxccsr_ext008             (-99 -88 -66=.) ;
recode dxccsr_ext009             (-99 -88 -66=.) ;
recode dxccsr_ext010             (-99 -88 -66=.) ;
recode dxccsr_ext011             (-99 -88 -66=.) ;
recode dxccsr_ext012             (-99 -88 -66=.) ;
recode dxccsr_ext013             (-99 -88 -66=.) ;
recode dxccsr_ext014             (-99 -88 -66=.) ;
recode dxccsr_ext015             (-99 -88 -66=.) ;
recode dxccsr_ext016             (-99 -88 -66=.) ;
recode dxccsr_ext017             (-99 -88 -66=.) ;
recode dxccsr_ext018             (-99 -88 -66=.) ;
recode dxccsr_ext019             (-99 -88 -66=.) ;
recode dxccsr_ext020             (-99 -88 -66=.) ;
recode dxccsr_ext021             (-99 -88 -66=.) ;
recode dxccsr_ext022             (-99 -88 -66=.) ;
recode dxccsr_ext023             (-99 -88 -66=.) ;
recode dxccsr_ext024             (-99 -88 -66=.) ;
recode dxccsr_ext025             (-99 -88 -66=.) ;
recode dxccsr_ext026             (-99 -88 -66=.) ;
recode dxccsr_ext027             (-99 -88 -66=.) ;
recode dxccsr_ext028             (-99 -88 -66=.) ;
recode dxccsr_ext029             (-99 -88 -66=.) ;
recode dxccsr_ext030             (-99 -88 -66=.) ;
recode dxccsr_eye001             (-99 -88 -66=.) ;
recode dxccsr_eye002             (-99 -88 -66=.) ;
recode dxccsr_eye003             (-99 -88 -66=.) ;
recode dxccsr_eye004             (-99 -88 -66=.) ;
recode dxccsr_eye005             (-99 -88 -66=.) ;
recode dxccsr_eye006             (-99 -88 -66=.) ;
recode dxccsr_eye007             (-99 -88 -66=.) ;
recode dxccsr_eye008             (-99 -88 -66=.) ;
recode dxccsr_eye009             (-99 -88 -66=.) ;
recode dxccsr_eye010             (-99 -88 -66=.) ;
recode dxccsr_eye011             (-99 -88 -66=.) ;
recode dxccsr_eye012             (-99 -88 -66=.) ;
recode dxccsr_fac001             (-99 -88 -66=.) ;
recode dxccsr_fac002             (-99 -88 -66=.) ;
recode dxccsr_fac003             (-99 -88 -66=.) ;
recode dxccsr_fac004             (-99 -88 -66=.) ;
recode dxccsr_fac005             (-99 -88 -66=.) ;
recode dxccsr_fac006             (-99 -88 -66=.) ;
recode dxccsr_fac007             (-99 -88 -66=.) ;
recode dxccsr_fac008             (-99 -88 -66=.) ;
recode dxccsr_fac009             (-99 -88 -66=.) ;
recode dxccsr_fac010             (-99 -88 -66=.) ;
recode dxccsr_fac011             (-99 -88 -66=.) ;
recode dxccsr_fac012             (-99 -88 -66=.) ;
recode dxccsr_fac013             (-99 -88 -66=.) ;
recode dxccsr_fac014             (-99 -88 -66=.) ;
recode dxccsr_fac015             (-99 -88 -66=.) ;
recode dxccsr_fac016             (-99 -88 -66=.) ;
recode dxccsr_fac017             (-99 -88 -66=.) ;
recode dxccsr_fac018             (-99 -88 -66=.) ;
recode dxccsr_fac019             (-99 -88 -66=.) ;
recode dxccsr_fac020             (-99 -88 -66=.) ;
recode dxccsr_fac021             (-99 -88 -66=.) ;
recode dxccsr_fac022             (-99 -88 -66=.) ;
recode dxccsr_fac023             (-99 -88 -66=.) ;
recode dxccsr_fac024             (-99 -88 -66=.) ;
recode dxccsr_fac025             (-99 -88 -66=.) ;
recode dxccsr_gen001             (-99 -88 -66=.) ;
recode dxccsr_gen002             (-99 -88 -66=.) ;
recode dxccsr_gen003             (-99 -88 -66=.) ;
recode dxccsr_gen004             (-99 -88 -66=.) ;
recode dxccsr_gen005             (-99 -88 -66=.) ;
recode dxccsr_gen006             (-99 -88 -66=.) ;
recode dxccsr_gen007             (-99 -88 -66=.) ;
recode dxccsr_gen008             (-99 -88 -66=.) ;
recode dxccsr_gen009             (-99 -88 -66=.) ;
recode dxccsr_gen010             (-99 -88 -66=.) ;
recode dxccsr_gen011             (-99 -88 -66=.) ;
recode dxccsr_gen012             (-99 -88 -66=.) ;
recode dxccsr_gen013             (-99 -88 -66=.) ;
recode dxccsr_gen014             (-99 -88 -66=.) ;
recode dxccsr_gen015             (-99 -88 -66=.) ;
recode dxccsr_gen016             (-99 -88 -66=.) ;
recode dxccsr_gen017             (-99 -88 -66=.) ;
recode dxccsr_gen018             (-99 -88 -66=.) ;
recode dxccsr_gen019             (-99 -88 -66=.) ;
recode dxccsr_gen020             (-99 -88 -66=.) ;
recode dxccsr_gen021             (-99 -88 -66=.) ;
recode dxccsr_gen022             (-99 -88 -66=.) ;
recode dxccsr_gen023             (-99 -88 -66=.) ;
recode dxccsr_gen024             (-99 -88 -66=.) ;
recode dxccsr_gen025             (-99 -88 -66=.) ;
recode dxccsr_gen026             (-99 -88 -66=.) ;
recode dxccsr_inf001             (-99 -88 -66=.) ;
recode dxccsr_inf002             (-99 -88 -66=.) ;
recode dxccsr_inf003             (-99 -88 -66=.) ;
recode dxccsr_inf004             (-99 -88 -66=.) ;
recode dxccsr_inf005             (-99 -88 -66=.) ;
recode dxccsr_inf006             (-99 -88 -66=.) ;
recode dxccsr_inf007             (-99 -88 -66=.) ;
recode dxccsr_inf008             (-99 -88 -66=.) ;
recode dxccsr_inf009             (-99 -88 -66=.) ;
recode dxccsr_inf010             (-99 -88 -66=.) ;
recode dxccsr_inf011             (-99 -88 -66=.) ;
recode dxccsr_inf012             (-99 -88 -66=.) ;
recode dxccsr_inj001             (-99 -88 -66=.) ;
recode dxccsr_inj002             (-99 -88 -66=.) ;
recode dxccsr_inj003             (-99 -88 -66=.) ;
recode dxccsr_inj004             (-99 -88 -66=.) ;
recode dxccsr_inj005             (-99 -88 -66=.) ;
recode dxccsr_inj006             (-99 -88 -66=.) ;
recode dxccsr_inj007             (-99 -88 -66=.) ;
recode dxccsr_inj008             (-99 -88 -66=.) ;
recode dxccsr_inj009             (-99 -88 -66=.) ;
recode dxccsr_inj010             (-99 -88 -66=.) ;
recode dxccsr_inj011             (-99 -88 -66=.) ;
recode dxccsr_inj012             (-99 -88 -66=.) ;
recode dxccsr_inj013             (-99 -88 -66=.) ;
recode dxccsr_inj014             (-99 -88 -66=.) ;
recode dxccsr_inj015             (-99 -88 -66=.) ;
recode dxccsr_inj016             (-99 -88 -66=.) ;
recode dxccsr_inj017             (-99 -88 -66=.) ;
recode dxccsr_inj018             (-99 -88 -66=.) ;
recode dxccsr_inj019             (-99 -88 -66=.) ;
recode dxccsr_inj020             (-99 -88 -66=.) ;
recode dxccsr_inj021             (-99 -88 -66=.) ;
recode dxccsr_inj022             (-99 -88 -66=.) ;
recode dxccsr_inj023             (-99 -88 -66=.) ;
recode dxccsr_inj024             (-99 -88 -66=.) ;
recode dxccsr_inj025             (-99 -88 -66=.) ;
recode dxccsr_inj026             (-99 -88 -66=.) ;
recode dxccsr_inj027             (-99 -88 -66=.) ;
recode dxccsr_inj028             (-99 -88 -66=.) ;
recode dxccsr_inj029             (-99 -88 -66=.) ;
recode dxccsr_inj030             (-99 -88 -66=.) ;
recode dxccsr_inj031             (-99 -88 -66=.) ;
recode dxccsr_inj032             (-99 -88 -66=.) ;
recode dxccsr_inj033             (-99 -88 -66=.) ;
recode dxccsr_inj034             (-99 -88 -66=.) ;
recode dxccsr_inj035             (-99 -88 -66=.) ;
recode dxccsr_inj036             (-99 -88 -66=.) ;
recode dxccsr_inj037             (-99 -88 -66=.) ;
recode dxccsr_inj038             (-99 -88 -66=.) ;
recode dxccsr_inj039             (-99 -88 -66=.) ;
recode dxccsr_inj040             (-99 -88 -66=.) ;
recode dxccsr_inj041             (-99 -88 -66=.) ;
recode dxccsr_inj042             (-99 -88 -66=.) ;
recode dxccsr_inj043             (-99 -88 -66=.) ;
recode dxccsr_inj044             (-99 -88 -66=.) ;
recode dxccsr_inj045             (-99 -88 -66=.) ;
recode dxccsr_inj046             (-99 -88 -66=.) ;
recode dxccsr_inj047             (-99 -88 -66=.) ;
recode dxccsr_inj048             (-99 -88 -66=.) ;
recode dxccsr_inj049             (-99 -88 -66=.) ;
recode dxccsr_inj050             (-99 -88 -66=.) ;
recode dxccsr_inj051             (-99 -88 -66=.) ;
recode dxccsr_inj052             (-99 -88 -66=.) ;
recode dxccsr_inj053             (-99 -88 -66=.) ;
recode dxccsr_inj054             (-99 -88 -66=.) ;
recode dxccsr_inj055             (-99 -88 -66=.) ;
recode dxccsr_inj056             (-99 -88 -66=.) ;
recode dxccsr_inj057             (-99 -88 -66=.) ;
recode dxccsr_inj058             (-99 -88 -66=.) ;
recode dxccsr_inj059             (-99 -88 -66=.) ;
recode dxccsr_inj060             (-99 -88 -66=.) ;
recode dxccsr_inj061             (-99 -88 -66=.) ;
recode dxccsr_inj062             (-99 -88 -66=.) ;
recode dxccsr_inj063             (-99 -88 -66=.) ;
recode dxccsr_inj064             (-99 -88 -66=.) ;
recode dxccsr_inj065             (-99 -88 -66=.) ;
recode dxccsr_inj066             (-99 -88 -66=.) ;
recode dxccsr_inj067             (-99 -88 -66=.) ;
recode dxccsr_inj068             (-99 -88 -66=.) ;
recode dxccsr_inj069             (-99 -88 -66=.) ;
recode dxccsr_inj070             (-99 -88 -66=.) ;
recode dxccsr_inj071             (-99 -88 -66=.) ;
recode dxccsr_inj072             (-99 -88 -66=.) ;
recode dxccsr_inj073             (-99 -88 -66=.) ;
recode dxccsr_inj074             (-99 -88 -66=.) ;
recode dxccsr_inj075             (-99 -88 -66=.) ;
recode dxccsr_inj076             (-99 -88 -66=.) ;
recode dxccsr_mal001             (-99 -88 -66=.) ;
recode dxccsr_mal002             (-99 -88 -66=.) ;
recode dxccsr_mal003             (-99 -88 -66=.) ;
recode dxccsr_mal004             (-99 -88 -66=.) ;
recode dxccsr_mal005             (-99 -88 -66=.) ;
recode dxccsr_mal006             (-99 -88 -66=.) ;
recode dxccsr_mal007             (-99 -88 -66=.) ;
recode dxccsr_mal008             (-99 -88 -66=.) ;
recode dxccsr_mal009             (-99 -88 -66=.) ;
recode dxccsr_mal010             (-99 -88 -66=.) ;
recode dxccsr_mbd001             (-99 -88 -66=.) ;
recode dxccsr_mbd002             (-99 -88 -66=.) ;
recode dxccsr_mbd003             (-99 -88 -66=.) ;
recode dxccsr_mbd004             (-99 -88 -66=.) ;
recode dxccsr_mbd005             (-99 -88 -66=.) ;
recode dxccsr_mbd006             (-99 -88 -66=.) ;
recode dxccsr_mbd007             (-99 -88 -66=.) ;
recode dxccsr_mbd008             (-99 -88 -66=.) ;
recode dxccsr_mbd009             (-99 -88 -66=.) ;
recode dxccsr_mbd010             (-99 -88 -66=.) ;
recode dxccsr_mbd011             (-99 -88 -66=.) ;
recode dxccsr_mbd012             (-99 -88 -66=.) ;
recode dxccsr_mbd013             (-99 -88 -66=.) ;
recode dxccsr_mbd014             (-99 -88 -66=.) ;
recode dxccsr_mbd017             (-99 -88 -66=.) ;
recode dxccsr_mbd018             (-99 -88 -66=.) ;
recode dxccsr_mbd019             (-99 -88 -66=.) ;
recode dxccsr_mbd020             (-99 -88 -66=.) ;
recode dxccsr_mbd021             (-99 -88 -66=.) ;
recode dxccsr_mbd022             (-99 -88 -66=.) ;
recode dxccsr_mbd023             (-99 -88 -66=.) ;
recode dxccsr_mbd024             (-99 -88 -66=.) ;
recode dxccsr_mbd025             (-99 -88 -66=.) ;
recode dxccsr_mbd026             (-99 -88 -66=.) ;
recode dxccsr_mbd027             (-99 -88 -66=.) ;
recode dxccsr_mbd028             (-99 -88 -66=.) ;
recode dxccsr_mbd029             (-99 -88 -66=.) ;
recode dxccsr_mbd030             (-99 -88 -66=.) ;
recode dxccsr_mbd031             (-99 -88 -66=.) ;
recode dxccsr_mbd032             (-99 -88 -66=.) ;
recode dxccsr_mbd033             (-99 -88 -66=.) ;
recode dxccsr_mbd034             (-99 -88 -66=.) ;
recode dxccsr_mus001             (-99 -88 -66=.) ;
recode dxccsr_mus002             (-99 -88 -66=.) ;
recode dxccsr_mus003             (-99 -88 -66=.) ;
recode dxccsr_mus004             (-99 -88 -66=.) ;
recode dxccsr_mus005             (-99 -88 -66=.) ;
recode dxccsr_mus006             (-99 -88 -66=.) ;
recode dxccsr_mus007             (-99 -88 -66=.) ;
recode dxccsr_mus008             (-99 -88 -66=.) ;
recode dxccsr_mus009             (-99 -88 -66=.) ;
recode dxccsr_mus010             (-99 -88 -66=.) ;
recode dxccsr_mus011             (-99 -88 -66=.) ;
recode dxccsr_mus012             (-99 -88 -66=.) ;
recode dxccsr_mus013             (-99 -88 -66=.) ;
recode dxccsr_mus014             (-99 -88 -66=.) ;
recode dxccsr_mus015             (-99 -88 -66=.) ;
recode dxccsr_mus016             (-99 -88 -66=.) ;
recode dxccsr_mus017             (-99 -88 -66=.) ;
recode dxccsr_mus018             (-99 -88 -66=.) ;
recode dxccsr_mus019             (-99 -88 -66=.) ;
recode dxccsr_mus020             (-99 -88 -66=.) ;
recode dxccsr_mus021             (-99 -88 -66=.) ;
recode dxccsr_mus022             (-99 -88 -66=.) ;
recode dxccsr_mus023             (-99 -88 -66=.) ;
recode dxccsr_mus024             (-99 -88 -66=.) ;
recode dxccsr_mus025             (-99 -88 -66=.) ;
recode dxccsr_mus026             (-99 -88 -66=.) ;
recode dxccsr_mus027             (-99 -88 -66=.) ;
recode dxccsr_mus028             (-99 -88 -66=.) ;
recode dxccsr_mus029             (-99 -88 -66=.) ;
recode dxccsr_mus030             (-99 -88 -66=.) ;
recode dxccsr_mus031             (-99 -88 -66=.) ;
recode dxccsr_mus032             (-99 -88 -66=.) ;
recode dxccsr_mus033             (-99 -88 -66=.) ;
recode dxccsr_mus034             (-99 -88 -66=.) ;
recode dxccsr_mus035             (-99 -88 -66=.) ;
recode dxccsr_mus036             (-99 -88 -66=.) ;
recode dxccsr_mus037             (-99 -88 -66=.) ;
recode dxccsr_mus038             (-99 -88 -66=.) ;
recode dxccsr_neo001             (-99 -88 -66=.) ;
recode dxccsr_neo002             (-99 -88 -66=.) ;
recode dxccsr_neo003             (-99 -88 -66=.) ;
recode dxccsr_neo004             (-99 -88 -66=.) ;
recode dxccsr_neo005             (-99 -88 -66=.) ;
recode dxccsr_neo006             (-99 -88 -66=.) ;
recode dxccsr_neo007             (-99 -88 -66=.) ;
recode dxccsr_neo008             (-99 -88 -66=.) ;
recode dxccsr_neo009             (-99 -88 -66=.) ;
recode dxccsr_neo010             (-99 -88 -66=.) ;
recode dxccsr_neo011             (-99 -88 -66=.) ;
recode dxccsr_neo012             (-99 -88 -66=.) ;
recode dxccsr_neo013             (-99 -88 -66=.) ;
recode dxccsr_neo014             (-99 -88 -66=.) ;
recode dxccsr_neo015             (-99 -88 -66=.) ;
recode dxccsr_neo016             (-99 -88 -66=.) ;
recode dxccsr_neo017             (-99 -88 -66=.) ;
recode dxccsr_neo018             (-99 -88 -66=.) ;
recode dxccsr_neo019             (-99 -88 -66=.) ;
recode dxccsr_neo020             (-99 -88 -66=.) ;
recode dxccsr_neo021             (-99 -88 -66=.) ;
recode dxccsr_neo022             (-99 -88 -66=.) ;
recode dxccsr_neo023             (-99 -88 -66=.) ;
recode dxccsr_neo024             (-99 -88 -66=.) ;
recode dxccsr_neo025             (-99 -88 -66=.) ;
recode dxccsr_neo026             (-99 -88 -66=.) ;
recode dxccsr_neo027             (-99 -88 -66=.) ;
recode dxccsr_neo028             (-99 -88 -66=.) ;
recode dxccsr_neo029             (-99 -88 -66=.) ;
recode dxccsr_neo030             (-99 -88 -66=.) ;
recode dxccsr_neo031             (-99 -88 -66=.) ;
recode dxccsr_neo032             (-99 -88 -66=.) ;
recode dxccsr_neo033             (-99 -88 -66=.) ;
recode dxccsr_neo034             (-99 -88 -66=.) ;
recode dxccsr_neo035             (-99 -88 -66=.) ;
recode dxccsr_neo036             (-99 -88 -66=.) ;
recode dxccsr_neo037             (-99 -88 -66=.) ;
recode dxccsr_neo038             (-99 -88 -66=.) ;
recode dxccsr_neo039             (-99 -88 -66=.) ;
recode dxccsr_neo040             (-99 -88 -66=.) ;
recode dxccsr_neo041             (-99 -88 -66=.) ;
recode dxccsr_neo042             (-99 -88 -66=.) ;
recode dxccsr_neo043             (-99 -88 -66=.) ;
recode dxccsr_neo044             (-99 -88 -66=.) ;
recode dxccsr_neo045             (-99 -88 -66=.) ;
recode dxccsr_neo046             (-99 -88 -66=.) ;
recode dxccsr_neo047             (-99 -88 -66=.) ;
recode dxccsr_neo048             (-99 -88 -66=.) ;
recode dxccsr_neo049             (-99 -88 -66=.) ;
recode dxccsr_neo050             (-99 -88 -66=.) ;
recode dxccsr_neo051             (-99 -88 -66=.) ;
recode dxccsr_neo052             (-99 -88 -66=.) ;
recode dxccsr_neo053             (-99 -88 -66=.) ;
recode dxccsr_neo054             (-99 -88 -66=.) ;
recode dxccsr_neo055             (-99 -88 -66=.) ;
recode dxccsr_neo056             (-99 -88 -66=.) ;
recode dxccsr_neo057             (-99 -88 -66=.) ;
recode dxccsr_neo058             (-99 -88 -66=.) ;
recode dxccsr_neo059             (-99 -88 -66=.) ;
recode dxccsr_neo060             (-99 -88 -66=.) ;
recode dxccsr_neo061             (-99 -88 -66=.) ;
recode dxccsr_neo062             (-99 -88 -66=.) ;
recode dxccsr_neo063             (-99 -88 -66=.) ;
recode dxccsr_neo064             (-99 -88 -66=.) ;
recode dxccsr_neo065             (-99 -88 -66=.) ;
recode dxccsr_neo066             (-99 -88 -66=.) ;
recode dxccsr_neo067             (-99 -88 -66=.) ;
recode dxccsr_neo068             (-99 -88 -66=.) ;
recode dxccsr_neo069             (-99 -88 -66=.) ;
recode dxccsr_neo070             (-99 -88 -66=.) ;
recode dxccsr_neo071             (-99 -88 -66=.) ;
recode dxccsr_neo072             (-99 -88 -66=.) ;
recode dxccsr_neo073             (-99 -88 -66=.) ;
recode dxccsr_neo074             (-99 -88 -66=.) ;
recode dxccsr_nvs001             (-99 -88 -66=.) ;
recode dxccsr_nvs002             (-99 -88 -66=.) ;
recode dxccsr_nvs003             (-99 -88 -66=.) ;
recode dxccsr_nvs004             (-99 -88 -66=.) ;
recode dxccsr_nvs005             (-99 -88 -66=.) ;
recode dxccsr_nvs006             (-99 -88 -66=.) ;
recode dxccsr_nvs007             (-99 -88 -66=.) ;
recode dxccsr_nvs008             (-99 -88 -66=.) ;
recode dxccsr_nvs009             (-99 -88 -66=.) ;
recode dxccsr_nvs010             (-99 -88 -66=.) ;
recode dxccsr_nvs011             (-99 -88 -66=.) ;
recode dxccsr_nvs012             (-99 -88 -66=.) ;
recode dxccsr_nvs013             (-99 -88 -66=.) ;
recode dxccsr_nvs014             (-99 -88 -66=.) ;
recode dxccsr_nvs015             (-99 -88 -66=.) ;
recode dxccsr_nvs016             (-99 -88 -66=.) ;
recode dxccsr_nvs017             (-99 -88 -66=.) ;
recode dxccsr_nvs018             (-99 -88 -66=.) ;
recode dxccsr_nvs019             (-99 -88 -66=.) ;
recode dxccsr_nvs020             (-99 -88 -66=.) ;
recode dxccsr_nvs021             (-99 -88 -66=.) ;
recode dxccsr_nvs022             (-99 -88 -66=.) ;
recode dxccsr_pnl001             (-99 -88 -66=.) ;
recode dxccsr_pnl002             (-99 -88 -66=.) ;
recode dxccsr_pnl003             (-99 -88 -66=.) ;
recode dxccsr_pnl004             (-99 -88 -66=.) ;
recode dxccsr_pnl005             (-99 -88 -66=.) ;
recode dxccsr_pnl006             (-99 -88 -66=.) ;
recode dxccsr_pnl007             (-99 -88 -66=.) ;
recode dxccsr_pnl008             (-99 -88 -66=.) ;
recode dxccsr_pnl009             (-99 -88 -66=.) ;
recode dxccsr_pnl010             (-99 -88 -66=.) ;
recode dxccsr_pnl011             (-99 -88 -66=.) ;
recode dxccsr_pnl012             (-99 -88 -66=.) ;
recode dxccsr_pnl013             (-99 -88 -66=.) ;
recode dxccsr_pnl014             (-99 -88 -66=.) ;
recode dxccsr_pnl015             (-99 -88 -66=.) ;
recode dxccsr_prg001             (-99 -88 -66=.) ;
recode dxccsr_prg002             (-99 -88 -66=.) ;
recode dxccsr_prg003             (-99 -88 -66=.) ;
recode dxccsr_prg004             (-99 -88 -66=.) ;
recode dxccsr_prg005             (-99 -88 -66=.) ;
recode dxccsr_prg006             (-99 -88 -66=.) ;
recode dxccsr_prg007             (-99 -88 -66=.) ;
recode dxccsr_prg008             (-99 -88 -66=.) ;
recode dxccsr_prg009             (-99 -88 -66=.) ;
recode dxccsr_prg010             (-99 -88 -66=.) ;
recode dxccsr_prg011             (-99 -88 -66=.) ;
recode dxccsr_prg012             (-99 -88 -66=.) ;
recode dxccsr_prg013             (-99 -88 -66=.) ;
recode dxccsr_prg014             (-99 -88 -66=.) ;
recode dxccsr_prg015             (-99 -88 -66=.) ;
recode dxccsr_prg016             (-99 -88 -66=.) ;
recode dxccsr_prg017             (-99 -88 -66=.) ;
recode dxccsr_prg018             (-99 -88 -66=.) ;
recode dxccsr_prg019             (-99 -88 -66=.) ;
recode dxccsr_prg020             (-99 -88 -66=.) ;
recode dxccsr_prg021             (-99 -88 -66=.) ;
recode dxccsr_prg022             (-99 -88 -66=.) ;
recode dxccsr_prg023             (-99 -88 -66=.) ;
recode dxccsr_prg024             (-99 -88 -66=.) ;
recode dxccsr_prg025             (-99 -88 -66=.) ;
recode dxccsr_prg026             (-99 -88 -66=.) ;
recode dxccsr_prg027             (-99 -88 -66=.) ;
recode dxccsr_prg028             (-99 -88 -66=.) ;
recode dxccsr_prg029             (-99 -88 -66=.) ;
recode dxccsr_prg030             (-99 -88 -66=.) ;
recode dxccsr_rsp001             (-99 -88 -66=.) ;
recode dxccsr_rsp002             (-99 -88 -66=.) ;
recode dxccsr_rsp003             (-99 -88 -66=.) ;
recode dxccsr_rsp004             (-99 -88 -66=.) ;
recode dxccsr_rsp005             (-99 -88 -66=.) ;
recode dxccsr_rsp006             (-99 -88 -66=.) ;
recode dxccsr_rsp007             (-99 -88 -66=.) ;
recode dxccsr_rsp008             (-99 -88 -66=.) ;
recode dxccsr_rsp009             (-99 -88 -66=.) ;
recode dxccsr_rsp010             (-99 -88 -66=.) ;
recode dxccsr_rsp011             (-99 -88 -66=.) ;
recode dxccsr_rsp012             (-99 -88 -66=.) ;
recode dxccsr_rsp013             (-99 -88 -66=.) ;
recode dxccsr_rsp014             (-99 -88 -66=.) ;
recode dxccsr_rsp015             (-99 -88 -66=.) ;
recode dxccsr_rsp016             (-99 -88 -66=.) ;
recode dxccsr_rsp017             (-99 -88 -66=.) ;
recode dxccsr_skn001             (-99 -88 -66=.) ;
recode dxccsr_skn002             (-99 -88 -66=.) ;
recode dxccsr_skn003             (-99 -88 -66=.) ;
recode dxccsr_skn004             (-99 -88 -66=.) ;
recode dxccsr_skn005             (-99 -88 -66=.) ;
recode dxccsr_skn006             (-99 -88 -66=.) ;
recode dxccsr_skn007             (-99 -88 -66=.) ;
recode dxccsr_sym001             (-99 -88 -66=.) ;
recode dxccsr_sym002             (-99 -88 -66=.) ;
recode dxccsr_sym003             (-99 -88 -66=.) ;
recode dxccsr_sym004             (-99 -88 -66=.) ;
recode dxccsr_sym005             (-99 -88 -66=.) ;
recode dxccsr_sym006             (-99 -88 -66=.) ;
recode dxccsr_sym007             (-99 -88 -66=.) ;
recode dxccsr_sym008             (-99 -88 -66=.) ;
recode dxccsr_sym009             (-99 -88 -66=.) ;
recode dxccsr_sym010             (-99 -88 -66=.) ;
recode dxccsr_sym011             (-99 -88 -66=.) ;
recode dxccsr_sym012             (-99 -88 -66=.) ;
recode dxccsr_sym013             (-99 -88 -66=.) ;
recode dxccsr_sym014             (-99 -88 -66=.) ;
recode dxccsr_sym015             (-99 -88 -66=.) ;
recode dxccsr_sym016             (-99 -88 -66=.) ;
recode dxccsr_sym017             (-99 -88 -66=.) ;
recode cmr_aids                  (-99 -88 -66=.) ;
recode cmr_alcohol               (-99 -88 -66=.) ;
recode cmr_autoimmune            (-99 -88 -66=.) ;
recode cmr_cancer_lymph          (-99 -88 -66=.) ;
recode cmr_cancer_leuk           (-99 -88 -66=.) ;
recode cmr_cancer_mets           (-99 -88 -66=.) ;
recode cmr_cancer_nsitu          (-99 -88 -66=.) ;
recode cmr_cancer_solid          (-99 -88 -66=.) ;
recode cmr_dementia              (-99 -88 -66=.) ;
recode cmr_depress               (-99 -88 -66=.) ;
recode cmr_diab_uncx             (-99 -88 -66=.) ;
recode cmr_diab_cx               (-99 -88 -66=.) ;
recode cmr_drug_abuse            (-99 -88 -66=.) ;
recode cmr_htn_cx                (-99 -88 -66=.) ;
recode cmr_htn_uncx              (-99 -88 -66=.) ;
recode cmr_lung_chronic          (-99 -88 -66=.) ;
recode cmr_obese                 (-99 -88 -66=.) ;
recode cmr_perivasc              (-99 -88 -66=.) ;
recode cmr_thyroid_hypo          (-99 -88 -66=.) ;
recode cmr_thyroid_oth           (-99 -88 -66=.) ;

describe;

save "NASS_2021_DX_PR_GRPS.dta", replace;
#delimit cr
