/*****************************************************************************/
/* SPSSload_NASS_2019_Supplemental.SPS                                          */
/* This program will load the NASS 2019 Supplemental csv File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NASS_2019_Supplemental.csv"
    /delimiters = ',' 
    /variables = 
    HOSP_NASS                F5.0
    KEY_NASS                 F8.0
    YEAR                     F4.0
    NCPT_NOTINSCOPE          F3.0
    CPTCCS1                  F4.0
    CPTCCS2                  F4.0
    CPTCCS3                  F4.0
    CPTCCS4                  F4.0
    CPTCCS5                  F4.0
    CPTCCS6                  F4.0
    CPTCCS7                  F4.0
    CPTCCS8                  F4.0
    CPTCCS9                  F4.0
    CPTCCS10                 F4.0
    CPTCCS11                 F4.0
    CPTCCS12                 F4.0
    CPTCCS13                 F4.0
    CPTCCS14                 F4.0
    CPTCCS15                 F4.0
    CPTCCS16                 F4.0
    CPTCCS17                 F4.0
    CPTCCS18                 F4.0
    CPTCCS19                 F4.0
    CPTCCS20                 F4.0
    CPTCCS21                 F4.0
    CPTCCS22                 F4.0
    CPTCCS23                 F4.0
    CPTCCS24                 F4.0
    CPTCCS25                 F4.0
    CPTCCS26                 F4.0
    CPTCCS27                 F4.0
    CPTCCS28                 F4.0
    CPTCCS29                 F4.0
    CPTCCS30                 F4.0
    CPT1                     A5
    CPT2                     A5
    CPT3                     A5
    CPT4                     A5
    CPT5                     A5
    CPT6                     A5
    CPT7                     A5
    CPT8                     A5
    CPT9                     A5
    CPT10                    A5
    CPT11                    A5
    CPT12                    A5
    CPT13                    A5
    CPT14                    A5
    CPT15                    A5
    CPT16                    A5
    CPT17                    A5
    CPT18                    A5
    CPT19                    A5
    CPT20                    A5
    CPT21                    A5
    CPT22                    A5
    CPT23                    A5
    CPT24                    A5
    CPT25                    A5
    CPT26                    A5
    CPT27                    A5
    CPT28                    A5
    CPT29                    A5
    CPT30                    A5
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    HOSP_NASS                "NASS Hospital Number"
    KEY_NASS                 "NASS record number"
    YEAR                     "Data Year"
    NCPT_NOTINSCOPE          "# Out-of-scope CPTs for this encounter"
    CPTCCS1                  "CPT 1 Procedure CCS"
    CPTCCS2                  "CPT 2 Procedure CCS"
    CPTCCS3                  "CPT 3 Procedure CCS"
    CPTCCS4                  "CPT 4 Procedure CCS"
    CPTCCS5                  "CPT 5 Procedure CCS"
    CPTCCS6                  "CPT 6 Procedure CCS"
    CPTCCS7                  "CPT 7 Procedure CCS"
    CPTCCS8                  "CPT 8 Procedure CCS"
    CPTCCS9                  "CPT 9 Procedure CCS"
    CPTCCS10                 "CPT 10 Procedure CCS"
    CPTCCS11                 "CPT 11 Procedure CCS"
    CPTCCS12                 "CPT 12 Procedure CCS"
    CPTCCS13                 "CPT 13 Procedure CCS"
    CPTCCS14                 "CPT 14 Procedure CCS"
    CPTCCS15                 "CPT 15 Procedure CCS"
    CPTCCS16                 "CPT 16 Procedure CCS"
    CPTCCS17                 "CPT 17 Procedure CCS"
    CPTCCS18                 "CPT 18 Procedure CCS"
    CPTCCS19                 "CPT 19 Procedure CCS"
    CPTCCS20                 "CPT 20 Procedure CCS"
    CPTCCS21                 "CPT 21 Procedure CCS"
    CPTCCS22                 "CPT 22 Procedure CCS"
    CPTCCS23                 "CPT 23 Procedure CCS"
    CPTCCS24                 "CPT 24 Procedure CCS"
    CPTCCS25                 "CPT 25 Procedure CCS"
    CPTCCS26                 "CPT 26 Procedure CCS"
    CPTCCS27                 "CPT 27 Procedure CCS"
    CPTCCS28                 "CPT 28 Procedure CCS"
    CPTCCS29                 "CPT 29 Procedure CCS"
    CPTCCS30                 "CPT 30 Procedure CCS"
    CPT1                     "CPT Procedure 1"
    CPT2                     "CPT Procedure 2"
    CPT3                     "CPT Procedure 3"
    CPT4                     "CPT Procedure 4"
    CPT5                     "CPT Procedure 5"
    CPT6                     "CPT Procedure 6"
    CPT7                     "CPT Procedure 7"
    CPT8                     "CPT Procedure 8"
    CPT9                     "CPT Procedure 9"
    CPT10                    "CPT Procedure 10"
    CPT11                    "CPT Procedure 11"
    CPT12                    "CPT Procedure 12"
    CPT13                    "CPT Procedure 13"
    CPT14                    "CPT Procedure 14"
    CPT15                    "CPT Procedure 15"
    CPT16                    "CPT Procedure 16"
    CPT17                    "CPT Procedure 17"
    CPT18                    "CPT Procedure 18"
    CPT19                    "CPT Procedure 19"
    CPT20                    "CPT Procedure 20"
    CPT21                    "CPT Procedure 21"
    CPT22                    "CPT Procedure 22"
    CPT23                    "CPT Procedure 23"
    CPT24                    "CPT Procedure 24"
    CPT25                    "CPT Procedure 25"
    CPT26                    "CPT Procedure 26"
    CPT27                    "CPT Procedure 27"
    CPT28                    "CPT Procedure 28"
    CPT29                    "CPT Procedure 29"
    CPT30                    "CPT Procedure 30" .

/* Convert special values to system missing values */
RECODE HOSP_NASS                (-9999 -8888 -6666=SYSMIS).
RECODE KEY_NASS                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE NCPT_NOTINSCOPE          (-99 -88 -66=SYSMIS).
RECODE CPTCCS1                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS2                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS3                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS4                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS5                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS6                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS7                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS8                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS9                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS10                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS11                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS12                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS13                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS14                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS15                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS16                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS17                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS18                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS19                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS20                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS21                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS22                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS23                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS24                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS25                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS26                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS27                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS28                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS29                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS30                 (-999 -888 -666=SYSMIS).

SAVE OUTFILE = 'NASS_2019_Supplemental.SAV' / COMPRESSED.
