/*****************************************************************************
* Stataload_KID_2012_Core.Do
* This program will load the 2012 KID ASCII Core File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix long   HOSP_KID                    1-  5   ///
      long   RECNUM                      6- 13   ///
      int    AGE                        14- 16   ///
      byte   AGE_NEONATE                17- 18   ///
      byte   AMONTH                     19- 20   ///
      byte   AWEEKEND                   21- 22   ///
      byte   DIED                       23- 24   ///
      double DISCWT                     25- 35   ///
      byte   DISPUNIFORM                36- 37   ///
      byte   DQTR                       38- 39   ///
      int    DRG                        40- 42   ///
      int    DRG24                      43- 45   ///
      byte   DRGVER                     46- 47   ///
      int    DRG_NoPOA                  48- 50   ///
      str    DX1                        51- 55   ///
      str    DX2                        56- 60   ///
      str    DX3                        61- 65   ///
      str    DX4                        66- 70   ///
      str    DX5                        71- 75   ///
      str    DX6                        76- 80   ///
      str    DX7                        81- 85   ///
      str    DX8                        86- 90   ///
      str    DX9                        91- 95   ///
      str    DX10                       96-100   ///
      str    DX11                      101-105   ///
      str    DX12                      106-110   ///
      str    DX13                      111-115   ///
      str    DX14                      116-120   ///
      str    DX15                      121-125   ///
      str    DX16                      126-130   ///
      str    DX17                      131-135   ///
      str    DX18                      136-140   ///
      str    DX19                      141-145   ///
      str    DX20                      146-150   ///
      str    DX21                      151-155   ///
      str    DX22                      156-160   ///
      str    DX23                      161-165   ///
      str    DX24                      166-170   ///
      str    DX25                      171-175   ///
      int    DXCCS1                    176-178   ///
      int    DXCCS2                    179-181   ///
      int    DXCCS3                    182-184   ///
      int    DXCCS4                    185-187   ///
      int    DXCCS5                    188-190   ///
      int    DXCCS6                    191-193   ///
      int    DXCCS7                    194-196   ///
      int    DXCCS8                    197-199   ///
      int    DXCCS9                    200-202   ///
      int    DXCCS10                   203-205   ///
      int    DXCCS11                   206-208   ///
      int    DXCCS12                   209-211   ///
      int    DXCCS13                   212-214   ///
      int    DXCCS14                   215-217   ///
      int    DXCCS15                   218-220   ///
      int    DXCCS16                   221-223   ///
      int    DXCCS17                   224-226   ///
      int    DXCCS18                   227-229   ///
      int    DXCCS19                   230-232   ///
      int    DXCCS20                   233-235   ///
      int    DXCCS21                   236-238   ///
      int    DXCCS22                   239-241   ///
      int    DXCCS23                   242-244   ///
      int    DXCCS24                   245-247   ///
      int    DXCCS25                   248-250   ///
      str    ECODE1                    251-255   ///
      str    ECODE2                    256-260   ///
      str    ECODE3                    261-265   ///
      str    ECODE4                    266-270   ///
      byte   ELECTIVE                  271-272   ///
      int    E_CCS1                    273-276   ///
      int    E_CCS2                    277-280   ///
      int    E_CCS3                    281-284   ///
      int    E_CCS4                    285-288   ///
      byte   FEMALE                    289-290   ///
      int    HCUP_ED                   291-293   ///
      byte   HOSPBRTH                  294-295   ///
      byte   HOSP_REGION               296-297   ///
      int    KID_STRATUM               298-301   ///
      long   LOS                       302-306   ///
      byte   MDC                       307-308   ///
      byte   MDC24                     309-310   ///
      byte   MDC_NoPOA                 311-312   ///
      byte   NCHRONIC                  313-314   ///
      byte   NDX                       315-316   ///
      int    NECODE                    317-319   ///
      byte   NEOMAT                    320-321   ///
      byte   NPR                       322-323   ///
      byte   ORPROC                    324-325   ///
      byte   PAY1                      326-327   ///
      int    PL_NCHS2006               328-330   ///
      str    PR1                       331-334   ///
      str    PR2                       335-338   ///
      str    PR3                       339-342   ///
      str    PR4                       343-346   ///
      str    PR5                       347-350   ///
      str    PR6                       351-354   ///
      str    PR7                       355-358   ///
      str    PR8                       359-362   ///
      str    PR9                       363-366   ///
      str    PR10                      367-370   ///
      str    PR11                      371-374   ///
      str    PR12                      375-378   ///
      str    PR13                      379-382   ///
      str    PR14                      383-386   ///
      str    PR15                      387-390   ///
      int    PRCCS1                    391-393   ///
      int    PRCCS2                    394-396   ///
      int    PRCCS3                    397-399   ///
      int    PRCCS4                    400-402   ///
      int    PRCCS5                    403-405   ///
      int    PRCCS6                    406-408   ///
      int    PRCCS7                    409-411   ///
      int    PRCCS8                    412-414   ///
      int    PRCCS9                    415-417   ///
      int    PRCCS10                   418-420   ///
      int    PRCCS11                   421-423   ///
      int    PRCCS12                   424-426   ///
      int    PRCCS13                   427-429   ///
      int    PRCCS14                   430-432   ///
      int    PRCCS15                   433-435   ///
      int    PRDAY1                    436-438   ///
      int    PRDAY2                    439-441   ///
      int    PRDAY3                    442-444   ///
      int    PRDAY4                    445-447   ///
      int    PRDAY5                    448-450   ///
      int    PRDAY6                    451-453   ///
      int    PRDAY7                    454-456   ///
      int    PRDAY8                    457-459   ///
      int    PRDAY9                    460-462   ///
      int    PRDAY10                   463-465   ///
      int    PRDAY11                   466-468   ///
      int    PRDAY12                   469-471   ///
      int    PRDAY13                   472-474   ///
      int    PRDAY14                   475-477   ///
      int    PRDAY15                   478-480   ///
      byte   RACE                      481-482   ///
      double TOTCHG                    483-492   ///
      byte   TRAN_IN                   493-494   ///
      byte   TRAN_OUT                  495-496   ///
      byte   UNCBRTH                   497-498   ///
      int    YEAR                      499-502   ///
      byte   ZIPINC_QRTL               503-504   ///
      using  "KID_2012_Core.ASC"

***  Assign labels to the data elements ***
label var HOSP_KID                 "KID hospital number"
label var RECNUM                   "KID record number"
label var AGE                      "Age in years at admission"
label var AGE_NEONATE              "Neonatal age (first 28 days after birth) indicator"
label var AMONTH                   "Admission month"
label var AWEEKEND                 "Admission day is a weekend"
label var DIED                     "Died during hospitalization"
label var DISCWT                   "KID discharge weight"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DQTR                     "Discharge quarter"
label var DRG                      "DRG in effect on discharge date"
label var DRG24                    "DRG, version 24"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
label var DX1                      "Diagnosis 1"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DX10                     "Diagnosis 10"
label var DX11                     "Diagnosis 11"
label var DX12                     "Diagnosis 12"
label var DX13                     "Diagnosis 13"
label var DX14                     "Diagnosis 14"
label var DX15                     "Diagnosis 15"
label var DX16                     "Diagnosis 16"
label var DX17                     "Diagnosis 17"
label var DX18                     "Diagnosis 18"
label var DX19                     "Diagnosis 19"
label var DX20                     "Diagnosis 20"
label var DX21                     "Diagnosis 21"
label var DX22                     "Diagnosis 22"
label var DX23                     "Diagnosis 23"
label var DX24                     "Diagnosis 24"
label var DX25                     "Diagnosis 25"
label var DXCCS1                   "CCS: diagnosis 1"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXCCS10                  "CCS: diagnosis 10"
label var DXCCS11                  "CCS: diagnosis 11"
label var DXCCS12                  "CCS: diagnosis 12"
label var DXCCS13                  "CCS: diagnosis 13"
label var DXCCS14                  "CCS: diagnosis 14"
label var DXCCS15                  "CCS: diagnosis 15"
label var DXCCS16                  "CCS: diagnosis 16"
label var DXCCS17                  "CCS: diagnosis 17"
label var DXCCS18                  "CCS: diagnosis 18"
label var DXCCS19                  "CCS: diagnosis 19"
label var DXCCS20                  "CCS: diagnosis 20"
label var DXCCS21                  "CCS: diagnosis 21"
label var DXCCS22                  "CCS: diagnosis 22"
label var DXCCS23                  "CCS: diagnosis 23"
label var DXCCS24                  "CCS: diagnosis 24"
label var DXCCS25                  "CCS: diagnosis 25"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var ELECTIVE                 "Elective versus non-elective admission"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HOSPBRTH                 "Indicator of birth in this hospital"
label var HOSP_REGION              "Region of hospital"
label var KID_STRATUM              "Stratum used to sample hospital"
label var LOS                      "Length of stay (cleaned)"
label var MDC                      "MDC in effect on discharge date"
label var MDC24                    "MDC, version 24"
label var MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
label var NCHRONIC                 "Number of chronic conditions"
label var NDX                      "Number of diagnoses on this record"
label var NECODE                   "Number of E codes on this record"
label var NEOMAT                   "Neonatal and/or maternal DX and/or PR"
label var NPR                      "Number of procedures on this record"
label var ORPROC                   "Major operating room procedure indicator"
label var PAY1                     "Primary expected payer (uniform)"
label var PL_NCHS2006              "Patient Location: NCHS Urban-Rural Code (V2006)"
label var PR1                      "Procedure 1"
label var PR2                      "Procedure 2"
label var PR3                      "Procedure 3"
label var PR4                      "Procedure 4"
label var PR5                      "Procedure 5"
label var PR6                      "Procedure 6"
label var PR7                      "Procedure 7"
label var PR8                      "Procedure 8"
label var PR9                      "Procedure 9"
label var PR10                     "Procedure 10"
label var PR11                     "Procedure 11"
label var PR12                     "Procedure 12"
label var PR13                     "Procedure 13"
label var PR14                     "Procedure 14"
label var PR15                     "Procedure 15"
label var PRCCS1                   "CCS: procedure 1"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRCCS7                   "CCS: procedure 7"
label var PRCCS8                   "CCS: procedure 8"
label var PRCCS9                   "CCS: procedure 9"
label var PRCCS10                  "CCS: procedure 10"
label var PRCCS11                  "CCS: procedure 11"
label var PRCCS12                  "CCS: procedure 12"
label var PRCCS13                  "CCS: procedure 13"
label var PRCCS14                  "CCS: procedure 14"
label var PRCCS15                  "CCS: procedure 15"
label var PRDAY1                   "Number of days from admission to PR1"
label var PRDAY2                   "Number of days from admission to PR2"
label var PRDAY3                   "Number of days from admission to PR3"
label var PRDAY4                   "Number of days from admission to PR4"
label var PRDAY5                   "Number of days from admission to PR5"
label var PRDAY6                   "Number of days from admission to PR6"
label var PRDAY7                   "Number of days from admission to PR7"
label var PRDAY8                   "Number of days from admission to PR8"
label var PRDAY9                   "Number of days from admission to PR9"
label var PRDAY10                  "Number of days from admission to PR10"
label var PRDAY11                  "Number of days from admission to PR11"
label var PRDAY12                  "Number of days from admission to PR12"
label var PRDAY13                  "Number of days from admission to PR13"
label var PRDAY14                  "Number of days from admission to PR14"
label var PRDAY15                  "Number of days from admission to PR15"
label var RACE                     "Race (uniform)"
label var TOTCHG                   "Total charges (cleaned)"
label var TRAN_IN                  "Transfer in indicator"
label var TRAN_OUT                 "Transfer out indicator"
label var UNCBRTH                  "Normal uncomplicated birth in hospital"
label var YEAR                     "Calendar year"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"

*** Convert special values to missing values ***
recode HOSP_KID                  (-9999 -8888 -6666=.)
recode RECNUM                    (-9999999 -8888888 -6666666=.)
recode AGE                       (-99 -88 -66=.)
recode AGE_NEONATE               (-9 -8 -6 -5=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISCWT                    (-99.9999999 -88.8888888 -66.6666666=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DRG                       (-99 -88 -66=.)
recode DRG24                     (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode DRG_NoPOA                 (-99 -88 -66=.)
recode DXCCS1                    (-99 -88 -66=.)
recode DXCCS2                    (-99 -88 -66=.)
recode DXCCS3                    (-99 -88 -66=.)
recode DXCCS4                    (-99 -88 -66=.)
recode DXCCS5                    (-99 -88 -66=.)
recode DXCCS6                    (-99 -88 -66=.)
recode DXCCS7                    (-99 -88 -66=.)
recode DXCCS8                    (-99 -88 -66=.)
recode DXCCS9                    (-99 -88 -66=.)
recode DXCCS10                   (-99 -88 -66=.)
recode DXCCS11                   (-99 -88 -66=.)
recode DXCCS12                   (-99 -88 -66=.)
recode DXCCS13                   (-99 -88 -66=.)
recode DXCCS14                   (-99 -88 -66=.)
recode DXCCS15                   (-99 -88 -66=.)
recode DXCCS16                   (-99 -88 -66=.)
recode DXCCS17                   (-99 -88 -66=.)
recode DXCCS18                   (-99 -88 -66=.)
recode DXCCS19                   (-99 -88 -66=.)
recode DXCCS20                   (-99 -88 -66=.)
recode DXCCS21                   (-99 -88 -66=.)
recode DXCCS22                   (-99 -88 -66=.)
recode DXCCS23                   (-99 -88 -66=.)
recode DXCCS24                   (-99 -88 -66=.)
recode DXCCS25                   (-99 -88 -66=.)
recode ELECTIVE                  (-9 -8 -6 -5=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-99 -88 -66=.)
recode HOSPBRTH                  (-9 -8 -6 -5=.)
recode HOSP_REGION               (-9 -8 -6 -5=.)
recode KID_STRATUM               (-999 -888 -666=.)
recode LOS                       (-9999 -8888 -6666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC24                     (-9 -8 -6 -5=.)
recode MDC_NoPOA                 (-9 -8 -6 -5=.)
recode NCHRONIC                  (-9 -8 -6 -5=.)
recode NDX                       (-9 -8 -6 -5=.)
recode NECODE                    (-99 -88 -66=.)
recode NEOMAT                    (-9 -8 -6 -5=.)
recode NPR                       (-9 -8 -6 -5=.)
recode ORPROC                    (-9 -8 -6 -5=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PL_NCHS2006               (-99 -88 -66=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRCCS7                    (-99 -88 -66=.)
recode PRCCS8                    (-99 -88 -66=.)
recode PRCCS9                    (-99 -88 -66=.)
recode PRCCS10                   (-99 -88 -66=.)
recode PRCCS11                   (-99 -88 -66=.)
recode PRCCS12                   (-99 -88 -66=.)
recode PRCCS13                   (-99 -88 -66=.)
recode PRCCS14                   (-99 -88 -66=.)
recode PRCCS15                   (-99 -88 -66=.)
recode PRDAY1                    (-99 -88 -66=.)
recode PRDAY2                    (-99 -88 -66=.)
recode PRDAY3                    (-99 -88 -66=.)
recode PRDAY4                    (-99 -88 -66=.)
recode PRDAY5                    (-99 -88 -66=.)
recode PRDAY6                    (-99 -88 -66=.)
recode PRDAY7                    (-99 -88 -66=.)
recode PRDAY8                    (-99 -88 -66=.)
recode PRDAY9                    (-99 -88 -66=.)
recode PRDAY10                   (-99 -88 -66=.)
recode PRDAY11                   (-99 -88 -66=.)
recode PRDAY12                   (-99 -88 -66=.)
recode PRDAY13                   (-99 -88 -66=.)
recode PRDAY14                   (-99 -88 -66=.)
recode PRDAY15                   (-99 -88 -66=.)
recode RACE                      (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TRAN_IN                   (-9 -8 -6 -5=.)
recode TRAN_OUT                  (-9 -8 -6 -5=.)
recode UNCBRTH                   (-9 -8 -6 -5=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-9 -8 -6 -5=.)

save "KID_2012_Core.dta", replace
