/*****************************************************************************
* SPSSload_KID_2022_Severity.SPS
* This program will load the KID_2022_Severity ASCII File into SPSS.
* Created on 11/07/2024.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'KID_2022_Severity.ASC' FIXED / 
    HOSP_KID                    1-   5
    RECNUM                      6-  13
    APRDRG                     14-  17
    APRDRG_Risk_Mortality      18-  19
    APRDRG_Severity            20-  21.

***  Specify write formats  ***.
FORMATS
    HOSP_KID                 (F5.0) /
    RECNUM                   (F8.0) /
    APRDRG                   (F4.0) /
    APRDRG_Risk_Mortality    (F2.0) /
    APRDRG_Severity          (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSP_KID                 "KID hospital number"
    RECNUM                   "KID record number"
    APRDRG                   "All Patient Refined DRG"
    APRDRG_Risk_Mortality    "All Patient Refined DRG: Risk of Mortality Subclass"
    APRDRG_Severity          "All Patient Refined DRG: Severity of Illness Subclass" .

*** Convert special values to system missing values ***.
RECODE HOSP_KID                 (-9999 -8888 -6666=SYSMIS).
RECODE RECNUM                   (-9999999 -8888888 -6666666=SYSMIS).
RECODE APRDRG                   (-999 -888 -666=SYSMIS).
RECODE APRDRG_Risk_Mortality    (-9 -8 -6 -5=SYSMIS).
RECODE APRDRG_Severity          (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'KID_2022_Severity.SAV' / COMPRESSED.
