/*****************************************************************************
* SASload_KID_2016_Core.SAS
* This program will load the KID_2016_Core ASCII File into SAS.
*****************************************************************************/

*** Create SAS informats for missing values ***;
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

*** Data Step to load the file ***;
DATA KID_2016_Core; 
INFILE 'KID_2016_Core.ASC' LRECL = 499;

*** Define data element attributes ***;
ATTRIB 
  HOSP_KID                   LENGTH=4            FORMAT=Z5.
  LABEL="KID hospital number"

  RECNUM                     LENGTH=5            FORMAT=Z8.
  LABEL="KID record number"

  AGE                        LENGTH=3
  LABEL="Age in years at admission"

  AGE_NEONATE                LENGTH=3
  LABEL="Neonatal age (first 28 days after birth) indicator"

  AMONTH                     LENGTH=3
  LABEL="Admission month"

  AWEEKEND                   LENGTH=3
  LABEL="Admission day is a weekend"

  DIED                       LENGTH=3
  LABEL="Died during hospitalization"

  DISCWT                     LENGTH=8
  LABEL="KID discharge weight"

  DISPUNIFORM                LENGTH=3
  LABEL="Disposition of patient (uniform)"

  DQTR                       LENGTH=3
  LABEL="Discharge quarter"

  DRG                        LENGTH=3
  LABEL="DRG in effect on discharge date"

  DRGVER                     LENGTH=3
  LABEL="DRG grouper version used on discharge date"

  DRG_NoPOA                  LENGTH=3
  LABEL="DRG in use on discharge date, calculated without POA"

  DXVER                      LENGTH=3
  LABEL="Diagnosis Version"

  ELECTIVE                   LENGTH=3
  LABEL="Elective versus non-elective admission"

  FEMALE                     LENGTH=3
  LABEL="Indicator of sex"

  HCUP_ED                    LENGTH=3
  LABEL="HCUP Emergency Department service indicator"

  HOSP_REGION                LENGTH=3
  LABEL="Region of hospital"

  I10_DX1                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 1"

  I10_DX2                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 2"

  I10_DX3                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 3"

  I10_DX4                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 4"

  I10_DX5                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 5"

  I10_DX6                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 6"

  I10_DX7                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 7"

  I10_DX8                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 8"

  I10_DX9                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 9"

  I10_DX10                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 10"

  I10_DX11                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 11"

  I10_DX12                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 12"

  I10_DX13                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 13"

  I10_DX14                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 14"

  I10_DX15                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 15"

  I10_DX16                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 16"

  I10_DX17                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 17"

  I10_DX18                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 18"

  I10_DX19                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 19"

  I10_DX20                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 20"

  I10_DX21                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 21"

  I10_DX22                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 22"

  I10_DX23                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 23"

  I10_DX24                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 24"

  I10_DX25                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 25"

  I10_DX26                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 26"

  I10_DX27                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 27"

  I10_DX28                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 28"

  I10_DX29                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 29"

  I10_DX30                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 30"

  I10_ECAUSE1                LENGTH=$7
  LABEL="ICD-10-CM External cause 1"

  I10_ECAUSE2                LENGTH=$7
  LABEL="ICD-10-CM External cause 2"

  I10_ECAUSE3                LENGTH=$7
  LABEL="ICD-10-CM External cause 3"

  I10_ECAUSE4                LENGTH=$7
  LABEL="ICD-10-CM External cause 4"

  I10_HOSPBRTH               LENGTH=3
  LABEL="ICD-10-CM Indicator of birth in this hospital"

  I10_NDX                    LENGTH=3
  LABEL="ICD-10-CM Number of diagnoses on this record"

  I10_NECAUSE                LENGTH=3
  LABEL="ICD-10-CM Number of External cause codes on this record"

  I10_NPR                    LENGTH=3
  LABEL="ICD-10-PCS Number of procedures on this record"

  I10_PR1                    LENGTH=$7
  LABEL="ICD-10-PCS Procedure 1"

  I10_PR2                    LENGTH=$7
  LABEL="ICD-10-PCS Procedure 2"

  I10_PR3                    LENGTH=$7
  LABEL="ICD-10-PCS Procedure 3"

  I10_PR4                    LENGTH=$7
  LABEL="ICD-10-PCS Procedure 4"

  I10_PR5                    LENGTH=$7
  LABEL="ICD-10-PCS Procedure 5"

  I10_PR6                    LENGTH=$7
  LABEL="ICD-10-PCS Procedure 6"

  I10_PR7                    LENGTH=$7
  LABEL="ICD-10-PCS Procedure 7"

  I10_PR8                    LENGTH=$7
  LABEL="ICD-10-PCS Procedure 8"

  I10_PR9                    LENGTH=$7
  LABEL="ICD-10-PCS Procedure 9"

  I10_PR10                   LENGTH=$7
  LABEL="ICD-10-PCS Procedure 10"

  I10_PR11                   LENGTH=$7
  LABEL="ICD-10-PCS Procedure 11"

  I10_PR12                   LENGTH=$7
  LABEL="ICD-10-PCS Procedure 12"

  I10_PR13                   LENGTH=$7
  LABEL="ICD-10-PCS Procedure 13"

  I10_PR14                   LENGTH=$7
  LABEL="ICD-10-PCS Procedure 14"

  I10_PR15                   LENGTH=$7
  LABEL="ICD-10-PCS Procedure 15"

  I10_UNCBRTH                LENGTH=3
  LABEL="Normal uncomplicated birth in hospital"

  KID_STRATUM                LENGTH=4
  LABEL="Stratum used to sample hospital"

  LOS                        LENGTH=4
  LABEL="Length of stay (cleaned)"

  MDC                        LENGTH=3
  LABEL="MDC in effect on discharge date"

  MDC_NoPOA                  LENGTH=3
  LABEL="MDC in use on discharge date, calculated without POA"

  PAY1                       LENGTH=3
  LABEL="Primary expected payer (uniform)"

  PL_NCHS                    LENGTH=3
  LABEL="Patient Location: NCHS Urban-Rural Code"

  PRDAY1                     LENGTH=4
  LABEL="Number of days from admission to I10_PR1"

  PRDAY2                     LENGTH=4
  LABEL="Number of days from admission to I10_PR2"

  PRDAY3                     LENGTH=4
  LABEL="Number of days from admission to I10_PR3"

  PRDAY4                     LENGTH=4
  LABEL="Number of days from admission to I10_PR4"

  PRDAY5                     LENGTH=4
  LABEL="Number of days from admission to I10_PR5"

  PRDAY6                     LENGTH=4
  LABEL="Number of days from admission to I10_PR6"

  PRDAY7                     LENGTH=4
  LABEL="Number of days from admission to I10_PR7"

  PRDAY8                     LENGTH=4
  LABEL="Number of days from admission to I10_PR8"

  PRDAY9                     LENGTH=4
  LABEL="Number of days from admission to I10_PR9"

  PRDAY10                    LENGTH=4
  LABEL="Number of days from admission to I10_PR10"

  PRDAY11                    LENGTH=4
  LABEL="Number of days from admission to I10_PR11"

  PRDAY12                    LENGTH=4
  LABEL="Number of days from admission to I10_PR12"

  PRDAY13                    LENGTH=4
  LABEL="Number of days from admission to I10_PR13"

  PRDAY14                    LENGTH=4
  LABEL="Number of days from admission to I10_PR14"

  PRDAY15                    LENGTH=4
  LABEL="Number of days from admission to I10_PR15"

  PRVER                      LENGTH=3
  LABEL="Procedure Version"

  RACE                       LENGTH=3
  LABEL="Race (uniform)"

  TOTCHG                     LENGTH=6
  LABEL="Total charges (cleaned)"

  TRAN_IN                    LENGTH=3
  LABEL="Transfer in indicator"

  TRAN_OUT                   LENGTH=3
  LABEL="Transfer out indicator"

  YEAR                       LENGTH=3
  LABEL="Calendar year"

  ZIPINC_QRTL                LENGTH=3
  LABEL="Median household income national quartile for patient ZIP Code"
  ;

*** Read data elements from the ASCII file ***;
INPUT 
      @1      HOSP_KID                 N5PF.
      @6      RECNUM                   N8PF.
      @14     AGE                      N3PF.
      @17     AGE_NEONATE              N2PF.
      @19     AMONTH                   N2PF.
      @21     AWEEKEND                 N2PF.
      @23     DIED                     N2PF.
      @25     DISCWT                   N11P7F.
      @36     DISPUNIFORM              N2PF.
      @38     DQTR                     N2PF.
      @40     DRG                      N3PF.
      @43     DRGVER                   N2PF.
      @45     DRG_NoPOA                N3PF.
      @48     DXVER                    N2PF.
      @50     ELECTIVE                 N2PF.
      @52     FEMALE                   N2PF.
      @54     HCUP_ED                  N3PF.
      @57     HOSP_REGION              N2PF.
      @59     I10_DX1                  $CHAR7.
      @66     I10_DX2                  $CHAR7.
      @73     I10_DX3                  $CHAR7.
      @80     I10_DX4                  $CHAR7.
      @87     I10_DX5                  $CHAR7.
      @94     I10_DX6                  $CHAR7.
      @101    I10_DX7                  $CHAR7.
      @108    I10_DX8                  $CHAR7.
      @115    I10_DX9                  $CHAR7.
      @122    I10_DX10                 $CHAR7.
      @129    I10_DX11                 $CHAR7.
      @136    I10_DX12                 $CHAR7.
      @143    I10_DX13                 $CHAR7.
      @150    I10_DX14                 $CHAR7.
      @157    I10_DX15                 $CHAR7.
      @164    I10_DX16                 $CHAR7.
      @171    I10_DX17                 $CHAR7.
      @178    I10_DX18                 $CHAR7.
      @185    I10_DX19                 $CHAR7.
      @192    I10_DX20                 $CHAR7.
      @199    I10_DX21                 $CHAR7.
      @206    I10_DX22                 $CHAR7.
      @213    I10_DX23                 $CHAR7.
      @220    I10_DX24                 $CHAR7.
      @227    I10_DX25                 $CHAR7.
      @234    I10_DX26                 $CHAR7.
      @241    I10_DX27                 $CHAR7.
      @248    I10_DX28                 $CHAR7.
      @255    I10_DX29                 $CHAR7.
      @262    I10_DX30                 $CHAR7.
      @269    I10_ECAUSE1              $CHAR7.
      @276    I10_ECAUSE2              $CHAR7.
      @283    I10_ECAUSE3              $CHAR7.
      @290    I10_ECAUSE4              $CHAR7.
      @297    I10_HOSPBRTH             N2PF.
      @299    I10_NDX                  N2PF.
      @301    I10_NECAUSE              N3PF.
      @304    I10_NPR                  N2PF.
      @306    I10_PR1                  $CHAR7.
      @313    I10_PR2                  $CHAR7.
      @320    I10_PR3                  $CHAR7.
      @327    I10_PR4                  $CHAR7.
      @334    I10_PR5                  $CHAR7.
      @341    I10_PR6                  $CHAR7.
      @348    I10_PR7                  $CHAR7.
      @355    I10_PR8                  $CHAR7.
      @362    I10_PR9                  $CHAR7.
      @369    I10_PR10                 $CHAR7.
      @376    I10_PR11                 $CHAR7.
      @383    I10_PR12                 $CHAR7.
      @390    I10_PR13                 $CHAR7.
      @397    I10_PR14                 $CHAR7.
      @404    I10_PR15                 $CHAR7.
      @411    I10_UNCBRTH              N2PF.
      @413    KID_STRATUM              N4PF.
      @417    LOS                      N5PF.
      @422    MDC                      N2PF.
      @424    MDC_NoPOA                N2PF.
      @426    PAY1                     N2PF.
      @428    PL_NCHS                  N3PF.
      @431    PRDAY1                   N3PF.
      @434    PRDAY2                   N3PF.
      @437    PRDAY3                   N3PF.
      @440    PRDAY4                   N3PF.
      @443    PRDAY5                   N3PF.
      @446    PRDAY6                   N3PF.
      @449    PRDAY7                   N3PF.
      @452    PRDAY8                   N3PF.
      @455    PRDAY9                   N3PF.
      @458    PRDAY10                  N3PF.
      @461    PRDAY11                  N3PF.
      @464    PRDAY12                  N3PF.
      @467    PRDAY13                  N3PF.
      @470    PRDAY14                  N3PF.
      @473    PRDAY15                  N3PF.
      @476    PRVER                    N2PF.
      @478    RACE                     N2PF.
      @480    TOTCHG                   N10PF.
      @490    TRAN_IN                  N2PF.
      @492    TRAN_OUT                 N2PF.
      @494    YEAR                     N4PF.
      @498    ZIPINC_QRTL              N2PF.
      ;
RUN;
